#include "stdafx.h"

using namespace ActiveBasic::IDE::WindowComponents::CodeEditor;

void Language::Load( const TiXmlDocument &doc )
{
	const TiXmlElement* root = doc.FirstChild( "language" )->ToElement();

	// ꖼ擾
	this->name = root->FirstChild( "name" )->FirstChild()->Value();

	// Syntax^O
	const TiXmlElement* syntaxElement = root->FirstChild( "syntax" )->ToElement();
	this->syntax.commentSingle = syntaxElement->FirstChild( "commentSingle" )->FirstChild()->Value();
	this->syntax.commentMultiBegin = syntaxElement->FirstChild( "commentMulti" )->FirstChild( "begin" )->FirstChild()->Value();
	this->syntax.commentMultiEnd = syntaxElement->FirstChild( "commentMulti" )->FirstChild( "end" )->FirstChild()->Value();
	{
		const TiXmlElement* element = syntaxElement->FirstChild( "quoteMarks" )->FirstChild( "item" )->ToElement();
		while( element )
		{
			this->syntax.quoteMarks.push_back( element->FirstChild()->Value() );
			element = element->NextSibling() ? element->NextSibling()->ToElement() : NULL;
		}
	}
	{
		const TiXmlElement* element = syntaxElement->FirstChild( "reservedSimpleKeywords" )->FirstChild( "item" )->ToElement();
		while( element )
		{
			this->syntax.reservedSimpleKeywords.push_back( element->FirstChild()->Value() );
			element = element->NextSibling() ? element->NextSibling()->ToElement() : NULL;
		}
	}
	{
		const TiXmlElement* element = syntaxElement->FirstChild( "reservedKeywordsWithQuickHelp" )->FirstChild( "item" )->ToElement();
		while( element )
		{
			ReservedKeywordWithQuickHelp temp;
			temp.keyword = element->FirstChild( "keyword" )->FirstChild()->Value();
			temp.quickHelp = element->FirstChild( "quickHelp" )->FirstChild()->Value();
			this->syntax.reservedKeywordsWithQuickHelp.push_back( temp );
			element = element->NextSibling() ? element->NextSibling()->ToElement() : NULL;
		}
	}
}

bool Language::IsExistKeyword( const std::string &keyword ) const
{
	if( Jenga::Common::IsExistString( this->syntax.reservedSimpleKeywords, keyword )
		|| this->IsExistReservedKeywordWithQuickHelp( keyword ) )
	{
		return true;
	}

	return false;
}

bool Language::IsExistReservedKeywordWithQuickHelp( const std::string &keyword ) const
{
	BOOST_FOREACH( const ReservedKeywordWithQuickHelp &item, syntax.reservedKeywordsWithQuickHelp )
	{
		if( item.keyword == keyword )
		{
			return true;
		}
	}

	return false;
}

const std::string &Language::GetReservedKeywordWithQuickHelp( const std::string &keyword ) const
{
	BOOST_FOREACH( const ReservedKeywordWithQuickHelp &item, syntax.reservedKeywordsWithQuickHelp )
	{
		if( item.keyword == keyword )
		{
			return item.quickHelp;
		}
	}

	throw;
}

bool Language::IsQuoteMark( char c ) const
{
	BOOST_FOREACH( const std::string &quoteMark, syntax.quoteMarks )
	{
		if( quoteMark.size() == 1 && c == quoteMark[0] )
		{
			return true;
		}
	}
	return false;
}

void Languages::Add( const std::string &xmlPath )
{
	Language language;
	try
	{
		TiXmlDocument doc( xmlPath );
		doc.LoadFile();

		language.Load( doc );

		(*this)[language.GetName()] = language;
	}
	catch( ... )
	{
	}
}

void Languages::LoadFiles( const std::string &dirPath )
{
	Jenga::Common::Strings results;
	Jenga::Common::Directory dir( dirPath );
	dir.SearchFiles( results, "*.xml" );
	BOOST_FOREACH( const std::string &xmlPath, results )
	{
		this->Add( xmlPath );
	}
}
