#include "stdafx.h"

using namespace ActiveBasic::Compiler;

bool LexicalAnalyzer::AnalyzeParameter( Parameters &params, const Jenga::Common::Strings &parameterStrings, int nowLine )
{
	int i2,i3,sw;
	char temporary[8192],temp2[VN_SIZE];

	//p[^
	BOOST_FOREACH( const std::string &paramStr, parameterStrings )
	{
		int i = 0;

		if( paramStr[i] == '\0' )
		{
			break;
		}

		//ByRef
		bool isRef;
		if(paramStr[i]==1&&paramStr[i+1]==ESC_BYVAL){
			isRef = false;
			i+=2;
		}
		else if(paramStr[i]==1&&paramStr[i+1]==ESC_BYREF){
			isRef = true;
			i+=2;
		}
		else isRef = false;

		//p[^
		bool isArray = false;
		Subscripts subscripts;
		char name[VN_SIZE];
		sw=0;
		for(i2=0;;i++,i2++){
			if(paramStr[i]=='('){
				if(!sw) sw=1;

				i3=GetStringInPare(name+i2,paramStr.c_str()+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(paramStr[i]=='['){
				if(!sw) sw=1;

				i3=GetStringInBracket(name+i2,paramStr.c_str()+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(!IsVariableChar(paramStr[i])){
				name[i2]=0;
				break;
			}
			name[i2]=paramStr[i];
		}
		if(sw){
			//zp[^
			if( isRef == false )
			{
				compiler.errorMessenger.Output(29,NULL,nowLine);
			}
			isArray = true;

			if((name[i2-2]=='('&&name[i2-1]==')')||
				(name[i2-2]=='['&&name[i2-1]==']'))
			{
				subscripts.push_back( LONG_MAX );

				name[i2-2]=0;
			}
			else{
				GetArrange(name,temp2,subscripts);
				lstrcpy(name,temp2);
			}

			i2=lstrlen(name);
		}

		Type type( DEF_NON );
		char initValue[8192] = "";
		if( paramStr[i] == '=' ){
			i++;
			i = GetOneParameter( paramStr.c_str(), i, initValue );

			// TODO: G[p fix me!!!
			//cp = nowLine;

			NumOpe_GetType( initValue, GetStringTypeInfo(), type );
			
			if( IS_LITERAL(type.GetIndex()) )
			{
				type.SetIndex( -1 );
			}
		}
		else if(paramStr[i]==1&&paramStr[i+1]==ESC_AS){
			// Asw
			i+=2;

			i2=0;
			while(paramStr[i]=='*'){
				temporary[i2]=paramStr[i];
				i++;
				i2++;
			}
			for(;;i++,i2++){
				if(!IsVariableChar(paramStr[i])){
					if(paramStr[i]==1&&(paramStr[i+1]==ESC_FUNCTION||paramStr[i+1]==ESC_SUB)){
						temporary[i2++]=paramStr[i++];
						temporary[i2]=paramStr[i];
						continue;
					}
					temporary[i2]=0;
					break;
				}
				temporary[i2]=paramStr[i];
			}

			compiler.StringToType( temporary, type );

			if( type.IsNull() ){
				compiler.errorMessenger.Output(3,temporary,nowLine);
				type.SetBasicType( DEF_PTR_VOID );
			}

			if( type.IsObject() ){
				if( type.GetClass().IsBlittableType() ){
					// Blittable^̂Ƃ͊{^ƂĈ
					type = type.GetClass().GetBlittableType();
				}
			}
		}
		else{
			type.SetBasicType( Type::GetBasicTypeFromSimpleName(temporary) );
			compiler.errorMessenger.Output(-103,temporary,nowLine);
		}

		Parameter *pParam = new Parameter( name, type, isRef, initValue );
		if( isArray ){
			pParam->SetArray( subscripts );
		}

		//p[^ǉ
		params.push_back( pParam );
	}

	return true;
}

bool LexicalAnalyzer::SetParamsAndReturnTypeForUserProc( UserProc &userProc, const char *sourceOfParams, int nowLine, bool isStatic )
{
	int i = 0;

	//\[XR[ḧʒu
	userProc.SetSourceCodePosition( SourceCodePosition( compiler.GetCurrentRelationalObjectModuleIndexForSource(), nowLine ) );

	//p[^
	if(sourceOfParams[i]!='('){
		compiler.errorMessenger.Output(1,NULL,nowLine);
		return false;
	}
	if(sourceOfParams[i + 1]!=')'&& userProc.HasParentClass() ){
		//NX̃o֐̏ꍇ̂݁AfXgN^Ƀp[^ꍇɃG[
		if(userProc.GetName()[0]=='~'){
			compiler.errorMessenger.Output(114,NULL,nowLine);
			return false;
		}
	}

	// JbR̃p[^擾
	char parametersStr1[8192];
	char parametersStr2[8192] = "";
	i += GetStringInPare( parametersStr1, sourceOfParams + i, true );
	if( sourceOfParams[i] == '(' )
	{
		i += GetStringInPare( parametersStr2, sourceOfParams + i, true );
	}

	// ߂l擾
	char returnTypeStr[VN_SIZE] = "";
	if( sourceOfParams[i] )
	{
		if( sourceOfParams[i] == 1 && sourceOfParams[i+1] == ESC_AS )
		{
			if( !userProc.IsFunction() ){
				// Sub/Macrȍꍇ
				compiler.errorMessenger.Output(38,userProc.GetName(),nowLine);
			}

			lstrcpy( returnTypeStr, sourceOfParams + i + 2 );
		}
		else
		{
			compiler.errorMessenger.Output(1,NULL,nowLine);
			return false;
		}
	}

	Jenga::Common::Strings parameters;

	// p[^
	SplitParameter( parametersStr1, parameters );
	ActiveBasic::Compiler::LexicalAnalyzer::AnalyzeParameter( userProc.GetParameters(), parameters, nowLine );

	// ȗ\p[^iÂdlB񐄏j
	userProc.SetSecondParmNum( (int)userProc.GetParameters().size() );
	SplitParameter( parametersStr2, parameters );
	ActiveBasic::Compiler::LexicalAnalyzer::AnalyzeParameter( userProc.GetParameters(), parameters, nowLine );


	if(returnTypeStr[0]){
		///////////////////
		// ߂l擾
		///////////////////

		if( !userProc.IsFunction() ){
			// Sub/Macrȍꍇ
			compiler.errorMessenger.Output(38,userProc.GetName(),nowLine);
		}

		if( userProc.HasParentClass() ){
			if( userProc.GetName() == userProc.GetParentClassPtr()->GetName() ||
				userProc.GetName()[0]=='~'){
				//NX̃RXgN^AfXgN^Function`̏ꍇ̓G[
				compiler.errorMessenger.Output(115,NULL,nowLine);
			}
		}

		compiler.StringToType( returnTypeStr, userProc.ReturnType() );
		if( userProc.ReturnType().IsNull() )
		{
			compiler.errorMessenger.Output(3,returnTypeStr,nowLine);
		}
	}
	else{
		if( userProc.IsFunction() )
		{
			// Function`Ȃ̂ɁA߂ľ^ZbgĂȂ
			compiler.errorMessenger.Output(-104,userProc.GetName().c_str(),nowLine);

			userProc.ReturnType().SetBasicType( DEF_DOUBLE );
		}
		else
		{
			//߂lȂSub`
			userProc.ReturnType().SetNull();
		}
	}

	//Ap[^̈擾i_System_LocalThisl2mۂꍇj

	if( userProc.HasParentClass() && isStatic == false ){
		//IuWFNgȍꍇ́Ap[^_System_LocalThisnpƂėp
		std::string name = "_System_LocalThis";
		Type type( DEF_PTR_VOID );
		userProc.RealParams().push_back( new Parameter( name, type ) );
	}

	if( userProc.ReturnType().IsStruct() ){
		//\̂߂lƂĎꍇ
		//p[^iThis|C^̏ꍇ͑p[^j߂lp̎QƐ錾ɂ

		std::string name = userProc.GetName();
		if(name[0]==1&&name[1]==ESC_OPERATOR){
			name="_System_ReturnValue";
		}
		Type type( DEF_STRUCT, userProc.ReturnType().GetIndex() );
		userProc.RealParams().push_back( new Parameter( name, type, true ) );
	}

	//p[^Rs[
	BOOST_FOREACH( Parameter *pParam, userProc.GetParameters() ){
		userProc.RealParams().push_back( new Parameter( *pParam ) );
	}

	return true;
}

bool LexicalAnalyzer::SetParamsAndReturnType( Procedure *pProc, const char *sourceOfParams, bool isSupportEllipse, int nowLine ){
	int i = 0;
	int i2,i3,sw;
	char temporary[8192],temp2[VN_SIZE];

	//\[XR[ḧʒu
	pProc->SetSourceCodePosition( SourceCodePosition( compiler.GetCurrentRelationalObjectModuleIndexForSource(), nowLine ) );

	//p[^
	if(sourceOfParams[i]!='('){
		compiler.errorMessenger.Output(1,NULL,nowLine);
		return 0;
	}
	i++;
	while(1){
		if(sourceOfParams[i]==')') break;

		//ByRef
		bool isRef;
		if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYVAL){
			isRef = false;
			i+=2;
		}
		else if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYREF){
			isRef = true;
			i+=2;
		}
		else isRef = false;

		//p[^
		bool isArray = false;
		Subscripts subscripts;
		char name[VN_SIZE];
		sw=0;
		for(i2=0;;i++,i2++){
			if(sourceOfParams[i]=='('){
				if(!sw) sw=1;

				i3=GetStringInPare(name+i2,sourceOfParams+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(sourceOfParams[i]=='['){
				if(!sw) sw=1;

				i3=GetStringInBracket(name+i2,sourceOfParams+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(!IsVariableChar(sourceOfParams[i])){
				name[i2]=0;
				break;
			}
			name[i2]=sourceOfParams[i];
		}
		if(sw){
			//zp[^
			if( isRef == false ) compiler.errorMessenger.Output(29,NULL,nowLine);
			isArray = true;

			if((name[i2-2]=='('&&name[i2-1]==')')||
				(name[i2-2]=='['&&name[i2-1]==']'))
			{
				subscripts.push_back( LONG_MAX );

				name[i2-2]=0;
			}
			else{
				GetArrange(name,temp2,subscripts);
				lstrcpy(name,temp2);
			}

			i2=lstrlen(name);
		}

		//^
		Type type( DEF_NON );
		if( isSupportEllipse && lstrcmp(name,"...")==0 )
		{
			type.SetBasicType( DEF_ELLIPSE );
		}
		else if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_AS)
		{
			i+=2;

			i2=0;
			while(sourceOfParams[i]=='*'){
				temporary[i2]=sourceOfParams[i];
				i++;
				i2++;
			}
			for(;;i++,i2++){
				if(!IsVariableChar(sourceOfParams[i])){
					if(sourceOfParams[i]==1&&(sourceOfParams[i+1]==ESC_FUNCTION||sourceOfParams[i+1]==ESC_SUB)){
						temporary[i2++]=sourceOfParams[i++];
						temporary[i2]=sourceOfParams[i];
						continue;
					}
					temporary[i2]=0;
					break;
				}
				temporary[i2]=sourceOfParams[i];
			}

			compiler.StringToType( temporary, type );

			if( type.IsNull() ){
				compiler.errorMessenger.Output(3,temporary,nowLine);
				type.SetBasicType( DEF_PTR_VOID );
			}
		}
		else{
			type.SetBasicType( Type::GetBasicTypeFromSimpleName(temporary) );
			compiler.errorMessenger.Output(-103,temporary,nowLine);
		}

		Parameter *pParam = new Parameter( name, type, isRef );
		if( isArray ){
			pParam->SetArray( subscripts );
		}

		//p[^ǉ
		pProc->GetParameters().push_back( pParam );

		if(sourceOfParams[i]==','){
			i++;
			continue;
		}
		else if(sourceOfParams[i]==')') continue;
		else{
			compiler.errorMessenger.Output(1,NULL,nowLine);
			break;
		}
	}
	i++;

	if(sourceOfParams[i]){
		///////////////////
		// ߂l擾
		///////////////////

		i2=lstrlen(sourceOfParams)-2;

		int sw_as=0;
		for(;i2>0;i2--){
			if(sourceOfParams[i2]==')') break;

			if(sourceOfParams[i2]==1&&sourceOfParams[i2+1]==ESC_AS){
				i2+=2;
				i3=0;
				while(sourceOfParams[i2]=='*') temporary[i3++]=sourceOfParams[i2++];
				for(;;i2++,i3++){
					if(!IsVariableChar(sourceOfParams[i2])){
						temporary[i3]=0;
						break;
					}
					temporary[i3]=sourceOfParams[i2];
				}
				compiler.StringToType( temporary, pProc->ReturnType() );
				if( pProc->ReturnType().IsNull() ) compiler.errorMessenger.Output(3,temporary,nowLine);

				sw_as=1;
				break;
			}
		}
	}
	else{
		//߂lȂSub`
		pProc->ReturnType().SetNull();
	}

	//߂l̃G[`FbN
	if( pProc->IsFunction() ){
		// Function`

		if( pProc->ReturnType().IsNull() ){
			// ߂lȂ
			compiler.errorMessenger.Output(26,pProc->GetName(),nowLine);
		}
	}
	else{
		if( !pProc->ReturnType().IsNull() ){
			// Sub`Ȃ̂ɁA߂l
			compiler.errorMessenger.Output(38,pProc->GetName(),nowLine);
		}
	}

	return true;
}

UserProc* LexicalAnalyzer::ParseUserProc( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, char *buffer,int nowLine,bool isVirtual,CClass *pobj_c, bool isStatic, char *interfaceName )
{
	int i2,i3;
	char temporary[8192];

	int i=1;

	Procedure::Kind kind = Procedure::Sub;
	bool isMacro = false;
	if(buffer[i]==ESC_FUNCTION) kind = Procedure::Function;
	if(buffer[i]==ESC_MACRO){
		isMacro = true;
	}

	i++;

	bool isCdecl = false;
	bool isExport = false;
	while(1){
		if(buffer[i]==1&&buffer[i+1]==ESC_CDECL&& isCdecl == false ){
			isCdecl = true;

			i+=2;
		}
		else if(buffer[i]==1&&buffer[i+1]==ESC_EXPORT&& isExport == false ){
			isExport = true;

			i+=2;
		}
		else break;
	}

	i2=0;
	if(buffer[i]==1&&buffer[i+1]==ESC_OPERATOR){
		if(!pobj_c){
			compiler.errorMessenger.Output(126,NULL,nowLine);
			return 0;
		}

		//Iy[^̏ꍇ
		temporary[i2++]=buffer[i++];
		temporary[i2++]=buffer[i++];

		int iCalcId;
		if(buffer[i]=='='&&buffer[i+1]=='='){
			iCalcId=CALC_EQUAL;
			i3=2;
		}
		else if(buffer[i]=='='){
			iCalcId=CALC_SUBSITUATION;
			i3=1;
		}
		else if(buffer[i]=='('){
			iCalcId=CALC_AS;
			i3=0;
		}
		else if(buffer[i]=='['&&buffer[i+1]==']'&&buffer[i+2]=='='){
			iCalcId=CALC_ARRAY_SET;
			i3=3;
		}
		else if(buffer[i]=='['&&buffer[i+1]==']'){
			iCalcId=CALC_ARRAY_GET;
			i3=2;
		}
		else{
			iCalcId=GetCalcId(buffer+i,&i3);
			i3++;
		}
		if(!iCalcId){
			compiler.errorMessenger.Output(1,NULL,nowLine);
			return 0;
		}
		temporary[i2++]=iCalcId;
		temporary[i2]=0;

		i+=i3;
	}
	else{
		if(pobj_c){
			//NXȍꍇAfXgN^ɂ~tƂl
			if(buffer[i]=='~'){
				temporary[i2]='~';
				i++;
				i2++;
			}
		}

		for(;;i++,i2++){
			if(!IsVariableChar(buffer[i])){
				temporary[i2]=0;
				break;
			}
			temporary[i2]=buffer[i];
		}

		char parentName[VN_SIZE], memberName[VN_SIZE];
		ReferenceKind refKind;
		if( SplitMemberName( temporary, parentName, memberName, refKind ) )
		{
			if( pobj_c )
			{
				if( interfaceName )
				{
					lstrcpy( interfaceName, parentName );
				}
				else
				{
					compiler.errorMessenger.OutputFatalError();
					return NULL;
				}

				char dummyMemberName[VN_SIZE];
				if( SplitMemberName( memberName, parentName, dummyMemberName, refKind ) )
				{
					compiler.errorMessenger.Output(69,temporary,nowLine);
					return NULL;
				}
			}
			else
			{
				compiler.errorMessenger.Output(68,temporary,nowLine);
				return NULL;
			}

			lstrcpy( temporary, memberName );
		}
	}

	if( isMacro ){
		//啶ɕϊ
		CharUpper(temporary);
	}

	if(!pobj_c){
		//NXoȊȌꍇ̂
		//d`FbN

		if(GetDeclareHash(temporary)){
			compiler.errorMessenger.Output(15,temporary,nowLine);
			return 0;
		}
	}

	UserProc *pUserProc = new UserProc( Symbol( namespaceScopes, temporary ), importedNamespaces, kind, isMacro, isCdecl, isExport );
	pUserProc->SetParentClass( pobj_c );

	// eC^[tFCXZbg
	if( interfaceName && interfaceName[0] )
	{
		::Interface *pTargetInterface = NULL;
		BOOST_FOREACH( ::Interface *pInterface, pobj_c->GetInterfaces() )
		{
			if( pInterface->GetClass().GetName() == interfaceName )
			{
				pTargetInterface = pInterface;
				break;
			}
		}
		pUserProc->SetInterface( pTargetInterface );
	}

	if(isExport){
		pUserProc->Using();
	}

	// p[^
	// 1p[^ɂɎw肷f[^̗F"( s As String ) As String"
	SetParamsAndReturnTypeForUserProc( *pUserProc, buffer + i, nowLine, isStatic );

	pUserProc->_paramStr = buffer + i;

	return pUserProc;
}

DllProc *LexicalAnalyzer::ParseDllProc(const NamespaceScopes &namespaceScopes, char *buffer,int nowLine)
{
	int i2;

	int i=0;

	//Sub/Function
	Procedure::Kind kind = Procedure::Sub;
	if(buffer[i]==ESC_SUB){
	}
	else if(buffer[i]==ESC_FUNCTION){
		kind = Procedure::Function;
	}
	else{
		compiler.errorMessenger.Output(1,NULL,nowLine);
		return NULL;
	}
	i++;

	//vV[W
	char procName[VN_SIZE];
	bool isCdecl = false;
	for(i2=0;;i++,i2++){
		if(buffer[i]==1&&buffer[i+1]==ESC_CDECL){
			isCdecl = true;

			i+=2;
			procName[i2]=0;
			break;
		}
		if(buffer[i]==','){
			procName[i2]=0;
			break;
		}
		if(buffer[i]=='\0'){
			compiler.errorMessenger.Output(1,NULL,nowLine);
			return NULL;
		}
		procName[i2]=buffer[i];
	}
	i++;

	//[U[`֐Ƃ̏d`FbN
	if(GetSubHash(procName)){
		compiler.errorMessenger.Output(15,procName,nowLine);
		return NULL;
	}


	//Cu
	char dllFileName[MAX_PATH];
	i = GetOneParameter( buffer, i, dllFileName );
	Type resultType;
	_int64 i64data;
	if( !StaticCalculation( true, dllFileName, 0, &i64data, resultType ) ){
		return NULL;
	}
	if( resultType.GetBasicType() != typeOfPtrChar ){
		compiler.errorMessenger.Output(1,NULL,nowLine);
		return NULL;
	}
	lstrcpy( dllFileName, (char *)i64data );
	CharUpper(dllFileName);
	if(!strstr(dllFileName,".")){
		lstrcat(dllFileName,".DLL");
		if(lstrlen(dllFileName)>=16){
			compiler.errorMessenger.Output(7,NULL,nowLine);
			return NULL;
		}
	}

	//GCAX
	char alias[VN_SIZE];
	i = GetOneParameter( buffer, i, alias );
	if( alias[0] ){
		if( !StaticCalculation( true, alias, 0, &i64data, resultType ) ){
			return NULL;
		}
		if( resultType.GetBasicType() != typeOfPtrChar ){
			compiler.errorMessenger.Output(1,NULL,nowLine);
			return NULL;
		}
		lstrcpy( alias, (char *)i64data );
	}
	else{
		//ȗꂽƂ͊֐
		lstrcpy( alias, procName );
	}


	// IuWFNg𐶐
	DllProc *pDllProc = new DllProc( Symbol( namespaceScopes, procName ), kind, isCdecl, dllFileName, alias );

	// p[^
	// 1p[^ɂɎw肷f[^̗F"( s As String ) As String"
	LexicalAnalyzer::SetParamsAndReturnType( pDllProc, buffer + i, true, nowLine );

	// p[^̃G[`FbN
	BOOST_FOREACH( const Parameter *pParam, pDllProc->Params() ){
		if( pParam->IsObject() ){
			compiler.errorMessenger.Output(25,pParam->GetVarName(),nowLine);
		}
		if( !pParam->IsRef() ){
			if( pParam->IsStruct() ){
				compiler.errorMessenger.Output(28,pParam->GetVarName(),nowLine);
			}
		}
	}

	//߂l̃G[`FbN
	if( pDllProc->IsFunction() ){
		// Function`

		if( pDllProc->ReturnType().IsObject() ){
			// DLL֐ł̓IuWFNg߂lɂłȂ
			compiler.errorMessenger.Output(40,pDllProc->GetName(),nowLine);
		}
	}

	return pDllProc;
}

void LexicalAnalyzer::CollectProcedures( const char *source, UserProcs &userProcs, DllProcs &dllProcs )
{
	extern HANDLE hHeap;
	int i,i2,i3;
	char temporary[8192];

	// OԊǗ
	NamespaceScopes &namespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	namespaceScopes.clear();

	// Imports̃NA
	compiler.GetNamespaceSupporter().ClearImportedNamespaces();

	i=-1;
	while(1){
		i++;

		if(source[i]==1&&(source[i+1]==ESC_CLASS||source[i+1]==ESC_INTERFACE)){
			/*	Class ` End Class
				Interface ` End Interface
				щz			*/
			i3=GetEndXXXCommand(source[i+1]);
			for(i+=2,i2=0;;i++,i2++){
				if(source[i]=='\0') break;
				if(source[i]==1&&source[i+1]==(char)i3){
					i++;
					break;
				}
			}
			if(source[i]=='\0') break;
			continue;
		}

		if( source[i] == 1 && source[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			namespaceScopes.push_back( temporary );

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				compiler.errorMessenger.Output(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_IMPORTS ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			if( !compiler.GetNamespaceSupporter().ImportsNamespace( temporary ) )
			{
				compiler.errorMessenger.Output(64,temporary,cp );
			}

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_CLEARNAMESPACEIMPORTED )
		{
			// Imports̃NA
			compiler.GetNamespaceSupporter().ClearImportedNamespaces();
			continue;
		}

		if(source[i]==1&&source[i+1]==ESC_DECLARE){
			for(i+=2,i2=0;;i2++,i++){
				if(source[i]=='\n'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
				if(source[i]=='\0') break;
			}
			DllProc *pDllProc = ParseDllProc( namespaceScopes, temporary, i );
			dllProcs.Put( pDllProc );

			continue;
		}
		if(source[i]==1&&(source[i+1]==ESC_SUB||source[i+1]==ESC_FUNCTION||source[i+1]==ESC_MACRO)){
			char statementChar = source[i+1];

			for(i2=0;;i2++,i++){
				if(IsCommandDelimitation(source[i])){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
				if(source[i]=='\0') break;
			}

			UserProc *pUserProc = ParseUserProc( namespaceScopes, compiler.GetNamespaceSupporter().GetImportedNamespaces(), temporary, i, false, NULL, false );

			// ֐ǉ
			if( userProcs.IsExist( pUserProc ) )
			{
				// ɑ݂Ă
				compiler.errorMessenger.Output(15,pUserProc->GetName(),i);

				delete pUserProc;
			}
			else
			{
				userProcs.Put( pUserProc );
			}

			/*	Sub ` End Sub
				Function ` End Function
				Macro ` End Macro
				щz			*/
			char endStatementChar = GetEndXXXCommand( statementChar );
			for(i2=0;;i++,i2++){
				if( source[i] == '\0' ) break;
				if( source[i] == 1 && source[i+1] == endStatementChar ){
					i++;
					break;
				}
			}
			if(source[i]=='\0') break;
			continue;
		}

		//̍s
		for(;;i++){
			if(IsCommandDelimitation(source[i])) break;
		}
		if(source[i]=='\0') break;
	}

	////////////
	// ֐
	////////////
	namespaceScopes.clear();
	compiler.GetNamespaceSupporter().ClearImportedNamespaces();

	compiler.globalAreaProcName = "_GlobalArea_" + compiler.GetModuleName();
	sprintf(temporary,"%c%c%s()",1,ESC_SUB,compiler.globalAreaProcName.c_str());
	UserProc *pUserProc = ParseUserProc( namespaceScopes, compiler.GetNamespaceSupporter().GetImportedNamespaces(), temporary, 0, false, NULL, false );

	// ֐ǉ
	if( userProcs.IsExist( pUserProc ) )
	{
		// ɑ݂Ă
		compiler.errorMessenger.Output(15,pUserProc->GetName(),i);

		delete pUserProc;
	}
	else
	{
		userProcs.Put( pUserProc );
	}
}
