#include "stdafx.h"

#include "../common.h"
#ifdef _AMD64_
#include "../../compiler_x64/opcode.h"
#else
#include "../../compiler_x86/opcode.h"
#endif

using namespace ActiveBasic::Compiler;


void LexicalAnalyzer::CollectClassesForNameOnly( const char *source, Classes &classes )
{
	int i, i2;
	char temporary[VN_SIZE];

	// OԊǗ
	NamespaceScopes &namespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	namespaceScopes.clear();

	// Imports̃NA
	compiler.GetNamespaceSupporter().ClearImportedNamespaces();

	for(i=0;;i++){
		if(source[i]=='\0') break;

		if( source[i] == 1 && source[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			namespaceScopes.push_back( temporary );

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				compiler.errorMessenger.Output(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_IMPORTS ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			if( !compiler.GetNamespaceSupporter().ImportsNamespace( temporary ) )
			{
				compiler.errorMessenger.Output(64,temporary,i );
			}

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_CLEARNAMESPACEIMPORTED )
		{
			// Imports̃NA
			compiler.GetNamespaceSupporter().ClearImportedNamespaces();
			continue;
		}

		if(source[i]==1&&(
			source[i+1]==ESC_CLASS||
			source[i+1]==ESC_TYPE||
			source[i+1]==ESC_INTERFACE
			))
		{
			int nowLine = i;
			i += 2;

			Type blittableType;
			if(memicmp(source+i,"Align(",6)==0){
				//ACgCq
				i+=6;
				i=JumpStringInPare(source,i)+1;
			}
			else if( memicmp( source + i, "Blittable(", 10 ) == 0 ){
				// BlittableCq
				i+=10;
				i+=GetStringInPare_RemovePare(temporary,source+i)+1;
				compiler.StringToType( temporary, blittableType );
			}

			bool isEnum = false;
			bool isDelegate = false;
			if( source[i] == 1 && source[i+1] == ESC_ENUM ){
				// 񋓌^̏ꍇ
				isEnum = true;

				i += 2;
			}
			else if( source[i] == 1 && source[i+1] == ESC_DELEGATE )
			{
				// fQ[g̏ꍇ
				isDelegate = true;

				i += 2;
			}

			for(i2=0;;i++,i2++){
				if(!IsVariableChar(source[i])){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}

			//NXǉ
			CClass *pClass = new CClass( Symbol( namespaceScopes, temporary ), compiler.GetNamespaceSupporter().GetImportedNamespaces() );
			if( classes.IsExist( pClass ) )
			{
				// ɑ݂Ă
				compiler.errorMessenger.Output(15,pClass->GetName(), nowLine);

				delete pClass;

				continue;
			}

			classes.Put( pClass );

			if( source[nowLine+1] == ESC_CLASS )
			{
				if( isEnum )
				{
					pClass->SetClassType( CClass::Enum );
				}
				else if( isDelegate )
				{
					pClass->SetClassType( CClass::Delegate );
				}
				else{
					pClass->SetClassType( CClass::Class );
				}
			}
			else if( source[nowLine+1] == ESC_INTERFACE )
			{
				pClass->SetClassType( CClass::Interface );
			}
			else
			{
				pClass->SetClassType( CClass::Structure );
			}

			// Blittable^̏ꍇ
			if( !blittableType.IsNull() ){
				pClass->SetBlittableType( blittableType );

				// Blittable^Ƃēo^
				compiler.GetObjectModule().meta.GetBlittableTypes().push_back( BlittableType( blittableType, pClass ) );
			}
		}
	}
}


class CLoopRefCheck{
	char **names;
	int num;
	void init(){
		int i;
		for(i=0;i<num;i++){
			free(names[i]);
		}
		free(names);
	}
public:
	CLoopRefCheck()
	{
		names=(char **)malloc(1);
		num=0;
	}
	~CLoopRefCheck()
	{
		init();
	}
	void add(const char *lpszInheritsClass)
	{
		names=(char **)realloc(names,(num+1)*sizeof(char *));
		names[num]=(char *)malloc(lstrlen(lpszInheritsClass)+1);
		lstrcpy(names[num],lpszInheritsClass);
		num++;
	}
	void del(const char *lpszInheritsClass)
	{
		int i;
		for(i=0;i<num;i++){
			if(lstrcmp(names[i],lpszInheritsClass)==0){
				free(names[i]);
				break;
			}
		}
		if(i!=num){
			num--;
			for(;i<num;i++){
				names[i]=names[i+1];
			}
		}
	}
	BOOL check(const CClass &inheritsClass) const
	{
		//[vp`FbN
		int i;
		for(i=0;i<num;i++){
			if( inheritsClass.GetName() == names[i] ){
				return 1;
			}
		}
		return 0;
	}
};
CLoopRefCheck *pobj_LoopRefCheck;

bool MemberVar_LoopRefCheck(const CClass &objClass){
	if( objClass.HasSuperClass() )
	{
		// NX`FbN
		if( MemberVar_LoopRefCheck( objClass.GetSuperClass() ) == false )
		{
			return false;
		}
	}

	bool result = true;
	BOOST_FOREACH( Member *pMember, objClass.GetDynamicMembers() ){
		if(pMember->GetType().IsStruct()){
			//zQƂłȂ`FbN
			if(pobj_LoopRefCheck->check(pMember->GetType().GetClass())){
				extern int cp;
				compiler.errorMessenger.Output(124,pMember->GetType().GetClass().GetName(),cp);
				return false;
			}

			pobj_LoopRefCheck->add(objClass.GetName().c_str());

			bool tempResult = MemberVar_LoopRefCheck(pMember->GetType().GetClass());
			if( result )
			{
				result = tempResult;
			}

			pobj_LoopRefCheck->del(objClass.GetName().c_str());
		}
	}

	return result;
}

void OverrideErrorCheck( const DynamicMethod::OverrideResult &result )
{
	switch( result.enumType )
	{
	case DynamicMethod::OverrideResult::Successful:
		break;
	case DynamicMethod::OverrideResult::NotVirtual:
		compiler.errorMessenger.Output(136, result.pMethod->GetUserProc().GetName(), cp);
		break;
	case DynamicMethod::OverrideResult::NotUseOverrideModifier:
		compiler.errorMessenger.Output(127, result.pMethod->GetUserProc().GetName(), cp);
		break;
	case DynamicMethod::OverrideResult::DifferentAccesibility:
		compiler.errorMessenger.Output(128, result.pMethod->GetUserProc().GetName(), cp);
		break;
	default:
		throw;
	}
}

Member *LexicalAnalyzer::CreateMember( const CClass &_class, Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine )
{
	extern int cp;

	//\
	char VarName[VN_SIZE];
	char initBuffer[VN_SIZE];
	char lpszConstructParameter[VN_SIZE];
	Subscripts subscripts;
	Type type;
	if( !GetDimentionFormat(buffer,VarName,subscripts,type,initBuffer,lpszConstructParameter) )
	{
		return NULL;
	}

	//d`FbN
	if( _class.DupliCheckAll( VarName ) ){
		compiler.errorMessenger.Output(15,VarName,cp);
	}

	Member *pMember = new Member( accessibility, VarName, type, isConst, subscripts, initBuffer, lpszConstructParameter );
	pMember->source_code_address = nowLine;
	return pMember;
}

void LexicalAnalyzer::AddMethod(CClass *pobj_c, UserProc *pUserProc, Prototype::Accessibility accessibility, BOOL bStatic, bool isConst, bool isAbstract,
	bool isVirtual, bool isOverride, const char *interfaceName, bool isAutoGeneration, int nowLine)
{
	if( isAutoGeneration )
	{
		// R[h
		pUserProc->ThisIsAutoGenerationProc();
	}


	////////////////////////////////////////////////////////////
	// RXgN^AfXgN^̏ꍇ̏
	////////////////////////////////////////////////////////////
	BOOL fConstructor=0,bDestructor=0;

	if( pUserProc->GetName() == pobj_c->GetName() ){
		//RXgN^̏ꍇ

		//WRXgN^iȂj
		if(pUserProc->Params().size()==0) fConstructor=1;

		//IConstCq
		isConst = true;
	}
	else if(pUserProc->GetName()[0]=='~'){
		//fXgN^̏ꍇ̖͂O`FbNs
		if(lstrcmp(pUserProc->GetName().c_str()+1,pobj_c->GetName().c_str())!=0)
			compiler.errorMessenger.Output(117,NULL,nowLine);
		else
			bDestructor=1;
	}
	if(fConstructor||bDestructor){
		// RXgN^AfXgN^̃ANZVreB`FbN

		//IConstCq
		isConst = true;
	}

	if( fConstructor == 1 )
		pobj_c->SetConstructorMemberSubIndex( (int)pobj_c->GetDynamicMethods().size() );
	else if( bDestructor )
		pobj_c->SetDestructorMemberSubIndex( (int)pobj_c->GetDynamicMethods().size() );



	//////////////////
	// d`FbN
	//////////////////

	if(pobj_c->DupliCheckMember( pUserProc->GetName().c_str() )){
		compiler.errorMessenger.Output(15,pUserProc->GetName(),nowLine);
		return;
	}

	//\bh
	BOOST_FOREACH( const CMethod *pMethod, pobj_c->GetDynamicMethods() )
	{
		//NXƏdꍇ̓I[o[Chs
		if( pMethod->GetInheritsClassPtr() ) continue;

		if( pMethod->GetUserProc().IsEqualForOverride( pobj_c->GetSuperClassActualTypeParameters(), pUserProc ) )
		{
			//֐Ap[^A߂lvƂ
			compiler.errorMessenger.Output(15,pUserProc->GetName().c_str(),nowLine);
			return;
		}
	}

	//z֐̏ꍇ
	if( isAbstract ) pUserProc->CompleteCompile();

	// \bh̃I[o[Ch
	DynamicMethod *pMethodForOverride = pobj_c->GetDynamicMethods().FindForOverride( pobj_c->GetSuperClassActualTypeParameters(), pUserProc );
	if( pMethodForOverride )
	{
		DynamicMethod::OverrideResult result;
		result.enumType = pMethodForOverride->Override( pUserProc, accessibility, isOverride );
		result.pMethod = pMethodForOverride;
		OverrideErrorCheck( result );

		pUserProc->SetMethod( pMethodForOverride );
		return;
	}
	else
	{
		// C^[tFCX \bh̃I[o[Ch
		BOOST_FOREACH( ::Interface *pInterface, pobj_c->GetInterfaces() )
		{
			if( interfaceName[0] )
			{
				if( pInterface->GetClass().GetName() != interfaceName )
				{
					// w肳ꂽC^[tFCXƐȂƂ
					continue;
				}
			}

			if( !pInterface->GetClass().IsReady() ){
				// C^[tFCX͂̂Ƃ
				LexicalAnalyzer::LookaheadClass(
					pInterface->GetClass().GetName().c_str(),
					compiler.GetObjectModule().meta.GetClasses()
				);
			}

			DynamicMethod *pMethodForOverride = pInterface->GetDynamicMethods().FindForOverride( pInterface->GetActualTypeParameters(), pUserProc );
			if( pMethodForOverride )
			{
				DynamicMethod::OverrideResult result;
				result.enumType = pMethodForOverride->Override( pUserProc, accessibility, isOverride );
				result.pMethod = pMethodForOverride;
				OverrideErrorCheck( result );

				pUserProc->SetMethod( pMethodForOverride );
				return;
			}
		}
	}

	if( interfaceName[0] )
	{
		compiler.errorMessenger.Output(139,interfaceName,nowLine);
	}

	if( isVirtual ){
		pobj_c->AddVtblNum( 1 );
	}

	if( isOverride ){
		compiler.errorMessenger.Output(12,"Override",nowLine);
	}

	if(bStatic){
		pobj_c->GetStaticMethods().AddStatic( pUserProc, accessibility );
	}
	else{
		pobj_c->GetDynamicMethods().Add(pUserProc, accessibility, isConst, isAbstract, isVirtual);
	}
}

bool LexicalAnalyzer::Inherits( CClass &_class, const char *inheritNames, int nowLine ){
	int i = 0;
	bool isInheritsClass = false;
	while( true ){

		char temporary[VN_SIZE];
		for( int i2=0;; i++, i2++ ){
			if( inheritNames[i] == '\0' || inheritNames[i] == ',' ){
				temporary[i2] = 0;
				break;
			}
			temporary[i2] = inheritNames[i];
		}

		// WFlNX\𕪉
		char className[VN_SIZE];
		Jenga::Common::Strings typeParameterStrings;
		SplitGenericClassInstance( temporary, className, typeParameterStrings );

		// ^p[^񂩂^f[^擾
		Types actualTypeParameters;
		BOOST_FOREACH( const std::string &typeParameterStr, typeParameterStrings )
		{
			Type type;
			compiler.StringToType( typeParameterStr, type );
			actualTypeParameters.push_back( type );
		}

		//pNX擾
		const CClass *pInheritsClass = compiler.GetObjectModule().meta.FindClassSupportedTypeDef(
			LexicalAnalyzer::FullNameToSymbol( className )
		);
		if( !pInheritsClass ){
			compiler.errorMessenger.Output(106,className,nowLine);
			return false;
		}

		if( pInheritsClass->IsClass() ){
			// NXp
			isInheritsClass = true;

			//[vpłȂ`FbN
			if( !LexicalAnalyzer::LoopRefCheck(*pInheritsClass) )
			{
				compiler.errorMessenger.Output(123,pInheritsClass->GetName(),nowLine);
				return false;
			}

			if( !pInheritsClass->IsReady() ){
				//p悪ǂݎĂȂƂ
				LexicalAnalyzer::LookaheadClass(
					pInheritsClass->GetName().c_str(),
					compiler.GetObjectModule().meta.GetClasses()
				);
			}

			if( !_class.InheritsClass( *pInheritsClass, actualTypeParameters, nowLine ) ){
				return false;
			}
		}
		else{
			compiler.errorMessenger.Output(135,pInheritsClass->GetFullName().c_str(),nowLine);
			return false;
		}

		if( inheritNames[i] == '\0' ){
			break;
		}
		i++;
	}

	if( !isInheritsClass ){
		const CClass *pObjectClass = compiler.GetObjectModule().meta.GetClasses().GetObjectClassPtr();
		//[vpłȂ`FbN
		if( !LexicalAnalyzer::LoopRefCheck( *pObjectClass ) )
		{
			compiler.errorMessenger.Output(123,pObjectClass->GetName(),nowLine);
			return false;
		}

		if( !pObjectClass->IsReady() ){
			//p悪ǂݎĂȂƂ
			LexicalAnalyzer::LookaheadClass(
				pObjectClass->GetName().c_str(),
				compiler.GetObjectModule().meta.GetClasses()
			);
		}

		// NXpĂȂƂ
		if( !_class.InheritsClass( *pObjectClass, Types(), nowLine ) ){
			return false;
		}
	}

	return true;
}

void LexicalAnalyzer::Implements( CClass &_class, Interface *pInterface, std::vector<DynamicMethod::OverrideResult> &overrideResults )
{
	_class.AddInterface( pInterface );


	/////////////////////////////////////////////////////////////////
	// NX̃\bhC^[tFCX\bhĎ
	/////////////////////////////////////////////////////////////////
	BOOST_FOREACH( CMethod *pMethod, _class.GetDynamicMethods() )
	{
		DynamicMethod *pMethodForOverride = pInterface->GetDynamicMethods().FindForOverride( pInterface->GetActualTypeParameters(), &pMethod->GetUserProc() );
		if( pMethodForOverride )
		{
			DynamicMethod::OverrideResult result;
			result.enumType = pMethodForOverride->Override( &pMethod->GetUserProc(), pMethod->GetAccessibility(), false );
			result.pMethod = pMethod;
			overrideResults.push_back( result );

			// ɂȂ郁\bh͌ĂяosɂĂiI[o[[h̉珜Oj
			pMethod->SetNotUseMark( true );
		}
	}


	/////////////////////////////////////////////////////////////////
	// LXg\bhǉiR[h͎邱Ɓj
	// COMC^[tFCX͏O邱
	/////////////////////////////////////////////////////////////////
	if( pInterface->GetClass().IsInterface() )
	{
		// Function Operator() As ITest

		char methodName[255] = { 1, ESC_OPERATOR, CALC_AS, '\0' };

		//֐nbV֓o^
		UserProc *pUserProc = new UserProc(
			Symbol( NamespaceScopes(), methodName ),
			NamespaceScopesCollection(),
			Procedure::Function,
			false,
			false,
			false );
		pUserProc->SetParentClass( &_class );

		Parameters params;
		params.push_back( new Parameter( "_System_LocalThis", Type( DEF_PTR_VOID ) ) );
		pUserProc->SetRealParams( params );

		pUserProc->SetReturnType( Type( DEF_OBJECT, pInterface->GetClass() ) );
		pUserProc->_paramStr = "";
		pUserProc->Using();

		// ֐ǉ
		if( compiler.GetObjectModule().meta.GetUserProcs().IsExist( pUserProc ) )
		{
			// ɑ݂Ă
			compiler.errorMessenger.Output(15,pUserProc->GetName(),-1);

			delete pUserProc;
		}
		else
		{
			compiler.GetObjectModule().meta.GetUserProcs().Put( pUserProc );
		}

		LexicalAnalyzer::AddMethod(
			&_class,
			pUserProc,
			Prototype::Public,
			0,
			false,			// isConst
			false,			// isAbstract
			false,			// isVirtual
			false,			// isOverride
			"",
			true,			// isAutoGeneration
			-1
		);
	}
}

bool LexicalAnalyzer::Implements( CClass &_class, const char *interfaceNames, int nowLine )
{
	Jenga::Common::Strings paramStrs;
	SplitParameter( interfaceNames, paramStrs );
	
	BOOST_FOREACH( const std::string &paramStr, paramStrs )
	{
		char className[VN_SIZE];
		Jenga::Common::Strings typeParameterStrings;
		SplitGenericClassInstance( paramStr.c_str(), className, typeParameterStrings );

		Types actualTypeParameters;
		BOOST_FOREACH( const std::string &typeParameterStr, typeParameterStrings )
		{
			Type type;
			compiler.StringToType( typeParameterStr, type );
			actualTypeParameters.push_back( type );
		}

		//pNX擾
		const CClass *pInterfaceClass = compiler.GetObjectModule().meta.FindClassSupportedTypeDef(
			LexicalAnalyzer::FullNameToSymbol( className )
		);
		if( !pInterfaceClass ){
			compiler.errorMessenger.Output(106,paramStr.c_str(),nowLine);
			continue;
		}

		if( !pInterfaceClass->IsReady() ){
			// C^[tFCX͂̂Ƃ
			LexicalAnalyzer::LookaheadClass(
				pInterfaceClass->GetName().c_str(),
				compiler.GetObjectModule().meta.GetClasses()
			);
		}

		if( pInterfaceClass->IsInterface() || pInterfaceClass->IsComInterface() )
		{
			// C^[tFCXp
			std::vector<DynamicMethod::OverrideResult> overrideResults;
			Implements(
				_class,
				new ::Interface( pInterfaceClass, actualTypeParameters ),
				overrideResults
			);

			// G[`FbN
			BOOST_FOREACH( const DynamicMethod::OverrideResult result, overrideResults )
			{
				OverrideErrorCheck( result );
			}
		}
		else
		{
			// C^[tFCXł͂ȂƂ
			compiler.errorMessenger.Output(138,pInterfaceClass->GetName().c_str(),nowLine );
		}
	}

	return true;
}

void GetClass_recur( const char *lpszInheritsClass, Classes &classes )
{
	extern char *basbuf;
	int i,i2,i3,sub_address,top_pos;
	char temporary[8192];

	// OԊǗ
	NamespaceScopes backupNamespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	NamespaceScopes &namespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	namespaceScopes.clear();

	// ImportsꂽOԂ̊Ǘ
	NamespaceScopesCollection backupImportedNamespaces = compiler.GetNamespaceSupporter().GetImportedNamespaces();
	compiler.GetNamespaceSupporter().ClearImportedNamespaces();

	// ĂяoŃRpC̃NX|C^obNAbv
	const CClass *pBackCompilingClass = compiler.IsCompilingClass()
		? &compiler.GetCompilingClass()
		: NULL;

	for(i=0;;i++){
		if(basbuf[i]=='\0') break;


		// O
		if( basbuf[i] == 1 && basbuf[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( basbuf[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=basbuf[i];
			}
			namespaceScopes.push_back( temporary );

			continue;
		}
		else if( basbuf[i] == 1 && basbuf[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				compiler.errorMessenger.Output(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}

		else if( basbuf[i] == 1 && basbuf[i+1] == ESC_IMPORTS ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( basbuf[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=basbuf[i];
			}
			if( !compiler.GetNamespaceSupporter().ImportsNamespace( temporary ) )
			{
				compiler.errorMessenger.Output(64,temporary,i );
			}

			continue;
		}
		else if( basbuf[i] == 1 && basbuf[i+1] == ESC_CLEARNAMESPACEIMPORTED )
		{
			// Imports̃NA
			compiler.GetNamespaceSupporter().ClearImportedNamespaces();
			continue;
		}



		if(basbuf[i]==1&&basbuf[i+1]==ESC_INTERFACE){
			//////////////////////////
			// C^[tFCX
			//////////////////////////

			top_pos=i;

			i+=2;

			//C^[tFCX擾
			GetCommandToken( temporary, basbuf, i );

			char className[VN_SIZE];
			Jenga::Common::Strings typeParameters;
			Jenga::Common::Strings typeParameterBaseClassNames;
			SplitGenericClassInstance( temporary, className, typeParameters, true, &typeParameterBaseClassNames );

			CClass *pobj_c = const_cast<CClass *>( classes.FindEx( Symbol( namespaceScopes, className ) ) );
			if(!pobj_c) continue;

			compiler.SetCompilingClass( pobj_c );

			if(lpszInheritsClass){
				if(lstrcmp(lpszInheritsClass,pobj_c->GetName().c_str())!=0){
					//pǂݗp
					continue;
				}
			}

			if(pobj_c->IsReady()){
				//ɐǂ݂ĂƂ
				continue;
			}

			/////////////////////////////////////////////////////////
			//  WFlNXT|[g 
			for( i2=0; i2<static_cast<int>(typeParameters.size()); i2++ )
			{
				Type baseType( DEF_OBJECT, *classes.GetObjectClassPtr() );
				if( typeParameterBaseClassNames[i2].size() )
				{
					if( !compiler.StringToType( typeParameterBaseClassNames[i2], baseType ) )
					{
						compiler.errorMessenger.Output(106,typeParameterBaseClassNames[i2],i);
					}
					else if( !baseType.IsObject() )
					{
						compiler.errorMessenger.Output(106,typeParameterBaseClassNames[i2],i);
					}
				}

				pobj_c->AddFormalGenericType( GenericType( typeParameters[i2], baseType ) );
			}
			/////////////////////////////////////////////////////////

			pobj_c->Readed();

			pobj_c->SetConstructorMemberSubIndex( -1 );
			pobj_c->SetDestructorMemberSubIndex( -1 );

			if( memcmp( basbuf+i+1, "__COM", 5 ) == 0 && IsCommandDelimitation( basbuf[i+1+5] ) )
			{
				// COMC^[tFCX
				pobj_c->SetClassType( CClass::ComInterface );

				i += 6;
			}

			if(basbuf[i+1]==1&&basbuf[i+2]==ESC_INHERITS){
				//psꍇ
				for(i+=3,i2=0;;i++,i2++){
					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}

				if(lstrcmpi(temporary,pobj_c->GetName().c_str())==0){
					compiler.errorMessenger.Output(105,temporary,i);
					goto Interface_InheritsError;
				}

				//pNX擾
				const CClass *pInheritsClass = compiler.GetObjectModule().meta.FindClassSupportedTypeDef(
					LexicalAnalyzer::FullNameToSymbol( temporary )
				);
				if( !pInheritsClass ){
					compiler.errorMessenger.Output(106,temporary,i);
					goto Interface_InheritsError;
				}

				//[vpłȂ`FbN
				if( !LexicalAnalyzer::LoopRefCheck( *pInheritsClass ) )
				{
					compiler.errorMessenger.Output(123,pInheritsClass->GetName(),i);
					goto Interface_InheritsError;
				}

				//p
				if( !pobj_c->InheritsClass( *pInheritsClass, Types(), i ) ){
					goto Interface_InheritsError;
				}
			}
			else{
				//p
				if( &pobj_c->GetSuperClass() || pobj_c->GetVtblNum() )
				{
					// TODO: ɗȂƂ؂ł炱̕͏
					Jenga::Throw( "GetClass_recur̗O" );
				}
			}
Interface_InheritsError:

			//oϐA֐擾
			while(1){
				i++;

				//G[
				if(basbuf[i]==1&&(basbuf[i+1]==ESC_CLASS||basbuf[i+1]==ESC_TYPE||basbuf[i+1]==ESC_INTERFACE)){
					compiler.errorMessenger.Output(22,"Interface",i);
					i--;
					break;
				}

				if(basbuf[i]==1&&basbuf[i+1]==ESC_INHERITS){
					compiler.errorMessenger.Output(111,NULL,i);
					break;
				}
				else if( basbuf[i] == 1 && basbuf[i+1] == ESC_IMPLEMENTS )
				{
					compiler.errorMessenger.Output(137, NULL, i );
					break;
				}

				sub_address=i;

				for(i2=0;;i++,i2++){
					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}
				if(temporary[0]=='\0'){
					if(basbuf[i]=='\0'){
						i--;
						compiler.errorMessenger.Output(22,"Interface",top_pos);
						break;
					}
					continue;
				}

				//End InterfaceLq̏ꍇ
				if(temporary[0]==1&&temporary[1]==ESC_ENDINTERFACE) break;

				if(!(temporary[0]==1&&(
					temporary[1]==ESC_SUB||temporary[1]==ESC_FUNCTION
					))){
					compiler.errorMessenger.Output(1,NULL,i);
					break;
				}

				//֐nbV֓o^
				char interfaceName[VN_SIZE] = "";
				UserProc *pUserProc = LexicalAnalyzer::ParseUserProc( NamespaceScopes(), NamespaceScopesCollection(), temporary,sub_address,true,pobj_c, false, interfaceName );
				if( pUserProc )
				{
					// ֐ǉ
					if( compiler.GetObjectModule().meta.GetUserProcs().IsExist( pUserProc ) )
					{
						// ɑ݂Ă
						compiler.errorMessenger.Output(15,pUserProc->GetName(),i);

						delete pUserProc;
					}
					else
					{
						compiler.GetObjectModule().meta.GetUserProcs().Put( pUserProc );
					}

					//o֐ǉ
					LexicalAnalyzer::AddMethod(pobj_c,
						pUserProc,
						Prototype::Public,	//PublicANZX
						0,					// bStatic
						false,				// isConst
						true,				// isAbstract
						true,				// isVirtual
						false,				// isOverride
						interfaceName,
						false,				// isAutoGeneration
						sub_address
						);
				}
			}
		}

		if(basbuf[i]==1&&(basbuf[i+1]==ESC_CLASS||basbuf[i+1]==ESC_TYPE)){
			//////////////////////////
			// NX
			//////////////////////////

			top_pos=i;

			const DWORD dwClassType=basbuf[i+1];

			i+=2;

			int iAlign=0;
			if(memicmp(basbuf+i,"Align(",6)==0){
				//ACgCq
				i+=6;
				i+=GetStringInPare_RemovePare(temporary,basbuf+i)+1;
				iAlign=atoi(temporary);

				if( dwClassType != ESC_TYPE )
				{
					compiler.errorMessenger.Output(140,NULL,i);
				}

				if(!(iAlign==1||iAlign==2||iAlign==4||iAlign==8||iAlign==16))
					compiler.errorMessenger.Output(51,NULL,i);
			}
			else if( memicmp( basbuf + i, "Blittable(", 10 ) == 0 ){
				// BlittableCq
				i+=10;
				i=JumpStringInPare(basbuf,i)+1;

				if( dwClassType != ESC_CLASS )
				{
					compiler.errorMessenger.Output(141,NULL,i);
				}
			}

			if( basbuf[i] == 1 && basbuf[i+1] == ESC_ENUM )
			{
				// 񋓌^̏ꍇ
				i += 2;
			}
			else if( basbuf[i] == 1 && basbuf[i+1] == ESC_DELEGATE )
			{
				// fQ[g̏ꍇ
				i += 2;
			}

			//NX擾
			GetCommandToken( temporary, basbuf, i );

			char className[VN_SIZE];
			Jenga::Common::Strings typeParameters;
			Jenga::Common::Strings typeParameterBaseClassNames;
			SplitGenericClassInstance( temporary, className, typeParameters, true, &typeParameterBaseClassNames );

			CClass *pobj_c =  const_cast<CClass *>( classes.FindEx( Symbol( namespaceScopes, className ) ) );
			if(!pobj_c) continue;

			compiler.SetCompilingClass( pobj_c );

			if(lpszInheritsClass){
				if( pobj_c->GetName() != lpszInheritsClass ){
					//pǂݗp
					continue;
				}
			}

			if( lstrcmp(className,"Control")==0)
			{
				int test=0;
			}

			if(pobj_c->IsReady()){
				//ɐǂ݂ĂƂ
				continue;
			}


			/////////////////////////////////////////////////////////
			//  WFlNXT|[g 
			for( i2=0; i2<static_cast<int>(typeParameters.size()); i2++ )
			{
				Type baseType( DEF_OBJECT, *classes.GetObjectClassPtr() );
				if( typeParameterBaseClassNames[i2].size() )
				{
					if( !compiler.StringToType( typeParameterBaseClassNames[i2], baseType ) )
					{
						compiler.errorMessenger.Output(106,typeParameterBaseClassNames[i2],i);
					}
					else if( !baseType.IsObject() )
					{
						compiler.errorMessenger.Output(106,typeParameterBaseClassNames[i2],i);
					}
				}

				pobj_c->AddFormalGenericType( GenericType( typeParameters[i2], baseType ) );
			}
			/////////////////////////////////////////////////////////


			pobj_c->SetFixedAlignment( iAlign );

			pobj_c->Readed();

			pobj_c->SetConstructorMemberSubIndex( -1 );
			pobj_c->SetDestructorMemberSubIndex( -1 );

			//ANZX̏lZbg
			Prototype::Accessibility accessibility;
			if(dwClassType==ESC_CLASS){
				accessibility = Prototype::Private;
			}
			else{
				accessibility = Prototype::Public;
			}

			if( pobj_c->GetName() == "Object"
				|| dwClassType == ESC_TYPE )
			{
				// pȂ

				if( &pobj_c->GetSuperClass() || pobj_c->GetVtblNum() )
				{
					// TODO: ɗȂƂ؂ł炱̕͏
					Jenga::Throw( "GetClass_recur̗O" );
				}
			}
			else{
				if(basbuf[i+1]==1&&basbuf[i+2]==ESC_INHERITS)
				{
					// NXp悪w肳ĂƂ
					i += 3;
					GetCommandToken( temporary, basbuf, i );

					if(lstrcmpi(temporary,pobj_c->GetName().c_str())==0){
						compiler.errorMessenger.Output(105,temporary,i);
						goto InheritsError;
					}
				}
				else
				{
					// ̎wȂƂObjectNXp
					lstrcpy( temporary, "Object" );
				}
				LexicalAnalyzer::Inherits( *pobj_c, temporary, i );

				if( basbuf[i+1] == 1 && basbuf[i+2] == ESC_IMPLEMENTS )
				{
					// C^[tFCXsꍇ
					i += 3;
					GetCommandToken( temporary, basbuf, i );

					LexicalAnalyzer::Implements( *pobj_c, temporary, i );
				}
			}
InheritsError:

			//oƃ\bh擾
			while(1){
				i++;

				//G[
				if(basbuf[i]==1&&(basbuf[i+1]==ESC_CLASS||basbuf[i+1]==ESC_TYPE)){
					compiler.errorMessenger.Output(22,"Class",i);
					i--;
					break;
				}

				if(basbuf[i]==1&&basbuf[i+1]==ESC_INHERITS){
					compiler.errorMessenger.Output(111,NULL,i);
					break;
				}
				else if( basbuf[i] == 1 && basbuf[i+1] == ESC_IMPLEMENTS )
				{
					compiler.errorMessenger.Output(137, NULL, i );
					break;
				}

				//StaticCq
				BOOL bStatic;
				if(basbuf[i]==1&&basbuf[i+1]==ESC_STATIC){
					bStatic=1;
					i+=2;
				}
				else bStatic=0;

				//ConstCq
				bool isConst = false;
				if( basbuf[i] == 1 && basbuf[i + 1] == ESC_CONST ){
					isConst = true;
					i += 2;
				}

				if(basbuf[i]==1&&(
					basbuf[i+1]==ESC_ABSTRACT||basbuf[i+1]==ESC_VIRTUAL||basbuf[i+1]==ESC_OVERRIDE||
					basbuf[i+1]==ESC_SUB||basbuf[i+1]==ESC_FUNCTION
					)){
					i3=basbuf[i+1];
					sub_address=i;
				}
				else i3=0;

				bool isVirtual = false, isAbstract = false, isOverride = false;
				if(i3==ESC_ABSTRACT){
					isAbstract=1;
					isVirtual=1;
					i+=2;

					i3=basbuf[i+1];
				}
				else if(i3==ESC_VIRTUAL){
					isAbstract=0;
					isVirtual=1;
					i+=2;

					i3=basbuf[i+1];
				}
				else if(i3==ESC_OVERRIDE){
					isOverride=1;
					isVirtual=1;

					i+=2;

					i3=basbuf[i+1];
				}

				for(i2=0;;i++,i2++){
					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}
				if(temporary[0]=='\0'){
					if(basbuf[i]=='\0'){

						if(dwClassType==ESC_CLASS)
							compiler.errorMessenger.Output(22,"Class",top_pos);
						else
							compiler.errorMessenger.Output(22,"Type",top_pos);

						i--;
						break;
					}
					continue;
				}

				//End ClassLq̏ꍇ
				if(temporary[0]==1&&temporary[1]==ESC_ENDCLASS&&dwClassType==ESC_CLASS) break;
				if(temporary[0]==1&&temporary[1]==ESC_ENDTYPE&&dwClassType==ESC_TYPE) break;

				//ANZXύX
				if(lstrcmpi(temporary,"Private")==0){
					accessibility = Prototype::Private;
					continue;
				}
				if(lstrcmpi(temporary,"Public")==0){
					accessibility = Prototype::Public;
					continue;
				}
				if(lstrcmpi(temporary,"Protected")==0){
					accessibility = Prototype::Protected;
					continue;
				}

				extern int cp;
				if(i3==0){
					cp=i;	//G[p
					Member *pMember = LexicalAnalyzer::CreateMember( *pobj_c, accessibility, isConst, false, temporary, i );
					if( pMember )
					{
						if(bStatic)
						{
							//ÓIoǉ
							pobj_c->AddStaticMember( pMember );
						}
						else
						{
							//oǉ
							pobj_c->AddDynamicMember( pMember );


							if(pobj_c->GetDynamicMembers().back()->GetType().IsStruct()){
								if( !pobj_c->GetDynamicMembers().back()->GetType().GetClass().IsReady() ){
									//QƐ悪ǂݎĂȂƂ
									GetClass_recur( pobj_c->GetDynamicMembers().back()->GetType().GetClass().GetName().c_str(), classes );
								}
							}


							if(pobj_c->GetDynamicMembers().back()->GetType().IsStruct()){
								//zQƂ̃`FbN
								pobj_LoopRefCheck->add(pobj_c->GetName().c_str());
								if(!MemberVar_LoopRefCheck(pobj_c->GetDynamicMembers().back()->GetType().GetClass())){
									//G[
									Type &type = const_cast<Type &>(pobj_c->GetDynamicMembers().back()->GetType());
									type.SetBasicType( DEF_PTR_VOID );
								}
								pobj_LoopRefCheck->del(pobj_c->GetName().c_str());
							}
						}
					}
				}
				else{
					//֐nbV֓o^
					char interfaceName[VN_SIZE] = "";
					UserProc *pUserProc = LexicalAnalyzer::ParseUserProc( NamespaceScopes(), NamespaceScopesCollection(), temporary,sub_address,isVirtual,pobj_c, (bStatic!=0), interfaceName );
					if( pUserProc )
					{
						// ֐ǉ
						if( compiler.GetObjectModule().meta.GetUserProcs().IsExist( pUserProc ) )
						{
							// ɑ݂Ă
							compiler.errorMessenger.Output(15,pUserProc->GetName(),i);

							delete pUserProc;
						}
						else
						{
							compiler.GetObjectModule().meta.GetUserProcs().Put( pUserProc );
						}

						//\bhǉ
						cp=i;	//G[p
						LexicalAnalyzer::AddMethod(pobj_c,
							pUserProc,
							accessibility,
							bStatic,
							isConst,
							isAbstract,
							isVirtual,
							isOverride,
							interfaceName,
							false,
							sub_address);
					}

					if( isAbstract ) continue;

					for(;;i++){
						if(basbuf[i]=='\0'){
							i--;
							break;
						}
						if(basbuf[i-1]!='*'&&
							basbuf[i]==1&&(
							basbuf[i+1]==ESC_SUB||
							basbuf[i+1]==ESC_FUNCTION||
							basbuf[i+1]==ESC_MACRO||
							basbuf[i+1]==ESC_TYPE||
							basbuf[i+1]==ESC_CLASS||
							basbuf[i+1]==ESC_INTERFACE||
							basbuf[i+1]==ESC_ENUM)){
							GetDefaultNameFromES(i3,temporary);
							compiler.errorMessenger.Output(22,temporary,i);
						}
						if(basbuf[i]==1&&basbuf[i+1]==GetEndXXXCommand((char)i3)){
							i+=2;
							break;
						}
					}
				}
			}
		}
	}

	// ĂяoŃRpC̃NX|C^ɖ߂
	compiler.SetCompilingClass( pBackCompilingClass );

	// OԂɖ߂
	compiler.GetNamespaceSupporter().GetLivingNamespaceScopes() = backupNamespaceScopes;

	// C|[gꂽOԂɖ߂
	compiler.GetNamespaceSupporter().SetImportedNamespaces( backupImportedNamespaces );
}

void LexicalAnalyzer::LookaheadClass( const char *className, Classes &classes )
{
	pobj_LoopRefCheck->add( className );
	GetClass_recur( className, classes );
	pobj_LoopRefCheck->del( className );
}

bool LexicalAnalyzer::LoopRefCheck( const CClass &objClass )
{
	if( pobj_LoopRefCheck->check( objClass ) )
	{
		return false;
	}

	return true;
}

void LexicalAnalyzer::CollectClasses( const char *source, Classes &classes ){
	//[vp`FbNp̃NX
	pobj_LoopRefCheck=new CLoopRefCheck();

	//NX擾
	GetClass_recur( 0, classes );

	delete pobj_LoopRefCheck;
	pobj_LoopRefCheck=0;

	// Ce[^̏
	classes.Iterator_Init();
}

void LexicalAnalyzer::TemplateExpand_ResolveMethod( const CMethod *pBaseMethod, const Types &actualTypes, CClass *pNewClass )
{
	UserProc *pUserProc = new UserProc(
		pBaseMethod->GetUserProc(),
		pNewClass
	);
	pUserProc->Using();
	pUserProc->GetParameters().clear();
	pUserProc->RealParams().clear();

	// p[^̃WFlbN^
	BOOST_FOREACH( const Parameter *pParam, pBaseMethod->GetUserProc().Params() )
	{
		Type type = pParam->IsTypeParameter()
			? actualTypes[pParam->GetFormalTypeIndex()]
			: *pParam;
		type.SetPtrLevel( pParam->PtrLevel() );

		pUserProc->GetParameters().push_back( new Parameter( *pParam, type ) );
	}
	BOOST_FOREACH( const Parameter *pParam, pBaseMethod->GetUserProc().RealParams() )
	{
		Type type = pParam->IsTypeParameter()
			? actualTypes[pParam->GetFormalTypeIndex()]
			: *pParam;
		type.SetPtrLevel( pParam->PtrLevel() );

		pUserProc->RealParams().push_back( new Parameter( *pParam, type ) );
	}

	// ߂l̃WFlbN^
	if( pUserProc->ReturnType().IsTypeParameter() )
	{
		Type type = actualTypes[pUserProc->ReturnType().GetFormalTypeIndex()];
		type.SetPtrLevel( pUserProc->ReturnType().PtrLevel() );
		pUserProc->SetReturnType( type );
	}

	compiler.GetObjectModule().meta.GetUserProcs().Put( pUserProc );
	compiler.GetObjectModule().meta.GetUserProcs().Iterator_Init();

	LexicalAnalyzer::AddMethod(
		pNewClass,
		pUserProc,
		pBaseMethod->GetAccessibility(),
		pBaseMethod->IsStatic(),
		pBaseMethod->IsConst(),
		pBaseMethod->IsAbstract(),
		pBaseMethod->IsVirtual(),
		false,
		"",
		false,
		-1
	);
}

const CClass *LexicalAnalyzer::TemplateExpand( CClass &_class, const Types &actualTypes )
{
	// WJς݂̃NX΂Ԃ
	BOOST_FOREACH( const ExpandedTemplateClass *pExpandedTemplateClass, _class.expandedTemplateClasses )
	{
		if( pExpandedTemplateClass->GetActualTypes().IsEquals( actualTypes ) )
		{
			return &pExpandedTemplateClass->GetClass();
		}
	}


	/////////////////////////////////////////////////////////////////
	// WJ̏ꍇ͐VɓWJ
	/////////////////////////////////////////////////////////////////

	// NXRs[
	CClass *pNewClass = new CClass(
		_class,
		_class.GetImportedNamespaces(),
		_class.GetClassType(),
		_class.GetFormalGenericTypes(),
		actualTypes,
		_class.GetConstructorMemberSubIndex(),
		_class.GetDestructorMemberSubIndex(),
		0,
		_class.GetFixedAlignment()
	);

	// NX
	pNewClass->SetSuperClass( &_class.GetSuperClass() );

	// C^[tFCX̃WFlbN^
	BOOST_FOREACH( const ::Interface *pInterface, _class.GetInterfaces() )
	{
		pNewClass->AddInterface( new ::Interface( &pInterface->GetClass(), actualTypes ) );
	}

	// õWFlbN^
	BOOST_FOREACH( const Member *pMember, _class.GetDynamicMembers() )
	{
		Type type = pMember->GetType();
		if( type.IsTypeParameter() )
		{
			// WFlbN^Ƃ͒l^ɕϊ
			type = actualTypes[type.GetFormalTypeIndex()];
			type.SetPtrLevel( pMember->GetType().PtrLevel() );
		}

		pNewClass->GetDynamicMembers().push_back(
			new Member( *pMember, type )
		);
	}

	// NX \bh̃WFlbN^
	BOOST_FOREACH( const CMethod *pMethod, _class.GetDynamicMethods() )
	{
		if( pMethod->GetUserProc().GetParentClassPtr() == &_class )
		{
			// ^[QbgNXŎ郁\bh̏ꍇ

			TemplateExpand_ResolveMethod( pMethod, actualTypes, pNewClass );
		}
		else
		{
			DynamicMethod *pNewDynamicMethod = new DynamicMethod( *pMethod );
			pNewClass->GetDynamicMethods().push_back( pNewDynamicMethod );
		}
	}

	// C^[tFCX \bh̃WFlbN^
	BOOST_FOREACH( const ::Interface *pInterface, _class.GetInterfaces() )
	{
		BOOST_FOREACH( const CMethod *pMethod, pInterface->GetDynamicMethods() )
		{
			TemplateExpand_ResolveMethod( pMethod, actualTypes, pNewClass );
		}
	}

	pNewClass->SetVtblNum( _class.GetVtblNum() );

	// WJς݃NXƂēo^
	_class.expandedTemplateClasses.push_back( new ExpandedTemplateClass( pNewClass, actualTypes ) );

	pNewClass->Readed();

	return pNewClass;
}
