#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

BOOL IsUse_ecx(RELATIVE_VAR *pRelativeVar){
	if(pRelativeVar->bOffsetOffset||pRelativeVar->dwKind==VAR_DIRECTMEM) return 1;
	return 0;
}

void SetStructVariable(LONG_PTR lpVarIndex,int CalcType,LONG_PTR lpCalcIndex,BOOL bUseHeap){
/*
	TODO: 
	///////////////////////////////////////////////////////////////////
	// Iy[^ '=' ̃I[o[[h֐Ă
	///////////////////////////////////////////////////////////////////

	int type[10];
	LONG_PTR index_stack[10];
	BOOL array_bUseHeap[10];
	int sp=2;

	//
	type[0]=DEF_OBJECT;
	index_stack[0]=lpVarIndex;
	array_bUseHeap[0]=0;

	//E
	type[1]=CalcType;
	index_stack[1]=lpCalcIndex;
	array_bUseHeap[1]=bUseHeap;

	int iRet;
	iRet=CallOperatorProc(CALC_SUBSITUATION,NULL,type,index_stack,array_bUseHeap,sp);
	if(iRet==-1||iRet==1){
		//ƂA܂̓G[sꂽƂ
		return;
	}*/


	if( CalcType == DEF_STRUCT ){
		CClass *pVarClass = (CClass *)lpVarIndex;
		CClass *pCalcClass = (CClass *)lpCalcIndex;


		if( pVarClass->IsEquals( pCalcClass ) ){		//

				//õIuWFNg^vA܂͔hEp֌WɂƂ
				//Rs[s

				int object_size = pVarClass->GetSize();

				//mov ecx,object_size
				op_mov_RV(REG_ECX,object_size);

				//pop esi
				op_pop(REG_ESI);

				//pop edi
				op_pop(REG_EDI);

				if(bUseHeap){
					//mov eax,esi
					op_mov_RR(REG_EAX,REG_ESI);
				}

				//rep movs byte ptr[edi],byte ptr[esi]
				op_rep_movs(sizeof(BYTE));

				if(bUseHeap){
					//push eax
					op_push(REG_EAX);

					//call free
					extern SUBINFO *pSub_free;
					op_call(pSub_free);
				}

				return;
		}
	}

	SetError(1,NULL,cp);
}


void SetRealVariable(int VarType,int CalcType,RELATIVE_VAR *pRelativeVar){
	if( !IsRealNumberType( CalcType ) ){
		// ֕ϊ
		// 64bit edx:eax -> st(0)
		// 32bit     eax -> st(0)

		if( Is64Type( CalcType ) ){
			//64rbg^

			//push edx
			op_push( REG_EDX );

			//push eax
			op_push( REG_EAX );

			//fild qword ptr[esp]
			op_fld_ptr_esp(DEF_INT64);

			//pop
			op_pop( REG_NON );

			//pop
			op_pop( REG_NON );
		}
		else{
			//push eax
			op_push( REG_EAX );

			//fild qword ptr[esp]
			op_fld_ptr_esp(DEF_LONG);

			//pop
			op_pop( REG_NON );
		}
	}

	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//fstp ptr[ecx+offset]
			op_fstp_base_offset(VarType,REG_ECX,(int)pRelativeVar->offset);
			obp-=sizeof(long);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//mov ecx,offset
			op_mov_RV(REG_ECX,(int)pRelativeVar->offset);
			obp-=sizeof(long);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);

			//fstp ptr[ecx]
			op_fstp_basereg(VarType,REG_ECX);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFGLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//add ecx,qword ptr[offset]
			op_add_RM(sizeof(long),REG_ECX,REG_NON,(int)pRelativeVar->offset,MOD_DISP32);
		}
		else{
			//mov ecx,qword ptr[offset]
			op_mov_RM(sizeof(long),REG_ECX,REG_NON,(int)pRelativeVar->offset,MOD_DISP32);
		}
		obp-=sizeof(long);
		pobj_GlobalVarSchedule->add();
		obp+=sizeof(long);

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//fstp ptr[ebp+ecx+offset]
			op_fstp_base_offset_ex(VarType,REG_EBP,REG_ECX,(int)pRelativeVar->offset,USE_OFFSET);
		}
		else{
			//fstp ptr[ebp+offset]
			op_fstp_base_offset(VarType,REG_EBP,(int)pRelativeVar->offset);
		}
		obp-=sizeof(long);
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);
	}
	else if(pRelativeVar->dwKind==VAR_REFLOCAL){
		if(pRelativeVar->bOffsetOffset){
			//add ecx,qword ptr[ebp+offset]
			op_add_RM(sizeof(long),REG_ECX,REG_EBP,(int)pRelativeVar->offset,MOD_BASE_DISP32);
		}
		else{
			//mov ecx,qword ptr[ebp+offset]
			op_mov_RM(sizeof(long),REG_ECX,REG_EBP,(int)pRelativeVar->offset,MOD_BASE_DISP32);
		}
		obp-=sizeof(long);
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
directmem:
		//fstp ptr[ecx]
		op_fstp_basereg(VarType,REG_ECX);
	}
}

void SetBooleanVariable(int type,RELATIVE_VAR *pRelative){
	if(type==DEF_DOUBLE){
		// TODO: 
		SetError();
	}
	else if(type==DEF_SINGLE){
		// TODO: 
		SetError();
	}
	else if(type==DEF_INT64||type==DEF_QWORD){
		//cmp eax,0
		op_cmp_value(GetTypeSize(type,-1),REG_EAX,0);

		//setne al
		op_setne( REG_EAX );

		//cmp edx,0
		op_cmp_value(GetTypeSize(type,-1),REG_EDX,0);

		//setne cl
		op_setne( REG_ECX );

		//or al,cl
		op_or_RR( sizeof( _int8 ), REG_EAX, REG_ECX );
	}
	else{
		if(!IsWholeNumberType(type)){
			//sȌ^̏ꍇ
			SetError(9,NULL,cp);
			return;
		}
	}

	//cmp eax,0
	op_cmp_value(GetTypeSize(type,-1),REG_EAX,0);

	//setne al
	op_setne( REG_EAX );

	SetWholeVariable( sizeof(char), DEF_BYTE, pRelative );
}

void ExtendTypeTo32(int type,int reg);
void ExtendTypeTo64(int type){
	if(Is64Type(type)) return;

	ExtendTypeTo32(type,REG_EAX);

	if(IsSignedType(type)){
		//cdq
		op_cdq();
	}
	else{
		//xor edx,edx
		op_zero_reg(REG_EDX);
	}
}
void ExtendTypeTo32(int type,int reg){
	if(type==DEF_INTEGER || (isUnicode&&type==DEF_CHAR)){
		//movsx reg32,reg16
		op_movsx_R32R16(reg,reg);
	}
	else if(type==DEF_WORD){
		//and reg,0000FFFFh
		op_and_RV(reg,(int)0x0000FFFF);
	}
	else if(type==DEF_SBYTE || (isUnicode==false&&type==DEF_CHAR)){
		//movsx reg32,reg8
		op_movsx_R32R8(reg,reg);
	}
	else if(type==DEF_BYTE||type==DEF_BOOLEAN){
		//and reg,000000FFh
		op_and_RV(reg,(int)0xFF);
	}
}
void ExtendTypeTo16(int type,int reg){
	if(type==DEF_SBYTE || (isUnicode==false&&type==DEF_CHAR)){
		//movsx reg16,reg8
		op_movsx_R16R8(reg,reg);
	}
	else if(type==DEF_BYTE||type==DEF_BOOLEAN){
		//and reg,000000FFh
		op_and_RV(reg,(int)0xFF);
	}
}

void SetWholeVariable(int varSize,int calcType,RELATIVE_VAR *pRelative){
	if( IsRealNumberType( calcType ) ){
		// ^琮^֕ϊ

		if( varSize == sizeof(_int64) ){
			// 64bit
			// st(0) -> edx:eax
			breakpoint;

			//push
			//push
			op_sub_esp( PTR_SIZE * 2 );

			//fistp qword ptr[esp]
			op_fistp_ptr_esp( sizeof(_int64) );

			//pop eax
			op_pop( REG_EAX );

			//pop edx
			op_pop( REG_EDX );
		}
		else{
			// 32bit
			// st(0) -> eax

			//push
			op_push( REG_NON );

			//fistp dword ptr[esp]
			op_fistp_ptr_esp( sizeof(long) );

			//pop eax
			op_pop( REG_EAX );
		}
	}
	else{
		//̑̐

		if(varSize==sizeof(_int64)){
			//eax̒l64rbgiedx:eaxjɊg
			ExtendTypeTo64(calcType);
		}
		else if(varSize==sizeof(long)){
			//WX^̒l32rbgieaxjɊg
			ExtendTypeTo32(calcType,REG_EAX);
		}
		else if(varSize==sizeof(short)){
			//WX^̒l16rbgiaxjɊg
			ExtendTypeTo16(calcType,REG_EAX);
		}
		//8rbg͊gȂ
	}

	if(varSize==sizeof(_int64)){
		//32rbg
		SetWholeVariable(sizeof(long),DEF_LONG,pRelative);

		//32rbg

		//ڎQƂɐ؂ւ
		SetVarPtrToEax(pRelative);
		pRelative->dwKind=VAR_DIRECTMEM;

		//mov ecx,eax
		op_mov_RR( REG_ECX, REG_EAX );

		//add ecx,sizeof(long)
		op_add_RV8( REG_ECX, sizeof(long) );

		//mov eax,edx
		op_mov_RR( REG_EAX, REG_EDX );

		SetWholeVariable(sizeof(long),DEF_LONG,pRelative);

		return;
	}

	if(pRelative->dwKind==VAR_GLOBAL){
		if(pRelative->bOffsetOffset){
			//mov ptr[ecx+offset],eax/ax/al
			op_mov_MR(varSize,REG_EAX,REG_ECX,(int)pRelative->offset,MOD_BASE_DISP32);
		}
		else{
			//mov ptr[offset],eax/ax/al
			op_mov_MR(varSize,REG_EAX,0,(int)pRelative->offset,MOD_DISP32);
		}
		obp-=sizeof(long);
		pobj_GlobalVarSchedule->add();
		obp+=sizeof(long);
	}
	else if(pRelative->dwKind==VAR_REFGLOBAL){
		if(pRelative->bOffsetOffset){
			//add ecx,qword ptr[offset]
			op_add_RM(varSize,REG_ECX,REG_NON,(int)pRelative->offset,MOD_DISP32);
		}
		else{
			//mov ecx,qword ptr[offset]
			op_mov_RM(varSize,REG_ECX,REG_NON,(int)pRelative->offset,MOD_DISP32);
		}
		obp-=sizeof(long);
		pobj_GlobalVarSchedule->add();
		obp+=sizeof(long);

		goto directmem;
	}
	else if(pRelative->dwKind==VAR_LOCAL){
		if(pRelative->bOffsetOffset){
			//mov ptr[ebp+ecx+offset],eax/ax/al
			op_mov_MR_ex(varSize,REG_EAX,REG_EBP,REG_ECX,(int)pRelative->offset,USE_OFFSET);
		}
		else{
			//mov ptr[ebp+offset],eax/ax/al
			op_mov_MR(varSize,REG_EAX,REG_EBP,(int)pRelative->offset,MOD_BASE_DISP32);
		}
		obp-=sizeof(long);
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);
	}
	else if(pRelative->dwKind==VAR_REFLOCAL){
		if(pRelative->bOffsetOffset){
			//add ecx,qword ptr[ebp+offset]
			op_add_RM(varSize,REG_ECX,REG_EBP,(int)pRelative->offset,MOD_BASE_DISP32);
		}
		else{
			//mov ecx,qword ptr[ebp+offset]
			op_mov_RM(varSize,REG_ECX,REG_EBP,(int)pRelative->offset,MOD_BASE_DISP32);
		}
		obp-=sizeof(long);
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);

		goto directmem;
	}
	else if(pRelative->dwKind==VAR_DIRECTMEM){
directmem:

		//mov ptr[ecx],eax/ax/al
		op_mov_MR(varSize,REG_EAX,REG_ECX,0,MOD_BASE);
	}
}

























/*
TODO: 
void SetDoubleVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset){
	ChangeTypeToDouble(type);

	//pop ebx
	op_pop(REG_EBX);

	//pop eax
	op_pop(REG_EAX);

	if(VarKind==VAR_GLOBAL){
		if(bOffsetOffset){
			//mov dword ptr[ecx+offset],ebx
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x99;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);

			//mov dword ptr[ecx+offset+sizeof(long)],eax
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x81;
			*((long *)(OpBuffer+obp))=offset+sizeof(long);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//mov dword ptr[offset],ebx
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x1D;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);

			//mov dword ptr[offset+sizeof(long)],eax
			OpBuffer[obp++]=(char)0xA3;
			*((long *)(OpBuffer+obp))=offset+sizeof(long);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if( VarKind==VAR_REFGLOBAL ){
		SetError(300,NULL,cp);
	}
	else if(VarKind==VAR_LOCAL){
		if(bOffsetOffset){
			//add ecx,offset
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//mov dword ptr[ebp+ecx],ebx
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x5C;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;

			//add ecx,sizeof(long)
			OpBuffer[obp++]=(char)0x83;
			OpBuffer[obp++]=(char)0xC1;
			OpBuffer[obp++]=(char)0x04;

			//mov dword ptr[ebp+ecx],eax
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x44;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//mov dword ptr[ebp+offset],ebx
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x9D;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//mov dword ptr[ebp+offset+sizeof(long)],eax
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=offset+sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(VarKind==VAR_REFLOCAL){
		if(bOffsetOffset){
			//add ecx,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0x8D;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else{
			//mov ecx,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0x8D;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}

		//mov dword ptr[ecx],ebx
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x19;

		//mov dword ptr[ecx+sizeof(long)],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x41;
		OpBuffer[obp++]=(char)0x04;
	}
	else if(VarKind==VAR_DIRECTMEM){
		//mov dword ptr[ecx],ebx
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x19;

		//mov dword ptr[ecx+sizeof(long)],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x41;
		OpBuffer[obp++]=(char)0x04;
	}
}
void SetSingleVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset){
	if(type==DEF_SINGLE){
		//32rbgϐƂĂ̂܂܃Rs[
		SetDWordVariable(DEF_DWORD,VarKind,offset,bOffsetOffset);
		return;
	}

	if(type==DEF_DOUBLE){
		//fld qword ptr[esp]
		op_fld_ptr_esp(DEF_DOUBLE);

		//add esp,8
		op_add_esp(8);
	}
	else if(type==DEF_INT64||type==DEF_QWORD){
		//64rbg

		//fild qword ptr[esp]
		op_fld_ptr_esp(DEF_INT64);

		//add esp,8
		op_add_esp(8);
	}
	else if(IsSignedType(type)){
		//萮

		//fild dword ptr[esp]
		op_fld_ptr_esp(DEF_LONG);

		//add esp,4
		op_add_esp(4);
	}
	else{
		if(!IsWholeNumberType(type)){
			//sȌ^̏ꍇ
			SetError(9,NULL,cp);
			return;
		}

		//Ȃ

		//pop eax
		op_pop(REG_EAX);

		//push 0
		op_push_value(0);

		//push eax
		op_push(REG_EAX);

		//fild qword ptr[esp]
		OpBuffer[obp++]=(char)0xDF;
		OpBuffer[obp++]=(char)0x2C;
		OpBuffer[obp++]=(char)0x24;

		//add esp,8
		op_add_esp(8);
	}

	if(VarKind==VAR_GLOBAL){
		if(bOffsetOffset){
			//fstp dword ptr[ecx+offset]
			OpBuffer[obp++]=(char)0xD9;
			OpBuffer[obp++]=(char)0x99;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//fstp dword ptr[offset]
			OpBuffer[obp++]=(char)0xD9;
			OpBuffer[obp++]=(char)0x1D;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if( VarKind==VAR_REFGLOBAL ){
		SetError(300,NULL,cp);
	}
	else if(VarKind==VAR_LOCAL){
		if(bOffsetOffset){
			//add ecx,offset
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//fstp dword ptr[ebp+ecx]
			OpBuffer[obp++]=(char)0xD9;
			OpBuffer[obp++]=(char)0x5C;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//fstp dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0xD9;
			OpBuffer[obp++]=(char)0x9D;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(VarKind==VAR_REFLOCAL){
		//mov eax,dword ptr[ebp+offset]
		OpBuffer[obp++]=(char)0x8B;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);

		if(bOffsetOffset){
			//add eax,ecx
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0xC1;
		}

		//fstp dword ptr[eax]
		OpBuffer[obp++]=(char)0xD9;
		OpBuffer[obp++]=(char)0x18;
	}
	else if(VarKind==VAR_DIRECTMEM){
		//fstp dword ptr[ecx]
		OpBuffer[obp++]=(char)0xD9;
		OpBuffer[obp++]=(char)0x19;
	}
}
void SetInt64Variable(int type,RELATIVE_VAR *pRelative){
	if(type==DEF_DOUBLE){
		//fld qword ptr[esp]
		op_fld_ptr_esp(DEF_DOUBLE);

		//fistp qword ptr[esp]
		fpu_cast();
		OpBuffer[obp++]=(char)0xDF;
		OpBuffer[obp++]=(char)0x3C;
		OpBuffer[obp++]=(char)0x24;
		fpu_cast_end();

		//pop eax
		op_pop(REG_EAX);

		//pop edx
		op_pop(REG_EDX);
	}
	else if(type==DEF_SINGLE){
		//fld dword ptr[esp]
		op_fld_ptr_esp(DEF_SINGLE);

		//sub esp,4
		op_sub_esp(4);

		//fistp qword ptr[esp]
		fpu_cast();
		OpBuffer[obp++]=(char)0xDF;
		OpBuffer[obp++]=(char)0x3C;
		OpBuffer[obp++]=(char)0x24;
		fpu_cast_end();

		//pop eax
		op_pop(REG_EAX);

		//pop edx
		op_pop(REG_EDX);
	}
	else if(type==DEF_INT64||type==DEF_QWORD){
		//pop eax
		op_pop(REG_EAX);

		//pop edx
		op_pop(REG_EDX);
	}
	else if(IsSignedType(type)){
		//g
		//edx:eax  eax

		//pop eax
		op_pop(REG_EAX);

		//cdq
		op_cdq();
	}
	else{
		if(!IsWholeNumberType(type)){
			//sȌ^̏ꍇ
			SetError(9,NULL,cp);
			return;
		}

		//g
		//edx=0:eax

		//pop eax
		op_pop(REG_EAX);

		//xor edx,edx
		op_zero_reg(REG_EDX);
	}

	if(pRelative->dwKind==VAR_GLOBAL){
		if(pRelative->bOffsetOffset){
			//mov dword ptr[ecx+offset],eax
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x81;
			*((long *)(OpBuffer+obp))=pRelative->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);

			//mov dword ptr[ecx+offset+sizeof(long)],edx
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x91;
			*((long *)(OpBuffer+obp))=pRelative->offset+sizeof(long);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//mov dword ptr[offset],eax
			OpBuffer[obp++]=(char)0xA3;
			*((long *)(OpBuffer+obp))=pRelative->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);

			//mov dword ptr[offset+sizeof(long)],edx
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x15;
			*((long *)(OpBuffer+obp))=pRelative->offset+sizeof(DWORD);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if(pRelative->dwKind==VAR_REFLOCAL){
		if(pRelative->bOffsetOffset){
			//add ecx,dword ptr[offset]
			op_add_RM( sizeof(long), REG_ECX, REG_NON, (int)pRelative->offset, MOD_DISP32 );
		}
		else{
			//mov ecx,dword ptr[offset]
			op_mov_RM( sizeof(long), REG_ECX, REG_NON, (int)pRelative->offset, MOD_DISP32 );
		}
		obp-=sizeof(long);
		pobj_GlobalVarSchedule->add();
		obp+=sizeof(long);

		//mov dword ptr[ecx],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x01;

		//mov dword ptr[ecx+sizeof(long)],edx
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x51;
		OpBuffer[obp++]=(char)0x04;
	}
	else if(pRelative->dwKind==VAR_LOCAL){
		if(pRelative->bOffsetOffset){
			//add ecx,offset
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=pRelative->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//mov dword ptr[ebp+ecx],eax
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x44;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;

			//add ecx,sizeof(long)
			OpBuffer[obp++]=(char)0x83;
			OpBuffer[obp++]=(char)0xC1;
			OpBuffer[obp++]=(char)0x04;

			//mov dword ptr[ebp+ecx],edx
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x54;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//mov dword ptr[ebp+offset],eax
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=pRelative->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//mov dword ptr[ebp+offset+sizeof(long)],edx
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x95;
			*((long *)(OpBuffer+obp))=pRelative->offset+sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(pRelative->dwKind==VAR_REFLOCAL){
		if(pRelative->bOffsetOffset){
			//add ecx,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0x8D;
			*((long *)(OpBuffer+obp))=pRelative->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else{
			//mov ecx,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0x8D;
			*((long *)(OpBuffer+obp))=pRelative->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}

		//mov dword ptr[ecx],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x01;

		//mov dword ptr[ecx+sizeof(long)],edx
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x51;
		OpBuffer[obp++]=(char)0x04;
	}
	else if(pRelative->dwKind==VAR_DIRECTMEM){
		//mov dword ptr[ecx],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x01;

		//mov dword ptr[ecx+sizeof(long)],edx
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x51;
		OpBuffer[obp++]=(char)0x04;
	}
}
void SetDWordVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset){
	if(type==DEF_DOUBLE||type==DEF_SINGLE){
		if(type==DEF_DOUBLE){
			//fld qword ptr[esp]
			op_fld_ptr_esp(DEF_DOUBLE);
		}
		else if(type==DEF_SINGLE){
			//fld dword ptr[esp]
			op_fld_ptr_esp(DEF_SINGLE);

			//sub esp,4
			op_sub_esp(4);
		}

		//fistp qword ptr[esp]
		fpu_cast();
		OpBuffer[obp++]=(char)0xDF;
		OpBuffer[obp++]=(char)0x3C;
		OpBuffer[obp++]=(char)0x24;
		fpu_cast_end();

		//pop eax
		op_pop(REG_EAX);

		//add esp,4
		op_add_esp(4);
	}
	else if(type==DEF_INT64||type==DEF_QWORD){
		//pop eax
		op_pop(REG_EAX);

		//add esp,4
		op_add_esp(4);
	}
	else{
		if(!IsWholeNumberType(type)){
			//sȌ^̏ꍇ
			SetError(9,NULL,cp);
			return;
		}

		ChangeTypeToWhole(type,DEF_LONG);

		//pop eax
		op_pop(REG_EAX);
	}

	if(VarKind==VAR_GLOBAL){
		if(bOffsetOffset){
			//mov dword ptr[ecx+offset],eax
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x81;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//mov dword ptr[offset],eax
			OpBuffer[obp++]=(char)0xA3;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if(VarKind==VAR_REFGLOBAL){
		if(bOffsetOffset){
			//add ecx,dword ptr[offset]
			op_add_RM( sizeof(long), REG_ECX, REG_NON, (int)offset, MOD_DISP32 );
		}
		else{
			//mov ecx,dword ptr[offset]
			op_mov_RM( sizeof(long), REG_ECX, REG_NON, (int)offset, MOD_DISP32 );
		}
		obp-=sizeof(long);
		pobj_GlobalVarSchedule->add();
		obp+=sizeof(long);

		//mov dword ptr[ecx],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x01;
	}
	else if(VarKind==VAR_LOCAL){
		if(bOffsetOffset){
			//add ecx,offset
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//mov dword ptr[ebp+ecx],eax
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x44;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//mov dword ptr[ebp+offset],eax
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(VarKind==VAR_REFLOCAL){
		if(bOffsetOffset){
			//add ecx,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0x8D;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else{
			//mov ecx,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0x8D;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}

		//mov dword ptr[ecx],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x01;
	}
	else if(VarKind==VAR_DIRECTMEM){
		//mov dword ptr[ecx],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x01;
	}
}
void SetLongVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset){
	if(type==DEF_DOUBLE||type==DEF_SINGLE){
		if(type==DEF_DOUBLE){
			//fld qword ptr[esp]
			op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,8
			op_add_esp(8);
		}
		else if(type==DEF_SINGLE){
			//fld dword ptr[esp]
			op_fld_ptr_esp(DEF_SINGLE);

			//add esp,4
			op_add_esp(4);
		}

		if(VarKind==VAR_GLOBAL){
			if(bOffsetOffset){
				//fistp dword ptr[ecx+offset]
				fpu_cast();
				OpBuffer[obp++]=(char)0xDB;
				OpBuffer[obp++]=(char)0x99;
				*((long *)(OpBuffer+obp))=offset;
				pobj_GlobalVarSchedule->add();
				obp+=sizeof(long);
				fpu_cast_end();
			}
			else{
				//fistp dword ptr[offset]
				fpu_cast();
				OpBuffer[obp++]=(char)0xDB;
				OpBuffer[obp++]=(char)0x1D;
				*((long *)(OpBuffer+obp))=offset;
				pobj_GlobalVarSchedule->add();
				obp+=sizeof(long);
				fpu_cast_end();
			}
		}
		else if(VarKind==VAR_REFGLOBAL){
			//mov eax,dword ptr[offset]
			op_mov_RM( sizeof(long), REG_EAX, REG_NON, (int)offset, MOD_DISP32 );
			obp-=sizeof(long);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);

			if(bOffsetOffset){
				//add eax,ecx
				OpBuffer[obp++]=(char)0x03;
				OpBuffer[obp++]=(char)0xC1;
			}

			//fistp dword ptr[eax]
			fpu_cast();
			OpBuffer[obp++]=(char)0xDB;
			OpBuffer[obp++]=(char)0x18;
			fpu_cast_end();
		}
		else if(VarKind==VAR_LOCAL){
			if(bOffsetOffset){
				//add ecx,offset
				OpBuffer[obp++]=(char)0x81;
				OpBuffer[obp++]=(char)0xC1;
				*((long *)(OpBuffer+obp))=offset;
				AddLocalVarAddrSchedule();
				obp+=sizeof(long);

				//fistp dword ptr[ebp+ecx]
				fpu_cast();
				OpBuffer[obp++]=(char)0xDB;
				OpBuffer[obp++]=(char)0x5C;
				OpBuffer[obp++]=(char)0x0D;
				OpBuffer[obp++]=(char)0x00;
				fpu_cast_end();
			}
			else{
				//fistp dword ptr[ebp+offset]
				fpu_cast();
				OpBuffer[obp++]=(char)0xDB;
				OpBuffer[obp++]=(char)0x9D;
				*((long *)(OpBuffer+obp))=offset;
				AddLocalVarAddrSchedule();
				obp+=sizeof(long);
				fpu_cast_end();
			}
		}
		else if(VarKind==VAR_REFLOCAL){
			//mov eax,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			if(bOffsetOffset){
				//add eax,ecx
				OpBuffer[obp++]=(char)0x03;
				OpBuffer[obp++]=(char)0xC1;
			}

			//fistp dword ptr[eax]
			fpu_cast();
			OpBuffer[obp++]=(char)0xDB;
			OpBuffer[obp++]=(char)0x18;
			fpu_cast_end();
		}
		else if(VarKind==VAR_DIRECTMEM){
			//fistp dword ptr[ecx]
			fpu_cast();
			OpBuffer[obp++]=(char)0xDB;
			OpBuffer[obp++]=(char)0x19;
			fpu_cast_end();
		}
	}
	else{
		//ȊǑ^̑DWord̂̂Ɠl
		SetDWordVariable(type,VarKind,offset,bOffsetOffset);
	}
}
void Set16Variable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset){
	ChangeTypeToWhole(type,DEF_INTEGER);

	//pop eax
	op_pop(REG_EAX);

	if(VarKind==VAR_GLOBAL){
		if(bOffsetOffset){
			//mov word ptr[ecx+offset],ax
			OpBuffer[obp++]=(char)0x66;
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x81;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//mov word ptr[offset],ax
			OpBuffer[obp++]=(char)0x66;
			OpBuffer[obp++]=(char)0xA3;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if(VarKind==VAR_REFGLOBAL){
		//mov ebx,dword ptr[offset]
		op_mov_RM( sizeof(long), REG_EBX, REG_NON, (int)offset, MOD_DISP32 );
		obp-=sizeof(long);
		pobj_GlobalVarSchedule->add();
		obp+=sizeof(long);

		if(bOffsetOffset){
			//add ebx,ecx
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0xD9;
		}

		//mov word ptr[ebx],ax
		OpBuffer[obp++]=(char)0x66;
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x03;
	}
	else if(VarKind==VAR_LOCAL){
		if(bOffsetOffset){
			//add ecx,offset
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//mov word ptr[ebp+ecx],ax
			OpBuffer[obp++]=(char)0x66;
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x44;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//mov word ptr[ebp+offset],ax
			OpBuffer[obp++]=(char)0x66;
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(VarKind==VAR_REFLOCAL){
		//mov ebx,dword ptr[ebp+offset]
		OpBuffer[obp++]=(char)0x8B;
		OpBuffer[obp++]=(char)0x9D;
		*((long *)(OpBuffer+obp))=offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);

		if(bOffsetOffset){
			//add ebx,ecx
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0xD9;
		}

		//mov word ptr[ebx],ax
		OpBuffer[obp++]=(char)0x66;
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x03;
	}
	else if(VarKind==VAR_DIRECTMEM){
		//mov word ptr[ecx],ax
		OpBuffer[obp++]=(char)0x66;
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x01;
	}
}
void Set8Variable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset){
	ChangeTypeToWhole(type,DEF_SBYTE);

	//pop eax
	op_pop(REG_EAX);

	if(VarKind==VAR_GLOBAL){
		if(bOffsetOffset){
			//mov byte ptr[ecx+offset],al
			OpBuffer[obp++]=(char)0x88;
			OpBuffer[obp++]=(char)0x81;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//mov byte ptr[offset],al
			OpBuffer[obp++]=(char)0xA2;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if(VarKind==VAR_REFGLOBAL){
		//mov ebx,dword ptr[offset]
		op_mov_RM( sizeof(long), REG_EBX, REG_NON, (int)offset, MOD_DISP32 );
		obp-=sizeof(long);
		pobj_GlobalVarSchedule->add();
		obp+=sizeof(long);

		if(bOffsetOffset){
			//add ebx,ecx
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0xD9;
		}

		//mov byte ptr[ebx],al
		OpBuffer[obp++]=(char)0x88;
		OpBuffer[obp++]=(char)0x03;
	}
	else if(VarKind==VAR_LOCAL){
		if(bOffsetOffset){
			//add ecx,offset
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//mov byte ptr[ebp+ecx],al
			OpBuffer[obp++]=(char)0x88;
			OpBuffer[obp++]=(char)0x44;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//mov byte ptr[ebp+offset],al
			OpBuffer[obp++]=(char)0x88;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(VarKind==VAR_REFLOCAL){
		//mov ebx,dword ptr[ebp+offset]
		OpBuffer[obp++]=(char)0x8B;
		OpBuffer[obp++]=(char)0x9D;
		*((long *)(OpBuffer+obp))=offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);

		if(bOffsetOffset){
			//add ebx,ecx
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0xD9;
		}

		//mov byte ptr[ebx],al
		OpBuffer[obp++]=(char)0x88;
		OpBuffer[obp++]=(char)0x03;
	}
	else if(VarKind==VAR_DIRECTMEM){
		//mov byte ptr[ecx],al
		OpBuffer[obp++]=(char)0x88;
		OpBuffer[obp++]=(char)0x01;
	}
}
*/
