#pragma once

namespace ActiveBasic{ namespace PM{ namespace FM{


class ItemBase
{
	HTREEITEM hTreeItem;

public:
	ItemBase( HTREEITEM hTreeItem )
		: hTreeItem( hTreeItem )
	{
	}

	HTREEITEM GetTreeItemHandle() const
	{
		return hTreeItem;
	}
	void SetTreeViewHandle( HTREEITEM hTreeItem )
	{
		this->hTreeItem = hTreeItem;
	}
};

class File
	: public ItemBase
{
	std::string relationalPath;

public:
	File( const std::string &relationalPath, HTREEITEM hTreeItem );

	const std::string &GetRelationalPath() const
	{
		return relationalPath;
	}
	const std::string GetFullPath() const;
};
typedef std::vector<File> Files;

class Folder;
typedef std::vector<Folder> Folders;

class Folder
	: public ItemBase
{
	std::string name;
public:
	Files files;
	Folders folders;

	Folder( const std::string &name, HTREEITEM hTreeItem )
		: ItemBase( hTreeItem )
		, name( name )
	{
	}

	const std::string &GetName() const
	{
		return name;
	}

	bool IsEmpty() const;
	void Clear();
	File &FindFile( HTREEITEM hTreeItem );
	File &FindFile( const std::string &path );
	bool IsExistFile( HTREEITEM hTreeItem ) const;
	bool IsExistFile( const std::string &path ) const;
	void Remove( HTREEITEM hTreeItem );
};

class FileSystem
{
public:
	Folder root;
	boost::mutex mutex;

	FileSystem( const std::string &rootFolderName )
		: root( rootFolderName, NULL )
	{
	}
};


}}}
