#pragma once


namespace ActiveBasic{ namespace PM{

class Project
{
public:

	Project()
		: workDir( "" )
		, fileSystem( "Source Files" )
	{
	}

	void Load( char *path );
	void Save();
	bool Close();

	const std::string &GetName() const
	{
		return name;
	}

	const Jenga::Common::Directory &GetWorkDir() const
	{
		return workDir;
	}

	const std::string GetResourceFileFullPath() const
	{
		return this->GetWorkDir().GetFullPath( this->GetName() + ".rc" );
	}

	bool IsOpened() const
	{
		return !name.empty();
	}

	ActiveBasic::Common::TargetModuleType::EnumType GetModuleType() const
	{
		return moduleType;
	}

	DWORD dwVersion;

	FM::FileSystem fileSystem;

	int NumberOfMenu;
	MENU_INFO *pMenuInfo;
	HTREEITEM hMenuTreeItem;

	WindowInfos windowInfos;
	HTREEITEM hWindowTreeItem;

	DWORD dwOption;
	char lpszOutput_Release[MAX_PATH];
	char lpszOutput_Debug[MAX_PATH];

	//}jtFXg
	char szManifestPath[MAX_PATH];

	//fobO
	char szCmdLine[8192];
	char szExePath[MAX_PATH];

	//u[N|Cg
	CDBBreakPoint *pobj_DBBreakPoint;

	_int8 ModifyOfMaterial;
	_int8 ModifuOfResource;
	_int8 modify;

private:
	std::string name;
	Jenga::Common::Directory workDir;
	ActiveBasic::Common::TargetModuleType::EnumType moduleType;

public:
	ActiveBasic::Common::ResourceManager resourceManager;
};


}}

extern ActiveBasic::PM::Project projectInfo;
