#include "stdafx.h"

#include "common.h"

CFileInfo::CFileInfo( const std::string &filepath, HTREEITEM hTreeItem )
	: filepath( filepath )
	, m_hTreeItem( hTreeItem )
{
}
void CFileInfo::GetFullPath(char *buffer){
	lstrcpy(buffer,this->GetPath().c_str());
	lstrcpy( buffer, projectInfo.GetWorkDir().GetFullPath( buffer ).c_str() );
}


CDBFileInfo::CDBFileInfo(){
	iNum=0;
	ppobj_FileInfo=(CFileInfo **)HeapAlloc(hHeap,0,1);
}
CDBFileInfo::~CDBFileInfo(){
	int i;
	for(i=0;i<iNum;i++){
		delete ppobj_FileInfo[i];
	}
	HeapDefaultFree(ppobj_FileInfo);
}

void CDBFileInfo::add(char *path,HTREEITEM hTreeItem){
	ppobj_FileInfo=(CFileInfo **)HeapReAlloc(hHeap,0,ppobj_FileInfo,(iNum+1)*sizeof(CFileInfo *));
	ppobj_FileInfo[iNum]=new CFileInfo(path,hTreeItem);
	iNum++;
}
void CDBFileInfo::del(HTREEITEM hTreeItem){
	int i;
	for(i=0;i<iNum;i++){
		if(ppobj_FileInfo[i]->m_hTreeItem==hTreeItem) break;
	}
	if(i==iNum) return;

	delete ppobj_FileInfo[i];

	iNum--;
	for(;i<iNum;i++) ppobj_FileInfo[i]=ppobj_FileInfo[i+1];
}
const std::string &CDBFileInfo::GetPath(HTREEITEM hTreeItem)
{
	for( int i=0; i<iNum; i++ )
	{
		if(ppobj_FileInfo[i]->m_hTreeItem==hTreeItem)
		{
			return ppobj_FileInfo[i]->GetPath();
		}
	}

	_ASSERTE( false );
	throw;
}
BOOL CDBFileInfo::IsMainFile(HTREEITEM hTreeItem){
	int i;
	for(i=0;i<iNum;i++){
		if(ppobj_FileInfo[i]->m_hTreeItem==hTreeItem) break;
	}
	if(i==0) return 1;
	return 0;
}
BOOL CDBFileInfo::dupli_check(char *path){
	//d`FbN
	int i;
	for(i=0;i<iNum;i++){
		if(lstrcmpi(ppobj_FileInfo[i]->GetPath().c_str(),path)==0){
			return 1;
		}
	}
	return 0;
}
