#include "stdafx.h"

//////////////////////////
// u[N|Cg
//////////////////////////

BreakPointManager *pobj_DBBreakPoint;

BreakPointsPerFile::BreakPointsPerFile(char *lpszFileName,int iLineNum){
	this->filename = lpszFileName;

	lines.clear();
	lines.push_back( iLineNum );
}
void BreakPointsPerFile::add(int iLineNum){
	lines.push_back( iLineNum );
}
void BreakPointsPerFile::remove( int iLineNum )
{
	for( int i=0; i<static_cast<int>(this->lines.size()); i++ )
	{
		if( iLineNum == this->lines[i] )
		{
			Jenga::Common::EraseVectorItem<std::vector<int>>( this->lines, i );
			break;
		}
	}
}

void BreakPointsPerFile::update(char *nativeCodeBuffer)
{
	int FileNum;
	const IncludedFilesRelation *pIncludedFilesRelation = NULL;
	const BasicSource *pNowSource = NULL;

	extern BasicSources sourcesLinkRelationalObjectModule;
	BOOST_FOREACH( const BasicSource &source, sourcesLinkRelationalObjectModule )
	{
		pIncludedFilesRelation = &source.GetIncludedFilesRelation();

		for(FileNum=0;FileNum<pIncludedFilesRelation->GetFileCounts();FileNum++)
		{
			if(lstrcmpi(pIncludedFilesRelation->GetFilePathFromFileNumber(FileNum).c_str(),this->filename.c_str())==0)
			{
				pNowSource = &source;
				break;
			}
		}
		if( FileNum == pIncludedFilesRelation->GetFileCounts() )
		{
			pIncludedFilesRelation = NULL;
		}
		else
		{
			break;
		}
	}

	if( !pIncludedFilesRelation )
	{
		Jenga::Throw( "BreakPointsPerFile::updateŕsȏ" );
		return;
	}

	int i;
	for(i=0;;i++){
		if( pIncludedFilesRelation->GetFileNumber( i ) == FileNum
			|| pIncludedFilesRelation->GetFileNumber( i ) == -1 )
		{
			break;
		}
	}
	if( pIncludedFilesRelation->GetFileNumber( i ) == -1 )
	{
		return;
	}

	int FileBaseLine;
	FileBaseLine=i;

	int i2,nCount=0;
	for(i2=0;;i2++){
		if( pIncludedFilesRelation->GetFileNumber( FileBaseLine+i2 ) == -1 )
		{
			//\[XR[h̏I[s
			break;
		}

		if(i2==this->lines[nCount]){
			extern SourceLines oldSourceLines;

loop:
			int tempCp = GetSourceCodeIndexFromLine( pNowSource->GetBuffer(), FileBaseLine+i2 );

			int i3;
			for(i3=0;i3<(int)oldSourceLines.size()-1;i3++){
				if(oldSourceLines[i3].GetSourceCodePosition().GetPos()==tempCp) break;
			}
			if(i3==oldSourceLines.size()-1){
				i2--;
				goto loop;
			}

			nativeCodeBuffer[oldSourceLines[i3].GetNativeCodePos()]=(char)0xCC;

			nCount++;
			if( nCount >= static_cast<int>(this->lines.size()) )
			{
				break;
			}
		}
	}
}


BreakPointManager::BreakPointManager()
{
	char *buffer;
	buffer=(char *)HeapAlloc(hHeap,0,65535);

	std::string filepath = ActiveBasic::Common::Environment::GetAbdevRootPath() + "\\ab_breakpoint.tmp";
	HANDLE hFile=CreateFile(
		filepath.c_str(),
		GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile!=INVALID_HANDLE_VALUE)
	{
		DWORD dwAccBytes;
		ReadFile(hFile,buffer,MAX_PATH,&dwAccBytes,NULL);
		CloseHandle(hFile);
		buffer[dwAccBytes]=0;
	}
	else
	{
		buffer[0]=0;
	}

	int i=0,i2;
	char szFilePath[MAX_PATH];
	while(buffer[i]){
		//t@CpX
		i=GetOneParameter(buffer,i,szFilePath);
		RemoveStringQuotes(szFilePath);

		while(buffer[i]!='\n'&&buffer[i]!='\0'){
			//sԍ
			char temporary[1024];
			i=GetOneParameter(buffer,i,temporary);
			i2=atoi(temporary);

			insert(szFilePath,i2);
		}

		while(buffer[i]=='\n') i++;

		if(buffer[i]=='\0') break;
	}

	HeapDefaultFree(buffer);
}
void BreakPointManager::insert(char *lpszFileName,int iLineNum)
{
	BOOST_FOREACH( BreakPointsPerFile &breakpointsPerFile, breakpointsPerFiles )
	{
		if(lstrcmpi(breakpointsPerFile.filename.c_str(),lpszFileName)==0)
		{
			breakpointsPerFile.add( iLineNum );
			return;
		}
	}

	this->breakpointsPerFiles.push_back( BreakPointsPerFile( lpszFileName, iLineNum ) );
}
void BreakPointManager::remove(char *lpszFileName,int iLineNum)
{
	for( int i=0; i<static_cast<int>(this->breakpointsPerFiles.size()); i++ )
	{
		BreakPointsPerFile *pBreakpointsPerFile = &breakpointsPerFiles[i];
		if(lstrcmpi(pBreakpointsPerFile->filename.c_str(),lpszFileName)==0)
		{
			pBreakpointsPerFile->remove( iLineNum );
			if( pBreakpointsPerFile->lines.empty() )
			{
				Jenga::Common::EraseVectorItem<BreakPointsPerFiles>( this->breakpointsPerFiles, i );
			}
			break;
		}
	}
}

char *BreakPointManager::update(char *nativeCodeBuffer,int SizeOf_CodeSection){
	char *buffer;
	buffer=(char *)HeapAlloc(hHeap,0,SizeOf_CodeSection);
	memcpy(buffer,nativeCodeBuffer,SizeOf_CodeSection);

	BOOST_FOREACH( BreakPointsPerFile &breakpointsPerFile, breakpointsPerFiles )
	{
		breakpointsPerFile.update( buffer );
	}

	return buffer;
}
