#include "stdafx.h"

#define BREAK_EIP(checkEip)  (obp+0x00401000>=checkEip)

const ::DllProc &Schedule::GetDllProc() const
{
	_ASSERT( type == Schedule::DllProc );
	return *pDllProc;
}
const ::UserProc &Schedule::GetUserProc() const
{
	_ASSERT( type == Schedule::UserProc || type == Schedule::AddressOf || type == Schedule::CatchAddress );
	return *pUserProc;
}
const ::CClass &Schedule::GetClass() const
{
	_ASSERT( type == Schedule::ComVtbl || type == Schedule::Vtbl || type == Schedule::TypeInfo );
	return *pClass;
}

bool Schedule::Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors )
{
	switch( type )
	{
	case UserProc:
	case AddressOf:
	case CatchAddress:
		if( this->pUserProc->IsNeedResolve() )
		{
			const ::UserProc *pTempUserProc = resolver.meta.GetUserProcs().FindLike( this->pUserProc );
			if( pTempUserProc )
			{
				this->pUserProc = pTempUserProc;
			}
			else
			{
				resolveErrors.Add( ResolveError( this->pUserProc->GetRelationalObjectModuleIndex(), this->pUserProc->GetFullName() ) );
			}
		}
		break;
	case DllProc:
		if( this->pDllProc->IsNeedResolve() )
		{
			const ::DllProc *pTempDllProc = resolver.meta.GetDllProcs().FindLike( this->pDllProc );
			if( pTempDllProc )
			{
				this->pDllProc = pTempDllProc;
			}
			else
			{
				resolveErrors.Add( ResolveError( this->pDllProc->GetRelationalObjectModuleIndex(), this->pDllProc->GetFullName() ) );
			}
		}
		break;
	case ComVtbl:
	case Vtbl:
	case TypeInfo:
		if( this->pClass->IsNeedResolve() )
		{
			const CClass *pTempClass = resolver.meta.GetClasses().FindLike( this->pClass );
			if( pTempClass )
			{
				this->pClass = pTempClass;
			}
			else
			{
				resolveErrors.Add( ResolveError( this->pClass->GetRelationalObjectModuleIndex(), this->pClass->GetFullName() ) );
			}
		}
		break;
	default:
		break;
	}

	return true;
}

void NativeCode::PutEx( const NativeCode &nativeCode )
{
	long baseOffset = GetSize();

	// R[hobt@ǉ
	Put( nativeCode.GetBuffer(), nativeCode.GetSize() );

	// XPW[ǉ
	BOOST_FOREACH( const Schedule &schedule, nativeCode.schedules )
	{
		this->schedules.push_back(
			Schedule(
				schedule.GetType(),
				baseOffset + schedule.GetOffset(),
				schedule.GetLongPtrValue()
			)
		);
	}

	// \[XR[hsԍƃlCeBuR[hʒȗΉǉ
	BOOST_FOREACH( const SourceLine &sourceLine, nativeCode.sourceLines )
	{
		this->sourceLines.push_back(
			SourceLine(
				baseOffset + sourceLine.GetNativeCodePos(),
				sourceLine.GetCodeType(),
				sourceLine.GetSourceCodePosition()
			)
		);
	}
}

void NativeCode::PutEx( long l, Schedule::Type scheduleType )
{
	if( scheduleType != Schedule::None )
	{
		schedules.push_back( Schedule( scheduleType, GetSize() ) );
	}

	Put( l );
}

void NativeCode::PutUserProcSchedule( const UserProc *pUserProc, bool isCall )
{
	pUserProc->Using();

	Schedule::Type type = isCall ? Schedule::UserProc : Schedule::AddressOf;

	schedules.push_back( Schedule( type, pUserProc, GetSize() ) );

	Put( (long)0 );
}

void NativeCode::PutCatchAddressSchedule( const UserProc *pUserProc, long codePos )
{
	pUserProc->Using();

	schedules.push_back( Schedule( Schedule::CatchAddress, pUserProc, GetSize() ) );

	Put( codePos );
}

void NativeCode::PutDllProcSchedule( const DllProc *pDllProc )
{
	pDllProc->Using();

	schedules.push_back( Schedule( pDllProc, GetSize() ) );

	Put( (long)0 );
}

void NativeCode::PutComVtblSchedule( const CClass *pClass )
{
	schedules.push_back( Schedule( Schedule::ComVtbl, pClass, GetSize() ) );

	Put( (long)0 );
}

void NativeCode::PutVtblSchedule( const CClass *pClass )
{
	schedules.push_back( Schedule( Schedule::Vtbl, pClass, GetSize() ) );

	Put( (long)0 );
}

void NativeCode::NextSourceLine( const SourceCodePosition &sourceCodePosition, bool isInSystemProc )
{
	if( sourceLines.size() )
	{
		if( sourceLines.back().GetNativeCodePos() == GetSize() )
		{
			sourceLines.back().SetSourceCodePosition( sourceCodePosition );
			return;
		}
	}

	extern BOOL bDebugSupportProc;
	DWORD sourceLineType = 0;
	if( bDebugSupportProc )
	{
		sourceLineType |= CODETYPE_DEBUGPROC;
	}
	if( isInSystemProc )
	{
		sourceLineType |= CODETYPE_SYSTEMPROC;
	}
	sourceLines.push_back(
		SourceLine(
			GetSize(),
			sourceLineType,
			sourceCodePosition
		)
	);
}

void NativeCode::ResetDataSectionBaseOffset( long dataSectionBaseOffset )
{
	BOOST_FOREACH( const Schedule &schedule, schedules )
	{
		if( schedule.GetType() == Schedule::DataTable )
		{
			Overwrite(
				schedule.GetOffset(),
				GetLong( schedule.GetOffset() ) + dataSectionBaseOffset
			);
		}
	}
}
void NativeCode::ResetRelationalObjectModuleIndex( const std::vector<int> &relationTable )
{
	BOOST_FOREACH( SourceLine &sourceLine, sourceLines )
	{
		sourceLine.GetSourceCodePosition().SetRelationalObjectModuleIndex(
			relationTable[sourceLine.GetSourceCodePosition().GetRelationalObjectModuleIndex()]
		);
	}
}

void NativeCode::Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors )
{
	BOOST_FOREACH( Schedule &schedule, schedules )
	{
		schedule.Resolve( resolver, resolveErrors );
	}
}
