#pragma once

class Procedure
	: public RelationalObjectModuleItem
{
public:
	// 
	enum Kind{
		Sub,
		Function,
	};

private:
	Kind kind;

	bool isCdecl;
	mutable bool isUsing;

	// p[^
	Parameters params;

protected:

	// ߂ľ^
	Type returnType;

private:
	// \[XR[ḧʒu
	SourceCodePosition sourceCodePosition;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - Procedure" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( RelationalObjectModuleItem );
		ar & BOOST_SERIALIZATION_NVP( kind );
		ar & BOOST_SERIALIZATION_NVP( isCdecl );
		ar & BOOST_SERIALIZATION_NVP( isUsing );
		ar & BOOST_SERIALIZATION_NVP( params );
		ar & BOOST_SERIALIZATION_NVP( returnType );
		ar & BOOST_SERIALIZATION_NVP( sourceCodePosition );
	}

public:
	Procedure( const Symbol &symbol, Kind kind, bool isCdecl )
		: RelationalObjectModuleItem( symbol )
		, kind( kind )
		, isCdecl( isCdecl )
		, isUsing( false )
	{
	}
	Procedure()
	{
	}
	~Procedure(){
		BOOST_FOREACH( Parameter *pParam, params ){
			delete pParam;
		}
	}

	bool IsSub() const
	{
		return ( kind == Sub );
	}
	bool IsFunction() const
	{
		return ( kind == Function );
	}

	bool IsCdecl() const
	{
		return isCdecl;
	}
	void Using() const
	{
		isUsing = true;
	}
	bool IsUsing() const
	{
		return isUsing;
	}

	const SourceCodePosition &GetSourceCodePosition() const
	{
		return sourceCodePosition;
	}
	void SetSourceCodePosition( const SourceCodePosition &sourceCodePosition )
	{
		this->sourceCodePosition = sourceCodePosition;
	}
	virtual void ResetRelationalObjectModuleIndex( const std::vector<int> &relationTable );

	const Parameters &Params() const
	{
		return params;
	}
	Parameters &GetParameters()
	{
		return params;
	}
	const Type &ReturnType() const
	{
		return returnType;
	}
	Type &ReturnType()
	{
		return returnType;
	}

	virtual bool Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors );
};

class UserProc : public Procedure, public Jenga::Common::ObjectInHashmap<UserProc>
{
public:
	std::string _paramStr;

private:
	NamespaceScopesCollection importedNamespaces;

	// eNXƑΉ郁\bh
	const CClass *pParentClass;
	const Interface *pInterface;
	CMethod *pMethod;

	bool isMacro;

	// p[^̒ǉ
	int secondParmNum;
	Parameters realParams;
	int realSecondParmNum;

	// etO
	bool isExport;
	mutable bool isAutoGenerationSystem;
	mutable bool isAutoGeneration;
	mutable bool isCompiled;

	mutable DWORD beginOpAddress;
	mutable DWORD endOpAddress;

	// [Jϐ
	mutable Variables localVars;

	// ID
	int id;

	// lCeBuR[h
	NativeCode nativeCode;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - UserProc" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Procedure );
		ar & boost::serialization::make_nvp("pParentClass", const_cast<CClass *&>(pParentClass) );
		ar & boost::serialization::make_nvp("pInterface", const_cast<Interface *&>(pInterface) );

		if( ActiveBasic::Common::Environment::IsRemoveExternal() )
		{
			if( this->IsExternal() )
			{
				this->NeedResolve();
				return;
			}
		}

		ar & BOOST_SERIALIZATION_NVP( _paramStr );
		ar & BOOST_SERIALIZATION_NVP( importedNamespaces );
		ar & BOOST_SERIALIZATION_NVP( pMethod );
		ar & BOOST_SERIALIZATION_NVP( isMacro );
		ar & BOOST_SERIALIZATION_NVP( secondParmNum );
		ar & BOOST_SERIALIZATION_NVP( realParams );
		ar & BOOST_SERIALIZATION_NVP( realSecondParmNum );
		ar & BOOST_SERIALIZATION_NVP( isExport );
		ar & BOOST_SERIALIZATION_NVP( isAutoGenerationSystem );
		ar & BOOST_SERIALIZATION_NVP( isAutoGeneration );
		ar & BOOST_SERIALIZATION_NVP( isCompiled );
		ar & BOOST_SERIALIZATION_NVP( beginOpAddress );
		ar & BOOST_SERIALIZATION_NVP( endOpAddress );
		ar & BOOST_SERIALIZATION_NVP( localVars );
		ar & BOOST_SERIALIZATION_NVP( id );
		ar & BOOST_SERIALIZATION_NVP( nativeCode );
	}

public:

	UserProc( const Symbol &symbol, const NamespaceScopesCollection &importedNamespaces, Kind kind, bool isMacro, bool isCdecl, bool isExport );
	UserProc( const UserProc &userProc, const CClass *pParentClass );
	UserProc();
	~UserProc();

	void SetReturnType( const Type &newReturnType )
	{
		returnType = newReturnType;
	}

	virtual const std::string &GetKeyName() const
	{
		return GetName();
	}

	virtual bool IsDuplication( const UserProc *pUserProc ) const
	{
		bool isEqualParentClass =
			this->HasParentClass() && pUserProc->HasParentClass()
			? this->GetParentClassPtr()->Equals( pUserProc->GetParentClassPtr() )
			: this->GetParentClassPtr() == pUserProc->GetParentClassPtr();
		bool isEqualInterface =
			this->pInterface && pUserProc->pInterface
			? this->pInterface->Equals( pUserProc->pInterface )
			: this->pInterface == pUserProc->pInterface;

		if( isEqualParentClass										// eNX
			&& isEqualInterface										// C^[tFCX
			&& pUserProc->IsEqualSymbol( *this )					// OԋyіO
			&& this->Params().Equals( pUserProc->Params() )			// p[^
			&& this->returnType.Equals( pUserProc->returnType ) )	// ߂l
		{
			return true;
		}
		return false;
	}

	virtual void ResetRelationalObjectModuleIndex( const std::vector<int> &relationTable );

	/*!
	@brief	I[o[ChpɊ֐mǂ`FbN
	@param	actualTypeParametersForThisProc thisIuWFNgŕۗL郁\bhΏۂƂ^p[^
			pUserProc Ƃ炵킹֐
	*/
	bool IsEqualForOverride( const Types &actualTypeParametersForThisProc, const UserProc *pUserProc ) const;

	bool IsMacro() const
	{
		return isMacro;
	}

	int GetSecondParmNum() const
	{
		return secondParmNum;
	}
	void SetSecondParmNum( int secondParmNum )
	{
		this->secondParmNum = secondParmNum;
	}
	const Parameters &RealParams() const
	{
		return realParams;
	}
	Parameters &RealParams()
	{
		return realParams;
	}
	void SetRealParams( const Parameters &params )
	{
		realParams = params;
	}
	int GetRealSecondParmNum() const
	{
		return realSecondParmNum;
	}

	void ExportOff(){
		isExport = false;
	}
	bool IsExport() const
	{
		return isExport;
	}
	void ThisIsAutoGenerationSystemProc() const
	{
		isAutoGenerationSystem = true;
	}
	bool IsAutoGenerationSystem() const
	{
		return isAutoGenerationSystem;
	}
	void ThisIsAutoGenerationProc() const
	{
		isAutoGeneration = true;
	}
	bool IsAutoGeneration() const
	{
		return isAutoGeneration;
	}
	bool IsSystem() const;
	void CompleteCompile() const
	{
		isCompiled = true;
	}
	void KillCompileStatus() const
	{
		isCompiled = false;
	}
	bool IsCompiled() const
	{
		return isCompiled;
	}
	bool IsDestructor() const
	{
		return ( GetName()[0] == '~' );
	}

	// oCiR[hʒuƃTCY
	DWORD GetBeginOpAddress() const
	{
		return beginOpAddress;
	}
	void SetBeginOpAddress( DWORD beginOpAddress ) const
	{
		this->beginOpAddress = beginOpAddress;
	}
	DWORD GetEndOpAddress() const
	{
		return endOpAddress;
	}
	void SetEndOpAddress( DWORD endOpAddress ) const
	{
		this->endOpAddress = endOpAddress;
	}
	int GetCodeSize() const
	{
		return endOpAddress - beginOpAddress;
	}

	virtual const NamespaceScopes &GetNamespaceScopes() const;
	const NamespaceScopesCollection &GetImportedNamespaces() const;

	Variables &GetLocalVars() const
	{
		return localVars;
	}

	int GetId() const
	{
		return id;
	}

	const NativeCode &GetNativeCode() const
	{
		return nativeCode;
	}
	NativeCode &GetNativeCode()
	{
		return nativeCode;
	}

	std::string GetFullName() const;
	bool IsCastOperator() const;

	bool IsVirtual() const;

	void SetParentClass( const CClass *pParentClass ){
		this->pParentClass = pParentClass;
	}
	const CClass *GetParentClassPtr() const
	{
		return pParentClass;
	}
	const CClass &GetParentClass() const
	{
		return *pParentClass;
	}
	bool HasParentClass() const
	{
		return ( pParentClass != NULL );
	}
	bool IsGlobalProcedure() const
	{
		return ( pParentClass == NULL );
	}
	void SetInterface( const Interface *pInterface )
	{
		this->pInterface = pInterface;
	}
	void SetMethod( CMethod *pMethod ){
		this->pMethod = pMethod;
	}
	const CMethod &GetMethod() const;

	virtual bool Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors );

	static const UserProc *pGlobalProc;
};

class UserProcs : public Jenga::Common::Hashmap<UserProc>
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - UserProcs" );

		ar & boost::serialization::make_nvp("Hashmap_UserProcImpl",
			boost::serialization::base_object<Jenga::Common::Hashmap<UserProc>>(*this));
	}


public:
	UserProcs()
	{
	}
	~UserProcs()
	{
	}

	void EnumGlobalProcs( const char *simpleName, const Symbol &localSymbol, std::vector<const UserProc *> &subs );
};

class DllProc
	: public Procedure
	, public Jenga::Common::ObjectInHashmap<DllProc>
{
	std::string dllFileName;
	std::string alias;
	int lookupAddress;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - DllProc" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Procedure );

		if( ActiveBasic::Common::Environment::IsRemoveExternal() )
		{
			if( this->IsExternal() )
			{
				this->NeedResolve();
				return;
			}
		}

		ar & BOOST_SERIALIZATION_NVP( dllFileName );
		ar & BOOST_SERIALIZATION_NVP( alias );
		ar & BOOST_SERIALIZATION_NVP( lookupAddress );
	}

public:
	DllProc( const Symbol &symbol, Kind kind, bool isCdecl, const std::string &dllFileName, const std::string &alias )
		: Procedure( symbol, kind, isCdecl )
		, dllFileName( dllFileName )
		, alias( alias )
		, lookupAddress( 0 )
	{
	}
	DllProc()
	{
	}
	~DllProc()
	{
	}

	virtual const std::string &GetKeyName() const
	{
		return GetName();
	}

	virtual bool IsDuplication( const DllProc *pDllProc ) const
	{
		if( pDllProc->IsEqualSymbol( *this )
			&& this->Params().Equals( pDllProc->Params() ) )
		{
			return true;
		}
		return false;
	}

	const std::string &GetDllFileName() const
	{
		return dllFileName;
	}
	const std::string &GetAlias() const
	{
		return alias;
	}

	void SetLookupAddress( int lookupAddress ){
		this->lookupAddress = lookupAddress;
	}
	int GetLookupAddress() const
	{
		return lookupAddress;
	}

	virtual bool Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors );
};
class DllProcs : public Jenga::Common::Hashmap<DllProc>
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - DllProcs" );

		ar & boost::serialization::make_nvp("Hashmap_DllProc",
			boost::serialization::base_object<Jenga::Common::Hashmap<DllProc>>(*this));
	}
};

class ProcPointer
	: public Procedure
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - ProcPointer" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Procedure );
	}

public:
	ProcPointer( Kind kind )
		: Procedure( Symbol( NamespaceScopes(), std::string() ), kind, false )
	{
	}
	ProcPointer()
	{
	}
	~ProcPointer()
	{
	}

	virtual bool Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors );
};

class ProcPointers : public std::vector<ProcPointer *>
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - ProcPointers" );

		ar & boost::serialization::make_nvp("vector_ProcPointer",
			boost::serialization::base_object<vector<ProcPointer *>>(*this));
	}

public:
	ProcPointers()
	{
	}
	~ProcPointers()
	{
		Clear();
	}

	void Clear();
	void PullOutAll()
	{
		clear();
	}
};
