#include "stdafx.h"


void Procedure::ResetRelationalObjectModuleIndex( const std::vector<int> &relationTable )
{
	RelationalObjectModuleItem::ResetRelationalObjectModuleIndex( relationTable );

	if( !this->sourceCodePosition.IsNothing() )
	{
		this->sourceCodePosition.SetRelationalObjectModuleIndex( relationTable[this->sourceCodePosition.GetRelationalObjectModuleIndex()] );
	}
}

bool Procedure::Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors )
{
	BOOST_FOREACH( Parameter *pParameter, params )
	{
		pParameter->Resolve( resolver, resolveErrors );
	}

	returnType.Resolve( resolver, resolveErrors );

	return true;
}


void UserProc::ResetRelationalObjectModuleIndex( const std::vector<int> &relationTable )
{
	Procedure::ResetRelationalObjectModuleIndex( relationTable );

	this->GetNativeCode().ResetRelationalObjectModuleIndex( relationTable );
}

int id_base = 0;

UserProc::UserProc( const Symbol &symbol, const NamespaceScopesCollection &importedNamespaces, Kind kind, bool isMacro, bool isCdecl, bool isExport )
	: Procedure( symbol, kind, isCdecl )
	, importedNamespaces( importedNamespaces )
	, pParentClass( NULL )
	, pInterface( NULL )
	, pMethod( NULL )
	, isMacro( isMacro )
	, secondParmNum( 0 )
	, realSecondParmNum( 1 )
	, isExport( isExport )
	, isAutoGenerationSystem( false )
	, isAutoGeneration( false )
	, isCompiled( false )
	, beginOpAddress( 0 )
	, endOpAddress( 0 )
	, id( id_base ++ )
{
}

UserProc::UserProc( const UserProc &userProc, const CClass *pParentClass )
	: Procedure( userProc )
	, _paramStr( userProc._paramStr )
	, importedNamespaces( userProc.importedNamespaces )
	, pParentClass( pParentClass )
	, pInterface( NULL )
	, pMethod( NULL )
	, isMacro( userProc.isMacro )
	, secondParmNum( userProc.secondParmNum )
	, realParams( userProc.realParams )
	, realSecondParmNum( userProc.realSecondParmNum )
	, isExport( userProc.isExport )
	, isAutoGenerationSystem( userProc.isAutoGenerationSystem )
	, isAutoGeneration( userProc.isAutoGeneration )
	, isCompiled( false )
	, beginOpAddress( 0 )
	, endOpAddress( 0 )
	, localVars( Variables() )
	, id( id_base ++ )
	, nativeCode( NativeCode() )
{
}

UserProc::UserProc()
{
}

UserProc::~UserProc()
{
	BOOST_FOREACH( Parameter *pParam, realParams ){
		delete pParam;
	}
}

bool UserProc::IsEqualForOverride( const Types &actualTypeParametersForThisProc, const UserProc *pUserProc ) const
{
	if( this->GetName() == pUserProc->GetName()						// OԋyіO
		&& this->Params().Equals( actualTypeParametersForThisProc, pUserProc->Params() ) )			// p[^
	{
		if( this->returnType.Equals( pUserProc->returnType ) )
		{
			// ߂l
			return true;
		}
		else if( this->returnType.IsCovariant( pUserProc->returnType ) )
		{
			// ߂l
			return true;
		}
		else if( this->returnType.IsTypeParameter() )
		{
			// ^p[^Ƃ

			if( actualTypeParametersForThisProc[this->returnType.GetFormalTypeIndex()].Equals( pUserProc->returnType ) )
			{
				// ߂l
				return true;
			}
			else if( actualTypeParametersForThisProc[this->returnType.GetFormalTypeIndex()].IsCovariant( pUserProc->returnType ) )
			{
				// ߂l
				return true;
			}
		}
	}
	return false;
}
	

std::string UserProc::GetFullName() const
{
	if( HasParentClass() ){
		return GetParentClass().GetName() + "." + GetName();
	}

	return GetName();
}
bool UserProc::IsCastOperator() const
{
	if( GetName()[0] == 1 && GetName()[1] == ESC_OPERATOR && GetName()[2] == CALC_AS )
	{
		return true;
	}
	return false;
}
bool UserProc::IsSystem() const
{
	// "_System_" 𖼑O̐擪Ɋ܂ފ֐
	if( memcmp( this->GetName().c_str(), "_System_", 8 ) == 0 )
	{
		return true;
	}

	// "_System_" 𖼑O̐擪Ɋ܂ރNX̃\bh
	if( this->HasParentClass() )
	{
		if( memcmp( this->GetParentClass().GetName().c_str(), "_System_", 8 ) == 0 )
		{
			return true;
		}
	}

	return false;
}
const NamespaceScopes &UserProc::GetNamespaceScopes() const
{
	if( HasParentClass() )
	{
		return GetParentClassPtr()->GetNamespaceScopes();
	}
	return Symbol::GetNamespaceScopes();
}
const NamespaceScopesCollection &UserProc::GetImportedNamespaces() const
{
	if( pParentClass )
	{
		return pParentClass->GetImportedNamespaces();
	}
	return importedNamespaces;
}
bool UserProc::IsVirtual() const
{
	if( pMethod == NULL ){
		return false;
	}
	return ( pMethod->IsVirtual() != 0 );
}
const CMethod &UserProc::GetMethod() const
{
	if( !HasParentClass() )
	{
		Jenga::Throw( "O[o֐ɑ΂UserProc::GetMethod\bhĂ΂ꂽ" );
	}
	return *pMethod;
}

bool UserProc::Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors )
{
	Procedure::Resolve( resolver, resolveErrors );

	if( this->pParentClass )
	{
		if( this->pParentClass->IsNeedResolve() )
		{
			const CClass *pTempClass = resolver.meta.GetClasses().FindLike( this->pParentClass );
			if( pTempClass )
			{
				this->pParentClass = pTempClass;
			}
			else
			{
				resolveErrors.Add( ResolveError( this->pParentClass->GetRelationalObjectModuleIndex(), this->pParentClass->GetFullName() ) );
			}
		}
	}

	if( pInterface )
	{
		const_cast<Interface *>(pInterface)->Resolve( resolver, resolveErrors );
	}

	if( pMethod )
	{
		pMethod->Resolve( resolver, resolveErrors );
	}

	BOOST_FOREACH( Parameter *pParameter, realParams )
	{
		pParameter->Resolve( resolver, resolveErrors );
	}

	BOOST_FOREACH( Variable *pLocalVar, localVars )
	{
		pLocalVar->Resolve( resolver, resolveErrors );
	}

	nativeCode.Resolve( resolver, resolveErrors );
	return true;
}

const UserProc *UserProc::pGlobalProc = NULL;


void UserProcs::EnumGlobalProcs( const char *simpleName, const Symbol &localSymbol, std::vector<const UserProc *> &subs )
{
	///////////////////////////
	// O[o֐
	///////////////////////////

	// nbVl擾
	UserProc *pUserProc = GetHashArrayElement( simpleName );
	while(pUserProc){
		if( pUserProc->IsGlobalProcedure() ){
			if( pUserProc->IsEqualSymbol( localSymbol ) ){
				subs.push_back( pUserProc );
			}
		}

		pUserProc=pUserProc->GetChainNext();
	}
}

bool DllProc::Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors )
{
	Procedure::Resolve( resolver, resolveErrors );
	return true;
}

bool ProcPointer::Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors )
{
	Procedure::Resolve( resolver, resolveErrors );
	return true;
}

void ProcPointers::Clear()
{
	ProcPointers &procPointers = *this;
	BOOST_FOREACH( ProcPointer *pProcPointer, procPointers ){
		delete pProcPointer;
	}
	this->clear();
}
