#include "stdafx.h"

using namespace ActiveBasic::IDE;
using namespace ActiveBasic::IDE::WindowComponents;

LRESULT CALLBACK WindowFunc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam);
void SetupWindow(HWND hwnd);
void ResetTextEditFont(HWND hwnd);

void MainFrame::Resized()
{
	int width_owner,height_owner;
	int height_Rebar;
	int height_MdiClient;
	RECT rect,StatusRect,RebarRect;

	this->GetClientRect( &rect );
	width_owner=rect.right;
	height_owner=rect.bottom;

	//Rebar
	SendMessage(pobj_Rebar->hRebar,WM_SIZE,0,MAKELONG(width_owner,height_owner));
	::UpdateWindow(pobj_Rebar->hRebar);

	//Status bar
#define STATUSBAR_PARTS_NUM 5
	int sb_size[STATUSBAR_PARTS_NUM];
	sb_size[0]=width_owner-340;
	sb_size[1]=width_owner-220;
	sb_size[2]=width_owner-120;
	sb_size[3]=width_owner-50;
	sb_size[4]=width_owner;
	extern HWND hStatusBar;
	::SendMessage(hStatusBar,SB_SETPARTS,STATUSBAR_PARTS_NUM,(LPARAM)sb_size);
	::SendMessage(hStatusBar,WM_SIZE,0,MAKELONG(width_owner,height_owner));
	::UpdateWindow(hStatusBar);

	//Status bar
	int height_Statusbar;
	SendMessage(hStatusBar,SB_GETRECT,0,(long)&StatusRect);
	height_Statusbar=StatusRect.bottom;

	::GetWindowRect(pobj_Rebar->hRebar,&RebarRect);
	height_Rebar=RebarRect.bottom-RebarRect.top+2;

	int height_dv;	//Width of Debugger View
	int height_cv;	//Width of Compiler View
	height_dv=0;
	height_cv=0;
#ifndef THETEXT
	extern BOOL bClipCompileView;
	if(bClipCompileView){
		if(pobj_Debugger->IsDebuggerView()){
			//fobKr[\ĂƂ
			height_dv=pobj_nv->height_ClipDebuggerView+LEVER_THICK;
		}

		extern HWND hCompileView;
		if(hCompileView){
			//RpCr[\ĂƂ
			height_cv=pobj_nv->height_ClipCompileView+LEVER_THICK;
		}
	}
#endif

	int width_pjv=0;	//Width of Project View
	if(pobj_nv->bClipProjectView){
		extern HWND hProjectView;
		if(::IsWindowVisible(hProjectView)){
			//vWFNgr[\ĂƂ
			width_pjv=pobj_nv->width_ClipProjectView+LEVER_THICK;
		}
	}

	int width_SideWeb=0;
	if( pobj_SideWeb )
	{
		if(pobj_SideWeb->bShow){
			width_SideWeb=pobj_nv->width_WebSearchView+LEVER_THICK;
		}
	}

	//MDINCAg̍
	height_MdiClient=height_owner-(
		height_Rebar+
		height_dv+
		height_cv+
		height_Statusbar
		);

	//^uRg[
	int tab_height;
	if(TabCtrl_GetItemCount(pobj_MainTab->hTab)==0) tab_height=0;
	else{
		RECT rc;
		TabCtrl_GetItemRect(pobj_MainTab->hTab,0,&rc);
		tab_height=rc.bottom-rc.top;
	}
	::MoveWindow(pobj_MainTab->hTab,
		width_pjv,
		height_Rebar,
		width_owner-width_pjv-width_SideWeb,
		tab_height,
		1);

	//MDINCAg
	::MoveWindow(
		hClient,
		width_pjv,
		height_Rebar+tab_height,
		width_owner-width_pjv-width_SideWeb,
		height_MdiClient-tab_height,
		1
	);

	if( pobj_SideWeb )
	{
		if(pobj_SideWeb->bShow){
			//SideWeb
			pobj_SideWeb->resize(
				width_owner - pobj_nv->width_WebSearchView,
				height_Rebar,
				pobj_nv->width_WebSearchView,
				height_MdiClient);
		}
		else pobj_SideWeb->resize(0,0,0,0);
	}

	if(width_pjv){
		//vWFNgr[
		extern HWND hProjectView;
		::MoveWindow(hProjectView,
			0,
			height_Rebar,
			pobj_nv->width_ClipProjectView,
			height_MdiClient,
			1);
		::InvalidateRect(hProjectView,NULL,0);
	}

	if(height_dv){
#ifndef THETEXT
		//fobKr[
		pobj_Debugger->resize(
			0,
			height_Rebar+height_MdiClient+LEVER_THICK,
			width_owner,
			pobj_nv->height_ClipDebuggerView);
#endif
	}
	if(height_cv){
		//RpCr[
		extern HWND hCompileView;
		::MoveWindow(hCompileView,
			0,
			height_Rebar+height_MdiClient+height_dv+LEVER_THICK,
			width_owner,
			pobj_nv->height_ClipCompileView,
			1);
	}
}

void MainFrame::OpenWebBrowser( const std::string &url )
{
	ShellExecute(m_hWnd,"open",url.c_str(),"",NULL,SW_SHOWNORMAL);
}

void MainFrame::OpenExplorer( const std::string &path )
{
	ShellExecute(m_hWnd,"explore",path.c_str(),NULL,NULL,SW_SHOWNORMAL);
}

::LRESULT MainFrame::OnCreate( ::UINT msg, ::WPARAM wParam, ::LPARAM lParam, ::BOOL& handled )
{
	// EBhEGA}l[WɐeEBhEo^
	wam.SetParentWnd( m_hWnd );

	RECT rect;
	GetClientRect( &rect );

	// MDIx[X쐬
    // t[EBhẼr[EBhE쐬
	int indexOfWindowSubMenu = pobj_MainMenu->FindSubMenuIndex( "EBhE(&W)" );
	HMENU hWindowSubMenu = NULL;
	if( indexOfWindowSubMenu != -1 )
	{
		hWindowSubMenu = GetSubMenu( pobj_MainMenu->hMenu, indexOfWindowSubMenu );
	}
	CreateMDIClient( hWindowSubMenu );
	wam.AddMdiClientWindow( m_hWndClient );

	// TODO: hClientp~Am_hWndClientɓꂷ邱
	extern HWND hClient;
	hClient = m_hWndClient;

    // bZ[W[vɃbZ[WtB^ƃAChnhǉ
	CMessageLoop* pLoop = Program::_Module.GetMessageLoop();
    pLoop->AddMessageFilter(this);
    pLoop->AddIdleHandler(this);





	extern HWND hOwner;
	hOwner = m_hWnd;
	extern WNDPROC oldMainFrameWndProc;
	oldMainFrameWndProc = (WNDPROC)::GetWindowLong( hOwner, GWL_WNDPROC );
	::SetWindowLong( hOwner, GWL_WNDPROC, (LONG)WindowFunc );

	SetupWindow(hOwner);

	//eLXgGfB^tHgݒ
	ResetTextEditFont(hOwner);



	return 0;
}

void MainFrame::OnSize(UINT nType, CSize size)
{
	this->Resized();
}

BOOL MainFrame::OnQueryEndSession(UINT nSource, UINT uLogOff)
{
	OnClose();

	return TRUE;
}

void MainFrame::OnClose()
{
	extern BOOL bSearchingClasses;
	if(bSearchingClasses){
		pobj_ClassTreeView->bCloseSwitch=1;
		return;
	}

	//RpCr[
	extern HWND hCompileView;
	if( hCompileView && ::IsWindow( hCompileView ) )
	{
		SendMessage(hCompileView,WM_COMMAND,IDCANCEL,0);
	}

	//NMDIEBhEő剻邩𔻒
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	pobj_nv->bMDIZoomed=::IsZoomed(hChild);

	//vWFNg
	if( projectInfo.IsOpened() ){
		if(!projectInfo.Close()) return;
	}

	//MDIEBhE̕ۑmF
	hChild=::GetWindow(hClient,GW_CHILD);
	while(hChild){
		if(!DocumentModifyCheck(hChild)) return;
		hChild=::GetNextWindow(hChild,GW_HWNDNEXT);
	}


	KillTimer(ID_TIMER_BACKUP);


	//ProjectVieẅʒuۑAProjectViewj
	extern HWND hProjectView;
	extern HWND hProjectView_ToolWindow;
	::GetWindowRect(hProjectView_ToolWindow,&pobj_nv->rectProjectView);
	::DestroyWindow(hProjectView);
	::DestroyWindow(hProjectView_ToolWindow);

	//Rebar̈ʒuۑARebarj
	delete pobj_Rebar;
	pobj_Rebar=0;

	//^uRg[j
	delete pobj_MainTab;
	pobj_MainTab=0;

	//SideWebj
	delete pobj_SideWeb;
	pobj_SideWeb=0;

	//CEBhE̍ő剻LAWۑ
	if(IsZoomed()) pobj_nv->bWindowMax=1;
	else if(!IsIconic()){
		pobj_nv->bWindowMax=0;
		GetWindowRect(&pobj_nv->StartupWindowRect);
	}

	hChild=::GetWindow(hClient,GW_CHILD);
	while(hChild){
		CloseDocWindow(GetWndNum(hChild));
		::DestroyWindow(hChild);
		hChild=::GetWindow(hClient,GW_CHILD);
	}

	EndProjectEditor();		//ProjectEditoȑۑ

	//GfB^ptHgj
	extern HFONT hFont_TextEdit,hFont_HyperLink_TextEdit;
	if(hFont_TextEdit) DeleteObject(hFont_TextEdit);
	if(hFont_HyperLink_TextEdit) DeleteObject(hFont_HyperLink_TextEdit);

	DestroyWindow();
}
void MainFrame::OnDestroy()
{
	::PostQuitMessage( 0 );
}

void backup(void *dummy);
void MainFrame::OnTimer( UINT_PTR id )
{
	switch( id )
	{
	case ID_TIMER_BACKUP:
		_beginthread( backup, 0, 0 );
		break;

#ifndef THETEXT
	case ID_DEBUGSAFTY:
		{
			//BasicCompiler.exeIĂ邩ǂ
			extern CDebugger *pobj_Debugger;
			pobj_Debugger->SaftyCheck();
			break;
		}
#endif
	}
}

void ResetState_EditMenu(void);
void MainFrame::OnDrawClipboard()
{
	ResetState_EditMenu();
}

void MenuAdvice(WPARAM msg);
void MainFrame::OnMenuSelect( UINT nItemID, UINT nFlags, HMENU menu )
{
	MenuAdvice( nItemID );
}

void MainFrame::OnInitMenu( HMENU menu )
{
	extern CNonVolatile *pobj_nv;
	extern CSubMenuEx *pobj_FileHistoryMenu;
	pobj_nv->pobj_History->ResetFileMenu(pobj_FileHistoryMenu,1);
#ifndef THETEXT
	extern CSubMenuEx *pobj_ProjectHistoryMenu;
	pobj_nv->pobj_ProjectHistory->ResetFileMenu(pobj_ProjectHistoryMenu,0);
#endif
}

void MainFrame::OnMeasureItem( int nIDCtl, LPMEASUREITEMSTRUCT lpMI )
{
	if(lpMI->CtlType==ODT_MENU){
		SIZE size;
		CMenuItemData *pobj_MenuItemData;
		pobj_MenuItemData=(CMenuItemData *)lpMI->itemData;
		if(pobj_MenuItemData->pobj_ThisMenu->hMenu==pobj_MainMenu->hMenu){
			//Cj[̐eACe
			pobj_MainMenu->GetItemSize(pobj_MenuItemData->item_index,&size);
			lpMI->itemWidth = size.cx;
			lpMI->itemHeight = size.cy;
		}
		else{
			//Cj[ɂԂ炳Tuj[
			pobj_MenuItemData->pobj_ThisMenu->GetItemSize(pobj_MenuItemData->item_index,&size);
			lpMI->itemWidth = size.cx;
			lpMI->itemHeight = size.cy;
		}
	}
}

void MainFrame::OnDrawItem( int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct )
{
	if(lpDrawItemStruct->CtlType==ODT_MENU){
		if(!pobj_MainMenu) return;

		CMenuItemData *pobj_MenuItemData;
		pobj_MenuItemData=(CMenuItemData *)lpDrawItemStruct->itemData;
		if(pobj_MainMenu->hMenu==pobj_MenuItemData->pobj_ThisMenu->hMenu){
			//Cj[̐eACe
			pobj_MainMenu->OwnerDrawMenu(lpDrawItemStruct->hDC,
				&lpDrawItemStruct->rcItem,
				(lpDrawItemStruct->itemState&ODS_SELECTED)!=0,
				pobj_MenuItemData->item_index);
		}
		else{
			//Cj[ɂԂ炳Tuj[
			pobj_MainMenu->OwnerDrawSubMenu(pobj_MenuItemData->pobj_ThisMenu->hMenu,
				lpDrawItemStruct->hDC,
				&lpDrawItemStruct->rcItem,
				(lpDrawItemStruct->itemState&ODS_SELECTED)!=0,
				pobj_MenuItemData->item_index);
		}
	}
}

LRESULT MainFrame::OnNotify( int idCtrl, LPNMHDR pnmh )
{
	NMPGCALCSIZE *lpCalcSize;
	NMPGSCROLL *lpScroll;

	if(!pnmh) return 0;
	LPTOOLTIPTEXT TipText=(LPTOOLTIPTEXT)pnmh;
	if(TipText->hdr.code==TTN_NEEDTEXT) ShowToolTipText(TipText);

	extern HWND hStandardToolbarPager;
	extern HWND hDebuggerToolbarPager;
	if(pobj_Rebar){
		//o[IuWFNg݂Ƃ
		if(pnmh->hwndFrom==pobj_Rebar->hRebar&&pnmh->code==RBN_HEIGHTCHANGE){
			this->Resized();
			return 0;
		}
	}
	if(pnmh->hwndFrom==hStandardToolbarPager){
		if(pnmh->code==PGN_CALCSIZE){
			lpCalcSize=(LPNMPGCALCSIZE)pnmh;
			if(lpCalcSize->dwFlag==PGF_CALCWIDTH)
				lpCalcSize->iWidth=BMPNUM_STANDARDTOOLBAR*23+SEPNUM_STANDARDTOOLBAR*8;
		}
		else if(pnmh->code==PGN_SCROLL){
			lpScroll=(LPNMPGSCROLL)pnmh;
			lpScroll->iScroll=20;
		}
	}
	else if(pnmh->hwndFrom==hDebuggerToolbarPager){
		if(pnmh->code==PGN_CALCSIZE){
			lpCalcSize=(LPNMPGCALCSIZE)pnmh;
			if(lpCalcSize->dwFlag==PGF_CALCWIDTH)
				lpCalcSize->iWidth=BMPNUM_DEBUGGERTOOLBAR*23+SEPNUM_DEBUGGERTOOLBAR*8;
		}
		else if(pnmh->code==PGN_SCROLL){
			lpScroll=(LPNMPGSCROLL)pnmh;
			lpScroll->iScroll=20;
		}
	}

	if(pobj_MainTab){
		if(pnmh->hwndFrom==pobj_MainTab->hTab){
			if(pnmh->code==TCN_SELCHANGE)
				pobj_MainTab->SelChangeEvent();

			if(pnmh->code==NM_RCLICK){

				TCHITTESTINFO tcHitTest;
				GetCursorPos(&tcHitTest.pt);
				::ScreenToClient(pobj_MainTab->hTab,&tcHitTest.pt);
				int index = TabCtrl_HitTest(pobj_MainTab->hTab,&tcHitTest);
				if( index == -1 ) return 0;

				TabCtrl_SetCurSel(pobj_MainTab->hTab,index);

				pobj_MainTab->SelChangeEvent();


				/////////////////////
				// j[\
				/////////////////////

				HWND hChild=::GetWindow(hClient,GW_CHILD);
				int WndNum=GetWndNum(hChild);

				//ۑR}h̕Zbg
				char temporary[1024], temp2[1024];
				MENUITEMINFO mii;
				mii.cbSize=sizeof(MENUITEMINFO);
				mii.fMask=MIIM_TYPE;
				mii.dwTypeData=temporary;
				mii.fType=MFT_STRING;
				if(!MdiInfo[WndNum]->path.empty()){
					_splitpath(MdiInfo[WndNum]->path.c_str(),NULL,NULL,temporary,temp2);
					lstrcat(temporary,temp2);
					lstrcat(temporary," ۑ(&S)");
				}
				else{
					lstrcpy(temporary,"ۑ(&S)");
				}
				extern HMENU hTabMenu;
				SetMenuItemInfo(hTabMenu,IDM_SAVE,FALSE,&mii);

				/*u΃pXRs[vutH_Jvut@C폜v
												R}hꍇɂĖɂ */
				if(!MdiInfo[WndNum]->path.empty()){
					EnableMenuItem(hTabMenu,IDM_PATH_COPY,MF_BYCOMMAND|MF_ENABLED);
					EnableMenuItem(hTabMenu,IDM_FOLDER_OPEN,MF_BYCOMMAND|MF_ENABLED);
					EnableMenuItem(hTabMenu,IDM_DELETE_FILE,MF_BYCOMMAND|MF_ENABLED);
				}
				else{
					EnableMenuItem(hTabMenu,IDM_PATH_COPY,MF_BYCOMMAND|MF_GRAYED);
					EnableMenuItem(hTabMenu,IDM_FOLDER_OPEN,MF_BYCOMMAND|MF_GRAYED);
					EnableMenuItem(hTabMenu,IDM_DELETE_FILE,MF_BYCOMMAND|MF_GRAYED);
				}

				POINT MousePos;
				GetCursorPos(&MousePos);
				TrackPopupMenu(hTabMenu,TPM_LEFTALIGN|TPM_RIGHTBUTTON,MousePos.x,MousePos.y,0,hOwner,NULL);
			}
		}
	}
	if(pobj_SideWeb){
		if(pnmh->hwndFrom==pobj_SideWeb->hTab&&pnmh->code==TCN_SELCHANGE){
			pobj_SideWeb->SelChangeEvent();
		}
	}

	return 0;
}

void MainFrame::OnDropFiles( HDROP hDropInfo )
{
	int max = DragQueryFile(hDropInfo,-1,0,0);
	for(int i=0;i<max;i++){
		char temporary[1024];
		DragQueryFile(hDropInfo,i,temporary,MAX_PATH);
		OpenFileWithExtension(temporary);
	}
	DragFinish(hDropInfo);
}

void MainFrame::OnPaint( HDC dummy )
{
	PAINTSTRUCT ps;
	HDC hdc = this->BeginPaint( &ps );

	HBRUSH hBrush = CreateSolidBrush( GetSysColor( COLOR_3DFACE ) );

	RECT rect;
	this->GetClientRect( &rect );

	FillRect( hdc, &rect, hBrush );

	DeleteObject( hBrush );

	this->EndPaint( &ps );
}

::LRESULT MainFrame::OnShowSourceLine( ::UINT msg, ::WPARAM wParam, ::LPARAM lParam, ::BOOL& handled )
{
	char temporary[1024];

	//G[𔽓]\
	DWORD AccBytes;
	HANDLE fh;
	sprintf(temporary,"%spgm.tmp",pj_editor_Dir);
	fh=CreateFile(temporary,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	ReadFile(fh,temporary,MAX_PATH,&AccBytes,NULL);
	CloseHandle(fh);
	temporary[AccBytes]=0;
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	int WndNum = -1;
	while(hChild){
		WndNum=GetWndNum(hChild);
		if(IS_DOCUMENT_TEXT(MdiInfo[WndNum]->DocType)){
			if(lstrcmpi(MdiInfo[WndNum]->path.c_str(),temporary)==0) break;
		}
		hChild=::GetNextWindow(hChild,GW_HWNDNEXT);
	}
	if(!hChild){
		hChild=OpenFileWithExtension(temporary);
		WndNum=GetWndNum(hChild);
	}

	if(WndNum==-1) return 0;

	//EBhEőOʂɕ\
	::BringWindowToTop(hChild);
	::UpdateWindow(hChild);

	char *pTemp=MdiInfo[WndNum]->pMdiTextEdit->buffer;

	//s̐擪CfbNX擾i擾s̔ԍwParamœnj
	int i,i2;
	for(i=0,i2=0;;i++){
		if(i2>=(int)wParam) break;
		if(pTemp[i]=='\0') break;
		if(pTemp[i]=='\r'&&pTemp[i+1]=='\n'){
			i++;
			i2++;
		}
	}
	POINT pos;
	pos.x=i;

	//s̏I[CfbNX擾
	for(;;i++){
		if(pTemp[i]=='\0') break;
		if(pTemp[i]=='\r'&&pTemp[i+1]=='\n') break;
	}
	pos.y=i;

	//sI
	TextEdit_SetSel(WndNum,pos.x,pos.y,TRUE);

	return 0;
}

void MainFrame::OnCmdNew( UINT uNotifyCode, int nID, CWindow wndCtl )
{

#ifdef THETEXT
	NewTextEditWindow(NULL,WNDTYPE_TEXT);
	return;
#else
	int FileType;
	BOOL bAddToProject;
	char temporary[MAX_PATH];

	FileType=DialogBox(hResInst,MAKEINTRESOURCE(IDD_NEWFILE),hOwner,(DLGPROC)DlgNewFile);
	if(FileType==-1) return;

	if(FileType&0x00008000){
		bAddToProject=1;
		FileType&=0x0FFF;
		extern char NewFileName[MAX_PATH];
		lstrcpy(temporary,NewFileName);
		if(!strstr(temporary,".")) lstrcat(temporary,".ab");

		lstrcpy( temporary, projectInfo.GetWorkDir().GetFullPath( temporary ).c_str() );
	}
	else bAddToProject=0;

	switch(FileType){
		case FT_BASICPROGRAM:		//BasicvO
		case FT_SUBPROGRAM:
			if(bAddToProject){
				WriteBuffer(temporary,0,0);
				NewTextEditWindow(temporary,WNDTYPE_BASIC);
				Project_File_Insert(temporary);
			}
			else NewTextEditWindow(NULL,WNDTYPE_BASIC);
			break;

		case FT_PROJECT:
			DlgNewProjectWizard(hOwner);
			break;

		case FT_TEXT:
			NewTextEditWindow(NULL,WNDTYPE_TEXT);
			break;

		case FT_HTML:
			NewTextEditWindow(NULL,WNDTYPE_HTML);
			break;

		case FT_ICON:
			NewIconEditWindow(NULL);
			break;
	}
#endif
}

void MainFrame::OnCmdOpen( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	//"t@Cw肵Ă"
	extern LPSTR DefFileFilter;
	char temporary[1024];
	if(!GetFilePathDialog(m_hWnd,temporary,DefFileFilter,STRING_FILEOPENTITLE_DEFAULT,TRUE)) return;

	OpenFileWithExtension( temporary );
}

void MainFrame::OnCmdClose( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	if(::IsWindow(hChild)) SendMessage(hChild,WM_CLOSE,0,0);
}

void MainFrame::OnCmdProjectOpen( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	//"vWFNg t@Cw肵ĉ"
	extern LPSTR ProjectFileFilter;
	char temporary[1024];
	if(!GetFilePathDialog(m_hWnd,temporary,ProjectFileFilter,STRING_FILEOPENTITLE_PROJECT,TRUE))
	{
		return;
	}

	projectInfo.Load(temporary);
}

void MainFrame::OnCmdProjectSave( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	projectInfo.Save();
}

void MainFrame::OnCmdProjectClose( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	projectInfo.Close();
}

void MainFrame::OnCmdProjectFolderOpen( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	ShellExecute(m_hWnd,"explore",projectInfo.GetWorkDir().GetPath().c_str(),NULL,NULL,SW_SHOWNORMAL);
}

void MainFrame::OnCmdSave( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	SaveDocument(::GetWindow(hClient,GW_CHILD),NULL);
}

void MainFrame::OnCmdNewSave( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	//"ۑ̃t@Cw肵Ă"
	extern LPSTR DefFileFilter;
	char temporary[1024];
	if(!GetFilePathDialog(m_hWnd,temporary,DefFileFilter,STRING_FILESAVETITLE_DEFAULT,FALSE)) return;

	SaveDocument(::GetWindow(hClient,GW_CHILD),temporary);
}

void MainFrame::OnCmdCodeSave( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	//R[hw肵ĕۑ
	DialogBox(hResInst,MAKEINTRESOURCE(IDD_CODE_SAVE),m_hWnd,(DLGPROC)nkfDlgCodeSave);
}

void MainFrame::OnCmdAllSave( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	for( int i=0;i<MdiInfo.size();i++){
		if(MdiInfo[i]->hwnd) SaveDocument(MdiInfo[i]->hwnd,NULL);
	}
	if( projectInfo.IsOpened() )
	{
		projectInfo.Save();
	}
}

void MainFrame::OnCmdPageSet( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	//y[Wݒ
	obj_Page.SetupDlg();
}

void MainFrame::OnCmdPreview( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	//vr[iProł̂݁j
	Preview();
}

void MainFrame::OnCmdPrintOut( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	//
	Printout();
}

void MainFrame::OnCmdExit( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	SendMessage(WM_CLOSE);
}

void MainFrame::OnCmdUndo( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	if(!hChild) return;
	int WndNum=GetWndNum(hChild);
	if( IS_DOCUMENT_TEXT(MdiInfo[WndNum]->DocType) )
	{
		TextEdit_UndoCommand(WndNum);
	}
	else if( MdiInfo[WndNum]->DocType == WNDTYPE_RAD )
	{
		Rad_UndoCommand(WndNum);
	}
	else if( MdiInfo[WndNum]->DocType == WNDTYPE_ICONEDIT )
	{
		IconEdit_UndoCommand(WndNum);
	}
}

void MainFrame::OnCmdRedo( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	if(!hChild) return;
	int WndNum=GetWndNum(hChild);
	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum]->DocType))
		TextEdit_RedoCommand(WndNum);
	else if(MdiInfo[WndNum]->DocType==WNDTYPE_RAD)
		Rad_RedoCommand(WndNum);
	else if(MdiInfo[WndNum]->DocType==WNDTYPE_ICONEDIT)
		IconEdit_RedoCommand(WndNum);
}

void MainFrame::OnCmdCut( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	int WndNum=GetWndNum(hChild);
	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum]->DocType)){
		HWND hEdit=::GetWindow(hChild,GW_CHILD);

		CHARRANGE CharRange;
		TextEdit_GetSel(WndNum,&CharRange);

		HGLOBAL hGlobal=(char *)GlobalAlloc(GMEM_MOVEABLE,CharRange.cpMax-CharRange.cpMin+1);
		char *pTemp=(char *)GlobalLock(hGlobal);
		memcpy(pTemp,MdiInfo[WndNum]->pMdiTextEdit->buffer+CharRange.cpMin,CharRange.cpMax-CharRange.cpMin);
		pTemp[CharRange.cpMax-CharRange.cpMin]=0;
		GlobalUnlock(hGlobal);

		//Nbv{[hɕۑ
		OpenClipboard();
		EmptyClipboard();
		SetClipboardData(CF_TEXT,hGlobal);
		CloseClipboard();

		//I𕶎
		SendMessage(hEdit,WM_KEYDOWN,VK_DELETE,0);
	}
	else if(MdiInfo[WndNum]->DocType==WNDTYPE_RAD){
		ActiveBasic::PM::WindowInfo *pWindowInfo = GetWndInfo(MdiInfo[WndNum]->path);
		int indexOfWndInfo = GetWndInfoNum(MdiInfo[WndNum]->path);

		//Nbv{[hɊi[邽߂̃f[^pӂ
		pWindowInfo->childWindowInfos[MdiInfo[WndNum]->MdiRadInfo->SelectingItem[0]]->pos.x-=17;
		pWindowInfo->childWindowInfos[MdiInfo[WndNum]->MdiRadInfo->SelectingItem[0]]->pos.y-=10;
		HGLOBAL hGlobal=Rad_GetChildInfoClipboardData(WndNum,indexOfWndInfo);
		pWindowInfo->childWindowInfos[MdiInfo[WndNum]->MdiRadInfo->SelectingItem[0]]->pos.x+=17;
		pWindowInfo->childWindowInfos[MdiInfo[WndNum]->MdiRadInfo->SelectingItem[0]]->pos.y+=10;

		OpenClipboard();
		EmptyClipboard();
		extern DWORD dwRadClipboardID;
		SetClipboardData(dwRadClipboardID,hGlobal);
		CloseClipboard();

		SendMessage(MdiInfo[WndNum]->MdiRadInfo->hRad,WM_COMMAND,IDM_RAD_ITEM_DELETE,0);
	}
	else if(MdiInfo[WndNum]->DocType==WNDTYPE_ICONEDIT){
		//Nbv{[hɊi[邽߂̃f[^pӂ
		HGLOBAL hGlobal=IconEdit_GetChildInfoClipboardData(WndNum);
		if(hGlobal==0) return;

		OpenClipboard();
		EmptyClipboard();
		SetClipboardData(CF_BITMAP,hGlobal);
		CloseClipboard();

		DeleteObject(MdiInfo[WndNum]->MdiIconEditInfo->hSelectingBmp);
		MdiInfo[WndNum]->MdiIconEditInfo->SelectLevel=0;

		IconEdit_EraseRect(WndNum,&MdiInfo[WndNum]->MdiIconEditInfo->DraggingRect);
	}
}

void MainFrame::OnCmdCopy( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	int WndNum=GetWndNum(hChild);
	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum]->DocType)){
		HWND hEdit = ::GetWindow(hChild,GW_CHILD);

		CHARRANGE CharRange;
		TextEdit_GetSel(WndNum,&CharRange);

		HGLOBAL hGlobal=(char *)GlobalAlloc(GMEM_MOVEABLE,CharRange.cpMax-CharRange.cpMin+1);
		char *pTemp=(char *)GlobalLock(hGlobal);
		memcpy(pTemp,MdiInfo[WndNum]->pMdiTextEdit->buffer+CharRange.cpMin,CharRange.cpMax-CharRange.cpMin);
		pTemp[CharRange.cpMax-CharRange.cpMin]=0;
		GlobalUnlock(hGlobal);

		//Nbv{[hɕۑ
		OpenClipboard();
		EmptyClipboard();
		SetClipboardData(CF_TEXT,hGlobal);
		CloseClipboard();
	}
	else if(MdiInfo[WndNum]->DocType==WNDTYPE_RAD){
		int indexOfWndInfo = GetWndInfoNum(MdiInfo[WndNum]->path);

		//Nbv{[hɊi[邽߂̃f[^pӂ
		HGLOBAL hGlobal=Rad_GetChildInfoClipboardData(WndNum,indexOfWndInfo);

		OpenClipboard();
		EmptyClipboard();
		extern DWORD dwRadClipboardID;
		SetClipboardData(dwRadClipboardID,hGlobal);
		CloseClipboard();
	}
	else if(MdiInfo[WndNum]->DocType==WNDTYPE_ICONEDIT){
		//Nbv{[hɊi[邽߂̃f[^pӂ
		HGLOBAL hGlobal=IconEdit_GetChildInfoClipboardData(WndNum);

		OpenClipboard();
		EmptyClipboard();
		SetClipboardData(CF_BITMAP,hGlobal);
		CloseClipboard();
	}
}

void MainFrame::OnCmdPaste( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	int WndNum=GetWndNum(hChild);
	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum]->DocType)){
		HWND hEdit=::GetWindow(hChild,GW_CHILD);

		//Nbv{[hJ
		OpenClipboard();
		HGLOBAL hGlobal=GetClipboardData(CF_TEXT);
		if(!hGlobal){
			CloseClipboard();
			return;
		}


		char *pTemp;
		if(pobj_nv->bPasteIndent){
			//Cfg`
			pTemp=CodeFormatter((char *)GlobalLock(hGlobal));
			GlobalUnlock(hGlobal);
		}
		else pTemp=(char *)GlobalLock(hGlobal);


		//eLXgGfB^̕vCX
		TextEdit_ReplaceUpdateUndoData(WndNum,
			pTemp,
			1,
			1);

		if(pobj_nv->bPasteIndent)
			HeapDefaultFree(pTemp);
		else
			GlobalUnlock(hGlobal);

		//Nbv{[h
		CloseClipboard();


		//Lbgʒu܂ŃXN[
		TextEdit_ScrollCaret(WndNum,0);
		ResetCaretPos(WndNum);
	}
	else if(MdiInfo[WndNum]->DocType==WNDTYPE_RAD){
		OpenClipboard();
		extern DWORD dwRadClipboardID;
		HGLOBAL hGlobal=GetClipboardData(dwRadClipboardID);
		if(!hGlobal){
			CloseClipboard();
			return;
		}
		Rad_PasteChildInfoClipboardData(WndNum,hGlobal);
		CloseClipboard();
	}
	else if(MdiInfo[WndNum]->DocType==WNDTYPE_ICONEDIT){
		OpenClipboard();
		HGLOBAL hGlobal=GetClipboardData(CF_BITMAP);
		if(!hGlobal){
			CloseClipboard();
			return;
		}
		IconEdit_PasteChildInfoClipboardData(WndNum,(HBITMAP)hGlobal);
		CloseClipboard();
	}
}

void MainFrame::OnCmdDelete( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	int WndNum=GetWndNum(hChild);
	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum]->DocType)){
		HWND hEdit=::GetWindow(hChild,GW_CHILD);
		TextEdit_ReplaceUpdateUndoData(WndNum,"",0,1);
	}
	else if(MdiInfo[WndNum]->DocType==WNDTYPE_RAD)
		SendMessage(MdiInfo[WndNum]->MdiRadInfo->hRad,WM_COMMAND,IDM_RAD_ITEM_DELETE,0);
}

void MainFrame::OnCmdAllSelect( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	int WndNum=GetWndNum(hChild);
	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum]->DocType)){
		HWND hEdit=::GetWindow(hChild,GW_CHILD);

		MdiInfo[WndNum]->pMdiTextEdit->StartCaretPos.x=0;
		MdiInfo[WndNum]->pMdiTextEdit->StartCaretPos.y=0;

		GetCaretPosFromBufferIndex(
			MdiInfo[WndNum]->pMdiTextEdit->buffer,
			lstrlen(MdiInfo[WndNum]->pMdiTextEdit->buffer),
			&MdiInfo[WndNum]->pMdiTextEdit->EndCaretPos);

		::InvalidateRect(hEdit,NULL,0);

		ResetState_EditMenu();
	}
	else if(MdiInfo[WndNum]->DocType==WNDTYPE_RAD){
		ActiveBasic::PM::WindowInfo *pWindowInfo = GetWndInfo(MdiInfo[WndNum]->path);
		for( int i3=0; i3<static_cast<int>(pWindowInfo->childWindowInfos.size()); i3++ )
		{
			MdiInfo[WndNum]->MdiRadInfo->SelectingItem[i3] = i3;
		}
		DrawRadWindow(WndNum,pWindowInfo);
	}
}

void MainFrame::OnCmdFind( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	DialogBox(hResInst,MAKEINTRESOURCE(IDD_FIND),m_hWnd,(DLGPROC)DlgFind);
}

void MainFrame::OnCmdPermutation( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	DialogBox(hResInst,MAKEINTRESOURCE(IDD_PERMUTATION),m_hWnd,(DLGPROC)DlgPermutation);
}

void MainFrame::OnCmdConvertX( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	TextEdit_Convert( nID );
}

#ifdef THETEXT
void MainFrame::OnCmdStringCount( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_STRING_COUNT),m_hWnd,(DLGPROC)DlgStringCount,0);
}

void MainFrame::OnCmdSelStringCount( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_STRING_COUNT),m_hWnd,(DLGPROC)DlgStringCount,1);
}
#endif

void MainFrame::OnCmdProjectView( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	extern HWND hProjectView;
	bool isCheck = false;
	if(pobj_nv->bClipProjectView){
		if(::IsWindowVisible(hProjectView)){
			::ShowWindow(hProjectView,SW_HIDE);
		}
		else{
			::ShowWindow(hProjectView,SW_SHOW);
			isCheck = true;
		}
	}
	else{
		extern HWND hProjectView_ToolWindow;
		if(::IsWindowVisible(hProjectView_ToolWindow)){
			::ShowWindow(hProjectView_ToolWindow,SW_HIDE);
		}
		else{
			::ShowWindow(hProjectView_ToolWindow,SW_SHOW);
			::ShowWindow(hProjectView,SW_SHOW);
			isCheck = true;
		}
	}
	pobj_MainMenu->CheckMenu(IDM_PROJECTVIEW,isCheck);

	//Ĕzu
	this->Resized();

	::ShowWindow(hClient,SW_SHOW);
}

void MainFrame::OnCmdProjectOption( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	DlgProjectOptionSetting( m_hWnd );
}

void MainFrame::OnCmdTopMost( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	if(pobj_MainMenu->IsCheck(IDM_TOPMOST)){
		SetWindowPos( HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
		pobj_MainMenu->CheckMenu(IDM_TOPMOST,0);
	}
	else{
		SetWindowPos( HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
		pobj_MainMenu->CheckMenu(IDM_TOPMOST,1);
	}
}

void ResetState_ViewMenu(void);
void MainFrame::OnCmdRightTurn( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	pobj_nv->bRightTurn^=1;
	ResetState_ViewMenu();

	//gbṽEBhEĕ`
	RedrawAllWindow();
}

void MainFrame::OnCmdSet( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	DlgOptionSetting( m_hWnd );
}

void CreateProcessWithStdHandle( const std::string &appPath, const std::string &cmdLine)
{
	std::string argsStr = (std::string)"\"" + appPath + "\" " + cmdLine;
	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	memset(&si,0,sizeof(STARTUPINFO));
	si.cb=sizeof(STARTUPINFO);
	si.dwFlags = STARTF_USESTDHANDLES | STARTF_USESHOWWINDOW;
	si.wShowWindow = SW_HIDE;
	si.hStdOutput = GetStdHandle(STD_OUTPUT_HANDLE);
	si.hStdInput = GetStdHandle(STD_INPUT_HANDLE);
	si.hStdError = GetStdHandle(STD_ERROR_HANDLE);
	
	char args[8192];
	lstrcpy( args, argsStr.c_str() );

	CreateProcess( NULL, args, NULL, NULL, FALSE, NORMAL_PRIORITY_CLASS, NULL, NULL, &si, &pi );
}

#ifndef THETEXT
void MainFrame::OnCmdDebug( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	char temporary[1024], temp2[1024], temp3[1024];
	if(pobj_Debugger->IsDebugging()){
		pobj_Debugger->DebugContinue();
		return;
	}

	HWND hChild = ::GetWindow(hClient,GW_CHILD);
	if( projectInfo.IsOpened() ){
		//vWFNgJĂꍇ
		if(!SetProjectToRun()) return;

		//fobOp̃R}hCyюs\t@CiDLL̂݁j
		sprintf(temporary,"%s\r\n%s",projectInfo.szExePath,projectInfo.szCmdLine);
		sprintf(temp2,"%spgm.tmp",pj_editor_Dir);
		HANDLE hFile=CreateFile(temp2,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_ARCHIVE|FILE_ATTRIBUTE_HIDDEN|FILE_ATTRIBUTE_TEMPORARY,NULL);
		DWORD dwAccessBytes;
		WriteFile(hFile,temporary,lstrlen(temporary),&dwAccessBytes,NULL);
		CloseHandle(hFile);

		//\[Xt@Ctemp2
		projectInfo.pobj_DBFileInfo->ppobj_FileInfo[0]->GetFullPath(temp2);

		//o̓t@Ctemp3
		lstrcpy(temp3,projectInfo.lpszOutput_Debug);
		lstrcpy( temp3, projectInfo.GetWorkDir().GetFullPath( temp3 ).c_str() );

		if(IsNeedCompileForProject(1))
			sprintf(temporary,"\"%s\" \"%s\" /debug /run /wnd:%08x",temp2,temp3,m_hWnd);
		else
			sprintf(temporary,"\"%s\" \"%s\" /run /wnd:%08x",temp2,temp3,m_hWnd);

		// DLLIvV
		if( projectInfo.GetModuleType() == ActiveBasic::Common::TargetModuleType::Dll )
		{
			lstrcat(temporary," /dll");
		}

		// SLLIvV
		if( projectInfo.GetModuleType() == ActiveBasic::Common::TargetModuleType::Sll )
		{
			lstrcat(temporary," /static_library");
		}

		//UnicodeIvV
		if(projectInfo.dwOption & PJ_OP_UNICODE) lstrcat(temporary," /unicode");

		//u[N|CgZ[u
		projectInfo.pobj_DBBreakPoint->SaveToTempFile();
	}
	else{
		//Pƃ\[XR[h
		if(!SetRunning(hChild)) return;
		if(IsNeedCompile(MdiInfo[GetWndNum(hChild)]->path,1))
			sprintf(temporary,"\"%s\" /debug /run /wnd:%08x",MdiInfo[GetWndNum(hChild)]->path.c_str(),m_hWnd);
		else
			sprintf(temporary,"\"%s\" /run /wnd:%08x",MdiInfo[GetWndNum(hChild)]->path.c_str(),m_hWnd);

		//u[N|CgZ[u
		extern CDBBreakPoint *pobj_DBBreakPoint;
		pobj_DBBreakPoint->SaveToTempFile();
	}

	//RpCr[Nbv邩ǂ
	extern BOOL bClipCompileView;
	if(bClipCompileView){
		lstrcat(temporary," /clip_compile_view");

		//RpCr[
		extern HWND hCompileView;
		if(hCompileView==(HWND)-1) return;
		if(hCompileView){
			hChild=hCompileView;
			hCompileView=(HWND)-1;
			SendMessage(hChild,WM_COMMAND,IDCANCEL,0);
		}

		//dNh~̂
		hCompileView=(HWND)-1;
	}

	//CN[hfBNg
	sprintf(temp2," /include_dir:\"%s\"",pobj_nv->GetIncludeDirFullPath().c_str());
	lstrcat(temporary,temp2);

	extern ActiveBasic::Common::Platform::EnumType selectingPlatform;
	CreateProcessWithStdHandle( ActiveBasic::Common::Environment::GetCompilerExePath( selectingPlatform ), temporary );
}

void MainFrame::OnCmdDebugCompile( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	char temporary[1024], temp2[1024], temp3[1024];

	HWND hChild=::GetWindow(hClient,GW_CHILD);
	if( projectInfo.IsOpened() ){
		//vWFNgJĂꍇ
		if(!SetProjectToRun()) return;

		//\[Xt@Ctemp2
		projectInfo.pobj_DBFileInfo->ppobj_FileInfo[0]->GetFullPath(temp2);

		//o̓t@Ctemp3
		lstrcpy(temp3,projectInfo.lpszOutput_Debug);
		lstrcpy( temp3, projectInfo.GetWorkDir().GetFullPath( temp3 ).c_str() );

		sprintf(temporary,"\"%s\" \"%s\" /debug /wnd:%08x",temp2,temp3,m_hWnd);

		//DLLIvV
		if( projectInfo.GetModuleType() == ActiveBasic::Common::TargetModuleType::Dll )
		{
			lstrcat(temporary," /dll");
		}

		// SLLIvV
		if( projectInfo.GetModuleType() == ActiveBasic::Common::TargetModuleType::Sll )
		{
			lstrcat(temporary," /static_library");
		}

		//UnicodeIvV
		if(projectInfo.dwOption & PJ_OP_UNICODE) lstrcat(temporary," /unicode");
	}
	else{
		//Pƃ\[XR[h
		if(!SetRunning(hChild)) return;
		sprintf(temporary,"\"%s\" /debug /wnd:%08x",MdiInfo[GetWndNum(hChild)]->path.c_str(),m_hWnd);
	}

	//RpCr[Nbv邩ǂ
	extern BOOL bClipCompileView;
	if(bClipCompileView){
		lstrcat(temporary," /clip_compile_view");

		//RpCr[
		extern HWND hCompileView;
		if(hCompileView==(HWND)-1) return;
		if(hCompileView){
			hChild=hCompileView;
			hCompileView=(HWND)-1;
			if( ::IsWindow( hChild ) )
			{
				SendMessage(hChild,WM_COMMAND,IDCANCEL,0);
			}
		}

		//dNh~̂
		hCompileView=(HWND)-1;	
	}

	//CN[hfBNg
	sprintf(temp2," /include_dir:\"%s\"",pobj_nv->GetIncludeDirFullPath().c_str());
	lstrcat(temporary,temp2);

	extern ActiveBasic::Common::Platform::EnumType selectingPlatform;
	CreateProcessWithStdHandle( ActiveBasic::Common::Environment::GetCompilerExePath( selectingPlatform ), temporary );

}

void MainFrame::OnCmdAttach( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	char temporary[1024], temp2[1024];

	int idProcess;
	DWORD dwPlatform;
	idProcess=DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_ATTACH),m_hWnd,(DLGPROC)DlgAttach,(LPARAM)&dwPlatform);
	if(idProcess==0) return;

	sprintf(temporary,"/attach:%08x /wnd:%08x",idProcess,m_hWnd);

	//RpCr[Nbv邩ǂ
	extern BOOL bClipCompileView;
	if(bClipCompileView){
		lstrcat(temporary," /clip_compile_view");

		//RpCr[
		extern HWND hCompileView;
		if(hCompileView==(HWND)-1) return;
		if(hCompileView){
			HWND hChild=hCompileView;
			hCompileView=(HWND)-1;
			SendMessage(hChild,WM_COMMAND,IDCANCEL,0);
		}

		//dNh~̂
		hCompileView=(HWND)-1;
	}

	//CN[hfBNg
	sprintf(temp2," /include_dir:\"%s\"",pobj_nv->GetIncludeDirFullPath().c_str());
	lstrcat(temporary,temp2);

	ActiveBasic::Common::Platform::EnumType platform;
	if(dwPlatform==IMAGE_FILE_MACHINE_I386)
	{
		platform = ActiveBasic::Common::Platform::X86;
	}
	else if(dwPlatform==IMAGE_FILE_MACHINE_AMD64)
	{
		platform = ActiveBasic::Common::Platform::X64;
	}
	else
	{
		throw;
	}

	extern ActiveBasic::Common::Platform::EnumType selectingPlatform;
	CreateProcessWithStdHandle( ActiveBasic::Common::Environment::GetCompilerExePath( platform ), temporary );
}

void MainFrame::OnCmdReleaseCompile( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	char temporary[1024], temp2[1024], temp3[1024];

	HWND hChild=::GetWindow(hClient,GW_CHILD);
	if( projectInfo.IsOpened() ){
		//vWFNgJĂꍇ
		if(!SetProjectToRun()) return;

		//\[Xt@Ctemp2
		projectInfo.pobj_DBFileInfo->ppobj_FileInfo[0]->GetFullPath(temp2);

		//o̓t@Ctemp3
		lstrcpy(temp3,projectInfo.lpszOutput_Release);
		lstrcpy( temp3, projectInfo.GetWorkDir().GetFullPath( temp3 ).c_str() );

		sprintf(temporary,"\"%s\" \"%s\" /wnd:%08x",temp2,temp3,m_hWnd);

		//DLLIvV
		if( projectInfo.GetModuleType() == ActiveBasic::Common::TargetModuleType::Dll )
		{
			lstrcat(temporary," /dll");
		}

		// SLLIvV
		if( projectInfo.GetModuleType() == ActiveBasic::Common::TargetModuleType::Sll )
		{
			lstrcat(temporary," /static_library");
		}

		//UnicodeIvV
		if(projectInfo.dwOption & PJ_OP_UNICODE) lstrcat(temporary," /unicode");
	}
	else{
		//Pƃ\[XR[h
		if(!SetRunning(hChild)) return;
		sprintf(temporary,"\"%s\" /wnd:%08x",MdiInfo[GetWndNum(hChild)]->path.c_str(),m_hWnd);
	}

	//RpCr[Nbv邩ǂ
	extern BOOL bClipCompileView;
	if(bClipCompileView){
		lstrcat(temporary," /clip_compile_view");

		//RpCr[
		extern HWND hCompileView;
		if(hCompileView==(HWND)-1) return;
		if(hCompileView){
			hChild=hCompileView;
			hCompileView=(HWND)-1;
			if( ::IsWindow( hChild ) )
			{
				SendMessage(hChild,WM_COMMAND,IDCANCEL,0);
			}
		}

		//dNh~̂
		hCompileView=(HWND)-1;
	}

	//CN[hfBNg
	sprintf(temp2," /include_dir:\"%s\"",pobj_nv->GetIncludeDirFullPath().c_str());
	lstrcat(temporary,temp2);

	extern ActiveBasic::Common::Platform::EnumType selectingPlatform;
	CreateProcessWithStdHandle( ActiveBasic::Common::Environment::GetCompilerExePath( selectingPlatform ), temporary );
}

void MainFrame::OnCmdReleaseRun( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	char temporary[1024], temp2[1024], temp3[1024];

	HWND hChild=::GetWindow(hClient,GW_CHILD);
	if( projectInfo.IsOpened() ){
/*						//vWFNgJĂꍇ
		if(!SetProjectToRun()) return;

		//Kvł΃[XRpC
		if(IsNeedCompileForProject(0))
			SendMessage(WM_COMMAND,IDM_RELEASECOMPILE,0);*/

		if( projectInfo.GetModuleType() == ActiveBasic::Common::TargetModuleType::Dll )
		{
			lstrcpy(temporary,projectInfo.szExePath);
		}
		else{
			lstrcpy(temporary,projectInfo.lpszOutput_Debug);
			lstrcpy( temporary, projectInfo.GetWorkDir().GetFullPath( temporary ).c_str() );
		}
	}
	else{
/*						//Kvł΃[XRpC
		if(!SetRunning(hChild)) return;

		if(IsNeedCompile(MdiInfo[GetWndNum(hChild)]->path,0))
			SendMessage(WM_COMMAND,IDM_RELEASECOMPILE,0);*/

		//Pƃ\[XR[h
		_splitpath(MdiInfo[GetWndNum(hChild)]->path.c_str(),temporary,temp2,temp3,NULL);
		lstrcat(temporary,temp2);
		lstrcat(temporary,temp3);
		lstrcat(temporary,".exe");
	}

	//CN[hfBNg
	sprintf(temp2," /include_dir:\"%s\"",pobj_nv->GetIncludeDirFullPath().c_str());
	lstrcat(temporary,temp2);

	ShellExecute(m_hWnd,"open",temporary,NULL,NULL,SW_SHOWNORMAL);
}

void MainFrame::OnCmdStepIn( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	pobj_Debugger->StepIn();
}

void MainFrame::OnCmdStepOver( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	pobj_Debugger->StepOver();
}

void MainFrame::OnCmdStepCursor( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	pobj_Debugger->StepToCursor();
}

void MainFrame::OnCmdBreakPoint( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	if( projectInfo.IsOpened() ){
		projectInfo.pobj_DBBreakPoint->Event_BreakPoint();
	}
	else{
		extern CDBBreakPoint *pobj_DBBreakPoint;
		pobj_DBBreakPoint->Event_BreakPoint();
	}
}

void MainFrame::OnCmdDebugStop( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	pobj_Debugger->DebugStop();
}

void MainFrame::OnCmdDebugPause( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	pobj_Debugger->DebugPause();
}

#endif	// not THETEXT

void MainFrame::OnCmdWebLink( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	switch( nID )
	{
#ifndef THETEXT
	case IDM_COMMUNITY:
		OpenWebBrowser( "http://www.activebasic.com/forum/" );
		break;
	case IDM_COMMU_SEARCH:
		OpenWebBrowser( "http://www.activebasic.com/forum/search.php" );
		break;
	case IDM_COMMU_PM:
		OpenWebBrowser( "http://www.activebasic.com/forum/privmsg.php?folder=inbox" );
		break;
	case ID_COMMU_FORUM1:
		OpenWebBrowser( "http://www.activebasic.com/forum/viewforum.php?f=1" );
		break;
	case ID_COMMU_FORUM2:
		OpenWebBrowser( "http://www.activebasic.com/forum/viewforum.php?f=2" );
		break;
	case ID_COMMU_FORUM3:
		OpenWebBrowser( "http://www.activebasic.com/forum/viewforum.php?f=5" );
		break;
	case ID_COMMU_FORUM4:
		OpenWebBrowser( "http://www.activebasic.com/forum/viewforum.php?f=3" );
		break;
	case ID_COMMU_FORUM5:
		OpenWebBrowser( "http://www.activebasic.com/forum/viewforum.php?f=6" );
		break;
	case ID_COMMU_FORUM6:
		OpenWebBrowser( "http://www.activebasic.com/forum/viewforum.php?f=8" );
		break;
	case ID_COMMU_FORUM7:
		OpenWebBrowser( "http://www.activebasic.com/forum/viewforum.php?f=4" );
		break;
	case ID_COMMU_FORUM8:
		OpenWebBrowser( "http://www.activebasic.com/forum/viewforum.php?f=7" );
		break;
	case IDM_AB_WEBSITE:
		OpenWebBrowser( "http://www.activebasic.com/" );
		break;
	case IDM_ACTBDL:
		OpenWebBrowser( "http://www.activebasic.com/activebasic5/download.htm" );
		break;
#else
	case IDM_DSHOMEPAGE:
		OpenWebBrowser( "http://www.discoversoft.net/" );
		break;
#endif // not THETEXT
	default:
		throw;
	}
}

void MainFrame::OnCmdTopics( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	char temporary[1024];
#ifdef THETEXT
	sprintf(temporary,"%sTopics\\index.html",pj_editor_Dir);
	ShellExecute(m_hWnd,"open",temporary,NULL,NULL,SW_SHOWNORMAL);
#else
	sprintf(temporary,"%sBasicHelp.chm",pj_editor_Dir);
	HtmlHelp(NULL,temporary,HH_DISPLAY_TOPIC,0);
#endif
}

void MainFrame::OnCmdAbout( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	DialogBox(hResInst,MAKEINTRESOURCE(IDD_ABOUT),m_hWnd,(DLGPROC)DialogAbout);
}

void MainFrame::OnCmdDocSelectBand( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	pobj_Rebar->ChangeRebarBand(ID_DOCCOMBO);
}

void MainFrame::OnCmdStandardBand( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	pobj_Rebar->ChangeRebarBand(ID_STANDARDTOOLBAR);
}

void MainFrame::OnCmdReleaseBand( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	pobj_Rebar->ChangeRebarBand(ID_RELEASETOOLBAR);
}

void MainFrame::OnCmdDebugBand( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	pobj_Rebar->ChangeRebarBand(ID_DEBUGGERTOOLBAR);
}

void MainFrame::OnCmdSelectCompilerBand( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	pobj_Rebar->ChangeRebarBand(ID_SELECTCOMPILERCOMBO);
}

void MainFrame::OnCmdNoGripper( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	if(pobj_nv->bNoGripper) pobj_nv->bNoGripper=0;
	else pobj_nv->bNoGripper=1;

	//o[Rg[Đ
	pobj_Rebar->ResetRebar();

	//j[Ԃݒ
	ResetState_DocMenu();
}

void MainFrame::OnCmdResetRebar( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	//"c[o[̔zuׂďԂɖ߂܂B\n낵łH"
	if( MessageBox(STRING_TOOLBAR_RESET,APPLICATION_NAME,MB_OKCANCEL|MB_ICONEXCLAMATION) == IDCANCEL )
	{
		return;
	}

	//o[Rg[Đ
	pobj_Rebar->ResetInitRebar();

	//j[Ԃݒ
	ResetState_DocMenu();
}

void MainFrame::OnCmdAllCloseOmitMyself( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	//̃EBhEȊOׂĕ(&A)
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	int WndNum=GetWndNum(hChild);
	for(int i=0;i<MdiInfo.size();i++){
		if(i==WndNum) continue;
		if(MdiInfo[i]->hwnd) SendMessage(MdiInfo[i]->hwnd,WM_CLOSE,0,0);
	}
}

void MainFrame::OnCmdPathCopy( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	int WndNum=GetWndNum(hChild);

	//΃pXRs[
	HGLOBAL hGlobal=(char *)GlobalAlloc(GMEM_MOVEABLE,MdiInfo[WndNum]->path.size()+1);
	char *pTemp=(char *)GlobalLock(hGlobal);
	lstrcpy(pTemp,MdiInfo[WndNum]->path.c_str());
	GlobalUnlock(hGlobal);

	//Nbv{[hɕۑ
	OpenClipboard();
	EmptyClipboard();
	SetClipboardData(CF_TEXT,hGlobal);
	CloseClipboard();
}

void MainFrame::OnCmdFolderOpen( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	int WndNum=GetWndNum(hChild);

	char temporary[1024], temp2[1024];
	_splitpath(MdiInfo[WndNum]->path.c_str(),temporary,temp2,NULL,NULL);
	lstrcat(temporary,temp2);

	OpenExplorer( temporary );
}

void MainFrame::OnCmdDeleteFile( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	int WndNum=GetWndNum(hChild);

	char temporary[1024], temp2[1024];
	_splitpath(MdiInfo[WndNum]->path.c_str(),NULL,NULL,temporary,temp2);
	lstrcat(temporary,temp2);

	lstrcat(temporary," ݔɈړĕ܂B낵łH");
	if(MessageBox(temporary,APPLICATION_NAME,MB_OKCANCEL|MB_ICONQUESTION)==IDCANCEL) return;

	//S~
	SHFILEOPSTRUCT fo;
	fo.hwnd=m_hWnd;
	fo.wFunc=FO_DELETE;
	fo.pFrom =MdiInfo[WndNum]->path.c_str();
	fo.pTo="\0";
	fo.fFlags =FOF_ALLOWUNDO|FOF_NOCONFIRMATION;
	SHFileOperation(&fo);

	//
	MdiInfo[WndNum]->pMdiTextEdit->UnModify();
	SendMessage(MdiInfo[WndNum]->hwnd,WM_CLOSE,0,0);
}

void MainFrame::OnCmdColor( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	static COLORREF colorUser=RGB(255,255,255);

	switch( nID )
	{
	case IDM_USER_COLOR:
		{
			CHOOSECOLOR cc;
			COLORREF CusColors[16]={
				RGB(255,255,255),
				RGB(0,0,0),
				RGB(128,128,128),
				RGB(192,192,192),
				RGB(128,0,0),
				RGB(255,0,0),
				RGB(128,128,0),
				RGB(255,255,0),
				RGB(0,128,0),
				RGB(0,255,0),
				RGB(0,128,128),
				RGB(0,255,255),
				RGB(0,0,128),
				RGB(0,0,255),
				RGB(128,0,128),
				RGB(255,0,255)};
			cc.lStructSize=sizeof(CHOOSECOLOR);
			cc.hwndOwner=m_hWnd;
			cc.rgbResult=colorUser;
			cc.lpCustColors=CusColors;
			cc.Flags=CC_RGBINIT|CC_FULLOPEN;
			if(!ChooseColor(&cc)){
				return;
			}
			colorUser=cc.rgbResult;
		}
	case IDM_GRAY:
	case IDM_WHITE:
	case IDM_RED:
	case IDM_GREEN:
	case IDM_BLUE:
	case IDM_YELLOW:
		{
			HWND hChild=::GetWindow(hClient,GW_CHILD);
			int WndNum=GetWndNum(hChild);

			TC_ITEM tcItem;
			tcItem.mask=TCIF_PARAM;
			if(nID==IDM_GRAY)	tcItem.lParam=TABCOLOR_GRAY;
			if(nID==IDM_WHITE)	tcItem.lParam=TABCOLOR_WHITE;
			if(nID==IDM_RED)		tcItem.lParam=TABCOLOR_RED;
			if(nID==IDM_GREEN)	tcItem.lParam=TABCOLOR_GREEN;
			if(nID==IDM_BLUE)	tcItem.lParam=TABCOLOR_BLUE;
			if(nID==IDM_YELLOW)	tcItem.lParam=TABCOLOR_YELLOW;
			if(nID==IDM_USER_COLOR) tcItem.lParam=colorUser;
			TabCtrl_SetItem(pobj_MainTab->hTab,
				TabCtrl_GetCurSel(pobj_MainTab->hTab),
				&tcItem);
			::InvalidateRect(pobj_MainTab->hTab,NULL,0);
			break;
		}
	default:
		throw;
	}
}
