#include "stdafx.h"

bool CMethod::Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors )
{
	if( this->pUserProc )
	{
		if( this->pUserProc->IsNeedResolve() )
		{
			const UserProc *pTempUserProc = resolver.meta.GetUserProcs().FindLike( this->pUserProc );
			if( pTempUserProc )
			{
				this->pUserProc = pTempUserProc;
			}
			else
			{
				resolveErrors.Add( ResolveError( this->pUserProc->GetRelationalObjectModuleIndex(), this->pUserProc->GetFullName() ) );
			}
		}
	}
	return true;
}

DynamicMethod::OverrideResult::EnumType DynamicMethod::Override( const UserProc *pUserProc, Prototype::Accessibility accessibility, bool isOverrideModifier )
{
	bool isAbstractBefore = this->IsAbstract();

	//o֐㏑
	this->SetUserProcPtr( pUserProc );
	this->SetAbstractMark( false );

	if( this->IsVirtual() )
	{
		if( !isAbstractBefore && isOverrideModifier == false )
		{
			return OverrideResult::NotUseOverrideModifier;
		}
	}
	else
	{
		return OverrideResult::NotVirtual;
	}

	if( this->GetAccessibility() != accessibility )
	{
		return OverrideResult::DifferentAccesibility;
	}

	return OverrideResult::Successful;
}

bool DynamicMethod::Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors )
{
	CMethod::Resolve( resolver, resolveErrors );

	if( this->pInheritsClass )
	{
		if( this->pInheritsClass->IsNeedResolve() )
		{
			const CClass *pTempClass = resolver.meta.GetClasses().FindLike( pInheritsClass );
			if( pTempClass )
			{
				this->pInheritsClass = pTempClass;
			}
			else
			{
				resolveErrors.Add( ResolveError( this->pInheritsClass->GetRelationalObjectModuleIndex(), this->pInheritsClass->GetFullName() ) );
			}
		}
	}

	return true;
}

StaticMethod::StaticMethod( const StaticMethod &staticMethod )
{
	// ÓI\bhRs[RXgg邱Ƃ͑z肵Ȃ
	throw;
}

bool StaticMethod::Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors )
{
	CMethod::Resolve( resolver, resolveErrors );
	return true;
}


Methods::Methods()
{
}

// Rs[RXgN^
Methods::Methods( const Methods &methods )
{
	BOOST_FOREACH( CMethod *pMethod, methods )
	{
		this->push_back( new DynamicMethod( dynamic_cast<DynamicMethod &>(*pMethod) ) );
	}
}

Methods::~Methods()
{
	Methods &methods = *this;
	BOOST_FOREACH( CMethod *pMethod, methods )
	{
		delete pMethod;
	}
}

void Methods::Add( UserProc *pUserProc,Prototype::Accessibility accessibility, bool isConst, bool isAbstract, bool isVirtual ){
	CMethod *pMethod = new DynamicMethod( pUserProc, accessibility, isAbstract, isVirtual, isConst );
	this->push_back( pMethod );
	pUserProc->SetMethod( pMethod );
}
void Methods::AddStatic(UserProc *pUserProc, Prototype::Accessibility accessibility ){
	CMethod *pMethod = new StaticMethod( pUserProc, accessibility );
	this->push_back( pMethod );
	pUserProc->SetMethod( pMethod );
}

DynamicMethod *Methods::FindForOverride( const Types &actualTypeParametersForThisMethods, const UserProc *pUserProc )
{
	//\bh̃I[o[Ch
	Methods &methods = *this;
	BOOST_FOREACH( CMethod *pMethod, methods )
	{
		if( !pMethod->IsNotUse() && pMethod->GetUserProc().IsEqualForOverride( actualTypeParametersForThisMethods, pUserProc ) )
		{
			return dynamic_cast<DynamicMethod *>(pMethod);
		}
	}
	return NULL;
}

const CMethod *Methods::GetMethodPtr( const UserProc *pUserProc ) const
{
	const Methods &methods = *this;
	for( int i=(int)methods.size()-1; i>=0; i-- ){
		if( pUserProc == &methods[i]->GetUserProc() ){
			return methods[i];
		}
	}
	return NULL;
}
bool Methods::IsExist( const char *name ) const
{
	const Methods &methods = *this;
	BOOST_FOREACH( const CMethod *pMethod, methods ){
		if( pMethod->GetUserProc().GetName() == name ) return true;
	}
	return false;
}
void Methods::Enum( const char *methodName, std::vector<const UserProc *> &subs ) const
{
	//IuWFNg̃o֐̏ꍇ
	//I[o[Chꂽ֐ɃT[`Kv邽߁AobNT[`s
	const Methods &methods = *this;
	for( int i=(int)methods.size()-1; i>=0; i-- ){
		if( methods[i]->GetUserProc().GetName() == methodName && methods[i]->IsNotUse() == false ){
			subs.push_back( &methods[i]->GetUserProc() );
		}
	}
}
void Methods::Enum( BYTE idOperatorCalc, std::vector<const UserProc *> &subs ) const
{
	//IuWFNg̃o֐̏ꍇ
	//I[o[Chꂽ֐ɃT[`Kv邽߁AobNT[`s
	const Methods &methods = *this;
	for( int i=(int)methods.size()-1; i>=0; i-- ){
		const UserProc &userProc = methods[i]->GetUserProc();
		const char *temp = userProc.GetName().c_str();
		if(temp[0]==1&&temp[1]==ESC_OPERATOR){
			if((BYTE)temp[2]==idOperatorCalc){
				subs.push_back( &userProc );
			}
		}
	}
}

int Methods::GetVtblNum() const
{
	int count = 0;
	const Methods &methods = *this;
	BOOST_FOREACH( const CMethod *pMethod, methods )
	{
		if( pMethod->IsVirtual() )
		{
			count++;
		}
	}
	return count;
}
