#pragma once

//DataTable.cpp
class DataTable
{
	char *buffer;
	int size;

public:
	// JŉȂ΂ȂȂXPW[
	Schedules schedules;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	BOOST_SERIALIZATION_SPLIT_MEMBER();
	template<class Archive> void load(Archive& ar, const unsigned int version)
	{
		std::string _buffer;
		ar & BOOST_SERIALIZATION_NVP( _buffer );
		ar & BOOST_SERIALIZATION_NVP( size );
		ar & BOOST_SERIALIZATION_NVP( schedules );

		// ǂݍ݌̏
		Realloc( size );
		for( int i=0; i<size; i++ )
		{
			ULONG_PTR l1 = ( ( _buffer[i*3] >= 'a' ) ? ( _buffer[i*3] - 'a' + 0x0a ) : ( _buffer[i*3] - '0' ) ) * 0x10;
			ULONG_PTR l2 = ( _buffer[i*3+1] >= 'a' ) ? ( _buffer[i*3+1] - 'a' + 0x0a ) : ( _buffer[i*3+1] - '0' );
			ULONG_PTR l = l1 + l2;
			buffer[i] = static_cast<char>(l);
		}
	}
	template<class Archive> void save(Archive& ar, const unsigned int version) const
	{
		// ۑ
		char *tempCode = (char *)calloc( (size+1) * 3, 1 );
		for( int i=0; i<size; i++ )
		{
			char temp[32];
			sprintf( temp, "%02x,", (unsigned char)buffer[i] );
			tempCode[i*3] = temp[0];
			tempCode[i*3+1] = temp[1];
			tempCode[i*3+2] = temp[2];
		}

		std::string _buffer = tempCode;
		free( tempCode );

		ar & BOOST_SERIALIZATION_NVP( _buffer );
		ar & BOOST_SERIALIZATION_NVP( size );
		ar & BOOST_SERIALIZATION_NVP( schedules );
	}


	void Realloc( int size )
	{
		this->buffer = (char *)realloc( this->buffer, size + 100 );
		this->size = size;
	}

public:
	DataTable()
		: buffer( (char *)malloc(100) )
		, size( 0 )
	{
		lstrcpy( buffer, "initialized!!!" );
	}
	DataTable( const DataTable &dataTable )
		: buffer( (char *)malloc(100) )
		, size( 0 )
	{
		lstrcpy( buffer, "initialized!!!" );
		AddBinary( dataTable.GetPtr(), dataTable.GetSize() );
	}
	~DataTable()
	{
		free( buffer );
	}
	void Clear()
	{
		size = 0;
	}

	void operator = ( const DataTable &dataTable )
	{
		Clear();
		AddBinary( dataTable.GetPtr(), dataTable.GetSize() );
	}

	int AddBinary( const void *buffer, int size );
	int Add( _int64 i64data );
	int Add( int i32data );
	int Add( double dbl );
	int Add( float flt );
	int AddString( const char *str );
	int AddString( const std::string &str );
	int AddWString( const std::wstring &wstr );
	void Add( const DataTable &dataTable )
	{
		long baseOffset = GetSize();

		AddBinary( dataTable.GetPtr(), dataTable.GetSize() );

		// XPW[ǉ
		BOOST_FOREACH( const Schedule &schedule, dataTable.schedules )
		{
			this->schedules.push_back(
				Schedule(
					schedule.GetType(),
					baseOffset + schedule.GetOffset(),
					schedule.GetLongPtrValue()
				)
			);
		}
	}
	int AddSpace( int size );
	void AddAlignment( int size );

	const void *GetPtr() const
	{
		return buffer;
	}
	int GetSize() const
	{
		return size;
	}

	long GetLong( int pos ) const
	{
		return *(long *)( buffer + pos );
	}
	_int64 GetInt64( int pos ) const
	{
		return *(_int64 *)( buffer + pos );
	}
	void Overwrite( int pos, long newLongValue )
	{
		*(long *)( buffer + pos ) = newLongValue;
	}
	void OverwriteInt64( int pos, _int64 new64Value )
	{
		*(_int64 *)( buffer + pos ) = new64Value;
	}
	void OverwriteBinary( int pos, const void *ptr, int size )
	{
		memcpy( buffer + pos, ptr, size );
	}

	void ResetDataSectionBaseOffset( long dataSectionBaseOffset );

	void Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors );
};
