#include <vector>

class CClass;
struct SUBINFO;

//f[^^
struct TYPEINFO{
	int type;
	union{
		LONG_PTR lpIndex;
		CClass *pobj_Class;
	}u;
};

#define ACCESS_NON			0
#define ACCESS_PRIVATE		1
#define ACCESS_PUBLIC		2
#define ACCESS_PROTECTED	3

class CMember{
	bool isConst;
	bool isRef;
public:
	char *name;
	int SubScripts[MAX_ARRAYDIM];
	TYPEINFO TypeInfo;

	DWORD dwAccess;

	char *InitBuf;
	char *ConstractParameter;

	int source_code_address;


	CMember( CClass *pobj_c, DWORD access, bool idConst, bool isRef, char *buffer, int NowLine=-1 );
	CMember( CMember *pobj );
	CMember();
	~CMember();

	bool IsConst();
	bool IsRef();
	int GetSize();


	static void InitStaticMember(void);
};
class CMethod{
public:
	SUBINFO *psi;
	DWORD dwAccess;
	BOOL bAbstract;
	BOOL bVirtual;
	bool isConst;

	CClass *pobj_InheritsClass;

	CMethod(CMethod *pobj);
	CMethod();
	~CMethod();
};
class CDBClass;
class CDebugSection;
class CClass{
	friend CMember;
	friend CDBClass;
	friend CDebugSection;

	//ÓIo
	std::vector<CMember *>staticMembers;

	//\bh
	std::vector<CMethod *> methods;
	int ConstructorMemberSubIndex;
	int CopyConstructorMemberSubIndex;
	int DestructorMemberSubIndex;

	//ÓI\bh
	std::vector<CMethod *> staticMethods;

	enum ClassType{
		Class,
		Structure,
		Interface,
	};

	ClassType classType;

public:
	//NX
	char *name;

	//pNXւ̃|C^
	CClass *pobj_InheritsClass;

	//o
	CMember **ppobj_Member;
	int iMemberNum;

	//z֐̐
	int vtbl_num;

	//ACgl
	int iAlign;


public:
	CClass(const char *name);
	~CClass();

	bool IsStructure() const;

	//p
	void Inherits( CClass *pInheritsClass );

	//oA\bh̒ǉ
	void AddMember( DWORD dwAccess, bool idConst, bool isRef, char *buffer );
	void AddStaticMember( DWORD dwAccess, bool isConst, bool isRef, char *buffer, int NowLine );
	void AddMethod( SUBINFO *psi,DWORD dwAccess, bool isConst, BOOL bAbstract, BOOL bVirtual );
	void AddStaticMethod(SUBINFO *psi,DWORD dwAccess);

	//d`FbN
	BOOL DupliCheckAll(const char *name);
	BOOL DupliCheckMember(const char *name);

	//\bh擾
	CMethod *GetMethodInfo( SUBINFO *psi );
	CMethod *GetStaticMethodInfo( SUBINFO *psi );

	//\bh݂̑mF
	bool IsExistMethod( const char *name );
	bool IsExistStaticMethod( const char *name );

	//\bh
	void EnumStaticMethod( const char *methodName, std::vector<SUBINFO *> &subs ) const;
	void EnumMethod( const char *methodName, std::vector<SUBINFO *> &subs ) const;
	void EnumMethod( const BYTE idOperatorCalc, std::vector<SUBINFO *> &subs ) const;

	//ftHg RXgN^ \bh擾
	CMethod *GetConstructorMethod() const;

	//ftHg Rs[RXgN^ \bh擾
	CMethod *GetCopyConstructorMethod() const;

	//fXgN^ \bh擾
	CMethod *GetDestructorMethod() const;

	// ȏTCY擾
	int GetSize() const;

	// õItZbg擾
	int GetMemberOffset( const char *memberName, int *pMemberNum ) const;

private:
	// ACgl擾
	int GetAlignment() const;


	//vtbl
private:
	long vtbl_offset;
public:
	int GetFuncNumInVtbl( const SUBINFO *psi ) const;
	LONG_PTR GetVtblGlobalOffset(void);
	void ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection);
	bool IsAbstract();


	//RXgN^RpCĂ邩ǂ̃`FbNtO
private:
	bool isCompilingConstructor;
public:
	void NotifyStartConstructorCompile();
	void NotifyFinishConstructorCompile();
	bool IsCompilingConstructor();

	//fXgN^RpCĂ邩ǂ̃`FbNtO
private:
	bool isCompilingDestructor;
public:
	void NotifyStartDestructorCompile();
	void NotifyFinishDestructorCompile();
	bool IsCompilingDestructor();


	//gƓNXǂmF
	bool IsEquals( CClass *pClass );

	//g̔hNXǂmF
	bool IsSubClass( CClass *pClass );

	//gƓ܂͔hNXǂmF
	bool IsEqualsOrSubClass( CClass *pClass );


	//`Xgp
	CClass *pobj_NextClass;


	//o̎Qƕ@
	enum RefType{
		Dot,			// obj.member
		Pointer,		// obj->member
		Non,			// no reference member
	};
};

#define MAX_CLASS_HASH 65535
class CDBClass{
	int hash(const char *name);
	void DestroyClass(CClass *pobj_c);
public:
	CClass *pobj_ClassHash[MAX_CLASS_HASH];

	CDBClass();
	~CDBClass();

	CClass *check(const char *name);

	CClass *AddClass(const char *name,int NowLine);

	void ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection);

private:
	void AddMethod(CClass *pobj_c, DWORD dwAccess, BOOL bStatic, bool isConst, BOOL bAbstract,
		BOOL bVirtual, BOOL bOverride, char *buffer, int NowLine);
	BOOL MemberVar_LoopRefCheck(CClass *pobj_c);
public:
	void InitNames(void);
	void GetClass_recur(const char *lpszInheritsClass);
	void GetObjectClassInfo(void);


	/////////////////////////////
	// ݃RpC̏
	/////////////////////////////
private:
	CClass *pCompilingClass;
	CMethod *pCompilingMethod;
public:
	//RpCJn̒ʒm󂯎郁\bh
	void StartCompile( SUBINFO *psi );

	//݃RpC̃\bh擾
	CClass *GetNowCompilingClass();
	CMethod *GetNowCompilingMethodInfo();


	/////////////////////
	// Ce[^
	/////////////////////
private:
	CClass **ppobj_IteClass;
	int iIteMaxNum;
	int iIteNextNum;
public:
	void Iterator_Reset(void);
	BOOL Iterator_HasNext(void);
	CClass *Iterator_GetNext(void);
	int Iterator_GetMaxCount(void);
};


extern CDBClass *pobj_DBClass;
extern CClass *pobj_CompilingClass;
