#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"


BOOL IsSafeReg(int reg){
	switch(reg){
		case REG_RBX:
		case REG_RSI:
		case REG_RDI:
		case REG_R12:
		case REG_R13:
		case REG_R14:
		case REG_R15:
			return 1;
		default:
			break;
	}
	return 0;
}



//////////////////////
// rexvtBbNX
//////////////////////
void set_rex(int op_size,int reg,int index_reg,int base_reg){
	char RexByte;

	if(reg==REG_NON&&index_reg==REG_NON){
		/////////////////////////////////////
		// WX^r/m݂̂Ɏw肷Ƃ
		/////////////////////////////////////

		if((base_reg&0x08)==0){
			if(op_size==sizeof(char)&&(base_reg&0x04)){
				// r/m  spl,bpl,sil,dilw肷Ƃ
				RexByte=0x40;
			}
			else RexByte=0;
		}
		else RexByte=(char)0x41;
	}
	else{
		/////////////////
		// ʏ
		/////////////////

		if((reg&0x08)==0){
			//reg c rax`rdi

			if((index_reg&0x08)==0){
				if((base_reg&0x08)==0) RexByte=0;
				else RexByte=(char)0x41;
			}
			else{
				if((base_reg&0x08)==0) RexByte=(char)0x42;
				else RexByte=(char)0x43;
			}
		}
		else{
			//reg c r8`r15

			if((index_reg&0x08)==0){
				if((base_reg&0x08)==0) RexByte=(char)0x44;
				else RexByte=(char)0x45;
			}
			else{
				if((base_reg&0x08)==0) RexByte=(char)0x46;
				else RexByte=(char)0x47;
			}
		}
	}

	if(op_size==sizeof(_int64)){
		//64rbgIyh
		RexByte|=0x48;
	}

	if(RexByte) OpBuffer[obp++]=RexByte;
}



/////////////////////////////////////////////////
// ModR/MoCgASIBoCgAfBXv[Xg
/////////////////////////////////////////////////

//XP[
#define SCALE_NON	(char)0x00
#define SCALE_2		(char)0x40
#define SCALE_4		(char)0x80
#define SCALE_8		(char)0xC0

//CfbNXȂ
#define INDEX_NON	0x04

void set_mod_rm_sib_disp(char mod,int reg,int scale,int index_reg,int base_reg,int disp){
	if(mod==MOD_DISP32){
		//ModR/MoCg
		OpBuffer[obp++]=(char)(      REGISTER_OPERAND(reg)<<3 | REGISTER_OPERAND(0x04));

		base_reg=0x05;
		index_reg=INDEX_NON;
	}
	else{
		//ModR/MoCg
		OpBuffer[obp++]=(char)(mod | REGISTER_OPERAND(reg)<<3 | REGISTER_OPERAND(base_reg));
	}


	//WX^[h̏ꍇ́AŏI
	if(mod==MOD_REG) return;


	if(REGISTER_OPERAND(base_reg)==0x04||mod==MOD_DISP32){
		//////////////////////
		// SIBoCgg
		//////////////////////

		OpBuffer[obp++]=(char)(scale| REGISTER_OPERAND(index_reg)<<3 | REGISTER_OPERAND(base_reg));
	}

	//fBXv[XgKvƂȂꍇ́AŏI
	if(mod==MOD_BASE) return;


	//////////////////////////
	// fBXv[Xg
	//////////////////////////

	if(mod==MOD_BASE_DISP8) OpBuffer[obp++]=(char)disp;
	else{
		*((long *)(OpBuffer+obp))=disp;
		obp+=sizeof(long);
	}
}



void __op_format(int op_size,char op_prefix,char opcode1,char opcode2,int reg,int base_reg,int offset,char mod){
	//߃vtBbNX
	if(op_prefix) OpBuffer[obp++]=op_prefix;

	//rexvtBbNX
	set_rex(op_size,reg,0,base_reg);

	//IyR[h
	OpBuffer[obp++]=opcode1;
	if(opcode2) OpBuffer[obp++]=opcode2;

	//ModR/M, SIB, disp
	set_mod_rm_sib_disp(mod,reg,SCALE_NON,INDEX_NON,base_reg,offset);
}




//////////////////////////
// X^bN֘A
//////////////////////////

void op_push(int reg){
	//X^bNɃWX^̒lvbV

	if(REG_RAX<=reg&&reg<=REG_RDI){
		/*	rax`rdi
			0101 0xxx	*/
		OpBuffer[obp++]=(char)(0x50| REGISTER_OPERAND(reg) );
	}
	if(REG_R8<=reg&&reg<=REG_R15){
		/*	r8`r15
			0100 0001 0101 0xxx	*/
		OpBuffer[obp++]=(char)0x41;
		OpBuffer[obp++]=(char)(0x50| REGISTER_OPERAND(reg) );
	}
}
void op_push_value(long data){
	//X^bNɃelvbV
	if(-128<=data&&data<=127){
		//push 8rbgl
		OpBuffer[obp++]=(char)0x6A;
		OpBuffer[obp++]=(char)data;
	}
	else{
		//push 32rbgl
		OpBuffer[obp++]=(char)0x68;
		*((long *)(OpBuffer+obp))=data;
		obp+=sizeof(long);
	}
}
void op_pop(int reg){
	//X^bN̓eWX^Ƀ|bv
	if(REG_RAX<=reg&&reg<=REG_RDI){
		/*	rax`rdi
			0101 1xxx	*/
		OpBuffer[obp++]=(char)(0x58| REGISTER_OPERAND(reg) );
	}
	if(REG_R8<=reg&&reg<=REG_R15){
		/*	r8`r15
			0100 0001 0101 1xxx	*/
		OpBuffer[obp++]=(char)0x41;
		OpBuffer[obp++]=(char)(0x58| REGISTER_OPERAND(reg) );
	}
}



///////////////////
// mov֘A
///////////////////

void op_mov_RV(int op_size,int reg,int i32data){
	//mov reg,i32data

	//rexvtBbNX
	set_rex(op_size,REG_NON,REG_NON,reg);

	if(op_size==sizeof(_int64)){
		//IyR[h
		OpBuffer[obp++]=(char)0xC7;

		//WX^
		OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg) );
	}
	else{
		//WX^
		OpBuffer[obp++]=(char)(0xB8| REGISTER_OPERAND(reg) );
	}

	//l
	*((long *)(OpBuffer+obp))=i32data;
	obp+=sizeof(long);
}
void op_mov_RV64(int reg,_int64 i64data){
	//mov reg,i64data

	//rexvtBbNX
	set_rex(sizeof(_int64),REG_NON,REG_NON,reg);

	//WX^
	OpBuffer[obp++]=(char)(0xB8| REGISTER_OPERAND(reg) );

	//l
	*((_int64 *)(OpBuffer+obp))=i64data;
	obp+=sizeof(_int64);
}
void op_mov_RM(int op_size,int reg,int base_reg,int offset,char mod){
	//mov reg64,qword ptr[base_reg+offset]
	//mov reg32,dword ptr[base_reg+offset]
	//mov reg16,word ptr[base_reg+offset]
	//mov reg8,byte ptr[base_reg+offset]

	//16rbgZ̖߃vtBbNX
	char op_prefix=0;
	if(op_size==sizeof(short)) op_prefix=(char)0x66;

	//IyR[h
	char opcode;
	if(op_size==sizeof(char)) opcode=(char)0x8A;
	else opcode=(char)0x8B;

	__op_format(op_size,op_prefix,opcode,0,reg,base_reg,offset,mod);
}
void op_mov_RM_ex(int op_size,int reg,int base_reg1,int base_reg2,int offset,BOOL bUseOffset){
	//mov reg64,qword ptr[base_reg1+base_reg2+offset]
	//mov reg32,dword ptr[base_reg1+base_reg2+offset]
	//mov reg16,word ptr[base_reg1+base_reg2+offset]
	//mov reg8,byte ptr[base_reg1+base_reg2+offset]

	if(base_reg1==REG_RSP){
		//SIBoCgindexrsp͎włȂ
		base_reg1=base_reg2;
		base_reg2=REG_RSP;
	}

	//16rbgZ̃vtBbNX
	if(op_size==sizeof(short)) OpBuffer[obp++]=(char)0x66;

	//rexvtBbNX
	set_rex(op_size,reg,base_reg1,base_reg2);

	//IyR[h
	if(op_size==sizeof(char)) OpBuffer[obp++]=(char)0x8A;
	else OpBuffer[obp++]=(char)0x8B;

	if(bUseOffset){
		///////////////////////////
		// ItZbglg
		///////////////////////////

		//WX^
		OpBuffer[obp++]=(char)(0x84| REGISTER_OPERAND(reg)<<3);

		//x[XWX^
		OpBuffer[obp++]=(char)(REGISTER_OPERAND(base_reg1)<<3 | REGISTER_OPERAND(base_reg2));

		//ItZbgl
		*((long *)(OpBuffer+obp))=offset;
		obp+=sizeof(long);
	}
	else{
		///////////////////////////
		// ItZbglgȂ
		///////////////////////////

		//WX^
		OpBuffer[obp++]=(char)(0x04| REGISTER_OPERAND(reg)<<3);

		//x[XWX^
		OpBuffer[obp++]=(char)(REGISTER_OPERAND(base_reg1)<<3 | REGISTER_OPERAND(base_reg2));
	}
}
void op_mov_MR(int op_size,int reg,int base_reg,int offset,char mod){
	//mov qword ptr[base_reg+offset],reg64
	//mov dword ptr[base_reg+offset],reg32
	//mov word ptr[base_reg+offset],reg16
	//mov byte ptr[base_reg+offset],reg8

	//16rbgZ̖߃vtBbNX
	char op_prefix=0;
	if(op_size==sizeof(short)) op_prefix=(char)0x66;

	//IyR[h
	char opcode;
	if(op_size==sizeof(char)) opcode=(char)0x88;
	else opcode=(char)0x89;

	__op_format(op_size,op_prefix,opcode,0,reg,base_reg,offset,mod);
}
void op_mov_MR_ex(int op_size,int reg,int base_reg1,int base_reg2,int offset,BOOL bUseOffset){
	//mov qword ptr[base_reg1+base_reg2+offset],reg64
	//mov dword ptr[base_reg1+base_reg2+offset],reg32
	//mov word ptr[base_reg1+base_reg2+offset],reg16
	//mov byte ptr[base_reg1+base_reg2+offset],reg8

	if(base_reg1==REG_RSP){
		//SIBoCgindexrsp͎włȂ
		base_reg1=base_reg2;
		base_reg2=REG_RSP;
	}

	//16rbgZ̃vtBbNX
	if(op_size==sizeof(short)) OpBuffer[obp++]=(char)0x66;

	//rexvtBbNX
	set_rex(op_size,reg,base_reg1,base_reg2);

	//IyR[h
	if(op_size==sizeof(char)) OpBuffer[obp++]=(char)0x88;
	else OpBuffer[obp++]=(char)0x89;

	if(bUseOffset==USE_OFFSET){
		//////////////////////////
		//ItZbglg
		//////////////////////////

		//WX^
		OpBuffer[obp++]=(char)(0x84| REGISTER_OPERAND(reg)<<3);

		//x[XWX^
		OpBuffer[obp++]=(char)(REGISTER_OPERAND(base_reg1)<<3 | REGISTER_OPERAND(base_reg2));

		//ItZbgl
		*((long *)(OpBuffer+obp))=offset;
		obp+=sizeof(long);
	}
	else{
		//////////////////////////
		//ItZbglgȂ
		//////////////////////////

		//WX^
		OpBuffer[obp++]=(char)(0x04| REGISTER_OPERAND(reg)<<3);

		//x[XWX^
		OpBuffer[obp++]=(char)(REGISTER_OPERAND(base_reg1)<<3 | REGISTER_OPERAND(base_reg2));
	}
}

void op_mov_MV(int op_size,int base_reg,int offset,BOOL bUseOffset,int i32data){
	//mov ptr[base_reg+offset],i32data
	//mov ptr[base_reg       ],i32data

	//16rbgZ̃vtBbNX
	if(op_size==sizeof(short)) OpBuffer[obp++]=(char)0x66;

	//rexvtBbNX
	set_rex(op_size,0,0,base_reg);

	//IyR[h
	if(op_size==sizeof(char)) OpBuffer[obp++]=(char)0xC6;
	else OpBuffer[obp++]=(char)0xC7;

	if(bUseOffset==USE_OFFSET){
		//////////////////////////
		//ItZbglg
		//////////////////////////

		//ModR/M, SIB, disp
		set_mod_rm_sib_disp(MOD_BASE_DISP32,0,SCALE_NON,INDEX_NON,base_reg,offset);
	}
	else{
		//ModR/M, SIB, disp
		set_mod_rm_sib_disp(MOD_BASE,0,SCALE_NON,INDEX_NON,base_reg,0);
	}

	//l
	if(op_size==sizeof(_int64)||op_size==sizeof(long)){
		//32/64rbg
		*((long *)(OpBuffer+obp))=i32data;
		obp+=sizeof(long);
	}
	else if(op_size==sizeof(short)){
		//16rbg
		*((short *)(OpBuffer+obp))=(short)i32data;
		obp+=sizeof(short);
	}
	else if(op_size==sizeof(char)){
		//16rbg
		*((char *)(OpBuffer+obp))=(char)i32data;
		obp++;
	}
}

void op_mov_RR(int reg1,int reg2){
	//mov reg1,reg2
	char RexByte=-1;

	if(reg1==reg2) return;

	if(REG_RAX<=reg1&&reg1<=REG_RDI){
		if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x48;
		if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x49;
	}
	if(REG_R8<=reg1&&reg1<=REG_R15){
		if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x4C;
		if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x4D;
	}

	if(RexByte==-1) SetError(300,NULL,cp);

	// [8bit rex] 1000 1011 11xx xbbb
	OpBuffer[obp++]=RexByte;
	OpBuffer[obp++]=(char)0x8B;
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg1)<<3 | REGISTER_OPERAND(reg2));
}



///////////////////
// mov64֘A
///////////////////

void op_mov64_ToReg(int reg,_int64 i64data){
	//mov reg,i64data

	if(REG_RAX<=reg&&reg<=REG_RDI){
		/*	rax`rdi
			0100 1000 1011 1xxx [64bit data]	*/
		OpBuffer[obp++]=(char)0x48;
		OpBuffer[obp++]=(char)(0xB8| REGISTER_OPERAND(reg) );
		*((_int64 *)(OpBuffer+obp))=i64data;
		obp+=sizeof(_int64);
	}
	if(REG_R8<=reg&&reg<=REG_R15){
		/*	r8`r15
			0100 1001 1011 1xxx [64bit data]	*/
		OpBuffer[obp++]=(char)0x49;
		OpBuffer[obp++]=(char)(0xB8| REGISTER_OPERAND(reg) );
		*((_int64 *)(OpBuffer+obp))=i64data;
		obp+=sizeof(_int64);
	}
}
void op_mov64_ToReg(int reg,int i32data){
	//mov reg,i32data

	if(REG_RAX<=reg&&reg<=REG_RDI){
		/*	rax`rdi
			0100 1000 1100 0111 1100 0xxx [32bit data]	*/
		OpBuffer[obp++]=(char)0x48;
		OpBuffer[obp++]=(char)0xC7;
		OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg) );
		*((long *)(OpBuffer+obp))=i32data;
		obp+=sizeof(long);
	}
	if(REG_R8<=reg&&reg<=REG_R15){
		/*	r8`r15
			0100 1001 1100 0111 1100 0xxx [32bit data]	*/
		OpBuffer[obp++]=(char)0x49;
		OpBuffer[obp++]=(char)0xC7;
		OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg) );
		*((long *)(OpBuffer+obp))=i32data;
		obp+=sizeof(long);
	}
}
void op_movsxd(int reg64,int reg32){
	//movsxd reg64,reg32
	char RexByte=-1;

	if(REG_RAX<=reg64&&reg64<=REG_RDI){
		if(REG_RAX<=reg32&&reg32<=REG_RDI) RexByte=(char)0x48;
		if(REG_R8<=reg32&&reg32<=REG_R15) RexByte=(char)0x49;
	}
	if(REG_R8<=reg64&&reg64<=REG_R15){
		if(REG_RAX<=reg32&&reg32<=REG_RDI) RexByte=(char)0x4C;
		if(REG_R8<=reg32&&reg32<=REG_R15) RexByte=(char)0x4D;
	}

	if(RexByte==-1) SetError(300,NULL,cp);

	//[8bit rex] 0110 0011 11rr rbbb
	OpBuffer[obp++]=RexByte;
	OpBuffer[obp++]=(char)0x63;
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg64)<<3 | REGISTER_OPERAND(reg32));
}
void op_movsx64_FromReg16(int reg64,int reg16){
	//movsx reg64,reg16
	char RexByte=-1;

	if(REG_RAX<=reg64&&reg64<=REG_RDI){
		if(REG_RAX<=reg16&&reg16<=REG_RDI) RexByte=(char)0x48;
		if(REG_R8<=reg16&&reg16<=REG_R15) RexByte=(char)0x49;
	}
	if(REG_R8<=reg64&&reg64<=REG_R15){
		if(REG_RAX<=reg16&&reg16<=REG_RDI) RexByte=(char)0x4C;
		if(REG_R8<=reg16&&reg16<=REG_R15) RexByte=(char)0x4D;
	}

	if(RexByte==-1) SetError(300,NULL,cp);

	//[8bit rex] 0000 1111 1011 1111 11rr rbbb
	OpBuffer[obp++]=RexByte;
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0xBF;
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg64)<<3 | REGISTER_OPERAND(reg16));
}
void op_movsx64_FromReg8(int reg64,int reg8){
	//movsx reg64,reg8
	char RexByte=-1;

	if(REG_RAX<=reg64&&reg64<=REG_RDI){
		if(REG_RAX<=reg8&&reg8<=REG_RDI) RexByte=(char)0x48;
		if(REG_R8<=reg8&&reg8<=REG_R15) RexByte=(char)0x49;
	}
	if(REG_R8<=reg64&&reg64<=REG_R15){
		if(REG_RAX<=reg8&&reg8<=REG_RDI) RexByte=(char)0x4C;
		if(REG_R8<=reg8&&reg8<=REG_R15) RexByte=(char)0x4D;
	}

	if(RexByte==-1) SetError(300,NULL,cp);

	//[8bit rex] 0000 1111 1011 1110 11rr rbbb
	OpBuffer[obp++]=RexByte;
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0xBE;
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg64)<<3 | REGISTER_OPERAND(reg8));
}



//////////////////
// mov32֘A
//////////////////

void op_movsx32_FromReg16(int reg32,int reg16){
	//movsx reg32,reg16
	char RexByte=-1;

	if(REG_RAX<=reg32&&reg32<=REG_RDI){
		if(REG_RAX<=reg16&&reg16<=REG_RDI) RexByte=0;
		if(REG_R8<=reg16&&reg16<=REG_R15) RexByte=(char)0x41;
	}
	if(REG_R8<=reg32&&reg32<=REG_R15){
		if(REG_RAX<=reg16&&reg16<=REG_RDI) RexByte=(char)0x44;
		if(REG_R8<=reg16&&reg16<=REG_R15) RexByte=(char)0x45;
	}

	if(RexByte==-1) SetError(300,NULL,cp);

	//[8bit rex] 0000 1111 1011 1111 11rr rbbb
	if(RexByte) OpBuffer[obp++]=RexByte;
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0xBF;
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg32)<<3 | REGISTER_OPERAND(reg16));
}
void op_movsx32_FromReg8(int reg32,int reg8){
	//movsx reg32,reg8
	char RexByte=-1;

	if(REG_RAX<=reg32&&reg32<=REG_RDI){
		if(REG_RAX<=reg8&&reg8<=REG_RBX) RexByte=0;
		if(REG_RSP<=reg8&&reg8<=REG_RDI) RexByte=(char)0x40;
		if(REG_R8<=reg8&&reg8<=REG_R15) RexByte=(char)0x41;
	}
	if(REG_R8<=reg32&&reg32<=REG_R15){
		if(REG_RAX<=reg8&&reg8<=REG_RDI) RexByte=(char)0x44;
		if(REG_R8<=reg8&&reg8<=REG_R15) RexByte=(char)0x45;
	}

	if(RexByte==-1) SetError(300,NULL,cp);

	//[8bit rex] 0000 1111 1011 1110 11rr rbbb
	if(RexByte) OpBuffer[obp++]=RexByte;
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0xBE;
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg32)<<3 | REGISTER_OPERAND(reg8));
}



/////////////////////
// mov16֘A
/////////////////////

void op_movsx16_FromReg8(int reg32,int reg8){
	//movsx reg16,reg8
	char RexByte=-1;

	if(REG_RAX<=reg32&&reg32<=REG_RDI){
		if(REG_RAX<=reg8&&reg8<=REG_RBX) RexByte=0;
		if(REG_RSP<=reg8&&reg8<=REG_RDI) RexByte=(char)0x40;
		if(REG_R8<=reg8&&reg8<=REG_R15) RexByte=(char)0x41;
	}
	if(REG_R8<=reg32&&reg32<=REG_R15){
		if(REG_RAX<=reg8&&reg8<=REG_RDI) RexByte=(char)0x44;
		if(REG_R8<=reg8&&reg8<=REG_R15) RexByte=(char)0x45;
	}

	if(RexByte==-1) SetError(300,NULL,cp);

	//0110 0110 [8bit rex] 0000 1111 1011 1110 11rr rbbb
	OpBuffer[obp++]=(char)0x66;
	if(RexByte) OpBuffer[obp++]=RexByte;
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0xBE;
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg32)<<3 | REGISTER_OPERAND(reg8));
}



//////////////////////////////////
// CNgEfNg
//////////////////////////////////

void op_inc(int reg){
	//inc reg

	//16rbgZ̖߃vtBbNX
	char op_prefix=0;

	//IyR[h
	char opcode=(char)0xFF;

	__op_format(sizeof(_int64),op_prefix,opcode,0,0,reg,0,MOD_REG);
}
void op_dec(int reg){
	op_inc(reg);
	OpBuffer[obp-1]=OpBuffer[obp-1]|0x08;
}



/////////////////////
// add֘A
/////////////////////

void op_add_RM(int op_size,int reg,int base_reg,int offset,char mod){
	//add reg64,qword ptr[base_reg+offset]
	//add reg32,dword ptr[base_reg+offset]
	//add reg16,word ptr[base_reg+offset]
	//add reg8,byte ptr[base_reg+offset]

	//16rbgZ̖߃vtBbNX
	char op_prefix=0;
	if(op_size==sizeof(short)) op_prefix=(char)0x66;

	//IyR[h
	char opcode;
	if(op_size==sizeof(char)) opcode=(char)0x02;
	else opcode=(char)0x03;

	__op_format(op_size,op_prefix,opcode,0,reg,base_reg,offset,mod);
}

void op_add_RV(int reg,int offset){
	//add reg,offset
	char RexByte=-1;

	if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=0x48;
	if(REG_R8<=reg&&reg<=REG_R15) RexByte=0x49;

	if(RexByte==-1) SetError(300,NULL,cp);

	if(reg==REG_RAX){
		//rax̂ݓ

		// [8bit rex] 0000 0101 [32bit offset]
		OpBuffer[obp++]=(char)RexByte;
		OpBuffer[obp++]=(char)0x05;
		*((long *)(OpBuffer+obp))=offset;
		obp+=sizeof(long);
	}
	else{
		//raxȊO

		//[8bit rex] 1000 0001 1100 0xxx [32bit offset]
		OpBuffer[obp++]=(char)RexByte;
		OpBuffer[obp++]=(char)0x81;
		OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg));
		*((long *)(OpBuffer+obp))=offset;
		obp+=sizeof(long);
	}
}
void op_add64_reg(int reg1,int reg2){
	//add reg1,reg2
	char RexByte=-1;

	if(REG_RAX<=reg1&&reg1<=REG_RDI){
		if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x48;
		if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x49;
	}
	if(REG_R8<=reg1&&reg1<=REG_R15){
		if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x4C;
		if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x4D;
	}

	if(RexByte==-1) SetError(300,NULL,cp);

	//[8bit rex] 0000 0011 11rr rbbb
	OpBuffer[obp++]=(char)RexByte;
	OpBuffer[obp++]=(char)0x03;
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg1)<<3 | REGISTER_OPERAND(reg2));
}
void op_add32_reg(int reg1,int reg2){
	//add reg1,reg2
	char RexByte=-1;

	if(REG_RAX<=reg1&&reg1<=REG_RDI){
		if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=0;
		if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x41;
	}
	if(REG_R8<=reg1&&reg1<=REG_R15){
		if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x44;
		if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x45;
	}

	if(RexByte==-1) SetError(300,NULL,cp);

	//[8bit rex] 0000 0011 11rr rbbb
	if(RexByte) OpBuffer[obp++]=(char)RexByte;
	OpBuffer[obp++]=(char)0x03;
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg1)<<3 | REGISTER_OPERAND(reg2));
}



////////////////////////
// sub֘A
////////////////////////

void op_sub_RV(int op_size,int reg,int i32data){
	//sub reg,i32data

	//rexvtBbNX
	set_rex(op_size,REG_NON,REG_NON,reg);

	if(reg==REG_RAX){
		//rax̂ݓ
		OpBuffer[obp++]=(char)0x2D;
	}
	else{
		//IyR[h
		OpBuffer[obp++]=(char)0x81;

		//WX^
		OpBuffer[obp++]=(char)(0xE8| REGISTER_OPERAND(reg) );
	}

	//l
	*((long *)(OpBuffer+obp))=i32data;
	obp+=sizeof(long);
}
void op_sub64_reg(int reg1,int reg2){
	//sub reg1,reg2
	char RexByte=-1;

	if(REG_RAX<=reg1&&reg1<=REG_RDI){
		if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x48;
		if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x49;
	}
	if(REG_R8<=reg1&&reg1<=REG_R15){
		if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x4C;
		if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x4D;
	}

	if(RexByte==-1) SetError(300,NULL,cp);

	//[8bit rex] 0010 1011 11rr rbbb
	OpBuffer[obp++]=(char)RexByte;
	OpBuffer[obp++]=(char)0x2B;
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg1)<<3 | REGISTER_OPERAND(reg2));
}
void op_sub32_reg(int reg1,int reg2){
	//sub reg1,reg2
	char RexByte=-1;

	if(REG_RAX<=reg1&&reg1<=REG_RDI){
		if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=0;
		if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x41;
	}
	if(REG_R8<=reg1&&reg1<=REG_R15){
		if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x44;
		if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x45;
	}

	if(RexByte==-1) SetError(300,NULL,cp);

	//[8bit rex] 0010 1011 11rr rbbb
	if(RexByte) OpBuffer[obp++]=(char)RexByte;
	OpBuffer[obp++]=(char)0x2B;
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg1)<<3 | REGISTER_OPERAND(reg2));
}
void op_sbb_RR( int op_size, int reg1, int reg2 ){
	//sbb reg1,reg2

	//rexvtBbNX
	set_rex(0,reg1,0,reg2);

	//IyR[h
	OpBuffer[obp++]=(char)0x1B;

	//WX^
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg1)<<3 | REGISTER_OPERAND(reg2));
}



////////////////////////
// imul֘A
////////////////////////

void op_imul_RR(int op_size,int reg1,int reg2){
	//imul reg1,reg2
	char RexByte=-1;

	if(op_size==sizeof(_int64)){
		if(REG_RAX<=reg1&&reg1<=REG_RDI){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x48;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x49;
		}
		if(REG_R8<=reg1&&reg1<=REG_R15){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x4C;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x4D;
		}
	}
	else{
		if(REG_RAX<=reg1&&reg1<=REG_RDI){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=0;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x41;
		}
		if(REG_R8<=reg1&&reg1<=REG_R15){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x44;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x45;
		}
	}

	if(RexByte==-1) SetError(300,NULL,cp);


	//rexvtBbNX
	if(RexByte) OpBuffer[obp++]=(char)RexByte;

	//IyR[h
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0xAF;

	//WX^
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg1)<<3 | REGISTER_OPERAND(reg2));
}
void op_imul_RV(int op_size,int reg,int i32data){
	//imul reg,i32data
	char RexByte=-1;

	if(op_size==sizeof(_int64)){
		if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=(char)0x48;
		if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x4D;
	}
	else{
		if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=0;
		if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x45;
	}

	if(RexByte==-1) SetError(300,NULL,cp);


	//rexvtBbNX
	if(RexByte) OpBuffer[obp++]=(char)RexByte;

	if(-128<=i32data&&i32data<=127){
		//IyR[h
		OpBuffer[obp++]=(char)0x6B;

		//WX^
		OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg)<<3 | REGISTER_OPERAND(reg));

		//l
		OpBuffer[obp++]=(char)i32data;
	}
	else{
		//IyR[h
		OpBuffer[obp++]=(char)0x69;

		//WX^
		OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg)<<3 | REGISTER_OPERAND(reg));

		//l
		*((long *)(OpBuffer+obp))=i32data;
		obp+=sizeof(long);
	}
}



////////////////////////
// divAidiv֘A
////////////////////////

void op_div64_reg(int reg){
	//div reg
	char RexByte=-1;

	if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=(char)0x48;
	if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x49;

	if(RexByte==-1) SetError(300,NULL,cp);

	//rexvtBbNX
	OpBuffer[obp++]=(char)RexByte;

	//IyR[h
	OpBuffer[obp++]=(char)0xF7;

	//WX^
	OpBuffer[obp++]=(char)(0xF0| REGISTER_OPERAND(reg));
}
void op_idiv64_reg(int reg){
	//idiv reg
	char RexByte=-1;

	if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=(char)0x48;
	if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x49;

	if(RexByte==-1) SetError(300,NULL,cp);

	//rexvtBbNX
	OpBuffer[obp++]=(char)RexByte;

	//IyR[h
	OpBuffer[obp++]=(char)0xF7;

	//WX^
	OpBuffer[obp++]=(char)(0xF8| REGISTER_OPERAND(reg));
}



////////////////////
// rbgVtg֘A
////////////////////

void op_shl_reg(int op_size,int reg){
	//shl reg,cl
	char RexByte=-1;

	if(op_size==sizeof(_int64)){
		if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=(char)0x48;
		if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x49;
	}
	else if(op_size==sizeof(char)){
		if(REG_RAX<=reg&&reg<=REG_RBX) RexByte=0;
		if(REG_RSP<=reg&&reg<=REG_RDI) RexByte=(char)0x40;
		if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x41;
	}
	else{
		if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=0;
		if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x41;
	}

	if(RexByte==-1) SetError(300,NULL,cp);


	//16rbgZ̃vtBbNX
	if(op_size==sizeof(short)) OpBuffer[obp++]=(char)0x66;

	//rexvtBbNX
	if(RexByte) OpBuffer[obp++]=(char)RexByte;

	//IyR[h
	if(op_size==sizeof(char)) OpBuffer[obp++]=(char)0xD2;
	else OpBuffer[obp++]=(char)0xD3;

	//WX^
	OpBuffer[obp++]=(char)(0xE0| REGISTER_OPERAND(reg));
}
void op_sar_reg(int op_size,int reg){
	//sar reg,cl
	char RexByte=-1;

	if(op_size==sizeof(_int64)){
		if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=(char)0x48;
		if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x49;
	}
	else if(op_size==sizeof(char)){
		if(REG_RAX<=reg&&reg<=REG_RBX) RexByte=0;
		if(REG_RSP<=reg&&reg<=REG_RDI) RexByte=(char)0x40;
		if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x41;
	}
	else{
		if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=0;
		if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x41;
	}

	if(RexByte==-1) SetError(300,NULL,cp);


	//16rbgZ̃vtBbNX
	if(op_size==sizeof(short)) OpBuffer[obp++]=(char)0x66;

	//rexvtBbNX
	if(RexByte) OpBuffer[obp++]=(char)RexByte;

	//IyR[h
	if(op_size==sizeof(char)) OpBuffer[obp++]=(char)0xD2;
	else OpBuffer[obp++]=(char)0xD3;

	//WX^
	OpBuffer[obp++]=(char)(0xF8| REGISTER_OPERAND(reg));
}
void op_shr_reg(int op_size,int reg){
	//shr reg,cl
	char RexByte=-1;

	if(op_size==sizeof(_int64)){
		if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=(char)0x48;
		if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x49;
	}
	else if(op_size==sizeof(char)){
		if(REG_RAX<=reg&&reg<=REG_RBX) RexByte=0;
		if(REG_RSP<=reg&&reg<=REG_RDI) RexByte=(char)0x40;
		if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x41;
	}
	else{
		if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=0;
		if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x41;
	}

	if(RexByte==-1) SetError(300,NULL,cp);


	//16rbgZ̃vtBbNX
	if(op_size==sizeof(short)) OpBuffer[obp++]=(char)0x66;

	//rexvtBbNX
	if(RexByte) OpBuffer[obp++]=(char)RexByte;

	//IyR[h
	if(op_size==sizeof(char)) OpBuffer[obp++]=(char)0xD2;
	else OpBuffer[obp++]=(char)0xD3;

	//WX^
	OpBuffer[obp++]=(char)(0xE8| REGISTER_OPERAND(reg));
}



////////////////////
// and ֘A
////////////////////

void op_and_reg(int op_size,int reg1,int reg2){
	//and reg1,reg2
	char RexByte=-1;

	if(op_size==sizeof(_int64)){
		if(REG_RAX<=reg1&&reg1<=REG_RDI){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x48;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x49;
		}
		if(REG_R8<=reg1&&reg1<=REG_R15){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x4C;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x4D;
		}
	}
	else{
		if(REG_RAX<=reg1&&reg1<=REG_RDI){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=0;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x41;
		}
		if(REG_R8<=reg1&&reg1<=REG_R15){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x44;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x45;
		}
	}

	if(RexByte==-1) SetError(300,NULL,cp);


	//rexvtBbNX
	if(RexByte) OpBuffer[obp++]=(char)RexByte;

	//IyR[h
	OpBuffer[obp++]=(char)0x23;

	//WX^
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg1)<<3 | REGISTER_OPERAND(reg2));
}
void op_and64_value(int reg,int offset){
	//and reg,offset
	char RexByte=-1;

	if(REG_RAX<=reg&&reg<=REG_RDI) (char)RexByte=0x48;
	if(REG_R8<=reg&&reg<=REG_R15) (char)RexByte=0x49;

	if(RexByte==-1) SetError(300,NULL,cp);

	if(reg==REG_RAX){
		//rax̂ݓ

		// [8bit rex] 0010 0101 [32bit offset]
		OpBuffer[obp++]=(char)RexByte;
		OpBuffer[obp++]=(char)0x25;
		*((long *)(OpBuffer+obp))=offset;
		obp+=sizeof(long);
	}
	else{
		//raxȊO

		//[8bit rex] 1000 0001 1100 0xxx [32bit offset]
		OpBuffer[obp++]=(char)RexByte;
		OpBuffer[obp++]=(char)0x81;
		OpBuffer[obp++]=(char)(0xE0| REGISTER_OPERAND(reg));
		*((long *)(OpBuffer+obp))=offset;
		obp+=sizeof(long);
	}
}
void op_and32_value(int reg,int offset){
	//and reg,offset
	char RexByte=-1;

	if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=0;
	if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x41;

	if(RexByte==-1) SetError(300,NULL,cp);

	if(reg==REG_RAX){
		//eax̂ݓ

		// [8bit rex] 0010 0101 [32bit offset]
		OpBuffer[obp++]=(char)0x25;
		*((long *)(OpBuffer+obp))=offset;
		obp+=sizeof(long);
	}
	else{
		//eaxȊO

		//[8bit rex] 1000 0001 1100 0xxx [32bit offset]
		if(RexByte) OpBuffer[obp++]=(char)RexByte;
		OpBuffer[obp++]=(char)0x81;
		OpBuffer[obp++]=(char)(0xE0| REGISTER_OPERAND(reg));
		*((long *)(OpBuffer+obp))=offset;
		obp+=sizeof(long);
	}
}



////////////////////////
// or ֘A
////////////////////////

void op_or_reg(int op_size,int reg1,int reg2){
	//or reg1,reg2
	char RexByte=-1;

	if(op_size==sizeof(_int64)){
		if(REG_RAX<=reg1&&reg1<=REG_RDI){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x48;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x49;
		}
		if(REG_R8<=reg1&&reg1<=REG_R15){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x4C;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x4D;
		}
	}
	else{
		if(REG_RAX<=reg1&&reg1<=REG_RDI){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=0;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x41;
		}
		if(REG_R8<=reg1&&reg1<=REG_R15){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x44;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x45;
		}
	}

	if(RexByte==-1) SetError(300,NULL,cp);


	//rexvtBbNX
	if(RexByte) OpBuffer[obp++]=(char)RexByte;

	//IyR[h
	OpBuffer[obp++]=(char)0x0B;

	//WX^
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg1)<<3 | REGISTER_OPERAND(reg2));
}



////////////////////////
// xor ֘A
////////////////////////

void op_xor_reg(int op_size,int reg1,int reg2){
	//xor reg1,reg2
	char RexByte=-1;

	if(op_size==sizeof(_int64)){
		if(REG_RAX<=reg1&&reg1<=REG_RDI){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x48;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x49;
		}
		if(REG_R8<=reg1&&reg1<=REG_R15){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x4C;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x4D;
		}
	}
	else{
		if(REG_RAX<=reg1&&reg1<=REG_RDI){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=0;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x41;
		}
		if(REG_R8<=reg1&&reg1<=REG_R15){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x44;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x45;
		}
	}

	if(RexByte==-1) SetError(300,NULL,cp);


	//rexvtBbNX
	if(RexByte) OpBuffer[obp++]=(char)RexByte;

	//IyR[h
	OpBuffer[obp++]=(char)0x33;

	//WX^
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg1)<<3 | REGISTER_OPERAND(reg2));
}



///////////////////////
// not ֘A
///////////////////////

void op_not_reg(int op_size,int reg){
	//not reg
	char RexByte=-1;

	if(op_size==sizeof(_int64)){
		if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=(char)0x48;
		if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x49;
	}
	else{
		if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=0;
		if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x41;
	}

	if(RexByte==-1) SetError(300,NULL,cp);


	//rexvtBbNX
	if(RexByte) OpBuffer[obp++]=(char)RexByte;

	//IyR[h
	OpBuffer[obp++]=(char)0xF7;

	//WX^
	OpBuffer[obp++]=(char)(0xD0| REGISTER_OPERAND(reg));
}
void op_neg( int reg ){
	//neg reg

	//IyR[h
	OpBuffer[obp++]=(char)0xF7;

	//WX^
	OpBuffer[obp++]=(char)(0xD8| REGISTER_OPERAND(reg));
}



////////////////////
// test֘A
////////////////////

void op_test(int reg1,int reg2){
	//test reg1,reg2
	char RexByte=-1;

	if(REG_RAX<=reg1&&reg1<=REG_RDI){
		if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x48;
		if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x49;
	}
	if(REG_R8<=reg1&&reg1<=REG_R15){
		if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x4C;
		if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x4D;
	}

	if(RexByte==-1) SetError(300,NULL,cp);

	//[8bit rex] 1000 0101 11rr rbbb
	OpBuffer[obp++]=(char)RexByte;
	OpBuffer[obp++]=(char)0x85;
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg1)<<3 | REGISTER_OPERAND(reg2));
}



/////////////////////
// cmp ֘A
/////////////////////

void op_cmp_reg(int op_size,int reg1,int reg2){
	//cmp reg1,reg2
	char RexByte=-1;

	if(op_size==sizeof(_int64)){
		if(REG_RAX<=reg1&&reg1<=REG_RDI){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x48;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x49;
		}
		if(REG_R8<=reg1&&reg1<=REG_R15){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x4C;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x4D;
		}
	}
	else{
		if(REG_RAX<=reg1&&reg1<=REG_RDI){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=0;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x41;
		}
		if(REG_R8<=reg1&&reg1<=REG_R15){
			if(REG_RAX<=reg2&&reg2<=REG_RDI) RexByte=(char)0x44;
			if(REG_R8<=reg2&&reg2<=REG_R15) RexByte=(char)0x45;
		}
	}

	if(RexByte==-1) SetError(300,NULL,cp);


	//rexvtBbNX
	if(RexByte) OpBuffer[obp++]=(char)RexByte;

	//IyR[h
	OpBuffer[obp++]=(char)0x3B;

	//WX^
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg1)<<3 | REGISTER_OPERAND(reg2));
}
void op_cmp_value(int op_size,int reg,char byte_data){
	//cmp reg,byte_data

	if(op_size==sizeof(char)&&reg==REG_RAX){
		//alWX^̏ꍇ͓
		OpBuffer[obp++]=(char)0x3C;

		//8rbgl
		OpBuffer[obp++]=byte_data;

		return;
	}

	//16rbgZ̃vtBbNX
	if(op_size==sizeof(short)) OpBuffer[obp++]=(char)0x66;

	//rexvtBbNX
	set_rex(op_size,REG_NON,REG_NON,reg);

	//IyR[h
	if(op_size==sizeof(char)) OpBuffer[obp++]=(char)0x80;
	else OpBuffer[obp++]=(char)0x83;

	//WX^
	OpBuffer[obp++]=(char)(0xF8| REGISTER_OPERAND(reg));

	//8rbgl
	OpBuffer[obp++]=byte_data;
}
void op_setne( int reg ){
	//IyR[h
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0x95;

	//WX^
	OpBuffer[obp++]=(char)( 0xC0 | REGISTER_OPERAND(reg) );
}


////////////////////
// SSE2֘A
////////////////////

void op_movlpd_MR(int xmm_reg,int base_reg,int offset,char mod){
	//movlpd qword ptr[base_reg+offset],xmm_reg
	__op_format(0,(char)0x66,(char)0x0F,(char)0x13,xmm_reg,base_reg,offset,mod);
}
void op_movlpd_RM(int xmm_reg,int base_reg,int offset,char mod){
	//movlpd xmm_reg,qword ptr[base_reg+offset]
	__op_format(0,(char)0x66,(char)0x0F,(char)0x12,xmm_reg,base_reg,offset,mod);
}
void op_movsd_RR(int xmm_reg1,int xmm_reg2){
	if(xmm_reg1==xmm_reg2) return;

	//movsd xmm_reg1,xmm_reg2
	__op_format(0,(char)0xF2,(char)0x0F,(char)0x10,xmm_reg1,xmm_reg2,0,MOD_REG);
}
void op_movsd_MR(int xmm_reg,int base_reg,int offset,char mod){
	//movsd qword ptr[reg+offset],xmm_reg
	//movsd qword ptr[reg],xmm_reg
	__op_format(0,(char)0xF2,(char)0x0F,(char)0x11,xmm_reg,base_reg,offset,mod);
}
void op_movss_RR(int xmm_reg1,int xmm_reg2){
	if(xmm_reg1==xmm_reg2) return;

	//movss xmm_reg1,xmm_reg2
	__op_format(0,(char)0xF3,(char)0x0F,(char)0x10,xmm_reg1,xmm_reg2,0,MOD_REG);
}
void op_movss_RM(int xmm_reg,int base_reg,int offset,char mod){
	//movss xmm_reg,dword ptr[base_reg+offset]
	__op_format(0,(char)0xF3,(char)0x0F,(char)0x10,xmm_reg,base_reg,offset,mod);
}
void op_movss_MR(int xmm_reg,int base_reg,int offset,char mod){
	//movss dword ptr[reg+offset],xmm_reg
	//movss dword ptr[reg],xmm_reg
	__op_format(0,(char)0xF3,(char)0x0F,(char)0x11,xmm_reg,base_reg,offset,mod);
}

void op_movd_RX(int reg,int xmm_reg){
	__op_format(sizeof(_int64),(char)0x66,(char)0x0F,(char)0x7E,xmm_reg,reg,0,MOD_REG);
}

void op_cvtsd2ss(int xmm_reg1,int xmm_reg2){
	//cvtsd2ss xmm_reg1,xmm_reg2

	//IyR[h
	OpBuffer[obp++]=(char)0xF2;

	//rexvtBbNX
	set_rex(sizeof(long),xmm_reg1,0,xmm_reg2);

	//IyR[h
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0x5A;

	//WX^
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(xmm_reg1)<<3 | REGISTER_OPERAND(xmm_reg2));
}
void op_cvtss2sd(int xmm_reg1,int xmm_reg2){
	//cvtss2sd xmm_reg1,xmm_reg2

	//IyR[h
	OpBuffer[obp++]=(char)0xF3;

	//rexvtBbNX
	set_rex(0,xmm_reg1,0,xmm_reg2);

	//IyR[h
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0x5A;

	//WX^
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(xmm_reg1)<<3 | REGISTER_OPERAND(xmm_reg2));
}
void op_cvttsd2si_xmm(int op_size,int reg,int xmm_reg){
	//cvttsd2si reg,xmm_reg

	//IyR[h
	OpBuffer[obp++]=(char)0xF2;

	//rexvtBbNX
	set_rex(op_size,reg,0,xmm_reg);

	//IyR[h
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0x2C;

	//WX^
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg)<<3 | REGISTER_OPERAND(xmm_reg));
}
void op_cvttss2si_xmm(int op_size,int reg,int xmm_reg){
	//cvttss2si reg,xmm_reg

	//IyR[h
	OpBuffer[obp++]=(char)0xF3;

	//rexvtBbNX
	set_rex(op_size,reg,0,xmm_reg);

	//IyR[h
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0x2C;

	//WX^
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg)<<3 | REGISTER_OPERAND(xmm_reg));
}
void op_cvtsi2sd_reg(int op_size,int xmm_reg,int reg){
	//cvtsi2sd xmm_reg,reg
	char RexByte=-1;

	if(op_size==sizeof(_int64)){
		if(REG_XMM0<=xmm_reg&&xmm_reg<=REG_XMM7){
			if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=(char)0x48;
			if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x49;
		}
		if(REG_XMM8<=xmm_reg&&xmm_reg<=REG_XMM15){
			if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=(char)0x4C;
			if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x4D;
		}
	}
	else{
		if(REG_XMM0<=xmm_reg&&xmm_reg<=REG_XMM7){
			if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=0;
			if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x41;
		}
		if(REG_XMM8<=xmm_reg&&xmm_reg<=REG_XMM15){
			if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=(char)0x44;
			if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x45;
		}
	}

	if(RexByte==-1) SetError(300,NULL,cp);


	//IyR[h
	OpBuffer[obp++]=(char)0xF2;

	//rexvtBbNX
	if(RexByte) OpBuffer[obp++]=(char)RexByte;

	//IyR[h
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0x2A;

	//WX^
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(xmm_reg)<<3 | REGISTER_OPERAND(reg));
}
void op_cvtsi2ss_reg(int op_size,int xmm_reg,int reg){
	//cvtsi2ss xmm_reg,reg
	char RexByte=-1;

	if(op_size==sizeof(_int64)){
		if(REG_XMM0<=xmm_reg&&xmm_reg<=REG_XMM7){
			if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=(char)0x48;
			if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x49;
		}
		if(REG_XMM8<=xmm_reg&&xmm_reg<=REG_XMM15){
			if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=(char)0x4C;
			if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x4D;
		}
	}
	else{
		if(REG_XMM0<=xmm_reg&&xmm_reg<=REG_XMM7){
			if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=0;
			if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x41;
		}
		if(REG_XMM8<=xmm_reg&&xmm_reg<=REG_XMM15){
			if(REG_RAX<=reg&&reg<=REG_RDI) RexByte=(char)0x44;
			if(REG_R8<=reg&&reg<=REG_R15) RexByte=(char)0x45;
		}
	}

	if(RexByte==-1) SetError(300,NULL,cp);


	//IyR[h
	OpBuffer[obp++]=(char)0xF3;

	//rexvtBbNX
	if(RexByte) OpBuffer[obp++]=(char)RexByte;

	//IyR[h
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0x2A;

	//WX^
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(xmm_reg)<<3 | REGISTER_OPERAND(reg));
}
void op_comisd(int xmm_reg1,int xmm_reg2){
	//comisd xmm_reg1,xmm_reg2

	//IyR[h
	OpBuffer[obp++]=(char)0x66;
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0x2F;

	//WX^
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(xmm_reg1)<<3 | REGISTER_OPERAND(xmm_reg2));
}
void op_comiss(int xmm_reg1,int xmm_reg2){
	//comiss xmm_reg1,xmm_reg2

	//IyR[h
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0x2F;

	//WX^
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(xmm_reg1)<<3 | REGISTER_OPERAND(xmm_reg2));
}



/////////////////////
// XgO֌W
/////////////////////

void op_rep_movs(int op_size){
	if(op_size==sizeof(BYTE)){
		//rep movs byte ptr[edi],byte ptr[esi]
		OpBuffer[obp++]=(char)0xF3;
		OpBuffer[obp++]=(char)0xA4;
	}
	else if(op_size==sizeof(short)){
		//rep movs word ptr[edi],word ptr[esi]
		OpBuffer[obp++]=(char)0xF3;
		OpBuffer[obp++]=(char)0x66;
		OpBuffer[obp++]=(char)0xA5;
	}
	else if(op_size==sizeof(long)){
		//rep movs dword ptr[edi],dword ptr[esi]
		OpBuffer[obp++]=(char)0xF3;
		OpBuffer[obp++]=(char)0xA5;
	}
}




void op_add_rsp(int num){
	//X^bN|C^̉Zipopj

	//add rsp,num
	if(0xFFFFFF80&num){
		OpBuffer[obp++]=(char)0x48;
		OpBuffer[obp++]=(char)0x81;
		OpBuffer[obp++]=(char)0xC4;
		*((long *)(OpBuffer+obp))=num;
		obp+=sizeof(long);
	}
	else{
		//u-128 < num < 127v̏ꍇ
		OpBuffer[obp++]=(char)0x48;
		OpBuffer[obp++]=(char)0x83;
		OpBuffer[obp++]=(char)0xC4;
		OpBuffer[obp++]=(char)num;
	}
}
void op_sub_rsp(int num){
	//X^bN|C^̌Zipushj

	//sub rsp,num
	if(0xFFFFFF80&num){
		OpBuffer[obp++]=(char)0x48;
		OpBuffer[obp++]=(char)0x81;
		OpBuffer[obp++]=(char)0xEC;
		*((long *)(OpBuffer+obp))=num;
		obp+=sizeof(long);
	}
	else{
		//u-128 < num < 127v̏ꍇ
		OpBuffer[obp++]=(char)0x48;
		OpBuffer[obp++]=(char)0x83;
		OpBuffer[obp++]=(char)0xEC;
		OpBuffer[obp++]=(char)num;
	}
}


void op_add_esp(int num){
	//X^bN|C^̉Zipopj

	//add esp,num
	if(0xFFFFFF80&num){
		OpBuffer[obp++]=(char)0x81;
		OpBuffer[obp++]=(char)0xC4;
		*((long *)(OpBuffer+obp))=num;
		obp+=sizeof(long);
	}
	else{
		//u-128 < num < 127v̏ꍇ
		OpBuffer[obp++]=(char)0x83;
		OpBuffer[obp++]=(char)0xC4;
		OpBuffer[obp++]=(char)num;
	}
}
void op_sub_esp(int num){
	//X^bN|C^̌Zipushj

	//sub esp,num
	if(0xFFFFFF80&num){
		OpBuffer[obp++]=(char)0x81;
		OpBuffer[obp++]=(char)0xEC;
		*((long *)(OpBuffer+obp))=num;
		obp+=sizeof(long);
	}
	else{
		//u-128 < num < 127v̏ꍇ
		OpBuffer[obp++]=(char)0x83;
		OpBuffer[obp++]=(char)0xEC;
		OpBuffer[obp++]=(char)num;
	}
}



//////////////////////////////
// _֘A
//////////////////////////////

void op_fld_ptr_esp(int type){
	//X^bN|C^obt@̃f[^𕂓_WX^փ[h

	if(type==DEF_DOUBLE){
		//fld qword ptr[esp]
		OpBuffer[obp++]=(char)0xDD;
		OpBuffer[obp++]=(char)0x04;
		OpBuffer[obp++]=(char)0x24;
	}
	else if(type==DEF_SINGLE){
		//fld dword ptr[esp]
		OpBuffer[obp++]=(char)0xD9;
		OpBuffer[obp++]=(char)0x04;
		OpBuffer[obp++]=(char)0x24;
	}
	else if(type==DEF_INT64){
		//fild qword ptr[esp]
		OpBuffer[obp++]=(char)0xDF;
		OpBuffer[obp++]=(char)0x2C;
		OpBuffer[obp++]=(char)0x24;
	}
	else if(type==DEF_LONG){
		//fild dword ptr[esp]
		OpBuffer[obp++]=(char)0xDB;
		OpBuffer[obp++]=(char)0x04;
		OpBuffer[obp++]=(char)0x24;
	}
}



//////////////////////////////
// WX^֘A
//////////////////////////////

void op_zero_reg(int reg){
	//WX^0Zbg

	if(REG_RAX<=reg&&reg<=REG_RDI){
		/*	rax`rdi
			0100 1000 0011 0011 11 xxx xxx	*/
		OpBuffer[obp++]=(char)0x48;
		OpBuffer[obp++]=(char)0x33;
		OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg)<<3 | REGISTER_OPERAND(reg));
	}
	if(REG_R8<=reg&&reg<=REG_R15){
		/*	r8`r15
			0100 1101 0011 0011 11 xxx xxx	*/
		OpBuffer[obp++]=(char)0x4D;
		OpBuffer[obp++]=(char)0x33;
		OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg)<<3 | REGISTER_OPERAND(reg));
	}
}



/////////////////////////////
// ֐Ăяo
/////////////////////////////

void op_call( SUBINFO *psi ){
	OpBuffer[obp++] = (char)0xE8;
	pobj_SubAddrSchedule->add( psi, 1 );
	psi->bUse = 1;
	obp += sizeof(long);
}
void op_call( DECLAREINFO *pdi ){
	OpBuffer[obp++] = (char)0xFF;
	OpBuffer[obp++] = (char)0x15;
	pobj_ImportAddrSchedule->add(pdi);
	obp += sizeof(long);

	pdi->bUse=1;
}
