#include "../BasicCompiler_Common/common.h"
#include "opcode.h"

//fobOp
#include "../BasicCompiler_Common/debug.h"

int Debugging_GetArray(int *SubScripts,char *array,int type,LONG_PTR lpIndex,LONG_PTR *plpOffset);

ULONG_PTR Debugging_GetVarPtr(RELATIVE_VAR *pRelativeVar){
	extern DWORD ImageBase;
	extern int MemPos_RWSection;
	int i2;

	if(pRelativeVar->dwKind==VAR_GLOBAL){
		return ImageBase+MemPos_RWSection+pRelativeVar->offset;
	}
	else if( pRelativeVar->dwKind == VAR_REFGLOBAL ){
		extern HANDLE hDebugProcess;
		LONG_PTR lpData;
		SIZE_T stAccBytes;
		ReadProcessMemory(hDebugProcess,
			(void *)(ImageBase+MemPos_RWSection+pRelativeVar->offset),
			&lpData,
			sizeof(LONG_PTR),
			&stAccBytes);

		return lpData;
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		extern HWND hDebugWnd;
		i2=(int)SendDlgItemMessage(hDebugWnd,IDC_PROCCOMBO,CB_GETCURSEL,0,0);
		i2=pobj_dti->iProcLevel-i2;

		if(pobj_dti->lplpSpBase[i2]==0) return 0;

		return pobj_dti->lplpSpBase[i2]+pRelativeVar->offset;
	}
	else if( pRelativeVar->dwKind == VAR_REFLOCAL ){
		extern HWND hDebugWnd;
		i2=(int)SendDlgItemMessage(hDebugWnd,IDC_PROCCOMBO,CB_GETCURSEL,0,0);
		i2=pobj_dti->iProcLevel-i2;

		if(pobj_dti->lplpSpBase[i2]==0) return 0;

		extern HANDLE hDebugProcess;
		LONG_PTR lpData;
		SIZE_T stAccBytes;
		ReadProcessMemory(hDebugProcess,
			(void *)(pobj_dti->lplpSpBase[i2]+(int)pRelativeVar->offset),
			&lpData,
			sizeof(LONG_PTR),
			&stAccBytes);

		return lpData;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
		return pRelativeVar->offset;
	}

	return 0;
}

BOOL Debugging_SetRelativeOffset(int *pType,LONG_PTR lpIndex,RELATIVE_VAR *pRelativeVar,char *lpPtrOffset){
	int array_num;

	_int64 i64data;
	int type;
	type=StaticCalculation(true, lpPtrOffset,0,&i64data,0,1);
	if(!type) return 0;
	if(IsRealNumberType(type)){
		double dbl;
		memcpy(&dbl,&i64data,sizeof(double));
		i64data=(_int64)dbl;
	}

	array_num=(int)i64data;

	if(PTR_LEVEL(*pType)){
		*pType=MAKE_PTR_TYPE(NATURAL_TYPE(*pType),PTR_LEVEL(*pType)-1);
		array_num *= GetTypeSize(*pType,-1);
	}
	else{
		//G[
		return 0;
	}

	extern HANDLE hDebugProcess;
	LONG_PTR lpData;
	SIZE_T stAccBytes;
	lpData=Debugging_GetVarPtr(pRelativeVar);
	if(!ReadProcessMemory(hDebugProcess,(void *)lpData,&pRelativeVar->offset,sizeof(LONG_PTR),&stAccBytes)) return 0;
	pRelativeVar->dwKind=VAR_DIRECTMEM;

	pRelativeVar->offset+=array_num;
	return 1;
}

BOOL Debugging_GetMember(CClass *pobj_c,char *member,int *pType,RELATIVE_VAR *pRelativeVar,LONG_PTR *plpNestIndex,BOOL bPrivateAccess){
	int i,i2;

	//ڎQƂɐ؂ւ
	pRelativeVar->offset=(LONG_PTR)Debugging_GetVarPtr(pRelativeVar);
	pRelativeVar->dwKind=VAR_DIRECTMEM;

	//NXAz̍\vf͂
	char VarName[VN_SIZE];		//ϐ
	char array[VN_SIZE];		//1z
	char lpPtrOffset[VN_SIZE];	//2z
	char NestMember[VN_SIZE];	//qo
	CClass::RefType refType;
	lstrcpy(VarName,member);
	if(!GetVarFormatString(VarName,array,lpPtrOffset,NestMember, refType ) ) return 0;


	////////////////////////////
	// oItZbg擾
	////////////////////////////

	int offset = pobj_c->GetMemberOffset( VarName, &i );
	if(i==pobj_c->iMemberNum) return 0;


	//ANZVreB`FbN
	if((bPrivateAccess==0&&pobj_c->ppobj_Member[i]->dwAccess==ACCESS_PRIVATE)||
		pobj_c->ppobj_Member[i]->dwAccess==ACCESS_NON){
		return 0;
	}
	else if(bPrivateAccess==0&&pobj_c->ppobj_Member[i]->dwAccess==ACCESS_PROTECTED)
		return 0;

	*pType=pobj_c->ppobj_Member[i]->TypeInfo.type;
	*plpNestIndex=pobj_c->ppobj_Member[i]->TypeInfo.u.lpIndex;

	//|C^ϐ̏ꍇ
	if(IsPtrType(*pType)){
		if(pobj_c->ppobj_Member[i]->SubScripts[0]==-1){
			lstrcpy(lpPtrOffset,array);
			array[0]=0;
		}
	}
	else{
		if(lpPtrOffset[0]) return 0;
	}

	pRelativeVar->offset+=offset;

	if(array[0]){
		//zItZbg
		i2=Debugging_GetArray(
			pobj_c->ppobj_Member[i]->SubScripts,
			array,
			*pType,
			pobj_c->ppobj_Member[i]->TypeInfo.u.lpIndex,
			&pRelativeVar->offset);
		if(i2==0){
			//G[
			return 0;
		}
		if(i2==-1){
			//ANZXG[
			return -1;
		}
	}
	else if(pobj_c->ppobj_Member[i]->SubScripts[0]!=-1){
		*pType|=FLAG_PTR;
	}

	if(NestMember[0]){
		//q\̏ꍇ

		if(*pType==DEF_OBJECT || *pType==DEF_STRUCT){
			if( refType != CClass::Dot ) return 0;

			if( *pType==DEF_OBJECT ){
				extern HANDLE hDebugProcess;
				LONG_PTR lpData;
				SIZE_T stAccBytes;
				lpData=Debugging_GetVarPtr(pRelativeVar);
				if(!ReadProcessMemory(hDebugProcess,(void *)lpData,&pRelativeVar->offset,sizeof(LONG_PTR),&stAccBytes)) return -1;
				pRelativeVar->dwKind=VAR_DIRECTMEM;
			}
		}
		else if(*pType==DEF_PTR_OBJECT || *pType==DEF_PTR_STRUCT){
			//\̃|C^^oϐ

			if(lpPtrOffset[0]){
				if( refType != CClass::Dot ) return 0;

				//ڎQƂɐ؂ւ
				Debugging_SetRelativeOffset(pType,*plpNestIndex,pRelativeVar,lpPtrOffset);

				lpPtrOffset[0]=0;
			}
			else{
				if( refType != CClass::Pointer ) return 0;

				extern HANDLE hDebugProcess;
				LONG_PTR lpData;
				SIZE_T stAccBytes;
				lpData=Debugging_GetVarPtr(pRelativeVar);
				if(!ReadProcessMemory(hDebugProcess,(void *)lpData,&pRelativeVar->offset,sizeof(LONG_PTR),&stAccBytes)) return -1;
				pRelativeVar->dwKind=VAR_DIRECTMEM;
			}
		}

		i2=Debugging_GetMember(pobj_c->ppobj_Member[i]->TypeInfo.u.pobj_Class,
			NestMember,
			pType,
			pRelativeVar,
			plpNestIndex,
			0);
		if(i2==0){
			//G[
			return 0;
		}
		if(i2==-1){
			//ANZXG[
			return -1;
		}
	}

	if(lpPtrOffset[0]){
		Debugging_SetRelativeOffset(pType,*plpNestIndex,pRelativeVar,lpPtrOffset);
	}

	return 1;
}
int Debugging_GetArray(int *SubScripts,char *array,int type,LONG_PTR lpIndex,LONG_PTR *plpOffset){
	extern HANDLE hHeap;
	int i,i2,i3,i4,i5,array_offset,TypeSize;
	char temporary[VN_SIZE],*pParm[MAX_PARMS];

	for(i=0,i2=0,i3=0;;i++,i2++){
		if(array[i]=='('){
			i4=GetStringInPare(temporary+i2,array+i);
			i+=i4-1;
			i2+=i4-1;
			continue;
		}
		if(array[i]=='['){
			i4=GetStringInBracket(temporary+i2,array+i);
			i+=i4-1;
			i2+=i4-1;
			continue;
		}
		if(array[i]==','||array[i]=='\0'){
			if(SubScripts[i3]==-1){
				for(i3--;i3>=0;i3--) HeapDefaultFree(pParm[i3]);
				return 0;
			}

			temporary[i2]=0;

			pParm[i3]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
			lstrcpy(pParm[i3],temporary);

			i3++;

			if(array[i]=='\0'){
				if(SubScripts[i3]!=-1){
					for(i3--;i3>=0;i3--) HeapDefaultFree(pParm[i3]);
					return 0;
				}
				break;
			}

			i2=-1;
			continue;
		}
		temporary[i2]=array[i];
	}

	array_offset=0;

	for(i=i3-1;i>=0;i--){
		_int64 i64data;
		i2=StaticCalculation(true, pParm[i],0,&i64data,0,1);
		if(i2==0){
			//G[
			return 0;
		}
		if(i2==-1){
			//ANZXG[
			return -1;
		}

		if(IsRealNumberType(i2)){
			double dbl;
			memcpy(&dbl,&i64data,sizeof(double));
			i64data=(_int64)dbl;
		}
		i5=(int)i64data;

		for(i2=i+1,i4=1;i2<i3;i2++) i4*=SubScripts[i2]+1;

		array_offset+=i5*i4;

		HeapDefaultFree(pParm[i]);
	}

	TypeSize=GetTypeSize(type,lpIndex);

	array_offset*=TypeSize;

	*plpOffset+=array_offset;

	return 1;
}
ULONG_PTR Debugging_GetThisPtrOffset(LONG_PTR obp_Rip){
	int i;
	SUBINFO *psi;

	//ripvV[W擾
	psi=GetSubFromObp(obp_Rip);

	for(i=0;i<psi->VarNum;i++){
		if(lstrcmp(psi->pVar[i].name,"_System_LocalThis")==0) break;
	}
	if(i==psi->VarNum) return 0;

	return psi->pVar[i].offset;
}
int Debugging_GetVarOffset(char *variable,int *pType,RELATIVE_VAR *pRelativeVar,LONG_PTR *plpIndex,int *pss){
	extern HANDLE hDebugProcess;
	int i,i2,i3;
	char member[VN_SIZE],VarName[VN_SIZE],array[VN_SIZE],lpPtrOffset[VN_SIZE];
	LONG_PTR lpData;
	SIZE_T stAccBytes;

	lstrcpy(VarName,variable);
	CClass::RefType refType;
	GetVarFormatString(VarName,array,lpPtrOffset,member,refType);

	LONG_PTR lpIndex;
	int *pSubScripts;
	BOOL bArray;


	/////////////////
	// [Jϐ
	/////////////////
	extern VARIABLE *LocalVar;
	extern int MaxLocalVarNum;
	for(i=0;i<MaxLocalVarNum;i++){
		if(lstrcmp(VarName,LocalVar[i].name)==0) break;
	}
	if(i!=MaxLocalVarNum){
		//|C^ϐ̏ꍇ
		if(IsPtrType(LocalVar[i].type)){
			if(!LocalVar[i].bArray){
				lstrcpy(lpPtrOffset,array);
				array[0]=0;
			}
		}
		else{
			if(lpPtrOffset[0]) return 0;
		}

		pRelativeVar->offset=LocalVar[i].offset;
		if(LocalVar[i].fRef) pRelativeVar->dwKind=VAR_REFLOCAL;
		else pRelativeVar->dwKind=VAR_LOCAL;
		*pType=LocalVar[i].type;
		lpIndex=LocalVar[i].u.index;
		*plpIndex=lpIndex;
		bArray=LocalVar[i].bArray;
		pSubScripts=LocalVar[i].SubScripts;
	}
	else{
		if(pobj_CompilingClass){
			///////////////////////
			// NXo̎Q
			///////////////////////

			if(memicmp(variable,"This.",5)==0){
				//ThisIuWFNg̃oQƂƂ
				SlideString(variable+5,-5);
				lstrcpy(VarName,variable);
			}
			else{
				//NXoQƂƂiʏj

				for(i=0;i<pobj_CompilingClass->iMemberNum;i++){
					if(lstrcmp(VarName,pobj_CompilingClass->ppobj_Member[i]->name)==0) break;
				}
				if(i==pobj_CompilingClass->iMemberNum) goto NonClassMember;
			}

			/////////////////////////////
			// this|C^擾

			extern HWND hDebugWnd;
			i2=(int)SendDlgItemMessage(hDebugWnd,IDC_PROCCOMBO,CB_GETCURSEL,0,0);
			i2=pobj_dti->iProcLevel-i2;

			lpData=Debugging_GetThisPtrOffset(pobj_dti->lplpObp[i2]);
			if(!lpData){
				//G[
				return 0;
			}
			lpData+=pobj_dti->lplpSpBase[i2];
			if(!ReadProcessMemory(hDebugProcess,(void *)lpData,&pRelativeVar->offset,sizeof(LONG_PTR),&stAccBytes)){
				//ɃANZXłȂƂ
				return -1;
			}

			pRelativeVar->dwKind=VAR_DIRECTMEM;

			LONG_PTR lp2;
			i3=Debugging_GetMember(pobj_CompilingClass,variable,pType,pRelativeVar,&lp2,1);
			if(i3==0){
				//G[
				return 0;
			}
			if(i3==-1){
				//ANZXG[
				return -1;
			}

			*plpIndex=lp2;
			return 1;
		}

NonClassMember:

		///////////////////
		// O[oϐ
		///////////////////
		extern VARIABLE *GlobalVar;
		extern int MaxGlobalVarNum;

		for(i=0;i<MaxGlobalVarNum;i++){
			if(lstrcmp(VarName,GlobalVar[i].name)==0) break;
		}
		if(i==MaxGlobalVarNum){
			//vȂƂ
			return 0;
		}

		//|C^ϐ̏ꍇ
		if(IsPtrType(GlobalVar[i].type)){
			if(!GlobalVar[i].bArray){
				lstrcpy(lpPtrOffset,array);
				array[0]=0;
			}
		}
		else{
			if(lpPtrOffset[0]) return 0;
		}

		pRelativeVar->offset=GlobalVar[i].offset;
		if(GlobalVar[i].fRef) pRelativeVar->dwKind=VAR_REFGLOBAL;
		else pRelativeVar->dwKind=VAR_GLOBAL;
		*pType=GlobalVar[i].type;
		lpIndex=GlobalVar[i].u.index;
		*plpIndex=lpIndex;
		bArray=GlobalVar[i].bArray;
		pSubScripts=GlobalVar[i].SubScripts;
	}


	if(array[0]==0&&bArray){
		//z̐擪|C^ꍇ
		*pType|=FLAG_PTR;
		if(pss) memcpy(pss,pSubScripts,MAX_ARRAYDIM);
		return 1;
	}

	if(array[0]){
		i3=Debugging_GetArray(pSubScripts,array,*pType,lpIndex,&pRelativeVar->offset);
		if(i3==0){
			//G[
			return 0;
		}
		if(i3==-1){
			//ANZXG[
			return -1;
		}
	}
	if(member[0]){
		if(*pType==DEF_OBJECT || *pType==DEF_STRUCT){
			//ԃIuWFNg̃oQƁiobj.memberj
			if( refType != CClass::Dot ){
				return 0;
			}

			LONG_PTR lp2;
			i3=Debugging_GetMember((CClass *)lpIndex,member,pType,pRelativeVar,&lp2,0);
			if(i3==0){
				//G[
				return 0;
			}
			if(i3==-1){
				//ANZXG[
				return -1;
			}

			*plpIndex=lp2;
		}
		else if(*pType==DEF_PTR_OBJECT || *pType==DEF_PTR_STRUCT){
			//|C^IuWFNgoQ
			if(lpPtrOffset[0]){
				//pObj[n].member
				if( refType != CClass::Dot ) return 0;
				Debugging_SetRelativeOffset(pType,lpIndex,pRelativeVar,lpPtrOffset);

				LONG_PTR lp2;
				i3=Debugging_GetMember((CClass *)lpIndex,member,pType,pRelativeVar,&lp2,0);
				if(i3==0){
					//G[
					return 0;
				}
				if(i3==-1){
					//ANZXG[
					return -1;
				}

				*plpIndex=lp2;
			}
			else{
				//pObj->member
				if( refType != CClass::Pointer ) return 0;

				pRelativeVar->offset=Debugging_GetVarPtr(pRelativeVar);
				pRelativeVar->dwKind=VAR_DIRECTMEM;

				if(!ReadProcessMemory(hDebugProcess,(void *)pRelativeVar->offset,&lpData,sizeof(LONG_PTR),&stAccBytes)) return -1;
				pRelativeVar->offset=lpData;

				LONG_PTR lp2;
				i3=Debugging_GetMember((CClass *)lpIndex,member,pType,pRelativeVar,&lp2,0);
				if(i3==0){
					//G[
					return 0;
				}
				if(i3==-1){
					//ANZXG[
					return -1;
				}

				*plpIndex=lp2;
			}
		}
		else{
			return 0;
		}
		return 1;
	}

	if(lpPtrOffset[0]){
		if(!Debugging_SetRelativeOffset(pType,lpIndex,pRelativeVar,lpPtrOffset)) return 0;
	}

	return 1;
}
