#pragma once

class ObjectModule;

namespace ActiveBasic{ namespace Common{ namespace Lexical{


class RelationalObjectModuleItem
	: public Symbol
{
	int relationalObjectModuleIndex;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Symbol );
		ar & BOOST_SERIALIZATION_NVP( relationalObjectModuleIndex );
	}

public:
	RelationalObjectModuleItem( const RelationalObjectModuleItem &relationalObjectModuleItem )
		: Symbol( relationalObjectModuleItem )
		, relationalObjectModuleIndex( relationalObjectModuleItem.relationalObjectModuleIndex )
		, isNeedResolve( false )
	{
	}
	RelationalObjectModuleItem( const Symbol &symbol )
		: Symbol( symbol )
		, relationalObjectModuleIndex( 0 )
		, isNeedResolve( false )
	{
	}
	RelationalObjectModuleItem()
		: relationalObjectModuleIndex( -1 )
		, isNeedResolve( false )
	{
	}

	int GetRelationalObjectModuleIndex() const
	{
		return relationalObjectModuleIndex;
	}
	void SetRelationalObjectModuleIndex( int relationalObjectModuleIndex )
	{
		this->relationalObjectModuleIndex = relationalObjectModuleIndex;
	}

	virtual void ResetRelationalObjectModuleIndex( const std::vector<int> &relationTable )
	{
		this->relationalObjectModuleIndex = relationTable[this->relationalObjectModuleIndex];
	}

	bool IsExternal() const
	{
		return ( relationalObjectModuleIndex != 0 );
	}

	bool isNeedResolve;
	bool IsNeedResolve() const
	{
		return isNeedResolve;
	}
	void NeedResolve()
	{
		isNeedResolve = true;
	}

	virtual bool Resolve( const ObjectModule &resolver ) = 0;
};


}}}
