#include "stdafx.h"

TypeDef::TypeDef( const Symbol &symbol, const std::string &baseName, const Type &baseType )
	: RelationalObjectModuleItem( symbol )
	, baseName( baseName )
	, baseType( baseType )
{
}

bool TypeDef::Resolve( const ObjectModule &resolver )
{
	this->baseType.Resolve( resolver );
	return true;
}

TypeDefCollection::TypeDefCollection(){
}
TypeDefCollection::~TypeDefCollection(){
}
void TypeDefCollection::Add( const Symbol &symbol, const std::string &baseName, int nowLine ){
	TypeDef typeDef( symbol, baseName, nowLine );
	this->push_back( typeDef );
}

const TypeDef *TypeDefCollection::Find( const Symbol &symbol ) const
{
	const TypeDefCollection &typeDefs = *this;
	BOOST_FOREACH( const TypeDef &typeDef, typeDefs )
	{
		if( typeDef.IsEqualSymbol( symbol ) )
		{
			return &typeDef;
		}
	}
	return NULL;
}
