#include "stdafx.h"

ExpandedTemplateClass::~ExpandedTemplateClass()
{
	if( pClass )
	{
		delete pClass;
	}
}

bool ExpandedTemplateClass::Resolve( const ObjectModule &resolver )
{
	if( pClass->IsNeedResolve() )
	{
		pClass = const_cast<CClass *>(resolver.meta.GetClasses().FindLike( pClass ));
	}

	BOOST_FOREACH( Type &actualType, actualTypes )
	{
		actualType.Resolve( resolver );
	}

	return true;
}
