#pragma once

class TypeDefCollection;

class TypeDef
	: public RelationalObjectModuleItem
{
	friend TypeDefCollection;

	std::string baseName;
	Type baseType;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - TypeDef" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( RelationalObjectModuleItem );

		if( ActiveBasic::Common::Environment::IsRemoveExternal() )
		{
			if( this->IsExternal() )
			{
				this->NeedResolve();
				return;
			}
		}

		ar & BOOST_SERIALIZATION_NVP( baseName );
		ar & BOOST_SERIALIZATION_NVP( baseType );
	}

public:
	TypeDef( const Symbol &symbol, const std::string &baseName, const Type &baseType );
	TypeDef()
	{
	}
	~TypeDef()
	{
	}

	const std::string &GetBaseName() const
	{
		return baseName;
	}
	const Type &GetBaseType() const
	{
		return baseType;
	}

	virtual bool Resolve( const ObjectModule &resolver );
};

class TypeDefCollection : public std::vector<TypeDef>
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - TypeDefCollection" );

		ar & boost::serialization::make_nvp("vector_TypeDef",
			boost::serialization::base_object<std::vector<TypeDef>>(*this));
	}

public:
	TypeDefCollection();
	~TypeDefCollection();

	void Add( const Symbol &symbol, const std::string &baseName, int nowLine );
	const TypeDef *Find( const Symbol &symbol ) const;
};
