#pragma once

class Delegate
	: public Procedure
	, public Jenga::Common::ObjectInHashmap<Delegate>
{
	// importĂ閼O
	NamespaceScopesCollection importedNamespaces;

	std::string paramStr;
	std::string returnTypeName;
	int sourceIndex;

	Parameters dynamicParams;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - Delegate" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Procedure );

		if( ActiveBasic::Common::Environment::IsRemoveExternal() )
		{
			if( this->IsExternal() )
			{
				this->NeedResolve();
				return;
			}
		}

		ar & BOOST_SERIALIZATION_NVP( importedNamespaces );
		ar & BOOST_SERIALIZATION_NVP( dynamicParams );
	}

public:
	Delegate( const Symbol &symbol, const NamespaceScopesCollection &importedNamespaces, Procedure::Kind procKind, const char *paramStr, const std::string &returnTypeName, int sourceIndex )
		: Procedure( symbol, procKind, false )
		, importedNamespaces( importedNamespaces )
		, paramStr( paramStr )
		, returnTypeName( returnTypeName )
		, sourceIndex( sourceIndex )
	{
	}
	Delegate()
	{
	}

	const NamespaceScopesCollection &GetImportedNamespaces() const
	{
		return importedNamespaces;
	}

	const std::string &GetParamStr() const
	{
		return paramStr;
	}
	const std::string &GetReturnTypeName() const
	{
		return returnTypeName;
	}
	void SetReturnType( const Type &returnType )
	{
		this->returnType = returnType;
	}

	int GetSourceIndex() const
	{
		return sourceIndex;
	}

	virtual const std::string &GetKeyName() const
	{
		return GetName();
	}

	const Parameters &GetDynamicParams() const
	{
		return dynamicParams;
	}
	Parameters &GetDynamicParams()
	{
		return dynamicParams;
	}

	/*!
	@brief	I[o[ChpɃfQ[gmǂ`FbN
	@param	dgt Ƃ炵킹fQ[g
	*/
	bool IsSimilar( const Delegate &dgt ) const;

	virtual bool Resolve( const ObjectModule &resolver );
};
typedef Jenga::Common::Hashmap<Delegate> Delegates;
