#include "stdafx.h"

#include <Compiler.h>

#include "common.h"

using namespace ActiveBasic::Compiler;

int MakeWholeType(int size,int bSigned){
	switch(size){
		case 1:
			if(bSigned) return DEF_SBYTE;
			else return DEF_BYTE;
			break;
		case 2:
			if(bSigned) return DEF_INTEGER;
			else return DEF_WORD;
			break;
		case 4:
			if(bSigned) return DEF_LONG;
			else return DEF_DWORD;
			break;
		case 8:
			if(bSigned) return DEF_INT64;
			else return DEF_QWORD;
			break;
	}
	return 0;
}

int AutoBigCast(int BaseType,int CalcType){
	int type;
	type=CalcType;

	if(BaseType==0||BaseType==-1){
		//x[X^Cv̂Ƃ
		return type;
	}

	if(!IsWholeNumberType(type)){
		//^ł͂ȂƂ͈Öق̕ϊ͕KvȂ
		return type;
	}

	if(BaseType==DEF_OBJECT||BaseType==DEF_STRUCT){
		//x[X^CvIuWFNĝƂ͈Öق̕ϊ͕KvȂ
		return type;
	}

	int BaseTypeSize;
	BaseTypeSize=Type(BaseType,-1).GetSize();

	if(IsRealNumberType(BaseType)){
		if(Type(CalcType,-1).GetSize()<4)
			type=MakeWholeType(4,IsSignedType(CalcType));
	}
	else if(BaseTypeSize>Type(CalcType,-1).GetSize()){
		//v^̂قTCY傫Ƃ
		type=MakeWholeType(BaseTypeSize,IsSignedType(CalcType));
	}

	if(!type){
		extern int cp;
		compiler.errorMessenger.Output(300,NULL,cp);
	}

	return type;
}

BOOL CheckCalcType(int idCalc,int *type,int sp){
	//Zq̉EӁAӂ̌^`FbN
	extern int cp;

	//Zq擾
	char temporary[255];
	GetCalcName(idCalc,temporary);

	switch(idCalc){

		/////////////////////////////////////
		// ɑ΂_Z̓G[
		/////////////////////////////////////

		case CALC_XOR:
		case CALC_OR:
		case CALC_AND:
			if(IsRealNumberType(type[sp-2])||IsRealNumberType(type[sp-1])){
				//ꂩ̍̂Ƃ
				compiler.errorMessenger.Output(45,temporary,cp);
				return 0;
			}

			//AsȊỎZqɌ^w肳ĂȂ`FbN
			if((type[sp-2]&FLAG_CAST)||(type[sp-1]&FLAG_CAST)){
				compiler.errorMessenger.Output(48,temporary,cp);
				return 0;
			}
			break;

		case CALC_NOT:
			if(IsRealNumberType(type[sp-1])){
				//̂Ƃ
				compiler.errorMessenger.Output(45,temporary,cp);
				return 0;
			}

			//AsȊỎZqɌ^w肳ĂȂ`FbN
			if(type[sp-1]&FLAG_CAST){
				compiler.errorMessenger.Output(48,temporary,cp);
				return 0;
			}
			break;



		/////////////////////////////////////
		// rZ̓`FbNڂȂ
		/////////////////////////////////////

		case CALC_PE:
		case CALC_QE:
		case CALC_NOTEQUAL:
		case CALC_EQUAL:
		case CALC_P:
		case CALC_Q:
			//AsȊỎZqɌ^w肳ĂȂ`FbN
			if((type[sp-2]&FLAG_CAST)||(type[sp-1]&FLAG_CAST)){
				compiler.errorMessenger.Output(48,temporary,cp);
				return 0;
			}
			break;



		/////////////////////////////////////
		// ZpZ`FbN
		/////////////////////////////////////

		case CALC_ADDITION:
		case CALC_SUBTRACTION:
		case CALC_PRODUCT:
		case CALC_QUOTIENT:
		case CALC_POWER:
			//AsȊỎZqɌ^w肳ĂȂ`FbN
			if((type[sp-2]&FLAG_CAST)||(type[sp-1]&FLAG_CAST)){
				compiler.errorMessenger.Output(48,temporary,cp);
				return 0;
			}
			break;

		case CALC_SHL:
		case CALC_SHR:
		case CALC_MOD:
		case CALC_INTQUOTIENT:
			if(IsRealNumberType(type[sp-2])||IsRealNumberType(type[sp-1])){
				//ꂩ̍̂Ƃ
				compiler.errorMessenger.Output(45,temporary,cp);
				return 0;
			}

			//AsȊỎZqɌ^w肳ĂȂ`FbN
			if((type[sp-2]&FLAG_CAST)||(type[sp-1]&FLAG_CAST)){
				compiler.errorMessenger.Output(48,temporary,cp);
				return 0;
			}
			break;

		case CALC_AS:
			if((type[sp-1]&FLAG_CAST)==0){
				//^w肳ĂȂƂ̓G[
				compiler.errorMessenger.Output(47,NULL,cp);
				return 0;
			}
			break;

		case CALC_BYVAL:
			if(type[sp-1]&FLAG_CAST){
				//^w肳ĂȂƂ̓G[
				compiler.errorMessenger.Output(47,NULL,cp);
				return 0;
			}
			break;

		case CALC_MINUSMARK:
			//AsȊỎZqɌ^w肳ĂȂ`FbN
			if(type[sp-1]&FLAG_CAST){
				compiler.errorMessenger.Output(48,temporary,cp);
				return 0;
			}
			break;
	}
	return 1;
}

int GetReturnType_OperatorProc(int idCalc,const Type &baseType,int *type_stack,LONG_PTR *index_stack,int &sp)
{
	if( sp < 2 )
	{
		Jenga::Throw( "GetReturnType_OperatorProcsp2ȉ" );
	}

	Type leftType( type_stack[sp-2], index_stack[sp-2] );
	Type rightType( type_stack[sp-1] & (~FLAG_CAST), index_stack[sp-1] );

	//I[o[[hꂽIy[^֐Ăяo
	const CClass *pobj_c = &leftType.GetClass();

	std::vector<const UserProc *> subs;
	pobj_c->GetDynamicMethods().Enum( idCalc, subs );
	if( subs.size() == 0 ){
		return 0;
	}


	//̐
	BOOL bTwoTerm=1;
	if(idCalc==CALC_AS) bTwoTerm=0;



	/////////////////////////////////////////////
	// I[o[[hp̃p[^ݒ
	/////////////////////////////////////////////


	//_System_LocalThis
	Parameters params;

	if(bTwoTerm){
		params.push_back( new Parameter( "", rightType ) );
	}


	//I[o[[h
	char temporary[255];
	if(idCalc==CALC_EQUAL) lstrcpy(temporary,"==");
	else GetCalcName(idCalc,temporary);
	const UserProc *pUserProc = OverloadSolution( temporary, subs, params, baseType, leftType );

	if(bTwoTerm){
		delete params[0];
	}

	if(!pUserProc){
		return 0;
	}
	else{
		//I[o[[hĂȂAp[^vȂƂ
		if(params.size()!=pUserProc->Params().size()){
			return 0;
		}
	}

	sp--;
	type_stack[sp-1]=pUserProc->ReturnType().GetBasicType();
	index_stack[sp-1]=pUserProc->ReturnType().GetIndex();

	return 1;
}

bool Operator_New_GetType(const char *Parameter,const Type &baseType, Type &resultType ){
	char TypeName[VN_SIZE],objectSizeStr[VN_SIZE];
	int i,i2;

	i=0;

	if(Parameter[0]=='['){
		i=GetStringInBracket(objectSizeStr,Parameter);

		SlideString(objectSizeStr+1,-1);
		objectSizeStr[i-2]=0;
	}
	else objectSizeStr[0]=0;

	for(i2=0;;i++,i2++){
		if(Parameter[i]=='(' || Parameter[i]=='['){
			TypeName[i2]=0;
			break;
		}
		TypeName[i2]=Parameter[i];
		if(Parameter[i]=='\0'){
			break;
		}
	}

	if( !compiler.StringToType( TypeName, resultType ) )
	{
		compiler.errorMessenger.Output(3,TypeName,cp);
		return false;
	}

	if( !resultType.IsObject() )
	{
		compiler.errorMessenger.Output(121,NULL,cp);
		return false;
	}

	if( baseType.IsObject() ){
		resultType.SetBasicType( DEF_OBJECT );
	}
	else{
		resultType.SetBasicType( DEF_PTR_OBJECT );
	}
	return true;
}

bool GetMemberTermType( const Type &leftType, const Type &baseType, Type &resultType, const char *termFull, const char *termLeft, const char *member, bool *pIsVariable )
{
	////////////////////////////////
	// CfNTigetANZTj
	////////////////////////////////

	char VarName[VN_SIZE],ArrayElements[VN_SIZE];
	GetArrayElement(member,VarName,ArrayElements);
	if(ArrayElements[0]){
		Type classType;
		if( VarName[0] == '\0' )
		{
			classType = leftType;

			if( classType.IsObject() )
			{
				// useRegɃIuWFNg|C^i[ĂAɑ΂CfNTĂяoꍇ
				// uvpeBlƂĕԂĂIuWFNgCX^X̃CfNTĂяovꍇɂɂ
			}
		}
		else
		{
			GetMemberType( leftType, VarName, classType, 0, false );
		}

		if( classType.IsObject() )
		{
			if( !GetReturnTypeOfIndexerGetterProc( classType, resultType ) ){
				compiler.errorMessenger.Output(1,NULL,cp);
				return false;
			}

			return true;
		}
	}


	///////////////////////////////////////////////////////////////////
	// o
	///////////////////////////////////////////////////////////////////
	if( GetMemberType( leftType, member, resultType, 0, false ) ){
		// oƂ

		if( pIsVariable )
		{
			*pIsVariable = true;
		}

		return true;
	}


	///////////////////////////////////////////////////////////////////
	// I\bh
	///////////////////////////////////////////////////////////////////
	char methodName[VN_SIZE] ,lpPtrOffset[VN_SIZE], dummy[1];
	char parameter[VN_SIZE];
	ReferenceKind refType;
	PareOrBracket pareOrBracket = None;
	lstrcpy( methodName, member );
	GetVarFormatString( methodName, parameter, lpPtrOffset, dummy, refType, &pareOrBracket );

	std::vector<const UserProc *> userProcs;
	leftType.GetClass().EnumDynamicMethodsOrInterfaceMethods( methodName, userProcs );
	if(userProcs.size()){
		//I[o[[h
		const UserProc *pUserProc = OverloadSolutionWithStrParam(termFull,userProcs,parameter,termLeft);

		if( pUserProc )
		{
			if(
				pUserProc->Params().size() == 0				// ̌0
				&& parameter[0]								// 1ȏ
				&& pUserProc->ReturnType().IsObject()		// ߂lNX^̏ꍇ
				&& pareOrBracket == Bracket )				// []ň͂܂Ă
			{
				// vpeBlƂĕԂĂIuWFNgCX^X̃CfNTĂяo

				// ܂̓vpeBl擾
				bool dummyIsVariable;
				GetMemberTermType( leftType, baseType, resultType, termFull, termLeft, methodName, &dummyIsVariable );

				// ߂l̃IuWFNgCX^X̃CfNTĂяo
				char temporary[VN_SIZE], temp2[VN_SIZE];
				sprintf( temporary, "[%s]", parameter );
				sprintf( temp2, "%s.%s", termLeft, methodName );
				Type classType = resultType;
				return GetMemberTermType( classType, baseType, resultType, termFull, temp2, temporary, pIsVariable );
			}

			resultType = pUserProc->ReturnType();

			// ^p[^
			ResolveFormalGenericTypeParameter( resultType, leftType, pUserProc );

			return true;
		}
	}

	return false;
}

bool GetTermType( const char *term, const Type &baseType, Type &resultType, bool &isLiteral, bool *pIsClassName, bool *pIsVariable )
{
	char parameter[VN_SIZE];

	// With
	char termFull[VN_SIZE];
	if(term[0]=='.'){
		GetWithName(termFull);
		lstrcat(termFull,term);
	}
	else lstrcpy(termFull,term);

	char termLeft[VN_SIZE];
	lstrcpy(termLeft,termFull);

	// p[X
	char member[VN_SIZE];
	ReferenceKind refType;
	if( SplitMemberName( termFull, termLeft, member, refType ) ){
		///////////////////////////////////////////////////////////////////
		// IuWFNgƃoɕłƂ
		// termLeft.member
		///////////////////////////////////////////////////////////////////

		isLiteral = false;

		// IuWFNǧ^擾
		bool isClassName = false;
		Type leftType;
		if( GetTermType( termLeft, Type(), leftType, isLiteral, &isClassName ) ){
			if( isClassName == false && compiler.GetObjectModule().meta.GetBlittableTypes().IsExist( leftType ) ){
				// ̃IuWFNgBlittable^̂Ƃ

				char temporary[VN_SIZE];
				lstrcpy( temporary, termLeft );
				sprintf( termLeft, "%s(%s)",
					compiler.GetObjectModule().meta.GetBlittableTypes().Find( leftType ).GetCreateStaticMethodFullName().c_str(),
					temporary );

				if( !GetTermType( termLeft, Type(), leftType, isLiteral, &isClassName ) ){
					goto globalArea;
				}
			}
		}
		else{
			goto globalArea;
		}

		if( isClassName ){
			// ÓIo/\bh̏ꍇ
			goto globalArea;
		}

		if( !leftType.HasMember() ){
			// oȂ^̏ꍇ
			return false;
		}

		return GetMemberTermType( leftType, baseType, resultType, termFull, termLeft, member, pIsVariable );
	}


	//////////////////////////////////////////////
	// NXǂ`FbNiÓIopj
	//////////////////////////////////////////////

	if( pIsClassName )
	{
		if( compiler.GetObjectModule().meta.FindClassSupportedTypeDef( LexicalAnalyzer::FullNameToSymbol( termFull ) ) )
		{
			*pIsClassName = true;
			return true;
		}
	}


	/////////////////////////////////////////////////////////////////
	// O[o
	/////////////////////////////////////////////////////////////////
globalArea:


	if(lstrcmpi(termFull,"This")==0)
	{
		if( !compiler.IsCompilingClass() )
		{
			return false;
		}

		//ThisIuWFNg
		resultType.SetType( DEF_OBJECT, &compiler.GetCompilingClass() );
		isLiteral = false;
		return true;
	}


	//////////////////////////////////////
	// ֐iDLLA[U[`Agݍ݁j
	//////////////////////////////////////
	char procName[VN_SIZE];
	char temporary[8192];

	int i2=GetCallProcName(termFull,procName);
	if(termFull[i2]=='('){
		int i4=GetStringInPare_RemovePare(parameter,termFull+i2+1);

		void *pProc;
		int idProc=GetProc(procName,(void **)&pProc);

		if(idProc){
			//JbR")"ɑNULLłȂƂ
			if(termFull[i2+1+i4+1]!='\0'){
				compiler.errorMessenger.Output(42,NULL,cp);
			}


			////////////////
			// Ăяo
			////////////////

			if( !CallProc(idProc,pProc,procName,parameter, baseType, resultType, false ) ){
				return false;
			}
			if( resultType.IsNull() ){
				//߂l݂ȂƂ
				return false;
			}

			isLiteral = false;

			return true;
		}
		else
		{
			ConstMacro *pConstMacro = compiler.GetObjectModule().meta.GetGlobalConstMacros().Find(
				ActiveBasic::Compiler::LexicalAnalyzer::FullNameToSymbol( procName )
			);
			if( pConstMacro )
			{
				if( ActiveBasic::Compiler::LexicalAnalyzer::ConstMacroToExpression( *pConstMacro, parameter, temporary ) )
				{
					/////////////////////////
					// }N֐
					/////////////////////////

					//JbR")"ɑNULLłȂƂ̓G[ɂ
					if(termFull[i2+1+i4+1]!='\0') compiler.errorMessenger.Output(42,NULL,cp);

					//}N֐̏ꍇ
					if( !NumOpe_GetType(temporary,Type(),resultType) ){
						return false;
					}

					if( !IS_LITERAL( resultType.GetIndex() ) ){
						//elł͂ȂƂ
						isLiteral = false;
					}

					return true;
				}
			}
		}
	}


	////////////////////////////////
	// CfNTigetANZTj
	////////////////////////////////

	char VarName[VN_SIZE],ArrayElements[VN_SIZE];
	GetArrayElement(termFull,VarName,ArrayElements);
	if(ArrayElements[0]){
		Type classType;
		GetVarType(VarName,classType,false);
		if( classType.IsObject() ){
			if( !GetReturnTypeOfIndexerGetterProc( classType, resultType ) ){
				compiler.errorMessenger.Output(1,NULL,cp);
				return false;
			}

			isLiteral = false;

			return true;
		}
	}


	////////////////////////////////
	// ϐ
	////////////////////////////////

	if( GetVarType( termFull, resultType, false ) ){
		if( resultType.GetBasicType() & FLAG_PTR ){
			//z|C^
			resultType.SetBasicType( GetPtrType( resultType.GetBasicType()^FLAG_PTR ) );
		}

		isLiteral = false;

		if( pIsVariable )
		{
			// ϐł
			*pIsVariable = true;
		}

		return true;
	}


	/////////////////////////////////
	// vpeBp̃\bh
	/////////////////////////////////

	//zvfr
	GetArrayElement(termFull,VarName,ArrayElements);

	if(GetSubHash(VarName,0)){
		GetReturnTypeOfPropertyMethod(termFull,NULL,resultType);

		isLiteral = false;

		return true;
	}


	return false;
}

bool GetTermType( const char *term, Type &resultType )
{
	bool isLiteral;
	return GetTermType( term, Type(), resultType, isLiteral );
}

bool GetTermTypeOnlyVariable( const char *term, Type &resultType )
{
	bool isLiteral, isVariable = false;
	bool result = GetTermType( term, Type(), resultType, isLiteral, NULL, &isVariable );
	return ( result && isVariable );
}

bool NumOpe_GetType( const char *expression, const Type &baseType, Type &resultType, bool *pIsLiteralCalculation ){
	extern int cp;
	int i,i3;

	//el݂̂̌vZǂ𔻕ʂ邽߂̃tO
	bool dummyBool;
	if( pIsLiteralCalculation == NULL )
	{
		pIsLiteralCalculation = &dummyBool;
	}
	*pIsLiteralCalculation = true;

	if(expression[0]=='\0'){
		compiler.errorMessenger.Output(1,NULL,cp);
		return false;
	}

	if(expression[0]==1&& ( expression[1]==ESC_NEW || expression[1] == ESC_SYSTEM_STATIC_NEW ) ){
		//NewZqiIuWFNgj
		*pIsLiteralCalculation = false;
		return Operator_New_GetType(expression+2,baseType, resultType );
	}

	if( expression[0] == '[' ){
		if( !baseType.IsPointer() ){
			return false;
		}

		resultType = baseType;
		return true;
	}


	/////////////////////////////////
	// vft|[hŎ擾
	/////////////////////////////////

	char *values[255];
	long calc[255];
	long stack[255];
	int pnum;
	if(!GetNumOpeElements(expression,&pnum,values,calc,stack)){
		for(i=0;i<pnum;i++){
			if(values[i]) HeapDefaultFree(values[i]);
		}
		return false;
	}



	////////////////////////////////
	// Z̃R[hJn
	////////////////////////////////

	BOOL bError;
	bError=0;

	int sp;
	int type_stack[255];
	LONG_PTR index_stack[255];
	bool isNothing_stack[255];
	_int64 i64data;
	int idCalc;
	for(i=0,sp=0;i<pnum;i++){
		idCalc=calc[i]%100;

		if(idCalc && sp >= 2){
			if(type_stack[sp-2]==DEF_OBJECT){
				if( idCalc == CALC_AS
					&& type_stack[sp-1] == ( DEF_OBJECT | FLAG_CAST )
					&& index_stack[sp-1] == index_stack[sp-2]
					|| isNothing_stack[sp-2] ){
						// ̌^A܂Nothingɑ΂AsAsZqĂяoȂ
				}
				else if( idCalc == CALC_AS
					&& type_stack[sp-1] == ( DEF_OBJECT | FLAG_CAST )
					&& ( ((CClass *)index_stack[sp-1])->IsEqualsOrSubClass( (CClass *)index_stack[sp-2] ) || ((CClass *)index_stack[sp-2])->IsEqualsOrSubClass( (CClass *)index_stack[sp-1] )
					)){
						// _ELXg
				}
				else if( idCalc == CALC_AS ){
					// NumOpe_GetTypełׂ͂ẴLXg
				}
				else{
					//I[o[[hꂽIy[^Ăяo
					if(!GetReturnType_OperatorProc(idCalc,baseType,type_stack,index_stack,sp)){
						goto error;
					}

					continue;
				}
			}

			if(!CheckCalcType(idCalc,type_stack,sp)) goto error;
		}

		switch(idCalc){
			//l
			case 0:
				index_stack[sp]=-1;
				isNothing_stack[sp] = false;

				char *term;
				term = values[i];

				if( calc[i+1]%100 == CALC_AS ){
					// AsZq̉EӒl
					//^
					if( compiler.StringToType( term, resultType ) ){

						if( resultType.IsObject() ){
							if( resultType.GetClass().IsBlittableType() ){
								// Blittable^̂Ƃ͊{^ƂĈ
								// ARpC̃\bhBlittable^NXɑĂȂ
								if( compiler.IsLocalAreaCompiling()
									&& compiler.GetCompilingUserProc().HasParentClass()
									&& compiler.GetCompilingUserProc().GetParentClass().IsBlittableType() )
								{
									// RpC̃\bhBlittable^NXɑĂ
								}
								else{
									resultType = resultType.GetClass().GetBlittableType();
								}
							}
						}

						resultType.SetBasicType( resultType.GetBasicType() | FLAG_CAST );
					}
					else{
						compiler.errorMessenger.Output(3, term, cp );
						goto error;
					}

					type_stack[sp] = resultType.GetBasicType();
					index_stack[sp] = resultType.GetIndex();
					sp++;

					break;
				}

				if(term[0]=='\"'){
StrLiteral:

					if( !baseType.IsPointer() ){
						//v^CvIuWFNgA܂͖̂Ƃ
						type_stack[sp]=DEF_OBJECT;
						index_stack[sp]=(LONG_PTR)compiler.GetObjectModule().meta.GetClasses().GetStringClassPtr();
						*pIsLiteralCalculation = false;

						sp++;
						break;
					}

					type_stack[sp]=typeOfPtrChar;
					*pIsLiteralCalculation = false;
				}
				else if((term[0]=='e'||term[0]=='E')&&
					(term[1]=='x'||term[1]=='X')&&
					term[2]=='\"'){
					//gŃeiGXP[vV[PX\j
					goto StrLiteral;
				}
				else if(IsVariableTopChar(term[0])||
					term[0]=='*'||
					(term[0]=='.'&&IsVariableTopChar(term[1])))
				{
					//////////////////
					// 炩̎ʎq

					bool isLiteral = true;
					if( GetTermType( term, baseType, resultType, isLiteral ) ){
						type_stack[sp] = resultType.GetBasicType();
						index_stack[sp] = resultType.GetIndex();

						if( !isLiteral ){
							*pIsLiteralCalculation = false;
						}

						sp++;
						break;
					}


					// Nothing
					if( lstrcmp( term, "Nothing" ) == 0 ){
						isNothing_stack[sp] = true;

						if( baseType.IsObject() ){
							type_stack[sp] = DEF_OBJECT;
							index_stack[sp] = baseType.GetIndex();
						}
						else{
							type_stack[sp] = baseType.GetBasicType();
							index_stack[sp] = baseType.GetIndex();
						}

						*pIsLiteralCalculation = false;
						sp++;
						break;
					}


					//////////////
					// 萔̏ꍇ
					//////////////

					i3 = compiler.GetObjectModule().meta.GetGlobalConsts().GetBasicType(
						ActiveBasic::Compiler::LexicalAnalyzer::FullNameToSymbol( term )
					);
					if(i3){
						if( compiler.GetObjectModule().meta.GetGlobalConsts().IsStringPtr( ActiveBasic::Compiler::LexicalAnalyzer::FullNameToSymbol( term ), compiler.IsUnicode() ) )
						{
							//e
							goto StrLiteral;
						}

						type_stack[sp]=i3;
						if(IsRealNumberType(i3)){
							//
							goto Literal;
						}
						else if(IsWholeNumberType(i3)){
							//
							goto Literal;
						}
						else if(Is64Type(i3)){
							//64rbgl
							goto Literal;
						}
						else{
							compiler.errorMessenger.Output(1,NULL,0);
							goto error;
						}
					}


					/////////////////////////////////
					// vpeBp̃\bh
					/////////////////////////////////

					//zvfr
					char VarName[VN_SIZE],ArrayElements[VN_SIZE];
					GetArrayElement(term,VarName,ArrayElements);

					if(GetSubHash(VarName,0)){
						compiler.errorMessenger.OutputFatalError();
						Type tempType;
						GetReturnTypeOfPropertyMethod(term,NULL,tempType);

						//傫Ȍ^ւ̈Öق̕ϊ
						type_stack[sp]=tempType.GetBasicType();

						index_stack[sp]=tempType.GetIndex();
						*pIsLiteralCalculation = false;

						sp++;
						break;
					}



					//Y鎯ʎqȂƂ̓G[ɂ
					bError=1;
					compiler.errorMessenger.Output(3,term,cp);
					type_stack[sp]=DEF_DOUBLE;
				}
				else{
					//el
					int base_type = 0;
					if( !baseType.IsNull() ) base_type = baseType.GetBasicType();
					type_stack[sp]=GetLiteralValue(term,&i64data,base_type);
Literal:
					if((long)i64data==0&&index_stack[sp]==-1) index_stack[sp]=LITERAL_NULL;
				}

				sp++;
				break;

			//_Zq
			case CALC_XOR:
			case CALC_OR:
			case CALC_AND:
				sp--;
				type_stack[sp-1]=NeutralizationType(type_stack[sp-1],index_stack[sp-1],type_stack[sp],index_stack[sp]);
				break;
			case CALC_NOT:
				//values[sp-1]=Not values[sp-1]
				//NOTZq
				break;

			//rZq
			case CALC_PE:		//values[sp-2] <= values[sp-1]
			case CALC_QE:		//values[sp-2] >= values[sp-1]
			case CALC_P:		//values[sp-2] <  values[sp-1]
			case CALC_Q:		//values[sp-2] >  values[sp-1]
			case CALC_NOTEQUAL:	//values[sp-2] <> values[sp-1]
			case CALC_EQUAL:	//values[sp-2] =  values[sp-1]	
				sp--;
				type_stack[sp-1]=DEF_LONG;
				break;

			//rbgVtg
			case CALC_SHL:	//values[sp-2] << values[sp-1]
			case CALC_SHR:	//values[sp-2] >> values[sp-1]
				sp--;
				break;

			//ZpZ
			case CALC_ADDITION:
			case CALC_SUBTRACTION:
			case CALC_PRODUCT:
				sp--;
				type_stack[sp-1]=NeutralizationType(type_stack[sp-1],index_stack[sp-1],type_stack[sp],index_stack[sp]);
				break;
			case CALC_MOD:
				//values[sp-2]%=values[sp-1]
				//]Z
				sp--;
				type_stack[sp-1]=NeutralizationType(type_stack[sp-1],index_stack[sp-1],type_stack[sp],index_stack[sp]);
				break;
			case CALC_QUOTIENT:
				//values[sp-2]/=values[sp-1];
				//Z
				sp--;
				type_stack[sp-1]=NeutralizationType(type_stack[sp-1],index_stack[sp-1],type_stack[sp],index_stack[sp]);
				break;
			case CALC_INTQUOTIENT:
				//values[sp-2]/=values[sp-1]
				//Z
				sp--;
				type_stack[sp-1]=NeutralizationType(type_stack[sp-1],index_stack[sp-1],type_stack[sp],index_stack[sp]);
				break;
			case CALC_MINUSMARK:
				//values[sp-1]=-values[sp-1]
				//]
				break;
			case CALC_POWER:
				//ׂ扉Zi_Ẑ݁j
				sp--;
				//
				break;
			case CALC_AS:
				//LXg
				type_stack[sp-2]=type_stack[sp-1]&(~FLAG_CAST);
				index_stack[sp-2]=index_stack[sp-1];

				sp--;
				break;

			case CALC_BYVAL:
				//|C^^Qƌ^
				if( PTR_LEVEL( type_stack[sp-1] ) <= 0 ){
					//|C^^ł͂ȂƂ
					compiler.errorMessenger.Output( 3, NULL, cp );
					goto error;
				}

				type_stack[sp-1] = PTR_LEVEL_DOWN( type_stack[sp-1] );
				break;
		}
	}

	if(bError) goto error;

	if(sp!=1){
		compiler.errorMessenger.Output(1,NULL,cp);
		goto error;
	}

	if( *pIsLiteralCalculation ){
		//EӒll̒萔̏ꍇ
		int base_type = 0;
		if( !baseType.IsNull() ) base_type = baseType.GetBasicType();
		Type tempType;
		StaticCalculation(true, expression,base_type,&i64data,tempType);

		type_stack[0]=tempType.GetBasicType();
		index_stack[0]=tempType.GetIndex();
	}
	else{
		//EӒll̒萔ł͂ȂƂ
		if(IS_LITERAL(index_stack[0])) index_stack[0]=-1;
	}

	resultType.SetType( type_stack[0], index_stack[0] );

	bool isSuccessful = true;
	goto finish;


	//////////////////
	// G[
	//////////////////

error:
	isSuccessful = false;
	goto finish;


finish:
	for(i=0;i<pnum;i++){
		if(values[i]) HeapDefaultFree(values[i]);
	}
	return isSuccessful;
}
