#include "stdafx.h"

#ifdef _AMD64_
#include "../../compiler_x64/opcode.h"
#else
#include "../../compiler_x86/opcode.h"
#endif

using namespace ActiveBasic::Compiler;

void ProcedureGenerator::Generate_InitStaticMember( const Classes &classes )
{
	//ÓIoO[öɍ쐬

	//Ce[^Zbg

	extern int cp;
	int back_cp=cp;

	classes.Iterator_Reset();
	while(classes.Iterator_HasNext()){
		CClass &objClass = *classes.Iterator_GetNext();
		if( objClass.IsExternal() )
		{
			// ÓINCȕꍇ͔΂iɃCX^X`ς݂ł邽߁j
			continue;
		}

		// OԂZbg
		compiler.GetNamespaceSupporter().GetLivingNamespaceScopes() = objClass.GetNamespaceScopes();

		DWORD dwFlags = 0;
		if( objClass.GetName() == "_System_TypeBase" )
		{
			// _System_TypeBaseNX̓O[oAX^eBbN̈邽߂̃NXȂ̂łł̏͏O
			dwFlags |= DIMFLAG_NONCALL_CONSTRACTOR;
		}

		// RpCNXƂăZbg
		compiler.SetCompilingClass( &objClass );

		const EnumInfo *pEnumInfo = NULL;
		if( objClass.IsEnum() )
		{
			pEnumInfo = compiler.enumInfoCollection.Find( objClass );
		}

		int i=0;
		BOOST_FOREACH( Member *member, objClass.GetStaticMembers() )
		{
			if( pEnumInfo )
			{
				cp = pEnumInfo->GetEnumMember( member->GetName() ).GetSourceIndex();
			}

			char temporary[VN_SIZE];
			sprintf(temporary,"%s.%s",objClass.GetName().c_str(),member->GetName().c_str());
			dim(
				temporary,
				member->GetSubscripts(),
				member->GetType(),
				member->GetInitializeExpression().c_str(),
				member->GetConstructParameter().c_str(),
				dwFlags);

			i++;
		}

		compiler.SetCompilingClass( NULL );
	}

	compiler.GetNamespaceSupporter().GetLivingNamespaceScopes().clear();

	cp=back_cp;
}

void ProcedureGenerator::Generate_System_InitializeUserTypes( const Classes &classes )
{
	char temporary[VN_SIZE];

	////////////////////////////////////////////////////////////////////
	// NXo^
	////////////////////////////////////////////////////////////////////

	// Ce[^Zbg
	classes.Iterator_Reset();

	while( classes.Iterator_HasNext() ){
		const CClass &objClass = *classes.Iterator_GetNext();

		if( !objClass.IsUsing() ){
			// gp̃NX͖
			continue;
		}

		std::string referenceOffsetsBuffer;
		int numOfReference = 0;
		objClass.GetReferenceOffsetsInitializeBuffer( referenceOffsetsBuffer, numOfReference );

		sprintf( temporary
			, "Add(%c%c_System_TypeForClass[strNamespace=\"%s\",name=\"%s\",fullName=\"%s\",referenceOffsets=[%s],numOfReference=%d])"
			, 1
			, ESC_SYSTEM_STATIC_NEW
			, objClass.GetNamespaceScopes().ToString().c_str()		// O
			, objClass.GetName().c_str()							// NX
			, objClass.GetFullName().c_str()						// tl[
			, referenceOffsetsBuffer.c_str()						// QƃoItZbgz
			, numOfReference										// Qƃǒ
			);

		// RpC
		ChangeOpcode( temporary );

		objClass.SetTypeInfoDataTableOffset(
			DataTableGenerator::GetLastMadeConstObjectDataTableOffset()
		);
	}
}

std::string ProcedureGenerator::GetStaticDefiningStringAsMemberTypeInfoNames( const CClass &_class )
{
	std::string result;

	BOOST_FOREACH( const Member *pMember, _class.GetDynamicMembers() )
	{
		if( result.size() )
		{
			result += ",";
		}

		result += "\"" + compiler.TypeToString( pMember->GetType() ) + "\"";
	}

	return result;
}

void ProcedureGenerator::Generate_System_InitializeUserTypesForBaseType( const Classes &classes )
{
	extern int cp;
	cp = -1;
	////////////////////////////////////////////////////////////////////
	// NXo^
	////////////////////////////////////////////////////////////////////

	char temporary[8192];
	sprintf(temporary, "%c%ctempType=Nothing%c%c_System_TypeForClass"
		, HIBYTE( COM_DIM )
		, LOBYTE( COM_DIM )
		, 1
		, ESC_AS
		);
	ChangeOpcode( temporary );

	// Ce[^Zbg
	classes.Iterator_Reset();

	while( classes.Iterator_HasNext() ){
		const CClass &objClass = *classes.Iterator_GetNext();

		if( !objClass.IsUsing() ){
			// gp̃NX͖
			continue;
		}

		if( objClass.HasSuperClass() || objClass.GetDynamicMembers().size() ){
			sprintf( temporary
				, "tempType=Search(\"%s\") As ActiveBasic.Core._System_TypeForClass"
				, objClass.GetFullName().c_str()
			);

			// RpC
			MakeMiddleCode( temporary );
			ChangeOpcode( temporary );

			sprintf( temporary
				, "tempType.SetClassInfo(%d,_System_GetComVtbl(%s),_System_GetVtblList(%s),_System_GetDefaultConstructor(%s),_System_GetDestructor(%s))"
				, objClass.GetSize()
				, objClass.GetFullName().c_str()
				, objClass.GetFullName().c_str()
				, objClass.GetFullName().c_str()
				, objClass.GetFullName().c_str()
				, objClass.GetName().c_str()
			);

			// RpC
			ChangeOpcode( temporary );

			if( objClass.HasSuperClass() )
			{
				sprintf( temporary
					, "tempType.SetBaseType(Search(\"%s\"))"
					, objClass.GetSuperClass().GetFullName().c_str()
				);

				// RpC
				ChangeOpcode( temporary );
			}

			if( objClass.GetDynamicMembers().size() )
			{
				// ǒ^TypeInfoIuWFNgւDataOffsetz̐ÓIf[^`擾
				sprintf(
					temporary,
					"tempType.SetMembers([%s],[%s],[%s],%d)",
					objClass.GetStaticDefiningStringAsMemberNames().c_str(),
					GetStaticDefiningStringAsMemberTypeInfoNames( objClass ).c_str(),
					objClass.GetStaticDefiningStringAsMemberOffsets().c_str(),
					objClass.GetDynamicMembers().size()
				);
				ChangeOpcode( temporary );
			}
		}
	}
}
