#include "stdafx.h"

Variable::Variable( const Symbol &symbol, const Type &type, bool isConst, bool isRef, const std::string &paramStrForConstructor, bool hasInitData )
	: RelationalObjectModuleItem( symbol )
	, type( type )
	, isConst( isConst )
	, isRef( isRef )
	, isArray( false )
	, isParameter( false)
	, paramStrForConstructor( paramStrForConstructor )
	, hasInitData( hasInitData )
{
}
Variable::Variable( const Variable &var )
	: RelationalObjectModuleItem( var )
	, type( var.type )
	, isConst( var.isConst )
	, isRef( var.isRef )
	, isArray( var.isArray )
	, subscripts( var.subscripts )
	, isParameter( false )
	, paramStrForConstructor( var.paramStrForConstructor )
	, hasInitData( var.hasInitData )
{
}
Variable::Variable()
{
}

bool Variable::Resolve()
{
	// TODO: Resolve
	return true;
}


bool Variables::DuplicateCheck( const Symbol &symbol, int nowScopeLevel ) const
{
	//LVJXR[vlďd
	for( int i=(int)this->size()-1; i>=0 ; i-- ){
		const Variable *pVar = (*this)[i];
		if( pVar->isLiving									//݂̃XR[vŗLȂ
			&& pVar->GetScopeLevel() == nowScopeLevel		//݂̃XR[vƓꃌx
			)
		{
			if( pVar->IsEqualSymbol( symbol ) ){
				return true;
			}
		}
	}
	return false;
}

const Variable *Variables::BackSearch( const Symbol &symbol, int nowScopeLevel ) const
{
	//LVJXR[vlăobNT[`
	for( int i=(int)this->size()-1; i>=0 ; i-- ){
		const Variable *pVar = (*this)[i];
		if( pVar->isLiving									//݂̃XR[vŗLȂ
			&& pVar->GetScopeLevel() <= nowScopeLevel		//݂̃XR[vx𒴂Ȃ́iReturnɂlj
			){
				if( pVar->IsEqualSymbol( symbol ) ){
					return pVar;
				}
		}
	}
	return NULL;
}

const Variable *Variables::Find( const Symbol &symbol )const
{
	int max = (int)this->size();
	for( int i=0; i<max; i++ ){
		Variable *pVar = (*this)[i];
		if( pVar->IsEqualSymbol( symbol ) ){
			return pVar;
		}
	}
	return NULL;
}

void GlobalVars::Add( Variable *pVar, bool isResetOffsetAddress )
{
	int alignment = 0;
	if( pVar->GetType().IsStruct() ){
		alignment = pVar->GetType().GetClass().GetFixedAlignment();
	}

	if( pVar->HasInitData() ){
		//obt@Ƃ

		if( isResetOffsetAddress )
		{
			if( alignment ){
				if( initAreaBuffer.GetSize() % alignment ){
					initAreaBuffer.Resize( initAreaBuffer.GetSize() + ( alignment - (initAreaBuffer.GetSize() % alignment) ) );
				}
			}

			pVar->SetOffsetAddress( initAreaBuffer.GetSize() );

			initAreaBuffer.Resize( initAreaBuffer.GetSize() + pVar->GetMemorySize() );
		}
	}
	else{
		//obt@ȂƂ

		if( alignment ){
			if( allSize % alignment ){
				allSize += alignment - (allSize % alignment);
			}
		}

		pVar->SetOffsetAddress( allSize | 0x80000000 );
		allSize += pVar->GetMemorySize();
	}

	push_back( pVar );
}
