#include "stdafx.h"

#include "common.h"
#include "DebugSection.h"


//fobOp
#include "../BasicCompiler_Common/debug.h"


extern HANDLE hDebugProcess;

CDebugThreadInfo *pobj_dti;

CDebugThreadInfo::CDebugThreadInfo(){
	memset(this,0,sizeof(CDebugThreadInfo));
}
CDebugThreadInfo::~CDebugThreadInfo(){
	Free();
}

BOOL CDebugThreadInfo::Reflesh(int ThreadNum){
	Free();

	ULONG_PTR lpData;
	ULONG_PTR lpAccBytes;

	DWORD dwRWSectionPos;
	dwRWSectionPos=pobj_DBDebugSection->ppobj_ds[0]->dwImageBase+
						pobj_DBDebugSection->ppobj_ds[0]->dwRVA_RWSection;

	ReadProcessMemory(hDebugProcess,
		(void *)(dwRWSectionPos+sizeof(DWORD)*256+ThreadNum*sizeof(DWORD)),
		&iProcLevel,
		sizeof(DWORD),&lpAccBytes);
	lplpObp=(ULONG_PTR *)HeapAlloc(hHeap,0,(iProcLevel+1)*sizeof(ULONG_PTR));
	lplpSpBase=(ULONG_PTR *)HeapAlloc(hHeap,0,(iProcLevel+1)*sizeof(ULONG_PTR));
	lpdwCp=(DWORD *)HeapAlloc(hHeap,0,(iProcLevel+1)*sizeof(DWORD));
	this->relationalObjectModuleIndexes.resize( iProcLevel + 1 );

	//lplpObp
	ReadProcessMemory(hDebugProcess,
		(void *)(dwRWSectionPos+sizeof(DWORD)*256*2+ThreadNum*sizeof(DWORD)),
		&lpData,
		sizeof(ULONG_PTR),&lpAccBytes);
	ReadProcessMemory(hDebugProcess,
		(void *)lpData,
		lplpObp,
		(iProcLevel+1)*sizeof(ULONG_PTR),&lpAccBytes);

	//lplpSpBase
	ReadProcessMemory(hDebugProcess,
		(void *)(dwRWSectionPos+sizeof(DWORD)*256*2+sizeof(ULONG_PTR)*256+ThreadNum*sizeof(ULONG_PTR)),
		&lpData,
		sizeof(ULONG_PTR),&lpAccBytes);
	ReadProcessMemory(hDebugProcess,
		(void *)lpData,
		lplpSpBase,
		(iProcLevel+1)*sizeof(ULONG_PTR),&lpAccBytes);

	//݂̎s
	CONTEXT Context;
	Context.ContextFlags=CONTEXT_CONTROL;
	GetThreadContext(array_hDebugThread[ThreadNum],&Context);


	//}bsOĂ郂W[̃C[Wx[X擾
	HMODULE array_hModule[1024];
	DWORD cbReturned;
	if(!EnumProcessModules( hDebugProcess, array_hModule, sizeof(HMODULE)*1024, &cbReturned )) return 0;

	int i;
	HMODULE hTargetModule=0;
	for(i=0;i<(int)(cbReturned/sizeof(HMODULE));i++){
		if((LONG_PTR)array_hModule[i]<=(LONG_PTR)EIP_RIP(Context)){
			if(hTargetModule<array_hModule[i]) hTargetModule=array_hModule[i];
		}
	}

	extern DWORD ImageBase;
	if((HMODULE)(ULONG_PTR)ImageBase!=hTargetModule){
		for(i=0;i<pobj_DBDebugSection->num;i++){
			if((HMODULE)(ULONG_PTR)pobj_DBDebugSection->ppobj_ds[i]->dwImageBase==hTargetModule){
				pobj_DBDebugSection->choice(i);
				break;
			}
		}
	}



	extern int MemPos_CodeSection;
	extern int FileSize_CodeSection;

	if(ImageBase+MemPos_CodeSection <= EIP_RIP(Context) &&
		EIP_RIP(Context) < ImageBase+MemPos_CodeSection+FileSize_CodeSection){
		lplpObp[iProcLevel]=EIP_RIP(Context);
		lplpSpBase[iProcLevel]=SP_BASE(Context);
	}
	//else API֐Ȃǂ̏ꍇ͊ lplpObp[iProcLevel] 𗘗p

	return 1;
}

void CDebugThreadInfo::Free(void){
	if(lplpObp){
		HeapDefaultFree(lplpObp);
		HeapDefaultFree(lplpSpBase);
		HeapDefaultFree(lpdwCp);
		relationalObjectModuleIndexes.clear();
	}

	memset(this,0,sizeof(CDebugThreadInfo));
}
