#include "stdafx.h"

using namespace ActiveBasic::Compiler;

Compiler compiler;

Compiler::Compiler()
	: isBuildSuccessful( false )
	, targetModuleType( ActiveBasic::Common::TargetModuleType::Exe )
	, isDebug( false )
	, isUnicode( false )
	, isCore( false )
	, currentRelationalObjectModuleIndexForSource( 0 )
{
	// ̃IuWFNgW[o^
	ObjectModule *pObjectModule = new ObjectModule();
	staticLibraries.push_back( pObjectModule );
	SelectObjectModule( pObjectModule );

	namespaceSupporter.RegistAllNamespaceScopesCollection( &GetObjectModule().meta.GetNamespaces() );

	Symbol::RegistNamespaceSupporter( &namespaceSupporter );
}
Compiler::~Compiler()
{
	BOOST_FOREACH( ObjectModule *pStaticLibrary, staticLibraries )
	{
		delete pStaticLibrary;
	}
	staticLibraries.clear();
}

void Compiler::PreStaticLink( const ObjectModules &staticLibraries )
{
	BOOST_FOREACH( const ObjectModule *pStaticLibrary, staticLibraries )
	{
		// ֘AIuWFNgW[̖OXg
		this->GetObjectModule().relationalObjectModuleNames.push_back( pStaticLibrary->GetName() );
	}
}
void Compiler::StaticLink( ObjectModules &staticLibraries )
{
	BOOST_FOREACH( ObjectModule *pStaticLibrary, staticLibraries )
	{
		if( &this->GetObjectModule() == pStaticLibrary )
		{
			// g̏ꍇ̓NȂ
			continue;
		}

		// ^
		this->GetObjectModule().StaticLink( *pStaticLibrary );
	}
}

ActiveBasic::Compiler::Error::StringToTypeErrorCode::EnumType Compiler::StringToGenericTypeEx( const std::string &typeName, Type &type )
{
	// WFlbNNXCX^X^̏ꍇ
	int i = 0;
	char className[VN_SIZE];
	GetIdentifierToken( className, typeName.c_str(), i );

	// WFlNXNX擾
	const CClass *pGenericClass = this->GetObjectModule().meta.FindClassSupportedTypeDef( 
		LexicalAnalyzer::FullNameToSymbol( className )
	);

	if( !pGenericClass )
	{
		return ActiveBasic::Compiler::Error::StringToTypeErrorCode::NotfoundGenericClass;
	}

	if( typeName[i] != '<' )
	{
		Jenga::Throw( "StringToTypeŃWFlNX\̉͂Ɏs" );
	}

	GenericTypes genericTypes;
	bool isValueType = false;
	while( true )
	{
		i++;

		char typeParameterStr[VN_SIZE];
		GetIdentifierToken( typeParameterStr, typeName.c_str(), i );

		// ^p[^̌^擾
		Type typeParameterType;
		StringToType( typeParameterStr, typeParameterType );

		genericTypes.push_back( GenericType( "(non support)", typeParameterType ) );

		if( typeParameterType.IsValueType() )
		{
			// l^̏ꍇ
			isValueType = true;
		}

		if( typeName[i] != ',' )
		{
			break;
		}
	}

	// {^Zbg
	type.SetBasicType( DEF_OBJECT );

	if( isValueType )
	{
		// ^p[^ɒl^w肳ꂽꍇ

		// ^p[^^p[^ɕϊ
		Types actualTypes;
		BOOST_FOREACH( const GenericType &genericType, genericTypes )
		{
			actualTypes.push_back( genericType.GetType() );
		}

		// ev[gƂăNXWJ
		const CClass *pExpandedClass = LexicalAnalyzer::TemplateExpand( *const_cast<CClass *>(pGenericClass), actualTypes );

		if( pExpandedClass )
		{
			// gZbg
			type.SetClassPtr( pExpandedClass );
		}
		else
		{
			// TODO: 
			goto Generic;
		}
	}
	else
	{
Generic:
		// ^p[^ɃNX^w肳ꂽꍇ

		// WFlbN NXƂėp

		// gZbg
		type.SetClassPtr( pGenericClass );
		type.SetActualGenericTypes( genericTypes );
	}

	return ActiveBasic::Compiler::Error::StringToTypeErrorCode::Successful;
}
ActiveBasic::Compiler::Error::StringToTypeErrorCode::EnumType Compiler::StringToTypeEx( const std::string &typeName, Type &type, bool isResolveGenerics )
{
	type.SetIndex( -1 );


	/////////////////////////////////////////////////////////
	//  WFlNXT|[g 

	if( strstr( typeName.c_str(), "<" ) )
	{
		return StringToGenericTypeEx( typeName, type );
	}

	//
	/////////////////////////////////////////////////////////


	if( typeName[0] == '*' ){
		if( typeName.size() >= 3
			&& typeName[1] == 1 && ( typeName[2] == ESC_FUNCTION || typeName[2] == ESC_SUB ) )
		{
			// ֐|C^ǉ
			{
				DWORD dwProcType = (DWORD)typeName[2];
				const std::string &paramStr = typeName.substr( 3 );

				Procedure::Kind kind = ( dwProcType == ESC_FUNCTION )
					? Procedure::Function
					: Procedure::Sub;

				ProcPointer *pProcPointer = new ProcPointer( kind );

				//buffer[0]'('ƂȂĂ
				extern int cp;
				ActiveBasic::Compiler::LexicalAnalyzer::SetParamsAndReturnType( pProcPointer, paramStr.c_str(), false, cp );

				this->GetObjectModule().meta.GetProcPointers().push_back( pProcPointer );
			}

			//֐|C^i*Functionj
			type.SetBasicType( DEF_PTR_PROC );
			type.SetIndex( this->GetObjectModule().meta.GetProcPointers().size() - 1 );
			return ActiveBasic::Compiler::Error::StringToTypeErrorCode::Successful;
		}

		const std::string &nextTypeName = typeName.substr( 1 );

		ActiveBasic::Compiler::Error::StringToTypeErrorCode::EnumType result = StringToTypeEx( nextTypeName, type, isResolveGenerics );
		if( result != ActiveBasic::Compiler::Error::StringToTypeErrorCode::Successful )
		{
			return result;
		}

		type.PtrLevelUp();

		return ActiveBasic::Compiler::Error::StringToTypeErrorCode::Successful;
	}

	{
		int basicType;
		if( Type::StringToBasicType( typeName, basicType ) )
		{
			// {^Ƃ
			type.SetBasicType( basicType );
			return ActiveBasic::Compiler::Error::StringToTypeErrorCode::Successful;
		}
	}

	// Object^Ƃ
	if( typeName == "Object" )
	{
		type.SetType( DEF_OBJECT, this->GetObjectModule().meta.GetClasses().GetObjectClassPtr() );
		return ActiveBasic::Compiler::Error::StringToTypeErrorCode::Successful;
	}

	// String^Ƃ
	if( typeName == "String" )
	{
		type.SetType( DEF_OBJECT, this->GetObjectModule().meta.GetClasses().GetStringClassPtr() );
		return ActiveBasic::Compiler::Error::StringToTypeErrorCode::Successful;
	}


	////////////////////
	// TypeDefꂽ^
	////////////////////
	const TypeDef *pTypeDef = this->GetObjectModule().meta.GetTypeDefs().Find( LexicalAnalyzer::FullNameToSymbol( typeName ) );
	if( pTypeDef )
	{
		type = pTypeDef->GetBaseType();

		if( type.IsObject() )
		{
			if( isResolveGenerics && !type.HasActualGenericType() )
			{
				// WFlbNNX̏ꍇ
				trace( "^ĂȂ" );
				return ActiveBasic::Compiler::Error::StringToTypeErrorCode::FailedResolveGenericType;
			}
		}

		return ActiveBasic::Compiler::Error::StringToTypeErrorCode::Successful;
	}

	//NX
	const CClass *pobj_c = this->GetObjectModule().meta.FindClassSupportedTypeDef( LexicalAnalyzer::FullNameToSymbol( typeName ) );
	if(pobj_c)
	{
		if( isResolveGenerics )
		{
			if( pobj_c->IsGeneric() )
			{
				// WFlbNNX̏ꍇ
				trace( "^ĂȂ" );
				return ActiveBasic::Compiler::Error::StringToTypeErrorCode::FailedResolveGenericType;
			}
		}

		if( pobj_c->IsStructure() )
		{
			type.SetBasicType( DEF_STRUCT );
		}
		else
		{
			type.SetBasicType( DEF_OBJECT );
		}
		type.SetClassPtr( pobj_c );
		return ActiveBasic::Compiler::Error::StringToTypeErrorCode::Successful;
	}


	/////////////////////////////////////////////////////////
	//  WFlNXT|[g 

	// ^p[^
	if( this->IsCompilingClass() )
	{
		// NXɑ郁\bhRpCĂƂ
		int formalTypeIndex = this->GetCompilingClass().GetFormalGenericTypeParameterIndex( typeName );
		if( formalTypeIndex != -1 )
		{
			// RpCNXɂWFlNXp̌^p[^̂Ƃ
			type.SetBasicType( DEF_TYPE_PARAMETER );
			type.SetClassPtr( &this->GetCompilingClass().GetFormalGenericTypes()[formalTypeIndex].GetType().GetClass() );
			type.SetFormalTypeName( typeName );
			type.SetFormalTypeIndex( formalTypeIndex );
			return ActiveBasic::Compiler::Error::StringToTypeErrorCode::Successful;
		}
	}

	//
	/////////////////////////////////////////////////////////

	return ActiveBasic::Compiler::Error::StringToTypeErrorCode::NotfoundType;
}

bool Compiler::StringToType( const std::string &typeName, Type &type )
{
	return ( StringToTypeEx( typeName, type, false ) == ActiveBasic::Compiler::Error::StringToTypeErrorCode::Successful );
}

const std::string Compiler::TypeToString( const Type &type )
{
	if( PTR_LEVEL( type.GetBasicType() ) ){
		//|C^x1ȏ̏ꍇ
		Type tempType( type );
		tempType.PtrLevelDown();

		return (std::string)"*" + TypeToString( tempType );
	}
	else if( type.IsObject() || type.IsStruct() ){
		//IuWFNg܂͍\

		if( !( type.GetIndex() == 0 || type.GetIndex() == -1 ) ){
			if( type.GetClass().GetNamespaceScopes().size() >= 1 )
			{
				return type.GetClass().GetNamespaceScopes().ToString() + "." + type.GetClass().GetName();
			}
			return type.GetClass().GetName();
		}
	}
	else if( type.IsProcPtr() ){
		if( type.GetIndex() == 0 || type.GetIndex() == -1 ){
			return "VoidPtr";
		}
		else{
			if( this->GetObjectModule().meta.GetProcPointers()[type.GetIndex()]->ReturnType().IsNull() ){
				return "*Sub";
			}
			return "*Function";
		}
	}
	else{
		// {^
		const char *lpszTypeName = Type::BasicTypeToCharPtr( type );
		if( lpszTypeName )
		{
			return (const std::string)lpszTypeName;
		}
	}

	compiler.errorMessenger.Output(1, NULL, cp);

	return (std::string)"(null)";
}

void Compiler::ClearCompilingUserProcAndClass()
{
	this->pCompilingUserProc = NULL;
	this->pCompilingClass = NULL;
}

void Compiler::SetCompilingClass( const CClass *pClass )
{
	this->pCompilingClass = pClass;
}

void Compiler::SetCompilingUserProc( const UserProc *pUserProc )
{
	this->pCompilingUserProc = pUserProc;

	this->SetCompilingClass( pUserProc->GetParentClassPtr() );
}

void Compiler::StartGlobalAreaCompile()
{
	ClearCompilingUserProcAndClass();
}

void Compiler::StartProcedureCompile( const UserProc *pUserProc )
{
	//RpC̊֐
	this->SetCompilingUserProc( pUserProc );

	if( pUserProc->HasParentClass() )
	{
		// NX̎gp`FbN
		pUserProc->GetParentClass().Using();
	}

	// RpC̊֐閼O
	this->GetNamespaceSupporter().SetLivingNamespaceScopes( pUserProc->GetNamespaceScopes() );

	// RpC̊֐ImportsĂ閼O
	this->GetNamespaceSupporter().SetImportedNamespaces( pUserProc->GetImportedNamespaces() );

	// R[hΏۂI
	this->codeGenerator.Select( (const_cast<UserProc *>(pUserProc))->GetNativeCode() );
}
void Compiler::FinishProcedureCompile()
{
	this->pCompilingUserProc = NULL;
	this->pCompilingClass = NULL;
}

bool Compiler::IsGlobalAreaCompiling()
{
	return ( pCompilingUserProc == NULL );
}
bool Compiler::IsLocalAreaCompiling()
{
	return ( pCompilingUserProc != NULL );
}
const UserProc &Compiler::GetCompilingUserProc()
{
	if( !this->IsGlobalAreaCompiling() )
	{
		return *pCompilingUserProc;
	}

	throw;
}

bool Compiler::IsCompilingClass()
{
	return ( pCompilingClass != NULL );
}
const CClass &Compiler::GetCompilingClass()
{
	if( this->IsCompilingClass() )
	{
		return *pCompilingClass;
	}

	throw;
}
