#include "stdafx.h"

Jenga::Common::Logger Program::logger( Jenga::Common::Environment::GetAppDir() + "\\logger.log", true );

Program program;

void Program::Configurate()
{
	Configuration configuration;
	const std::string filePath = Jenga::Common::Environment::GetAppDir() + "\\config.xml";
	if( Jenga::Common::Path( filePath ).IsExistFile() )
	{
		configuration.ReadXml( filePath );
	}
	else
	{
		configuration.WriteXml( filePath );
	}

	ActiveBasic::Common::Environment::SetAbdevRootPath( configuration.GetAbdevRootRelativePath() );
}

bool Program::AnalysisCommandLines()
{
	// R}hC
	const Jenga::Common::CmdLines cmdLines( PathGetArgs( GetCommandLine() ) );
	int cmdLineIndex = 0;

	if( cmdLines.size() == 0 )
	{
		// w肳ĂȂƂ
		return true;
	}

	if( cmdLines[cmdLineIndex].IsNamelessCommand() )
	{
		// 擪ɖR}hꍇA\[Xt@CƂĔF
		std::string tempParam = cmdLines[cmdLineIndex].GetParameter();
		Program::SetSourceFilePath( Jenga::Common::StringReplace( tempParam, "/", "\\" ) );

		cmdLineIndex ++;

		if( cmdLines.size() == 1 )
		{
			// \[Xt@Ĉ݂̎w肾Ƃ
			return true;
		}

		// o̓t@C擾
		if( cmdLines[cmdLineIndex].IsNamelessCommand() )
		{
			// ԖڂɂR}hꍇAo̓t@CƂĔF
			std::string tempParam = cmdLines[cmdLineIndex].GetParameter();
			SetOutputFilePath( Jenga::Common::StringReplace( tempParam, "/", "\\" ) );

			cmdLineIndex ++;
		}
	}

	for( ; cmdLineIndex < static_cast<int>(cmdLines.size()); cmdLineIndex++ )
	{
		const Jenga::Common::CmdLine &cmdLine = cmdLines[cmdLineIndex];

		if( cmdLine.GetCommand() == "wnd" )
		{
			// eGfB^̃EBhE nh
			isKickedFromEditor = true;
			sscanf( cmdLine.GetParameter().c_str(), "%08x", &hOwnerEditor );
		}
		else if( cmdLine.GetCommand() == "show_dlg" )
		{
			isShowDlg = true;
		}
		else if( cmdLine.GetCommand() == "debug" )
		{
			// fobO rh
			compiler.SetDebugMark( true );
		}
		else if( cmdLine.GetCommand() == "run" )
		{
			// fobOs
			isDebugRun = true;
		}
		else if( cmdLine.GetCommand() == "attach" )
		{
			// A^b`
			isDebugRun = true;
			isAttach = true;
			sscanf( cmdLine.GetParameter().c_str(), "%08x", &attachProcessId );
		}
		else if( cmdLine.GetCommand() == "dll" )
		{
			// DLLƂărh
			compiler.SetTargetModuleType( ActiveBasic::Common::TargetModuleType::Dll );
		}
		else if( cmdLine.GetCommand() == "static_library" )
		{
			// ÓINCuƂărh
			compiler.SetTargetModuleType( ActiveBasic::Common::TargetModuleType::Sll );
		}
		else if( cmdLine.GetCommand() == "unicode" )
		{
			// Unicode
			compiler.SetUnicodeMark( true );
			typeOfPtrChar = MAKE_PTR_TYPE(DEF_WORD,1);
			typeOfPtrUChar = MAKE_PTR_TYPE(DEF_WORD,1);
		}
		else if( cmdLine.GetCommand() == "clip_compile_view" )
		{
			//ߍ݌^RpCr[
			isClipCompileView = true;
		}
		else if( cmdLine.GetCommand() == "include_dir" )
		{
			//CN[h fBNg
			includeDir = cmdLines[cmdLineIndex].GetParameter();

			// '/' ꍇ '\\' ɒu
			Jenga::Common::StringReplace( includeDir, "/", "\\" );
		}
		else if( cmdLine.GetCommand() == "?" || cmdLine.GetCommand() == "help" )
		{
			std::cout << "TODO: ActiveBasic command line help." << std::endl;
		}
		else
		{
			// sȃR}h
			std::string keyword = cmdLine.GetCommand();
			if( keyword.size() == 0 )
			{
				keyword = cmdLine.GetParameter();
			}
			std::cout << keyword << " R}hƂĔFł܂B" << std::endl;
			return false;
		}
	}

	return true;
}

int Program::GetExitCode() const
{
	if( !compiler.IsBuildSuccessful() )
	{
		// rhɎs
		return 1;
	}

	// rhɐ
	return 0;
}
