#include "stdafx.h"

TypeDef::TypeDef( const NamespaceScopes &namespaceScopes, const std::string &name, const std::string &baseName, const Type &baseType )
	: Symbol( namespaceScopes, name )
	, baseName( baseName )
	, baseType( baseType )
{
}

TypeDefCollection::TypeDefCollection(){
}
TypeDefCollection::~TypeDefCollection(){
}
void TypeDefCollection::Add( const NamespaceScopes &namespaceScopes, const std::string &name, const std::string &baseName, int nowLine ){
	TypeDef typeDef( namespaceScopes, name, baseName, nowLine );
	this->push_back( typeDef );
}

const TypeDef *TypeDefCollection::Find( const Symbol &symbol ) const
{
	const TypeDefCollection &typeDefs = *this;
	BOOST_FOREACH( const TypeDef &typeDef, typeDefs )
	{
		if( typeDef.IsEqualSymbol( symbol ) )
		{
			return &typeDef;
		}
	}
	return NULL;
}
