#include "stdafx.h"

using namespace ActiveBasic::Common::Lexical;

const NamespaceSupporter *Symbol::namespaceSupporter = NULL;

char *calcNames[256] = {
	"xor",
};
void InitCalcNames()
{
	if( calcNames[CALC_XOR] )
	{
		return;
	}

	memset( calcNames, 0, 255 * sizeof(char *) );
	calcNames[CALC_XOR] = "xor";
	calcNames[CALC_OR] = "or";
	calcNames[CALC_AND] = "and";
	calcNames[CALC_NOT] = "Not";
	calcNames[CALC_PE] = "<=";
	calcNames[CALC_QE] = ">=";
	calcNames[CALC_NOTEQUAL] = "<>";
	calcNames[CALC_EQUAL] = "=(compare)";
	calcNames[CALC_P] = "<";
	calcNames[CALC_Q] = ">";
	calcNames[CALC_SHL] = "<<";
	calcNames[CALC_SHR] = ">>";
	calcNames[CALC_ADDITION] = "+";
	calcNames[CALC_SUBTRACTION] = "-";
	calcNames[CALC_STRPLUS] = "&";
	calcNames[CALC_MOD] = "mod";
	calcNames[CALC_PRODUCT] = "*";
	calcNames[CALC_QUOTIENT] = "/";
	calcNames[CALC_INTQUOTIENT] = "\\";
	calcNames[CALC_AS] = "As";
	calcNames[CALC_BYVAL] = "ByVal";
	calcNames[CALC_MINUSMARK] = "-(mark)";
	calcNames[CALC_POWER] = "^";
	calcNames[CALC_SUBSITUATION] = "=";
	calcNames[CALC_ARRAY_GET] = "[]";
	calcNames[CALC_ARRAY_SET] = "[]=";
}
void GetCalcName(int idCalc,char *name){
	InitCalcNames();

	if( calcNames[idCalc] == NULL )
	{
		throw;
	}

	lstrcpy( name, calcNames[idCalc] );
}

std::string ActiveBasic::Common::Lexical::Operator_CalcMarkStringToNaturalString( const std::string &name )
{
	if( name[0] == 1 && name[1] == ESC_OPERATOR )
	{
		BYTE calcId = name[2];
		char temporary[255], calcName[255];
		GetCalcName( calcId, calcName );
		temporary[0] = name[0];
		temporary[1] = name[1];
		lstrcpy( temporary+2, calcName );
		return temporary;
	}
	return name;
}

BYTE ToCalcId( const char *name )
{
	InitCalcNames();

	for( int i=0; i<255; i++ )
	{
		if( calcNames[i] )
		{
			if( lstrcmp( name, calcNames[i] ) == 0 )
			{
				return i;
			}
		}
	}

	throw;
}

std::string ActiveBasic::Common::Lexical::Operator_NaturalStringToCalcMarkString( const std::string &name )
{
	if( name[0] == 1 && name[1] == ESC_OPERATOR )
	{
		BYTE calcId = ToCalcId( name.c_str()+2 );
		char temporary[255];
		temporary[0] = name[0];
		temporary[1] = name[1];
		temporary[2] = calcId;
		temporary[3] = 0;
		return temporary;
	}
	return name;
}

std::string Symbol::GetFullName() const
{
	if( namespaceScopes.size() )
	{
		return namespaceScopes.ToString() + "." + name;
	}

	return name;
}

bool Symbol::IsEqualSymbol( const NamespaceScopes &namespaceScopes, const std::string &name ) const
{
	if( GetName() != name ){
		return false;
	}

	_ASSERTE( namespaceSupporter );
	return namespaceSupporter->IsSameAreaNamespace( GetNamespaceScopes(), namespaceScopes );
}
bool Symbol::IsEqualSymbol( const Symbol &symbol ) const
{
	if( IsEqualSymbol( symbol.GetNamespaceScopes(), symbol.GetName() ) )
	{
		return true;
	}

	if( symbol.GetNamespaceScopes().size() >= 1 )
	{
		// ÓIol
		NamespaceScopes namespaceScopes( symbol.GetNamespaceScopes() );
		std::string name = namespaceScopes[namespaceScopes.size()-1] + "." + symbol.GetName();
		namespaceScopes.pop_back();

		return IsEqualSymbol( namespaceScopes, name );
	}
	return false;
}
