#include "stdafx.h"

int id_base = 0;

UserProc::UserProc( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const std::string &name, Kind kind, bool isMacro, bool isCdecl, bool isExport )
	: Procedure( namespaceScopes, name, kind, isCdecl )
	, importedNamespaces( importedNamespaces )
	, pParentClass( NULL )
	, pInterface( NULL )
	, pMethod( NULL )
	, isMacro( isMacro )
	, secondParmNum( 0 )
	, realSecondParmNum( 1 )
	, isExport( isExport )
	, isSystem( false )
	, isAutoGeneration( false )
	, isCompiled( false )
	, beginOpAddress( 0 )
	, endOpAddress( 0 )
	, id( id_base ++ )
{
}

UserProc::UserProc( const UserProc &userProc, const CClass *pParentClass )
	: Procedure( userProc )
	, _paramStr( userProc._paramStr )
	, importedNamespaces( userProc.importedNamespaces )
	, pParentClass( pParentClass )
	, pInterface( NULL )
	, pMethod( NULL )
	, isMacro( userProc.isMacro )
	, secondParmNum( userProc.secondParmNum )
	, realParams( userProc.realParams )
	, realSecondParmNum( userProc.realSecondParmNum )
	, isExport( userProc.isExport )
	, isSystem( userProc.isSystem )
	, isAutoGeneration( userProc.isAutoGeneration )
	, isCompiled( false )
	, beginOpAddress( 0 )
	, endOpAddress( 0 )
	, localVars( Variables() )
	, id( id_base ++ )
	, nativeCode( NativeCode() )
{
}

UserProc::UserProc()
{
}

UserProc::~UserProc()
{
	BOOST_FOREACH( Parameter *pParam, realParams ){
		delete pParam;
	}
}

bool UserProc::IsEqualForOverride( const Types &actualTypeParametersForThisProc, const UserProc *pUserProc ) const
{
	if( this->GetName() == pUserProc->GetName()						// OԋyіO
		&& this->Params().Equals( actualTypeParametersForThisProc, pUserProc->Params() ) )			// p[^
	{
		if( this->returnType.Equals( pUserProc->returnType ) )
		{
			// ߂l
			return true;
		}
		else if( this->returnType.IsCovariant( pUserProc->returnType ) )
		{
			// ߂l
			return true;
		}
		else if( this->returnType.IsTypeParameter() )
		{
			// ^p[^Ƃ

			if( actualTypeParametersForThisProc[this->returnType.GetFormalTypeIndex()].Equals( pUserProc->returnType ) )
			{
				// ߂l
				return true;
			}
			else if( actualTypeParametersForThisProc[this->returnType.GetFormalTypeIndex()].IsCovariant( pUserProc->returnType ) )
			{
				// ߂l
				return true;
			}
		}
	}
	return false;
}
	

std::string UserProc::GetFullName() const
{
	if( HasParentClass() ){
		return GetParentClass().GetName() + "." + GetName();
	}

	return GetName();
}
bool UserProc::IsCastOperator() const
{
	if( GetName()[0] == 1 && GetName()[1] == ESC_OPERATOR && GetName()[2] == CALC_AS )
	{
		return true;
	}
	return false;
}
const NamespaceScopes &UserProc::GetNamespaceScopes() const
{
	if( HasParentClass() )
	{
		return GetParentClassPtr()->GetNamespaceScopes();
	}
	return Symbol::GetNamespaceScopes();
}
const NamespaceScopesCollection &UserProc::GetImportedNamespaces() const
{
	if( pParentClass )
	{
		return pParentClass->GetImportedNamespaces();
	}
	return importedNamespaces;
}
bool UserProc::IsVirtual() const
{
	if( pMethod == NULL ){
		return false;
	}
	return ( pMethod->IsVirtual() != 0 );
}
const CMethod &UserProc::GetMethod() const
{
	if( !HasParentClass() )
	{
		Jenga::Throw( "O[o֐ɑ΂UserProc::GetMethod\bhĂ΂ꂽ" );
	}
	return *pMethod;
}

const UserProc *UserProc::pGlobalProc = NULL;


void UserProcs::EnumGlobalProcs( const char *simpleName, const Symbol &localSymbol, std::vector<const UserProc *> &subs )
{
	///////////////////////////
	// O[o֐
	///////////////////////////

	// nbVl擾
	UserProc *pUserProc = GetHashArrayElement( simpleName );
	while(pUserProc){
		if( pUserProc->IsGlobalProcedure() ){
			if( pUserProc->IsEqualSymbol( localSymbol ) ){
				subs.push_back( pUserProc );
			}
		}

		pUserProc=pUserProc->GetChainNext();
	}
}

void ProcPointers::Clear()
{
	ProcPointers &procPointers = *this;
	BOOST_FOREACH( ProcPointer *pProcPointer, procPointers ){
		delete pProcPointer;
	}
	this->clear();
}
