#include "stdafx.h"


Member::Member( Prototype::Accessibility accessibility, const std::string &name, const Type &newType, bool isConst, const Subscripts &subscripts, const std::string &initializeExpression, const std::string &constructParameter )
	: MemberPrototype( accessibility )
	, name( name )
	, type( newType )
	, isConst( isConst )
	, subscripts( subscripts )
	, initializeExpression( initializeExpression )
	, constructParameter( constructParameter )
{
}

Member::Member( const Member &member )
	: MemberPrototype( member.GetAccessibility() )
	, name( member.GetName() )
	, type( member.GetType() )
	, isConst( member.IsConst() )
	, subscripts( member.GetSubscripts() )
	, source_code_address( member.source_code_address )
{
}

Member::Member( const Member &member, const Type &actualType )
	: MemberPrototype( member.GetAccessibility() )
	, name( member.GetName() )
	, type( actualType )
	, isConst( member.IsConst() )
	, subscripts( member.GetSubscripts() )
	, source_code_address( member.source_code_address )
{
}

Member::Member()
{
}

Member::~Member()
{
}