#include "stdafx.h"

#include "common.h"

CHistory::CHistory(int BaseID){
	iNum=0;
	iMaxHistoryNum=15;

	m_BaseID=BaseID;
}
CHistory::~CHistory(){
	int i;
	for(i=0;i<iNum;i++){
		HeapDefaultFree(lpszPath[i]);
	}
}

void CHistory::load(char *path){
	char temporary[MAX_PATH];

	char *buffer;
	buffer=ReadBuffer_NonErrMsg(path);
	if(buffer){
		int i;
		i=0;
		while(buffer[i]){
			//\
			i=GetOneParameter(buffer,i,temporary);
			if(temporary[0]=='\0') break;

			if(buffer[i]=='\r'&&buffer[i+1]=='\n'){
				i+=2;
			}

			add(temporary);
		}
		HeapDefaultFree(buffer);
	}
}
void CHistory::save(char *path){
	char *buffer;
	buffer=(char *)HeapAlloc(hHeap,0,iNum*MAX_PATH+1);
	buffer[0]=0;

	int i;
	for(i=0;i<iNum;i++){
		sprintf(buffer+lstrlen(buffer),"%s\r\n",lpszPath[i]);
	}

	WriteBuffer(path,buffer,lstrlen(buffer));

	HeapDefaultFree(buffer);
}
void CHistory::add(char *path){
	lpszPath[iNum]=(char *)HeapAlloc(hHeap,0,lstrlen(path)+1);
	lstrcpy(lpszPath[iNum],path);
	iNum++;
}
void CHistory::insert(const char *path){
	//d`FbN
	int i;
	for(i=0;i<iNum;i++){
		if(lstrcmpi(path,lpszPath[i])==0) break;
	}
	if(i==iNum){
		//[e[V
		for(i=iNum;i>0;i--){
			lpszPath[i]=lpszPath[i-1];
		}

		if(iNum+1 == iMaxHistoryNum){
			//ԌÂ폜
			HeapDefaultFree(lpszPath[iNum]);
		}
		else iNum++;
	}
	else{
		//[e[V
		HeapDefaultFree(lpszPath[i]);

		for(;i>0;i--){
			lpszPath[i]=lpszPath[i-1];
		}
	}

	lpszPath[0]=(char *)HeapAlloc(hHeap,0,lstrlen(path)+1);
	lstrcpy(lpszPath[0],path);
}

void CHistory::ResetFileMenu(CSubMenuEx *pobj_SubMenu,BOOL bOwnerDraw){
	//Âj[ACe
	while(0<pobj_SubMenu->iMenuItemNum){
		pobj_SubMenu->RemoveItem(0);
	}

	if(iNum==0){
		//Ȃ
		pobj_SubMenu->InsertItem(0,100,"Ȃ");
		pobj_SubMenu->EnableItem(100,MF_BYCOMMAND|MF_GRAYED);
		return;
	}


	int i;
	for(i=0;i<iNum;i++){
		//}
		pobj_SubMenu->InsertItem(i,m_BaseID+i,lpszPath[i]);

		//ACRZbgilbg[NhCũt@C͎擾ɎԂ邽߁AOj
		if( !Jenga::Common::Path( lpszPath[i] ).IsNetworkPath() )
		{
			if(IsExistFile(lpszPath[i])){
				SHFILEINFO shfi;
				SHGetFileInfo( lpszPath[i], FILE_ATTRIBUTE_ARCHIVE, &shfi, sizeof(SHFILEINFO), SHGFI_ICON | SHGFI_SMALLICON );

				if(shfi.hIcon){
					pobj_SubMenu->SetIcon(m_BaseID+i,shfi.hIcon);
				}
			}
		}
	}
}
