#pragma once

namespace Jenga{
namespace Common{


class Path
{
	std::string fullPath;
	std::string driveName;
	std::string dirName;
	std::string fileName;
	std::string ext;

	void Expand()
	{
		char szDrive[32], szDir[1024], szFile[1024], szExt[255];
		_splitpath_s( fullPath.c_str(), szDrive, 32, szDir, 1024, szFile, 1024, szExt, 255 );
		driveName = szDrive;
		dirName = szDir;
		fileName = szFile;
		ext = szExt;
	}

public:
	Path( const std::string &fullPath )
		: fullPath( fullPath )
	{
		Expand();
	}
	~Path()
	{
	}

	bool IsExistFile() const;

	const std::string &GetDriveName() const
	{
		return driveName;
	}
	const std::string &GetDirName() const
	{
		return dirName;
	}
	const std::string &GetFileName() const
	{
		return fileName;
	}
	const std::string &GetExt() const
	{
		return ext;
	}
	const std::string &GetFullPath() const
	{
		return fullPath;
	}
	bool IsNetworkPath() const
	{
		if( fullPath.size() < 2 )
		{
			return false;
		}
		return ( ( fullPath[0] == '\\' ) && ( fullPath[1] == '\\' ) );
	}

	static std::string MakeFullPath( const std::string &relativePath, const std::string &baseDirPath );
	static std::string MakeFullPathByCurrentDirectory( const std::string &relativePath );
	static std::string ExtractDirPath( const std::string &path );
};


}}
