#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void FreeTempObject(int reg,CClass *pobj_c){
	if(!IsSafeReg(reg)) SetError(300,NULL,cp);

	CMethod *method = pobj_c->GetDestructorMethod();
	if( method ){
		//push reg
		op_push(reg);

		//call DestructorProcAddr
		op_call( method->psi );
	}

	//push reg
	op_push(reg);

	//call free
	extern SUBINFO *pSub_free;
	op_call(pSub_free);
}

int CallOperatorProc(int idCalc,TYPEINFO *pBaseTypeInfo,int *type,LONG_PTR *index_stack,BOOL *bUseHeap,int &sp){
	//I[o[[hꂽIy[^֐Ăяo
	CClass *pobj_c;
	pobj_c=(CClass *)index_stack[sp-2];

	std::vector<SUBINFO *> subs;
	pobj_c->EnumMethod( idCalc, subs );
	if( subs.size() == 0 ){
		return 0;
	}


	//̐
	BOOL bTwoTerm=1;
	if(idCalc==CALC_AS) bTwoTerm=0;


	int i;
	BOOL bReturnTypeIsObject=1;
	TYPEINFO ReturnType={DEF_OBJECT,subs[0]->u.ReturnIndex};
	foreach( SUBINFO *psi, subs ){
		if(psi->ReturnType!=DEF_OBJECT)
			bReturnTypeIsObject=0;
	}

	if(bReturnTypeIsObject==0){
		if(pBaseTypeInfo){
			if(pBaseTypeInfo->type==DEF_OBJECT){
				bReturnTypeIsObject=1;
				ReturnType.u.lpIndex=pBaseTypeInfo->u.lpIndex;
			}
		}
	}



	/////////////////////////////////////////////
	// I[o[[hp̃p[^ݒ
	/////////////////////////////////////////////

	PARAMETER_INFO *ppi = (PARAMETER_INFO *)HeapAlloc(hHeap,0,sizeof(PARAMETER_INFO)*3);
	int iParmNum=0;

	if(bTwoTerm){
		ppi[iParmNum].bArray=0;
		ppi[iParmNum].bByVal=0;
		ppi[iParmNum].name=0;
		ppi[iParmNum].type=type[sp-1];
		ppi[iParmNum].u.index=index_stack[sp-1];
		ppi[iParmNum].SubScripts[0]=-1;
		iParmNum++;
	}


	//I[o[[h
	char temporary[255];
	if(idCalc==CALC_EQUAL) lstrcpy(temporary,"==");
	else GetCalcName(idCalc,temporary);
	SUBINFO *psi;
	psi=OverloadSolution(temporary,subs,ppi,iParmNum,pBaseTypeInfo);

	if(!psi){
		HeapDefaultFree(ppi);
		return -1;
	}
	else{
		//I[o[[hĂȂAp[^vȂƂ
		if(iParmNum!=psi->ParmNum){
			HeapDefaultFree(ppi);
			return -1;
		}
	}

	for(i=0;i<iParmNum;i++){
		CheckDifferentType(
			psi->pParmInfo[i].type,
			psi->pParmInfo[i].u.index,
			ppi[i].type,
			ppi[i].u.index,
			"",
			i);
	}

	HeapDefaultFree(ppi);

	int right_side_size;
	if(type[sp-1]==DEF_OBJECT) right_side_size=PTR_SIZE;
	else right_side_size=GetTypeSize(type[sp-1],index_stack[sp-1]);

	if(bTwoTerm){
		if(psi->pParmInfo[1].type==DEF_OBJECT&&psi->pParmInfo[1].bByVal){
			//ꎞIuWFNg̓\bhŔj
			bUseHeap[sp-1]=0;
		}
	}


	if(psi->ReturnType==DEF_OBJECT){
		//////////////////////////////////////////////////////
		// ߂lɃIuWFNg CX^Xꍇ
		// ByRef _System_ReturnObject p[^p̈擾
		//////////////////////////////////////////////////////

		int object_size = psi->u.Return_pobj_c->GetSize();

		//push object_size
		op_push_value(object_size);

		//call calloc
		extern SUBINFO *pSub_calloc;
		op_call(pSub_calloc);

		//mov ebx,eax
		op_mov_RR(REG_EBX,REG_EAX);
	}


	//2̍o
	if(bTwoTerm){
		if(right_side_size==sizeof(_int64)){
			//pop eax
			op_pop(REG_EAX);

			//pop edx
			op_pop(REG_EDX);
		}
		else{
			//pop eax
			op_pop(REG_EAX);
		}
	}

	//pop ecx
	op_pop(REG_ECX);


	//q[vpɑޔ
	if(bUseHeap[sp-1]){
		//mov esi,eax
		op_mov_RR(REG_ESI,REG_EAX);
	}
	if(bUseHeap[sp-2]){
		//mov edi,ecx
		op_mov_RR(REG_EDI,REG_ECX);
	}



	if(bTwoTerm){
		if(right_side_size==sizeof(_int64)){
			//push edx
			op_push(REG_EDX);

			//push eax
			op_push(REG_EAX);
		}
		else{
			//push eax
			op_push(REG_EAX);
		}
	}

	if(psi->ReturnType==DEF_OBJECT){
		//push ebx
		op_push(REG_EBX);
	}

	//push ecx
	op_push(REG_ECX);

	//call operator_proc
	op_call(psi);

	if(psi->ReturnType!=-1){
		//X^bNփvbV
		PushReturnValue(psi->ReturnType);
	}

	if(bUseHeap[sp-1]){
		FreeTempObject(REG_ESI,(CClass *)index_stack[sp-1]);
	}
	if(bUseHeap[sp-2]){
		FreeTempObject(REG_EDI,(CClass *)index_stack[sp-2]);
	}

	sp--;
	type[sp-1]=psi->ReturnType;
	index_stack[sp-1]=psi->u.ReturnIndex;

	if(psi->ReturnType==DEF_OBJECT){
		//Object^߂Ƃ̓q[v̈ɃCX^Xi[Ă
		//freeKv
		bUseHeap[sp-1]=1;
	}
	else bUseHeap[sp-1]=0;

	return 1;
}

void CallCastOperatorProc(int &CalcType,LONG_PTR &lpCalcIndex,BOOL bCalcUseHeap,int ToType,LONG_PTR lpToIndex){
	int type[10];
	LONG_PTR index_stack[10];
	BOOL array_bUseHeap[10];
	int sp=2;

	if(bCalcUseHeap){
		//̃CX^X݂|x
		SetError(-105,NULL,cp);
	}

	//
	type[0]=CalcType;
	index_stack[0]=lpCalcIndex;
	array_bUseHeap[0]=0;
	type[1]=ToType;
	index_stack[1]=lpToIndex;
	array_bUseHeap[1]=0;

	TYPEINFO BaseTypeInfo={ToType,lpToIndex};

	int iRet;
	iRet=CallOperatorProc(CALC_AS,&BaseTypeInfo,type,index_stack,array_bUseHeap,sp);
	if(iRet==1){
		//Ƃ
		CalcType=type[0];
		lpCalcIndex=index_stack[0];
		return;
	}
	else if(iRet==-1){
		//G[sꂽƂ
		return;
	}

	//G[𔭍s
	SetError(-1,"LXgZqI[o[[hĂ܂B",cp);
}
void CallIndexerGetterProc(CClass *pobj_Class,char *ObjectName,char *Parameter,TYPEINFO &RetTypeInfo){
	std::vector<SUBINFO *> subs;
	pobj_Class->EnumMethod( CALC_ARRAY_GET, subs );
	if( subs.size() == 0 ){
		return;
	}

	Opcode_CallProc(Parameter,subs[0],0,ObjectName,DEF_OBJECT);
	RetTypeInfo.type = subs[0]->ReturnType;
	RetTypeInfo.u.lpIndex = subs[0]->u.ReturnIndex;
}
