

#define LIGHT_RGB(rgb,ratio) RGB(\
	LOBYTE(LOWORD(rgb))+(BYTE)((double)(255-LOBYTE(LOWORD(rgb)))*ratio),\
	HIBYTE(LOWORD(rgb))+(BYTE)((double)(255-HIBYTE(LOWORD(rgb)))*ratio),\
	LOBYTE(HIWORD(rgb))+(BYTE)((double)(255-LOBYTE(HIWORD(rgb)))*ratio))


#define MENUCOLOR_TEXT			GetSysColor(COLOR_WINDOWTEXT)				//eLXg̐F
#define MENUCOLOR_GRAY_TEXT		GetSysColor(COLOR_GRAYTEXT)		//WFeLXg̐F
#define MENUCOLOR_DEFAULT_LINE	GetSysColor(COLOR_3DDKSHADOW)	//ʏ펞̐̐F
#define MENUCOLOR_DEFAULT_BACK	GetSysColor(COLOR_3DFACE)		//ʏ펞̔wiF
#define MENUCOLOR_HOT_LINE		GetSysColor(COLOR_ACTIVECAPTION)			//zbgԂ̐̐F
#define MENUCOLOR_HOT_BACK		LIGHT_RGB(MENUCOLOR_HOT_LINE,0.7)		//zbgԂ̔wiF
#define MENUCOLOR_SELECT_LINE	MENUCOLOR_DEFAULT_LINE	//IԂ̐̐F
#define MENUCOLOR_SELECT_BACK	GetSysColor(COLOR_MENU)	//IԂ̔wiF


extern HFONT hMenuFont;


class CSubMenuEx;
class CMenuEx;

class CMenuItemData{
public:
	int item_index;
	int itemID;
	LPSTR str;

	CMenuEx *pobj_ThisMenu;
	CSubMenuEx *pobj_SubMenu;

	HICON hIcon;
	HICON hGrayIcon;

	CMenuItemData(int item_index,int itemID,char *str,CMenuEx *pobj_ThisMenu,CSubMenuEx *pobj_SubMenu);
	~CMenuItemData();
};

class CMenuEx{
public:
	HMENU hMenu;

	CMenuEx(HMENU hmenu);
	~CMenuEx();


	//gj[f[^
	CMenuItemData **ppobj_MenuItemData;
	int iMenuItemNum;
	CMenuItemData *AddMenuExItemData(int item_index,int itemID,char *str,CMenuEx *pobj_ThisMenu,CSubMenuEx *pobj_SubMenu);



	void EnableItem(UINT uIDEnableItem,UINT uEnable);

	void CheckMenu(UINT idItem,BOOL bChecked);
	BOOL IsCheck(UINT idItem);

	void RenameMenuItem(int item_index,char *str);
	void RenameMenuItemByID(int itemID,char *str);

	void RemoveItem(int item_index);
	void InsertItem(int item_index,int itemID,char *str);


	//ACR\g
	BOOL SetIcon(int itemID,HICON hIcon);

	int FindSubMenuIndex( const std::string &itemStr );


private:
	CSubMenuEx *AddSubMenu(HMENU hSubMenu);
public:
	// I[i[`֘A
	void InitOwnerDraw(BOOL bParent);
	virtual void GetItemSize(int item_index,SIZE *pSize);
	BOOL OwnerDrawSubMenu(HMENU hSubMenu,HDC hdc,RECT *pRect,BOOL bSelect,int item_index);
	virtual void OwnerDrawMenu(HDC hdc,RECT *pRect,BOOL bSelect,int item_index);
};

class CSubMenuEx:public CMenuEx{
public:
	CSubMenuEx(HMENU hMenu);
	virtual void GetItemSize(int item_index,SIZE *pSize);
	virtual void OwnerDrawMenu(HDC hdc,RECT *pRect,BOOL bSelect,int item_index);
};

extern CMenuEx *pobj_MainMenu;
