#include "stdafx.h"

#include "Common.h"

//^up
BOOL SetSwitch[32];


void SetPosCenter(HWND hParent,HWND hwnd){
	RECT owrect,rect;
	int x,y;

	if(IsWindow(hParent)) GetWindowRect(hParent,&owrect);
	else{
		owrect.left=0;
		owrect.top=0;
		owrect.right=ScreenX;
		owrect.bottom=ScreenY;
	}
	GetWindowRect(hwnd,&rect);
	x=((owrect.right-owrect.left)-(rect.right-rect.left))/2+owrect.left;
	y=((owrect.bottom-owrect.top)-(rect.bottom-rect.top))/2+owrect.top;
	SetWindowPos(hwnd,0,x,y,0,0,SWP_NOSIZE);
}
void SetPosCenter(HWND hwnd){
	SetPosCenter(hOwner,hwnd);
}
BOOL SetFontDialog(HWND hwnd,LOGFONT *lf,BOOL bFixedPitchOnly,int *lpiPointSize){
	CHOOSEFONT cf;
	LOGFONT lfDummy;

	lfDummy=*lf;
	memset(&cf,0,sizeof(CHOOSEFONT));
	cf.lStructSize=sizeof(CHOOSEFONT);
	cf.hwndOwner=hwnd;
	cf.lpLogFont=&lfDummy;
	cf.Flags=CF_SCREENFONTS|CF_INITTOLOGFONTSTRUCT;
	if(bFixedPitchOnly) cf.Flags|=CF_FIXEDPITCHONLY|CF_NOVERTFONTS;
	cf.nFontType=SCREEN_FONTTYPE;
	lstrcpy((char *)cf.lpTemplateName,"Font select");

	if(!ChooseFont(&cf)) return 0;

	memcpy(lf,&lfDummy,sizeof(LOGFONT));

	if(lpiPointSize) *lpiPointSize=cf.iPointSize;

	return 1;
}



//////////////////////////////////
// vWFNgVK쐬EBU[h
//////////////////////////////////

//vWFNg쐬
#if defined(JPN)
//{
#define TEXT_BASE_NORMAL	"m[} EBhEx[XɁAGUIAvP[V쐬܂B"
#define TEXT_BASE_PROMPT	"vvg EBhEx[XɁAN88BASIC݊vO쐬܂B"
#define TEXT_BASE_DOSPROMPT	"R\[ AvP[V쐬܂BWindowsŉғDOSvvgł̓o͂\ɂȂ܂B"
#define TEXT_NOBASE			"̃vWFNg쐬܂B"
#define TEXT_DIRECTX		"DirectXɑΉAvP[V쐬܂B2D܂3D̕`ɍsƂłAQ[AvP[VȂǂ̊JɍœKłB"
#define TEXT_DLL			"_Ci~bN N Cu(DLL)쐬܂B"
#define TEXT_SLL			"ÓI N Cu(lib)쐬܂B"
#else
//p
#define TEXT_BASE_NORMAL	"You can make a GUI application of a normal window base."
#define TEXT_BASE_PROMPT	"You can make a N88 compatible program of a prompt window base."
#define TEXT_BASE_DOSPROMPT	"You can make a console application."
#define TEXT_NOBASE			"Empty project is created."
#define TEXT_DIRECTX		"You can make a DirectX application. It can draw 2D or 3D graphics at high speed and it is useful to a game programing."
#define TEXT_DLL			"You can make a DLL(Dynamic Link Library)."
#endif

void GetCheckTextBuffer(char *buffer){
	extern NEWPROJECTINFO NewProjectInfo;
	int i;

#if defined(JPN)
	//{
	lstrcpy(buffer,"쐬vWFNg̓emF \"\" {^ĉB\r\n\r\n");
	i=lstrlen(buffer);
	sprintf(buffer+i,"vWFNg: \"%s\"\r\n",NewProjectInfo.name);
	i+=lstrlen(buffer+i);
	sprintf(buffer+i,"[N fBNg: \"%s\\%s\"\r\n\r\n",pobj_nv->ProjectSaveDir,NewProjectInfo.name);
	i+=lstrlen(buffer+i);

	if(NewProjectInfo.dwTypeID==IDC_EXE_WINDOWBASE){
		lstrcpy(buffer+i,"m[} EBhEEXE`̎st@C쐬܂B\r\n\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"--- ȉ̃t@C܂ ---\r\n");
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.pj c vWFNg t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.idx c CfbNX t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.ab c C \[XR[h t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.wnd c EBhE fUCۑp\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.wrk c Ə󋵂̊Ǘp\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"MainWnd.ab c C EBhẼCxg vV[Wp\r\n",NewProjectInfo.name);
	}
	else if(NewProjectInfo.dwTypeID==IDC_EXE_PROMPTBASE){
		lstrcpy(buffer+i,"vvg EBhEEXE`̎st@C쐬܂B\r\n\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"--- ȉ̃t@C܂ ---\r\n");
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.pj c vWFNg t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.idx c CfbNX t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.ab c C \[XR[h t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.wrk c Ə󋵂̊Ǘp\r\n",NewProjectInfo.name);
	}
	else if(NewProjectInfo.dwTypeID==IDC_EXE_DOSPROMPTBASE){
		lstrcpy(buffer+i,"EXE`̃R\[ AvP[V쐬܂B\r\n\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"--- ȉ̃t@C܂ ---\r\n");
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.pj c vWFNg t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.idx c CfbNX t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.ab c C \[XR[h t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.wrk c Ə󋵂̊Ǘp\r\n",NewProjectInfo.name);
	}
	else if(NewProjectInfo.dwTypeID==IDC_EXE_NOBASE){
		lstrcpy(buffer+i,"EXE`̎st@C쐬܂B\r\n\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"--- ȉ̃t@C܂ ---\r\n");
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.pj c vWFNg t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.idx c CfbNX t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.ab c C \[XR[h t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.wrk c Ə󋵂̊Ǘp\r\n",NewProjectInfo.name);
	}
	else if(NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX){
		lstrcpy(buffer+i,"EXE`̎st@C쐬܂BɁADirectX̑ɕKvȃ\[XR[h𐶐܂B\r\n\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"--- ȉ̃t@C܂ ---\r\n");
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.pj c vWFNg t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.idx c CfbNX t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.ab c C \[XR[h t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"dx_graphics.sbp c DirectGraphicsT|[gp\[XR[h t@C\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"dx_input.sbp c DirectInputT|[gp\[XR[h t@C\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"dx_music.sbp c DirectMusicT|[gp\[XR[h t@C\r\n");
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.wrk c Ə󋵂̊Ǘp\r\n",NewProjectInfo.name);
	}
	else if(NewProjectInfo.dwTypeID==IDC_DLL){
		lstrcpy(buffer+i,"_Ci~bN N Cu(DLL)쐬܂B\r\n\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"--- ȉ̃t@C܂ ---\r\n");
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.pj c vWFNg t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.idx c CfbNX t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.ab c C \[XR[h t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.wrk c Ə󋵂̊Ǘp\r\n",NewProjectInfo.name);
	}
	else if(NewProjectInfo.dwTypeID==IDC_SLL){
		lstrcpy(buffer+i,"ÓI N Cu(lib)쐬܂B\r\n\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"--- ȉ̃t@C܂ ---\r\n");
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.pj c vWFNg t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.idx c CfbNX t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.ab c C \[XR[h t@C\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.wrk c Ə󋵂̊Ǘp\r\n",NewProjectInfo.name);
	}
#else
	//p
	lstrcpy(buffer,"Please check following points and click the \"Finish\" button.\r\n\r\n");
	i=lstrlen(buffer);
	sprintf(buffer+i,"Project Name: \"%s\"\r\n",NewProjectInfo.name);
	i+=lstrlen(buffer+i);
	sprintf(buffer+i,"Work Directory: \"%s\\%s\"\r\n\r\n",pobj_nv->ProjectSaveDir,NewProjectInfo.name);
	i+=lstrlen(buffer+i);

	if(NewProjectInfo.dwTypeID==IDC_EXE_WINDOWBASE){
		sprintf(buffer+i,"%s\r\n\r\n",TEXT_BASE_NORMAL);
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"--- Creation Files ---\r\n");
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.pj c Project file\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.idx c Index file\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.ab c Main Source Code file\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.wnd c Data of Window Design\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.wrk c Data of Work State\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"MainWnd.ab c Data of Event Procedures of the Main Window\r\n",NewProjectInfo.name);
	}
	else if(NewProjectInfo.dwTypeID==IDC_EXE_PROMPTBASE){
		sprintf(buffer+i,"%s\r\n\r\n",TEXT_BASE_PROMPT);
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"--- Creation Files ---\r\n");
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.pj c Creation Files\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.idx c Index file\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.ab c Main Source Code file\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.wrk c Data of Work State\r\n",NewProjectInfo.name);
	}
	else if(NewProjectInfo.dwTypeID==IDC_EXE_DOSPROMPTBASE){
		sprintf(buffer+i,"%s\r\n\r\n",TEXT_BASE_DOSPROMPT);
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"--- Creation Files ---\r\n");
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.pj c Creation Files\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.idx c Index file\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.ab c Main Source Code file\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.wrk c Data of Work State\r\n",NewProjectInfo.name);
	}
	else if(NewProjectInfo.dwTypeID==IDC_EXE_NOBASE){
		sprintf(buffer+i,"%s\r\n\r\n",TEXT_NOBASE);
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"--- Creation Files ---\r\n");
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.pj c Creation Files\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.idx c Index file\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.ab c Main Source Code file\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.wrk c Data of Work State\r\n",NewProjectInfo.name);
	}
	else if(NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX){
		sprintf(buffer+i,"%s\r\n\r\n",TEXT_DIRECTX);
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"--- Creation Files ---\r\n");
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.pj c Creation Files\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.idx c Index file\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.ab c Main Source Code file\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"dx_graphics.sbp c DirectGraphics is supported at this source file\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"dx_input.sbp c DirectInput is supported at this source file\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"dx_music.sbp c DirectMusic is supported at this source file\r\n");
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.wrk c Data of Work State\r\n",NewProjectInfo.name);
	}
	else if(NewProjectInfo.dwTypeID==IDC_DLL){
		sprintf(buffer+i,"%s\r\n\r\n",TEXT_DLL);
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"--- Creation Files ---\r\n");
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.pj c Creation Files\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.idx c Index file\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.ab c Main Source Code file\r\n",NewProjectInfo.name);
		i+=lstrlen(buffer+i);
		sprintf(buffer+i,"%s.wrk c Data of Work State\r\n",NewProjectInfo.name);
	}
#endif
}
BOOL CALLBACK DlgNewProject_Page3(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	char buffer[GENERAL_SIZE];
	LPPSHNOTIFY lpPshNotify;
	switch(message){
		case WM_NOTIFY:
			lpPshNotify=(LPPSHNOTIFY)lParam;
			switch(lpPshNotify->hdr.code){
				case PSN_SETACTIVE:
					PropSheet_SetWizButtons(GetParent(hwnd),PSWIZB_FINISH|PSWIZB_BACK);

					GetCheckTextBuffer(buffer);

					SetDlgItemText(hwnd,IDC_PROJECTINFO,buffer);
					SetTimer(hwnd,1,10,0);
					return 1;
				case PSN_WIZFINISH:
					MakeNewProject();
					return 1;
			}
			break;
		case WM_TIMER:
			KillTimer(hwnd,1);
			SendDlgItemMessage(hwnd,IDC_PROJECTINFO,EM_SETSEL,0,0);
			return 1;
	}
	return 0;
}
BOOL CALLBACK DlgNewProject_Page2(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern NEWPROJECTINFO NewProjectInfo;
	LPPSHNOTIFY lpPshNotify;
	switch(message){
		case WM_INITDIALOG:

			break;
		case WM_NOTIFY:
			lpPshNotify=(LPPSHNOTIFY)lParam;
			switch(lpPshNotify->hdr.code){
				case PSN_SETACTIVE:
					//DirectXAv̂ƂMMSYS`FbN
					if(NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX){
						SendDlgItemMessage(hwnd,IDC_API_MMSYS,BM_SETCHECK,BST_CHECKED,0);
						EnableWindow(GetDlgItem(hwnd,IDC_API_MMSYS),0);
					}
					else{
						EnableWindow(GetDlgItem(hwnd,IDC_API_MMSYS),1);
					}

					PropSheet_SetWizButtons(GetParent(hwnd),PSWIZB_NEXT|PSWIZB_BACK);
					return 1;
				case PSN_WIZNEXT:
					NewProjectInfo.dwOption=PJ_OP_RC_MANIFEST;
					if(SendDlgItemMessage(hwnd,IDC_UNICODE,BM_GETCHECK,0,0))
						NewProjectInfo.dwOption|=PJ_OP_UNICODE;
					if(SendDlgItemMessage(hwnd,IDC_API_COMMCTRL,BM_GETCHECK,0,0))
						NewProjectInfo.dwOption|=PJ_OP_COMMCTRL;
					if(SendDlgItemMessage(hwnd,IDC_API_MMSYS,BM_GETCHECK,0,0))
						NewProjectInfo.dwOption|=PJ_OP_MMSYSTEM;
					if(SendDlgItemMessage(hwnd,IDC_API_RICHEDIT,BM_GETCHECK,0,0))
						NewProjectInfo.dwOption|=PJ_OP_RICHEDIT;
					if(SendDlgItemMessage(hwnd,IDC_API_WINSOCK,BM_GETCHECK,0,0))
						NewProjectInfo.dwOption|=PJ_OP_WINSOCK;
					return 1;
			}
			break;
	}
	return 0;
}
void AppImage_ShowOrHide(HWND hDlg,int id){
	int nCmd;

	if(id==IDC_EXE_WINDOWBASE) nCmd=SW_SHOW;
	else nCmd=SW_HIDE;
	ShowWindow(GetDlgItem(hDlg,IDC_IMAGE_WINDOW),nCmd);

	if(id==IDC_EXE_PROMPTBASE) nCmd=SW_SHOW;
	else nCmd=SW_HIDE;
	ShowWindow(GetDlgItem(hDlg,IDC_IMAGE_PROMPT),nCmd);

	if(id==IDC_EXE_DOSPROMPTBASE) nCmd=SW_SHOW;
	else nCmd=SW_HIDE;
	ShowWindow(GetDlgItem(hDlg,IDC_IMAGE_DOSPROMPT),nCmd);

	if(id==IDC_EXE_NOBASE) nCmd=SW_SHOW;
	else nCmd=SW_HIDE;
	ShowWindow(GetDlgItem(hDlg,IDC_IMAGE_NON),nCmd);

	if(id==IDC_EXE_DIRECTX) nCmd=SW_SHOW;
	else nCmd=SW_HIDE;
	ShowWindow(GetDlgItem(hDlg,IDC_IMAGE_DIRECTX),nCmd);
}
BOOL CALLBACK DlgNewProject_Page1(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern NEWPROJECTINFO NewProjectInfo;
	int i;
	char temporary[MAX_PATH];
	LPPSHNOTIFY lpPshNotify;

	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(GetParent(hwnd));

			SetDlgItemText(hwnd,IDC_DIRPATH,pobj_nv->ProjectSaveDir);
			SendDlgItemMessage(hwnd,IDC_EXE_WINDOWBASE,BM_SETCHECK,BST_CHECKED,0);
			SetDlgItemText(hwnd,IDC_HELPTEXT_OFBASE,TEXT_BASE_NORMAL);
			break;
		case WM_COMMAND:
			if(HIWORD(wParam)==EN_CHANGE){
				if(GetWindowTextLength(GetDlgItem(hwnd,IDC_PROJECTNAME))==0||
					GetWindowTextLength(GetDlgItem(hwnd,IDC_DIRPATH))==0){
					PropSheet_SetWizButtons(GetParent(hwnd),0);
				}
				else PropSheet_SetWizButtons(GetParent(hwnd),PSWIZB_NEXT);
			}
			switch(LOWORD(wParam)){
				case IDC_PATHBROWSE:
					//"fBNgIĉ"
					if(!GetFolder(hwnd,temporary,STRING_DIRECTORY_SELECT)) return 1;
					SetDlgItemText(hwnd,IDC_DIRPATH,temporary);
					return 1;
				case IDC_EXE_WINDOWBASE:
					AppImage_ShowOrHide(hwnd,LOWORD(wParam));

					SetDlgItemText(hwnd,IDC_HELPTEXT_OFBASE,TEXT_BASE_NORMAL);
					EnableWindow(GetDlgItem(hwnd,IDC_SHOWHELLOWORLD),1);
					return 1;
				case IDC_EXE_PROMPTBASE:
					AppImage_ShowOrHide(hwnd,LOWORD(wParam));

					SetDlgItemText(hwnd,IDC_HELPTEXT_OFBASE,TEXT_BASE_PROMPT);
					EnableWindow(GetDlgItem(hwnd,IDC_SHOWHELLOWORLD),1);
					return 1;
				case IDC_EXE_DOSPROMPTBASE:
					AppImage_ShowOrHide(hwnd,LOWORD(wParam));

					SetDlgItemText(hwnd,IDC_HELPTEXT_OFBASE,TEXT_BASE_DOSPROMPT);
					EnableWindow(GetDlgItem(hwnd,IDC_SHOWHELLOWORLD),1);
					return 1;
				case IDC_EXE_NOBASE:
					AppImage_ShowOrHide(hwnd,LOWORD(wParam));

					SetDlgItemText(hwnd,IDC_HELPTEXT_OFBASE,TEXT_NOBASE);
					EnableWindow(GetDlgItem(hwnd,IDC_SHOWHELLOWORLD),0);
					return 1;
				case IDC_EXE_DIRECTX:
					AppImage_ShowOrHide(hwnd,LOWORD(wParam));

					SetDlgItemText(hwnd,IDC_HELPTEXT_OFBASE,TEXT_DIRECTX);
					EnableWindow(GetDlgItem(hwnd,IDC_SHOWHELLOWORLD),0);
					return 1;
				case IDC_DLL:
					AppImage_ShowOrHide(hwnd,LOWORD(wParam));

					SetDlgItemText(hwnd,IDC_HELPTEXT_OFBASE,TEXT_DLL);
					EnableWindow(GetDlgItem(hwnd,IDC_SHOWHELLOWORLD),0);
					return 1;
				case IDC_SLL:
					AppImage_ShowOrHide(hwnd,LOWORD(wParam));

					SetDlgItemText(hwnd,IDC_HELPTEXT_OFBASE,TEXT_SLL);
					EnableWindow(GetDlgItem(hwnd,IDC_SHOWHELLOWORLD),0);
					return 1;
			}
			break;
		case WM_NOTIFY:
			lpPshNotify=(LPPSHNOTIFY)lParam;
			switch(lpPshNotify->hdr.code){
				case PSN_SETACTIVE:
					SendMessage(hwnd,WM_COMMAND,MAKELONG(0,EN_CHANGE),0);
					return 1;
				case PSN_WIZNEXT:
					GetDlgItemText(hwnd,IDC_PROJECTNAME,NewProjectInfo.name,MAX_PATH);
					if(!IsVariableTopChar(NewProjectInfo.name[0])){
						//"vWFNg̐擪̓At@xbgiA`ZAa`zj܂̓A_[o[i_jłȂ΂Ȃ܂B"
						MessageBox(hwnd,STRING_ERROR_PROJECTTOPCHAR,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
						SetWindowLongPtr(hwnd,DWLP_MSGRESULT,-1);
						return 1;
					}
					for(i=1;;i++){
						if(NewProjectInfo.name[i]=='\0') break;
						if(!IsVariableChar(NewProjectInfo.name[i])){
							//"vWFNgɕsȕR[h܂܂Ă܂B"
							MessageBox(hwnd,STRING_ERROR_PROJECTNAME,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
							SetWindowLongPtr(hwnd,DWLP_MSGRESULT,-1);
							return 1;
						}
					}
					GetDlgItemText(hwnd,IDC_DIRPATH,pobj_nv->ProjectSaveDir,MAX_PATH);

					//x[XI
					if(SendDlgItemMessage(hwnd,IDC_EXE_WINDOWBASE,BM_GETCHECK,0,0))
						NewProjectInfo.dwTypeID=IDC_EXE_WINDOWBASE;
					else if(SendDlgItemMessage(hwnd,IDC_EXE_PROMPTBASE,BM_GETCHECK,0,0))
						NewProjectInfo.dwTypeID=IDC_EXE_PROMPTBASE;
					else if(SendDlgItemMessage(hwnd,IDC_EXE_DOSPROMPTBASE,BM_GETCHECK,0,0))
						NewProjectInfo.dwTypeID=IDC_EXE_DOSPROMPTBASE;
					else if(SendDlgItemMessage(hwnd,IDC_EXE_NOBASE,BM_GETCHECK,0,0))
						NewProjectInfo.dwTypeID=IDC_EXE_NOBASE;
					else if(SendDlgItemMessage(hwnd,IDC_EXE_DIRECTX,BM_GETCHECK,0,0))
						NewProjectInfo.dwTypeID=IDC_EXE_DIRECTX;
					else if(SendDlgItemMessage(hwnd,IDC_DLL,BM_GETCHECK,0,0))
						NewProjectInfo.dwTypeID=IDC_DLL;
					else if(SendDlgItemMessage(hwnd,IDC_SLL,BM_GETCHECK,0,0))
						NewProjectInfo.dwTypeID=IDC_SLL;

					//"Hello World!"\邩
					if(SendDlgItemMessage(hwnd,IDC_SHOWHELLOWORLD,BM_GETCHECK,0,0)) NewProjectInfo.ShowHelloWorld=1;
					else NewProjectInfo.ShowHelloWorld=0;
					return 1;
			}
			break;
	}
	return 0;
}
void DlgNewProjectWizard(HWND hwnd){
#define MAX_NEWPROJECTPAGE 3
	PROPSHEETHEADER psh;
	PROPSHEETPAGE psp;
	HPROPSHEETPAGE hpsp[MAX_NEWPROJECTPAGE];
	int i;

	psp.dwSize=sizeof(PROPSHEETPAGE);
	psp.hInstance=hResInst;
	psp.dwFlags=PSP_DEFAULT;

	//ey[W̃ZbeBO
	i=0;
	psp.pszTemplate=MAKEINTRESOURCE(IDD_NEWPROJECT_PAGE1);
	psp.pfnDlgProc=(DLGPROC)DlgNewProject_Page1;
	hpsp[i]=CreatePropertySheetPage(&psp);
	i++;
	psp.pszTemplate=MAKEINTRESOURCE(IDD_NEWPROJECT_PAGE2);
	psp.pfnDlgProc=(DLGPROC)DlgNewProject_Page2;
	hpsp[i]=CreatePropertySheetPage(&psp);
	i++;
	psp.pszTemplate=MAKEINTRESOURCE(IDD_NEWPROJECT_PAGE3);
	psp.pfnDlgProc=(DLGPROC)DlgNewProject_Page3;
	hpsp[i]=CreatePropertySheetPage(&psp);

	memset(&psh,0,sizeof(PROPSHEETHEADER));
	psh.dwSize=sizeof(PROPSHEETHEADER);
	psh.dwFlags=PSH_WIZARD;
	psh.phpage=hpsp;
	psh.hwndParent=hwnd;
	psh.nPages=MAX_NEWPROJECTPAGE;
	PropertySheet(&psh);
}

#define CATEGORY_TEXT_BASIC	"Basic"
#define CATEGORY_TEXT_TEXT	"eLXg"
#define CATEGORY_TEXT_OTHER "̑"

#define CATEGORY_BASIC	1
#define CATEGORY_TEXT	2
#define CATEGORY_OTHER	3
void ResetNewFileTypeListView(HWND hListView,int fCategory){
	ListView_DeleteAllItems(hListView);

	LV_ITEM lvItem;
	lvItem.mask = LVIF_TEXT|LVIF_IMAGE|LVIF_PARAM;
	lvItem.iItem=0;
	lvItem.iSubItem=0;

	if(fCategory==CATEGORY_BASIC){
		lvItem.pszText="Basic \[X t@C";
		lvItem.iImage=0;
		lvItem.lParam=FT_BASICPROGRAM;
		ListView_InsertItem(hListView,&lvItem);
		lvItem.iItem++;

		lvItem.pszText="vWFNg";
		lvItem.iImage=2;
		lvItem.lParam=FT_PROJECT;
		ListView_InsertItem(hListView,&lvItem);
	}
	else if(fCategory==CATEGORY_TEXT){
		lvItem.pszText="eLXg t@C";
		lvItem.iImage=3;
		lvItem.lParam=FT_TEXT;
		ListView_InsertItem(hListView,&lvItem);
		lvItem.iItem++;

		lvItem.pszText="HTML t@C";
		lvItem.iImage=4;
		lvItem.lParam=FT_HTML;
		ListView_InsertItem(hListView,&lvItem);
	}
	else if(fCategory==CATEGORY_OTHER){
		lvItem.pszText="ACR t@C";
		lvItem.iImage=5;
		lvItem.lParam=FT_ICON;
		ListView_InsertItem(hListView,&lvItem);
	}

	ListView_SetItemState(hListView,0,LVIS_SELECTED|LVIS_FOCUSED,LVIS_SELECTED|LVIS_FOCUSED);
}

#ifndef THETEXT
BOOL CALLBACK DlgNewFile(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern char NewFileName[MAX_PATH];

	static HIMAGELIST hImageList;
	static HWND hTree;
	static HWND hListView;
	int i;
	LVITEM lvItem;
	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(hwnd);


			///////////////////////////////////
			// JeSc[r[
			///////////////////////////////////
			HTREEITEM hBasicTreeItem;

			hTree=GetDlgItem(hwnd,IDC_CATEGORY_TREE);

			TV_INSERTSTRUCT tv;
			tv.hInsertAfter=TVI_LAST;
			tv.item.mask=TVIF_TEXT;
			tv.hParent=TVI_ROOT;

			tv.item.pszText=CATEGORY_TEXT_BASIC;
			hBasicTreeItem=TreeView_InsertItem(hTree,&tv);
			tv.item.pszText=CATEGORY_TEXT_TEXT;
			TreeView_InsertItem(hTree,&tv);
			tv.item.pszText=CATEGORY_TEXT_OTHER;
			TreeView_InsertItem(hTree,&tv);

			TreeView_SelectItem(hTree,hBasicTreeItem);



			/////////////////////////////////////////
			// t@C^Cv Xgr[
			/////////////////////////////////////////

			hListView=GetDlgItem(hwnd,IDC_FILETYPELIST);

			hImageList=ImageList_Create(32, 32, ILC_COLOR24|ILC_MASK, 6, 0);
			ListView_SetImageList(hListView, hImageList, LVSIL_NORMAL);
			ImageList_AddIcon(hImageList, LoadIcon(hInst, MAKEINTRESOURCE(IDI_FILE_BAS)));
			ImageList_AddIcon(hImageList, LoadIcon(hInst, MAKEINTRESOURCE(IDI_FILE_SBP)));
			ImageList_AddIcon(hImageList, LoadIcon(hResInst, MAKEINTRESOURCE(IDI_NEWFILE_PJ)));
			ImageList_AddIcon(hImageList, LoadIcon(hResInst, MAKEINTRESOURCE(IDI_NEWFILE_TEXT)));
			ImageList_AddIcon(hImageList, LoadIcon(hResInst, MAKEINTRESOURCE(IDI_NEWFILE_HTML)));
			ImageList_AddIcon(hImageList, LoadIcon(hResInst, MAKEINTRESOURCE(IDI_NEWFILE_ICON)));


			ResetNewFileTypeListView(hListView,CATEGORY_BASIC);


			SetFocus(GetDlgItem(hwnd,IDC_FILETYPELIST));

			if( projectInfo.IsOpened() ){
				SendDlgItemMessage(hwnd,IDC_ADDTOPROJECT,BM_SETCHECK,BST_CHECKED,0);
			}

			SendMessage(hwnd,WM_COMMAND,IDC_ADDTOPROJECT,0);
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					for(i=0;i<ListView_GetItemCount(hListView);i++){
						if(ListView_GetItemState(hListView,i,LVIS_SELECTED)){
							lvItem.mask=LVIF_PARAM;
							lvItem.iItem=i;
							lvItem.iSubItem=0;
							ListView_GetItem(hListView,&lvItem);
							break;
						}
					}
					if(i==ListView_GetItemCount(hListView)) return 1;

					//t@C^Cv
					i=lvItem.lParam;

					//vWFNg֒ǉ邩ǂ
					if(IsWindowEnabled(GetDlgItem(hwnd,IDC_ADDTOPROJECT))){
						if(SendDlgItemMessage(hwnd,IDC_ADDTOPROJECT,BM_GETCHECK,0,0)){
							i|=0x00008000;
							GetDlgItemText(hwnd,IDC_FILENAME,NewFileName,MAX_PATH);

							if(NewFileName[0]=='\0'){
								MessageBox(hwnd,"t@C͂ĂB",APPLICATION_NAME,MB_OK);
								return 1;
							}
						}
					}

					EndDialog(hwnd,i);
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,-1);
					return 1;
				case IDC_ADDTOPROJECT:
					if(IsWindowEnabled(GetDlgItem(hwnd,IDC_ADDTOPROJECT))&&
						SendDlgItemMessage(hwnd,IDC_ADDTOPROJECT,BM_GETCHECK,0,0)){
						EnableWindow(GetDlgItem(hwnd,IDC_FILENAME),1);
						EnableWindow(GetDlgItem(hwnd,IDC_STATIC_FILENAME),1);
					}
					else{
						EnableWindow(GetDlgItem(hwnd,IDC_FILENAME),0);
						EnableWindow(GetDlgItem(hwnd,IDC_STATIC_FILENAME),0);
					}
					return 1;
			}
			break;

		case WM_NOTIFY:
			NMHDR *hdr;
			hdr=(NMHDR *)lParam;
			if(hdr->hwndFrom==hTree&&hdr->code==TVN_SELCHANGED){
				NMTREEVIEW *lpnmTree;
				lpnmTree=(NMTREEVIEW *)lParam;

				char temporary[255];
				TVITEM tvItem;
				tvItem.mask=TVIF_TEXT|TVIF_HANDLE;
				tvItem.hItem=lpnmTree->itemNew.hItem;
				tvItem.pszText=temporary;
				tvItem.cchTextMax=255;
				TreeView_GetItem(hTree,&tvItem);

				if(lstrcmpi(tvItem.pszText,CATEGORY_TEXT_BASIC)==0)
					ResetNewFileTypeListView(hListView,CATEGORY_BASIC);
				else if(lstrcmpi(tvItem.pszText,CATEGORY_TEXT_TEXT)==0)
					ResetNewFileTypeListView(hListView,CATEGORY_TEXT);
				else if(lstrcmpi(tvItem.pszText,CATEGORY_TEXT_OTHER)==0)
					ResetNewFileTypeListView(hListView,CATEGORY_OTHER);
			}
			if(hdr->hwndFrom==hListView){
				if(hdr->code==LVN_ITEMCHANGED){
					for(i=0;i<ListView_GetItemCount(hListView);i++){
						if(ListView_GetItemState(hListView,i,LVIS_SELECTED)){
							lvItem.mask=LVIF_PARAM;
							lvItem.iItem=i;
							lvItem.iSubItem=0;
							ListView_GetItem(hListView,&lvItem);
							break;
						}
					}
					if(i!=ListView_GetItemCount(hListView)&& projectInfo.IsOpened() &&(
						lvItem.lParam==FT_BASICPROGRAM||
						lvItem.lParam==FT_SUBPROGRAM
						)){
						EnableWindow(GetDlgItem(hwnd,IDC_ADDTOPROJECT),1);
					}
					else EnableWindow(GetDlgItem(hwnd,IDC_ADDTOPROJECT),0);

					SendMessage(hwnd,WM_COMMAND,IDC_ADDTOPROJECT,0);
				}
				else if(hdr->code==NM_DBLCLK){
					SendMessage(hwnd,WM_COMMAND,IDOK,0);
				}
			}
			return 0;

		case WM_DESTROY:
			ImageList_Destroy(hImageList);
			return 0;
	}
	return 0;
}
#endif


//vWFNgIvV
#define MAX_PJSETDLG 4
DWORD temp_dwPjOption;
char temp_lpszOutputRelease[MAX_PATH];
char temp_lpszOutputDebug[MAX_PATH];
char temp_szManifestPath[MAX_PATH];
char temp_szDebugCmdLine[8192];
char temp_szDebugExePath[MAX_PATH];

void SaveSetting_DlgPjOption(void){
	if(SetSwitch[0]){
		//o̓t@C
		lstrcpy(projectInfo.lpszOutput_Release,temp_lpszOutputRelease);
		lstrcpy(projectInfo.lpszOutput_Debug,temp_lpszOutputDebug);

		//Rg̗L
		projectInfo.dwOption=temp_dwPjOption;
	}
	if(SetSwitch[1]){
		//Win32API
		projectInfo.dwOption=temp_dwPjOption;
	}
	if(SetSwitch[2]){
		//}jtFXg

		//pX
		lstrcpy(projectInfo.szManifestPath,temp_szManifestPath);

		projectInfo.dwOption=temp_dwPjOption;

		projectInfo.ModifuOfResource=1;
	}
	if(SetSwitch[3]){
		//fobO

		//R}hC
		lstrcpy(projectInfo.szCmdLine,temp_szDebugCmdLine);

		//fobOZbVp̎s\t@C
		lstrcpy(projectInfo.szExePath,temp_szDebugExePath);
	}

	projectInfo.modify=1;
}
BOOL CALLBACK DlgProjectOption_Whole(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	NMHDR *nmhdr;

	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(GetParent(hwnd));

			SetSwitch[0]=1;

			//o̓t@C
			SetDlgItemText(hwnd,IDC_EDIT_RELEASE,projectInfo.lpszOutput_Release);
			SetDlgItemText(hwnd,IDC_EDIT_DEBUG,projectInfo.lpszOutput_Debug);

			//Unicode
			if(temp_dwPjOption&PJ_OP_UNICODE)
				SendDlgItemMessage(hwnd,IDC_UNICODE,BM_SETCHECK,BST_CHECKED,0);

			break;
		case WM_NOTIFY:
			nmhdr=(NMHDR *)lParam;
			if(nmhdr->code==PSN_APPLY||nmhdr->code==PSN_KILLACTIVE){
				GetDlgItemText(hwnd,IDC_EDIT_RELEASE,temp_lpszOutputRelease,MAX_PATH);
				GetDlgItemText(hwnd,IDC_EDIT_DEBUG,temp_lpszOutputDebug,MAX_PATH);

				//Unicode
				if(SendDlgItemMessage(hwnd,IDC_UNICODE,BM_GETCHECK,0,0))
					temp_dwPjOption|=PJ_OP_UNICODE;
				else temp_dwPjOption&=~PJ_OP_UNICODE;

				if(nmhdr->code==PSN_APPLY) SaveSetting_DlgPjOption();
			}
			return 1;
	}
	return 0;
}
BOOL CALLBACK DlgProjectOption_Win32API(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	NMHDR *nmhdr;

	switch(message){
		case WM_INITDIALOG:
			SetSwitch[1]=1;

			if(temp_dwPjOption&PJ_OP_MMSYSTEM)
				SendDlgItemMessage(hwnd,IDC_API_MMSYS,BM_SETCHECK,BST_CHECKED,0);
			if(temp_dwPjOption&PJ_OP_COMMCTRL)
				SendDlgItemMessage(hwnd,IDC_API_COMMCTRL,BM_SETCHECK,BST_CHECKED,0);
			if(temp_dwPjOption&PJ_OP_RICHEDIT)
				SendDlgItemMessage(hwnd,IDC_API_RICHEDIT,BM_SETCHECK,BST_CHECKED,0);
			if(temp_dwPjOption&PJ_OP_WINSOCK)
				SendDlgItemMessage(hwnd,IDC_API_WINSOCK,BM_SETCHECK,BST_CHECKED,0);
			break;
		case WM_NOTIFY:
			nmhdr=(NMHDR *)lParam;
			if(nmhdr->code==PSN_APPLY||nmhdr->code==PSN_KILLACTIVE){
				if(SendDlgItemMessage(hwnd,IDC_API_MMSYS,BM_GETCHECK,0,0))
					temp_dwPjOption|=PJ_OP_MMSYSTEM;
				else temp_dwPjOption&=~PJ_OP_MMSYSTEM;
				if(SendDlgItemMessage(hwnd,IDC_API_COMMCTRL,BM_GETCHECK,0,0))
					temp_dwPjOption|=PJ_OP_COMMCTRL;
				else temp_dwPjOption&=~PJ_OP_COMMCTRL;
				if(SendDlgItemMessage(hwnd,IDC_API_RICHEDIT,BM_GETCHECK,0,0))
					temp_dwPjOption|=PJ_OP_RICHEDIT;
				else temp_dwPjOption&=~PJ_OP_RICHEDIT;
				if(SendDlgItemMessage(hwnd,IDC_API_WINSOCK,BM_GETCHECK,0,0))
					temp_dwPjOption|=PJ_OP_WINSOCK;
				else temp_dwPjOption&=~PJ_OP_WINSOCK;

				if(nmhdr->code==PSN_APPLY) SaveSetting_DlgPjOption();
			}
			return 1;
	}
	return 0;
}
BOOL CALLBACK DlgProjectOption_Manifest(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	switch(message){
		case WM_INITDIALOG:
			SetSwitch[2]=1;

			//pX
			SetDlgItemText(hwnd,IDC_PATH,projectInfo.szManifestPath);

			//}jtFXg\[Xɖߍ
			if(temp_dwPjOption&PJ_OP_RC_MANIFEST)
				SendDlgItemMessage(hwnd,IDC_RC_MANIFEST,BM_SETCHECK,BST_CHECKED,0);

			SendMessage(hwnd,WM_COMMAND,IDC_RC_MANIFEST,0);

			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_RC_MANIFEST:
					if(SendDlgItemMessage(hwnd,IDC_RC_MANIFEST,BM_GETCHECK,0,0)){
						EnableWindow(GetDlgItem(hwnd,IDC_STATIC_PATH),1);
						EnableWindow(GetDlgItem(hwnd,IDC_PATH),1);
					}
					else{
						EnableWindow(GetDlgItem(hwnd,IDC_STATIC_PATH),0);
						EnableWindow(GetDlgItem(hwnd,IDC_PATH),0);
					}
					return 1;
			}
			break;
		case WM_NOTIFY:
			NMHDR *nmhdr;
			nmhdr=(NMHDR *)lParam;
			if(nmhdr->code==PSN_APPLY||nmhdr->code==PSN_KILLACTIVE){

				//pX
				GetDlgItemText(hwnd,IDC_PATH,temp_szManifestPath,MAX_PATH);

				//}jtFXg\[Xɖߍ
				if(SendDlgItemMessage(hwnd,IDC_RC_MANIFEST,BM_GETCHECK,0,0))
					temp_dwPjOption|=PJ_OP_RC_MANIFEST;
				else temp_dwPjOption&=~PJ_OP_RC_MANIFEST;

				if(nmhdr->code==PSN_APPLY) SaveSetting_DlgPjOption();
			}
			return 1;
	}
	return 0;
}
BOOL CALLBACK DlgProjectOption_Debug(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	NMHDR *nmhdr;
	char temporary[MAX_PATH];

	switch(message){
		case WM_INITDIALOG:
			SetSwitch[3]=1;

			if( projectInfo.GetModuleType() != ActiveBasic::Common::TargetModuleType::Dll )
			{
				EnableWindow(GetDlgItem(hwnd,IDC_EXE_PATH),0);
				EnableWindow(GetDlgItem(hwnd,IDC_DIR),0);
			}

			SetDlgItemText(hwnd,IDC_CMD_LINE,projectInfo.szCmdLine);
			SetDlgItemText(hwnd,IDC_EXE_PATH,projectInfo.szExePath);

			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_DIR:
					extern LPSTR ExeFileFilter;
					if(!GetFilePathDialog(hwnd,temporary,ExeFileFilter,"DLLfobOp̎s\t@Cw肵Ă",1)) break;

					SetDlgItemText(hwnd,IDC_EXE_PATH,temporary);
					return 1;
			}
			break;
		case WM_NOTIFY:
			nmhdr=(NMHDR *)lParam;
			if(nmhdr->code==PSN_APPLY||nmhdr->code==PSN_KILLACTIVE){
				GetDlgItemText(hwnd,IDC_CMD_LINE,temp_szDebugCmdLine,8192);
				GetDlgItemText(hwnd,IDC_EXE_PATH,temp_szDebugExePath,MAX_PATH);

				if(nmhdr->code==PSN_APPLY) SaveSetting_DlgPjOption();
			}
			return 1;
	}
	return 0;
}
void DlgProjectOptionSetting(HWND hwnd){
	PROPSHEETHEADER psh;
	PROPSHEETPAGE psp[MAX_PJSETDLG];
	HPROPSHEETPAGE hpsp[MAX_PJSETDLG];
	int i;
	memset(&SetSwitch,0,MAX_PJSETDLG);

	//ey[W̃ZbeBO
	i=0;
	psp[i].dwSize=sizeof(PROPSHEETPAGE);
	psp[i].dwFlags=PSP_DEFAULT;
	psp[i].hInstance=hResInst;
	psp[i].pszTemplate=MAKEINTRESOURCE(IDD_PJ_OPTION1);
	psp[i].pfnDlgProc=(DLGPROC)DlgProjectOption_Whole;
	hpsp[i]=CreatePropertySheetPage(&psp[i]);
	i++;
	psp[i].dwSize=sizeof(PROPSHEETPAGE);
	psp[i].dwFlags=PSP_DEFAULT;
	psp[i].hInstance=hResInst;
	psp[i].pszTemplate=MAKEINTRESOURCE(IDD_PJ_OPTION2);
	psp[i].pfnDlgProc=(DLGPROC)DlgProjectOption_Win32API;
	hpsp[i]=CreatePropertySheetPage(&psp[i]);
	i++;
	psp[i].dwSize=sizeof(PROPSHEETPAGE);
	psp[i].dwFlags=PSP_DEFAULT;
	psp[i].hInstance=hResInst;
	psp[i].pszTemplate=MAKEINTRESOURCE(IDD_PJ_OPTION3);
	psp[i].pfnDlgProc=(DLGPROC)DlgProjectOption_Manifest;
	hpsp[i]=CreatePropertySheetPage(&psp[i]);
	i++;
	psp[i].dwSize=sizeof(PROPSHEETPAGE);
	psp[i].dwFlags=PSP_DEFAULT;
	psp[i].hInstance=hResInst;
	psp[i].pszTemplate=MAKEINTRESOURCE(IDD_PJ_OPTION4);
	psp[i].pfnDlgProc=(DLGPROC)DlgProjectOption_Debug;
	hpsp[i]=CreatePropertySheetPage(&psp[i]);

	temp_dwPjOption=projectInfo.dwOption;

	memset(&psh,0,sizeof(PROPSHEETHEADER));
	psh.dwSize=sizeof(PROPSHEETHEADER);
	psh.dwFlags=PSH_PROPSHEETPAGE|PSH_NOAPPLYNOW;
	psh.phpage=hpsp;
	psh.hwndParent=hwnd;
	psh.pszCaption=STRING_PROJECTOPTION;	//"vWFNg IvV"
	psh.nPages=MAX_PJSETDLG;
	psh.nStartPage=0;
	psh.ppsp=psp;
	PropertySheet(&psh);
}


/////////////////////
// IvV
/////////////////////

BOOL bOptionWhole;
BOOL bOptionEditor;
BOOL bOptionColor;
BOOL bOptionToolbar;
BOOL bOptionRad;
BOOL bOptionWeb;
BOOL temp_bSaveCheckProject;
BOOL temp_bLineAdjust;
BOOL temp_bSaveTabToHead;
LOGFONT temp_lf,temp_HintFont;
int temp_TabSize;
BOOL temp_bEditor_LineNumber;
BOOL temp_bEditor_Ruler;
BOOL temp_bEditor_CaretLine_BackGround;
int temp_iMaxOneLineTextLength;
BOOL temp_bAutoIndent;
BOOL temp_bPasteIndent;
DWORD temp_dwParameterHint;
BOOL temp_bShowComplementWnd;
int temp_BackNum_PairStatementComplement;
BOOL temp_bSaveFindStr;

CTheme obj_temp_Theme;

BOOL temp_bCtrlKeyHyperLink;
BOOL temp_bSaveWebFindStr;
CDBDomain *pobj_temp_DBDomain;

void SaveSetting(void){
	int i;
	if(bOptionWhole){
		//śAvWFNg̕ۑmF̗L
		pobj_nv->bSaveCheckProject=temp_bSaveCheckProject;

		//hLgۑƂɃ^u擪ɍĔzu邩ǂ
		pobj_nv->bSaveTabToHead=temp_bSaveTabToHead;
	}
	if(bOptionEditor){
		//tHg
		pobj_nv->lf=temp_lf;

		//^uTCY
		pobj_nv->TabSize=temp_TabSize;

		//GfB^̍sԍ\邩ǂ
		pobj_nv->bEditor_LineNumber=temp_bEditor_LineNumber;

		//GfB^̃[[\邩ǂ
		pobj_nv->bEditor_Ruler=temp_bEditor_Ruler;

		//J[\s\邩ǂ
		pobj_nv->bEditor_CaretLine_BackGround=temp_bEditor_CaretLine_BackGround;

		//܂Ԃ̈s̕
		pobj_nv->iMaxOneLineTextLength=temp_iMaxOneLineTextLength;

		//R[h⊮@\
		pobj_nv->bShowComplementWnd=temp_bShowComplementWnd;

		pobj_nv->BackNum_PairStatementComplement=temp_BackNum_PairStatementComplement;

		//p[^ qg
		pobj_nv->dwParameterHint=temp_dwParameterHint;

		//p[^ qg tHg
		extern METHODCHECKINFO MethodCheckInfo;
		MethodCheckInfo.LogFont=temp_HintFont;
		DeleteObject(MethodCheckInfo.hFont);
		DeleteObject(MethodCheckInfo.hBoldFont);

		MethodCheckInfo.hFont=CreateFontIndirect(&MethodCheckInfo.LogFont);
		i=MethodCheckInfo.LogFont.lfWeight;
		MethodCheckInfo.LogFont.lfWeight=FW_BOLD;
		MethodCheckInfo.hBoldFont=CreateFontIndirect(&MethodCheckInfo.LogFont);
		MethodCheckInfo.LogFont.lfWeight=i;

		//Cfg
		pobj_nv->bAutoIndent=temp_bAutoIndent;

		//\t̃Cfg
		pobj_nv->bPasteIndent=temp_bPasteIndent;

		//Euۑ邩ǂ
		pobj_nv->bSaveFindStr=temp_bSaveFindStr;

		RedrawAllWindow();		//ׂẴEBhEĕ`
	}
	if(bOptionColor){
		//J[fUCXV
		CTheme *pobj_Theme;
		pobj_Theme=pobj_DBTheme->dupli_check(obj_temp_Theme.m_name);
		*pobj_Theme=obj_temp_Theme;
		if(lstrcmp(pobj_Theme->m_name,THEMENAME_USER)==0){
			//[U[ݒ̏ꍇ͎IɃt@Cɕۑ
			pobj_Theme->save();
		}

		//ĕ`
		SetTextEditColorDesign(&tci,pobj_Theme,1);
	}
	if(bOptionRad){
		//C AWX^
		pobj_nv->bLineAdjust=temp_bLineAdjust;
	}
	if(bOptionWeb){
		pobj_nv->bCtrlKeyHyperLink=temp_bCtrlKeyHyperLink;

		pobj_nv->bSaveWebFindStr=temp_bSaveWebFindStr;

		//Web
		pobj_nv->pobj_DBDomain->copy_get(pobj_temp_DBDomain);

		//SideWebEBhEĕ\
		//delete pobj_SideWeb;
		//pobj_SideWeb=new CSideWeb(hOwner);
		//ActiveBasic::IDE::Program::mainFrame.Resized();
	}
	return;
}
BOOL CALLBACK Dlg_Option_Whole(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	NMHDR *nmhdr;
	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(GetParent(hwnd));

			bOptionWhole=1;

			//śAvWFNg̕ۑmF̗L
			if(pobj_nv->bSaveCheckProject) SendDlgItemMessage(hwnd,IDC_SAVECHECK,BM_SETCHECK,BST_CHECKED,0);

			//hLgۑƂɃ^u擪ɍĔzu邩ǂ
			if(pobj_nv->bSaveTabToHead) SendDlgItemMessage(hwnd,IDC_SAVE_TAB_TO_HEAD,BM_SETCHECK,BST_CHECKED,0);

			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_LINKFILE:
					ExtensionLink(hwnd);
					return 1;
			}
			break;
		case WM_NOTIFY:
			nmhdr=(NMHDR *)lParam;
			if(nmhdr->code==PSN_APPLY||nmhdr->code==PSN_KILLACTIVE){
				//śAvWFNg̕ۑmF̗L
				if(SendDlgItemMessage(hwnd,IDC_SAVECHECK,BM_GETCHECK,0,0)) temp_bSaveCheckProject=1;
				else temp_bSaveCheckProject=0;

				//hLgۑƂɃ^u擪ɍĔzu邩ǂ
				if(SendDlgItemMessage(hwnd,IDC_SAVE_TAB_TO_HEAD,BM_GETCHECK,0,0)) temp_bSaveTabToHead=1;
				else temp_bSaveTabToHead=0;

				if(nmhdr->code==PSN_APPLY) SaveSetting();
			}
			return 1;
		case WM_HELP:
			HELPINFO *lpHelpInfo;
			lpHelpInfo = (HELPINFO *)lParam;

			HH_POPUP hp;
			memset(&hp, 0, sizeof(HH_POPUP));
			hp.cbStruct = sizeof(HH_POPUP);
			hp.pt.x = lpHelpInfo->MousePos.x;
			hp.pt.y = lpHelpInfo->MousePos.y+10;
			hp.clrForeground = RGB(0, 0, 0);
			hp.clrBackground = -1;
			hp.rcMargins.left = -1;
			hp.rcMargins.right = -1;
			hp.rcMargins.top = -1;
			hp.rcMargins.bottom = -1;
			hp.idString = 0;
			hp.pszFont="MS Sans Serif,10";

			switch(lpHelpInfo->iCtrlId){
				case IDC_SAVECHECK:
#if defined(JPN)
					//{
					hp.pszText="̃`FbN{bNXIɂƁAvWFNgۑ̏ԂłƂARpCɕۑmF̃_CAO{bNX\悤ɂȂ܂B\n`FbNItɂƁAvWFNg̓RpCɎIɕۑ܂iftHg̓ItłjB";
#else
					//p
					hp.pszText="When the compiling button is clicked, if this check is on, the DialogBox to save modification is displayed.\nIf this check is off, the project is saved automatically(Default).";
#endif
					break;
				case IDC_LINKFILE:
#if defined(JPN)
					//{
					hp.pszText="t@C̊֘Ats܂B";
#else
					//p
					hp.pszText="Relate the files.";
#endif
					break;
				default:
					hp.pszText="";
					break;
			}
			HtmlHelp(hwnd, 0, HH_DISPLAY_TEXT_POPUP, (DWORD)&hp);
			return 1;
	}
	return 0;
}
BOOL CALLBACK Dlg_Option_Editor(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern METHODCHECKINFO MethodCheckInfo;
	char str[255];
	NMHDR *nmhdr;
	switch(message){
		case WM_INITDIALOG:
			bOptionEditor=1;

			//tHg
			sprintf(str,"%s",pobj_nv->lf.lfFaceName);
			SetDlgItemText(hwnd,IDC_SETFONT,str);
			temp_lf=pobj_nv->lf;

			//^uTCY
			sprintf(str,"%d",pobj_nv->TabSize);
			SetDlgItemText(hwnd,IDC_TABSIZE,str);

			//GfB^̍sԍ\邩ǂ
			if(pobj_nv->bEditor_LineNumber) SendDlgItemMessage(hwnd,IDC_LINENUMBER,BM_SETCHECK,BST_CHECKED,0);

			//GfB^̃[[\邩ǂ
			if(pobj_nv->bEditor_Ruler) SendDlgItemMessage(hwnd,IDC_RULER,BM_SETCHECK,BST_CHECKED,0);

			//J[\s\邩ǂ
			if(pobj_nv->bEditor_CaretLine_BackGround) SendDlgItemMessage(hwnd,IDC_CARETLINE_BACKGROUND,BM_SETCHECK,BST_CHECKED,0);

#ifdef THETEXT
			//܂Ԃ̈s̕
			sprintf(str,"%d",pobj_nv->iMaxOneLineTextLength);
			SetDlgItemText(hwnd,IDC_MAX_ONELINE_TEXT_LENGTH,str);
#endif

			//Cfg
			if(pobj_nv->bAutoIndent) SendDlgItemMessage(hwnd,IDC_ISAUTOINDENT,BM_SETCHECK,BST_CHECKED,0);

			//\t̃Cfg
			if(pobj_nv->bPasteIndent) SendDlgItemMessage(hwnd,IDC_PASTEINDENT,BM_SETCHECK,BST_CHECKED,0);

			//R[h⊮
			if(pobj_nv->bShowComplementWnd)
				SendDlgItemMessage(hwnd,IDC_COMPLEMENT,BM_SETCHECK,BST_CHECKED,0);

			//yAXe[gg⊮
			SendDlgItemMessage(hwnd,IDC_BACKNUM,EM_SETLIMITTEXT,4,0);
			if(pobj_nv->BackNum_PairStatementComplement){
				SendDlgItemMessage(hwnd,IDC_PAIRSTATEMENT,BM_SETCHECK,BST_CHECKED,0);
				sprintf(str,"%d",pobj_nv->BackNum_PairStatementComplement);
				SetDlgItemText(hwnd,IDC_BACKNUM,str);
			}

			SendMessage(hwnd,WM_COMMAND,IDC_COMPLEMENT,0);

			//p[^ qg
			if(pobj_nv->dwParameterHint){
				SendDlgItemMessage(hwnd,IDC_PARAMHINT,BM_SETCHECK,BST_CHECKED,0);
				if(pobj_nv->dwParameterHint==1)
					SendDlgItemMessage(hwnd,IDC_POPUP,BM_SETCHECK,BST_CHECKED,0);
				else
					SendDlgItemMessage(hwnd,IDC_STATUSBAR,BM_SETCHECK,BST_CHECKED,0);
				SendMessage(hwnd,WM_COMMAND,IDC_PARAMHINT,0);
			}
			else SendDlgItemMessage(hwnd,IDC_POPUP,BM_SETCHECK,BST_CHECKED,0);

			//p[^ qg tHg
			sprintf(str,"%s",MethodCheckInfo.LogFont.lfFaceName);
			SetDlgItemText(hwnd,IDC_HINTFONT,str);
			temp_HintFont=MethodCheckInfo.LogFont;

			//Euۑ邩ǂ
			if(pobj_nv->bSaveFindStr) SendDlgItemMessage(hwnd,IDC_SAVE_FINDSTR,BM_SETCHECK,BST_CHECKED,0);

			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_SETFONT:
					if(!SetFontDialog(hwnd,&temp_lf,1)) return 1;
					sprintf(str,"%s",temp_lf.lfFaceName);
					SetDlgItemText(hwnd,IDC_SETFONT,str);
					return 1;
				case IDC_HINTFONT:
					if(!SetFontDialog(hwnd,&temp_HintFont,0)) return 1;
					sprintf(str,"%s",temp_HintFont.lfFaceName);
					SetDlgItemText(hwnd,IDC_HINTFONT,str);
					return 1;

				case IDC_ISAUTOINDENT:
				case IDC_COMPLEMENT:
					if(SendDlgItemMessage(hwnd,IDC_ISAUTOINDENT,BM_GETCHECK,0,0)&&
						SendDlgItemMessage(hwnd,IDC_COMPLEMENT,BM_GETCHECK,0,0)){
						EnableWindow(GetDlgItem(hwnd,IDC_PAIRSTATEMENT),1);
						SendMessage(hwnd,WM_COMMAND,IDC_PAIRSTATEMENT,0);
					}
					else{
						EnableWindow(GetDlgItem(hwnd,IDC_PAIRSTATEMENT),0);
						EnableWindow(GetDlgItem(hwnd,IDC_BACKNUM),0);
						EnableWindow(GetDlgItem(hwnd,IDC_STATIC_PAIRSTATEMENT),0);
					}
					return 1;

				case IDC_PAIRSTATEMENT:
					if(SendDlgItemMessage(hwnd,IDC_PAIRSTATEMENT,BM_GETCHECK,0,0)){
						EnableWindow(GetDlgItem(hwnd,IDC_BACKNUM),1);
						EnableWindow(GetDlgItem(hwnd,IDC_STATIC_PAIRSTATEMENT),1);

						if(GetWindowTextLength(GetDlgItem(hwnd,IDC_BACKNUM))==0)
							SetDlgItemText(hwnd,IDC_BACKNUM,"100");
					}
					else{
						EnableWindow(GetDlgItem(hwnd,IDC_BACKNUM),0);
						EnableWindow(GetDlgItem(hwnd,IDC_STATIC_PAIRSTATEMENT),0);
					}
					return 1;

				case IDC_PARAMHINT:
					if(SendDlgItemMessage(hwnd,IDC_PARAMHINT,BM_GETCHECK,0,0)){
						EnableWindow(GetDlgItem(hwnd,IDC_POPUP),1);
						EnableWindow(GetDlgItem(hwnd,IDC_STATUSBAR),1);
						if(SendDlgItemMessage(hwnd,IDC_POPUP,BM_GETCHECK,0,0)){
							EnableWindow(GetDlgItem(hwnd,IDC_STATIC_HINTFONT),1);
							EnableWindow(GetDlgItem(hwnd,IDC_HINTFONT),1);
						}
					}
					else{
						EnableWindow(GetDlgItem(hwnd,IDC_POPUP),0);
						EnableWindow(GetDlgItem(hwnd,IDC_STATUSBAR),0);
						EnableWindow(GetDlgItem(hwnd,IDC_STATIC_HINTFONT),0);
						EnableWindow(GetDlgItem(hwnd,IDC_HINTFONT),0);
					}
					return 1;
				case IDC_POPUP:
					EnableWindow(GetDlgItem(hwnd,IDC_STATIC_HINTFONT),1);
					EnableWindow(GetDlgItem(hwnd,IDC_HINTFONT),1);
					return 1;
				case IDC_STATUSBAR:
					EnableWindow(GetDlgItem(hwnd,IDC_STATIC_HINTFONT),0);
					EnableWindow(GetDlgItem(hwnd,IDC_HINTFONT),0);
					return 1;
			}
			break;
		case WM_NOTIFY:
			nmhdr=(NMHDR *)lParam;
			if(nmhdr->code==PSN_APPLY||nmhdr->code==PSN_KILLACTIVE){
				GetDlgItemText(hwnd,IDC_TABSIZE,str,255);
				sscanf(str,"%d",&temp_TabSize);

				//GfB^̍sԍ\邩ǂ
				if(SendDlgItemMessage(hwnd,IDC_LINENUMBER,BM_GETCHECK,0,0)) temp_bEditor_LineNumber=1;
				else temp_bEditor_LineNumber=0;

				//GfB^̃[[\邩ǂ
				if(SendDlgItemMessage(hwnd,IDC_RULER,BM_GETCHECK,0,0)) temp_bEditor_Ruler=1;
				else temp_bEditor_Ruler=0;

				//J[\s\邩ǂ
				if(SendDlgItemMessage(hwnd,IDC_CARETLINE_BACKGROUND,BM_GETCHECK,0,0)) temp_bEditor_CaretLine_BackGround=1;
				else temp_bEditor_CaretLine_BackGround=0;

#ifdef THETEXT
				//܂Ԃ̈s̕
				GetDlgItemText(hwnd,IDC_MAX_ONELINE_TEXT_LENGTH,str,255);
				sscanf(str,"%d",&temp_iMaxOneLineTextLength);
				if(temp_iMaxOneLineTextLength<=0){
					temp_iMaxOneLineTextLength=75;
				}
#endif

				//Cfg
				if(SendDlgItemMessage(hwnd,IDC_ISAUTOINDENT,BM_GETCHECK,0,0)) temp_bAutoIndent=1;
				else temp_bAutoIndent=0;

				//\t̃Cfg
				if(SendDlgItemMessage(hwnd,IDC_PASTEINDENT,BM_GETCHECK,0,0)) temp_bPasteIndent=1;
				else temp_bPasteIndent=0;

				//R[h⊮@\
				if(SendDlgItemMessage(hwnd,IDC_COMPLEMENT,BM_GETCHECK,0,0))
					temp_bShowComplementWnd=1;
				else temp_bShowComplementWnd=0;

				//yAXe[gg⊮
				if(IsWindowEnabled(GetDlgItem(hwnd,IDC_PAIRSTATEMENT))){
					if(SendDlgItemMessage(hwnd,IDC_PAIRSTATEMENT,BM_GETCHECK,0,0)){
						GetDlgItemText(hwnd,IDC_BACKNUM,str,255);
						sscanf(str,"%d",&temp_BackNum_PairStatementComplement);
					}
					else temp_BackNum_PairStatementComplement=0;
				}
				else temp_BackNum_PairStatementComplement=0;

				//p[^qg
				if(SendDlgItemMessage(hwnd,IDC_PARAMHINT,BM_GETCHECK,0,0)){
					if(SendDlgItemMessage(hwnd,IDC_POPUP,BM_GETCHECK,0,0)) temp_dwParameterHint=1;
					else temp_dwParameterHint=2;
				}
				else temp_dwParameterHint=0;

				if(SendDlgItemMessage(hwnd,IDC_SAVE_FINDSTR,BM_GETCHECK,0,0))
					temp_bSaveFindStr=1;
				else temp_bSaveFindStr=0;

				if(nmhdr->code==PSN_APPLY) SaveSetting();
			}
			return 1;

		case WM_HELP:
			HELPINFO *lpHelpInfo;
			lpHelpInfo = (HELPINFO *)lParam;

			HH_POPUP hp;
			memset(&hp, 0, sizeof(HH_POPUP));
			hp.cbStruct = sizeof(HH_POPUP);
			hp.pt.x = lpHelpInfo->MousePos.x;
			hp.pt.y = lpHelpInfo->MousePos.y+10;
			hp.clrForeground = RGB(0, 0, 0);
			hp.clrBackground = -1;
			hp.rcMargins.left = -1;
			hp.rcMargins.right = -1;
			hp.rcMargins.top = -1;
			hp.rcMargins.bottom = -1;
			hp.idString = 0;
			hp.pszFont="MS Sans Serif,10";

			switch(lpHelpInfo->iCtrlId){
				case IDC_STATIC_SETFONT:
				case IDC_SETFONT:
#if defined(JPN)
					//{
					hp.pszText="GfB^ŎgptHgI邱Ƃł܂B";
#else
					//p
					hp.pszText="Choose the font displayed on the editor";
#endif
					break;
				case IDC_STATIC_TABSIZE:
				case IDC_TABSIZE:
#if defined(JPN)
					//{
					hp.pszText="^uTCYw肵܂BftHgl4łB";
#else
					//p
					hp.pszText="Set the tab size. Value of default is 4.";
#endif
					break;
				case IDC_ISAUTOINDENT:
#if defined(JPN)
					//{
					hp.pszText="̃`FbNIɂƁAKvɉāAIɃCfgp̃^u}܂B";
#else
					//p
					hp.pszText="If this check is on, the indent tabs will be inserted automatically.";
#endif
					break;
				case IDC_COMPLEMENT:
#if defined(JPN)
					//{
					hp.pszText="̃`FbNIɂƁANX܂͍\̂̃o͂ƂɁA\zL[[hXg\܂B";
#else
					//p
					hp.pszText="If this check is on, the member expected is displayed in a list when inputting the member of the class object.";
#endif
					break;
				case IDC_PARAMHINT:
#if defined(JPN)
					//{
					hp.pszText="̃`FbNIɂƁA֐܂̓Xe[gg͂ƂɁAYp[^̃qg񂪕\܂B̕\@̓|bvAbv܂̓Xe[^Xo[̂ꂩI邱Ƃł܂B";
#else
					//p
					hp.pszText="If this check is on, parameter hint is displayed when inputting a function or a statement.";
#endif
					break;
				case IDC_POPUP:
#if defined(JPN)
					//{
					hp.pszText="p[^qg|bvAbv\Ƃ́A`FbN܂B";
#else
					//p
					hp.pszText="If this check is on, parameter hint is displayed on a popup window.";
#endif
					break;
				case IDC_STATUSBAR:
#if defined(JPN)
					//{
					hp.pszText="p[^qgXe[^Xo[ɕ\Ƃ́A`FbN܂B";
#else
					//p
					hp.pszText="If this check is on, parameter hint is displayed in a status bar.";
#endif
					break;
				case IDC_STATIC_HINTFONT:
				case IDC_HINTFONT:
#if defined(JPN)
					//{
					hp.pszText="|bvAbv\p[^qg̃tHgw肵܂B";
#else
					//p
					hp.pszText="Choose the font displayed on the popup hint.";
#endif
					break;
				default:
					hp.pszText="";
					break;
			}
			HtmlHelp(hwnd, 0, HH_DISPLAY_TEXT_POPUP, (DWORD)&hp);
			return 1;
	}
	return 0;
}
COLORREF GetColorFromSelection(int iPos,TEXTEDIT_COLOR_INFO *ptci){
	if(iPos==0) return ptci->rgbComment;
	else if(iPos==1) return ptci->rgbString;
	else if(iPos==2) return ptci->rgbDefault;
	else if(iPos==3) return ptci->rgbStatement;
	else if(iPos==4) return ptci->rgbCursorBack;
	else if(iPos==5) return ptci->rgbBackground;
	return 0;
}
void SetColorFromSelection(int iPos,COLORREF rgb,TEXTEDIT_COLOR_INFO *ptci){
	if(iPos==0) ptci->rgbComment=rgb;
	else if(iPos==1) ptci->rgbString=rgb;
	else if(iPos==2) ptci->rgbDefault=rgb;
	else if(iPos==3) ptci->rgbStatement=rgb;
	else if(iPos==4) ptci->rgbCursorBack=rgb;
	else if(iPos==5) ptci->rgbBackground=rgb;
}
#ifdef THETEXT
char szNewThemeName[MAX_PATH];
BOOL bThemeOverwirte;
BOOL CALLBACK DlgOptionThemeSave(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(hwnd);

			SendMessage(hwnd,WM_COMMAND,IDC_NAME,0);
			SetFocus(GetDlgItem(hwnd,IDC_NAME));
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					GetDlgItemText(hwnd,IDC_NAME,szNewThemeName,MAX_PATH);

					if(SendDlgItemMessage(hwnd,IDC_OVERWRITE,BM_GETCHECK,0,0))
						bThemeOverwirte=1;
					else bThemeOverwirte=0;

					if(pobj_DBTheme->dupli_check(szNewThemeName)){
						if(!bThemeOverwirte){
							char temporary[MAX_PATH];
							sprintf(temporary,"e[} \"%s\" ͊ɑ݂܂Bu㏑v`FbNAۑĂB",szNewThemeName);
							MessageBox(hwnd,temporary,APPLICATION_NAME,MB_OK);
							return 1;
						}
					}

					EndDialog(hwnd,1);
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
				case IDC_NAME:
					if(GetWindowTextLength(GetDlgItem(hwnd,IDC_NAME)))
						EnableWindow(GetDlgItem(hwnd,IDOK),1);
					else EnableWindow(GetDlgItem(hwnd,IDOK),0);
					return 1;
			}
			break;
	}
	return 0;
}
#endif
BOOL CALLBACK Dlg_Option_Color(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	int iPos;
	CTheme *pobj_Theme;
	char temporary[MAX_PATH];
	switch(message){
		case WM_INITDIALOG:
			bOptionColor=1;

			//ꎞۑl
			pobj_Theme=pobj_DBTheme->GetActiveTheme();
			obj_temp_Theme=*pobj_Theme;

			//w肷镔
			SendDlgItemMessage(hwnd,IDC_TARGET,CB_ADDSTRING,0,(LPARAM)"Rg");
			SendDlgItemMessage(hwnd,IDC_TARGET,CB_ADDSTRING,0,(LPARAM)"_uNH[g̕");
			SendDlgItemMessage(hwnd,IDC_TARGET,CB_ADDSTRING,0,(LPARAM)"ʏ̕");
			SendDlgItemMessage(hwnd,IDC_TARGET,CB_ADDSTRING,0,(LPARAM)"Xe[gg");
			SendDlgItemMessage(hwnd,IDC_TARGET,CB_ADDSTRING,0,(LPARAM)"wiFiJ[\sj");
			SendDlgItemMessage(hwnd,IDC_TARGET,CB_ADDSTRING,0,(LPARAM)"wiFiʁj");
			SendDlgItemMessage(hwnd,IDC_TARGET,CB_SETCURSEL,0,0);


			//e[}R{{bNXɃZbg
			pobj_DBTheme->ResetTheme_ToComboBox(GetDlgItem(hwnd,IDC_THEME));


			SendMessage(hwnd,WM_COMMAND,MAKELONG(IDC_THEME,CBN_SELCHANGE),0);
			break;

		case WM_COMMAND:
			switch(LOWORD(wParam)){
#ifdef THETEXT
				case IDC_SAVE:
					if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_OPTION_THEME_SAVE),hwnd,(DLGPROC)DlgOptionThemeSave)) return 1;

					pobj_Theme=pobj_DBTheme->dupli_check(szNewThemeName);
					if(pobj_Theme){
					}
					else{
						//VKɒǉ
						pobj_Theme=pobj_DBTheme->add(0,szNewThemeName);
					}
					*pobj_Theme=obj_temp_Theme;
					lstrcpy(pobj_Theme->m_name,szNewThemeName);

					//t@Cɕۑ
					pobj_Theme->save();

					//e[} R{{bNX̃J[\ʒuZbg
					ComboBox_SetSelText(GetDlgItem(hwnd,IDC_THEME),szNewThemeName);

					return 1;
#endif //THETEXT
				case IDC_THEME:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						if(!SendDlgItemMessage(hwnd,IDC_THEME,CB_GETLBTEXT,
							SendDlgItemMessage(hwnd,IDC_THEME,CB_GETCURSEL,0,0),
							(LPARAM)temporary)) return 1;

						pobj_Theme=pobj_DBTheme->dupli_check(temporary);
						obj_temp_Theme=*pobj_Theme;

						InvalidateRect(GetDlgItem(hwnd,IDC_SAMPLE),NULL,0);
						InvalidateRect(GetDlgItem(hwnd,IDC_COLOR_BUTTON),NULL,0);
					}
					return 1;
				case IDC_TARGET:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						InvalidateRect(GetDlgItem(hwnd,IDC_COLOR_BUTTON),NULL,0);
					}
					return 1;
				case IDC_COLOR_BUTTON:
					iPos=SendDlgItemMessage(hwnd,IDC_TARGET,CB_GETCURSEL,0,0);

					CHOOSECOLOR cc;
					static COLORREF CustColors[16];
					cc.lStructSize=sizeof(CHOOSECOLOR);
					cc.hwndOwner=hwnd;
					cc.rgbResult=GetColorFromSelection(iPos,&obj_temp_Theme.TextColorInfo);
					cc.lpCustColors=CustColors;
					cc.Flags=CC_FULLOPEN | CC_RGBINIT;
					if(!ChooseColor(&cc)) return 1;

					SetColorFromSelection(iPos,cc.rgbResult,&obj_temp_Theme.TextColorInfo);

					InvalidateRect(GetDlgItem(hwnd,IDC_COLOR_BUTTON),NULL,0);
					InvalidateRect(GetDlgItem(hwnd,IDC_SAMPLE),NULL,0);

					lstrcpy(obj_temp_Theme.m_name,THEMENAME_USER);

					//[U[ݒI
					ComboBox_SetSelText(GetDlgItem(hwnd,IDC_THEME),THEMENAME_USER);
					return 1;
			}
			break;

		case WM_NOTIFY:
			NMHDR *nmhdr;
			nmhdr=(NMHDR *)lParam;

			if(nmhdr->code==PSN_APPLY) SaveSetting();
			return 1;

		case WM_DRAWITEM:
			LPDRAWITEMSTRUCT pds;
			pds=(LPDRAWITEMSTRUCT)lParam;

			HBRUSH hBrush,hOldBrush;

			if(wParam==IDC_COLOR_BUTTON){
				iPos=SendDlgItemMessage(hwnd,IDC_TARGET,CB_GETCURSEL,0,0);

				//////////////
				// F`
				//////////////

				//yƃuV𐶐
				HPEN hPen,hOldPen;
				hPen=(HPEN)GetStockObject(WHITE_PEN);
				if(IsWindowEnabled(GetDlgItem(hwnd,IDC_COLOR_BUTTON)))
					hBrush=CreateSolidBrush(GetColorFromSelection(iPos,&obj_temp_Theme.TextColorInfo));
				else
					hBrush=CreateSolidBrush(GetSysColor(COLOR_3DFACE));

				//hԂ
				hOldPen=(HPEN)SelectObject(pds->hDC,hPen);
				hOldBrush=(HBRUSH)SelectObject(pds->hDC,hBrush);
				Rectangle(pds->hDC,0,0,pds->rcItem.right,pds->rcItem.bottom);
				SelectObject(pds->hDC,hOldPen);
				SelectObject(pds->hDC,hOldBrush);

				//uVj
				DeleteObject(hBrush);
			}
			else if(wParam==IDC_SAMPLE){
				TEXTEDIT_COLOR_INFO ColorInfo;
				ColorInfo=obj_temp_Theme.TextColorInfo;

				//wiFœhԂ
				hBrush=CreateSolidBrush(ColorInfo.rgbBackground);
				hOldBrush=(HBRUSH)SelectObject(pds->hDC,hBrush);
				PatBlt(pds->hDC,0,0,pds->rcItem.right,pds->rcItem.bottom,PATCOPY);
				SelectObject(pds->hDC,hOldBrush);
				DeleteObject(hBrush);

				//tHgI
				extern HFONT hFont_TextEdit;
				HFONT hOldFont;
				hOldFont=(HFONT)SelectObject(pds->hDC,hFont_TextEdit);

				///////////////////
				// Tv`
				///////////////////

				extern int font_width,font_height;
				int x=0,y=0;

#ifdef THETEXT
#define SAMPLESTR_STATEMENT "div"
#define SAMPLESTR_COMMENT "<!-- ̍sɃJ[\܂ -->"
#define SAMPLESTR_DEFAULT "<    style=               >Hello World!</   >"
#define SAMPLESTR_STRING "\"color:#123456\""

				y+=font_height;

				//"<    style=               >Hello World!</   >"
				SetTextColor(pds->hDC,ColorInfo.rgbDefault);
				SetBkColor(pds->hDC,ColorInfo.rgbBackground);
				TextOut(pds->hDC,x,y,SAMPLESTR_DEFAULT,lstrlen(SAMPLESTR_DEFAULT));

				//div
				x=font_width*1;
				SetTextColor(pds->hDC,ColorInfo.rgbStatement);
				TextOut(pds->hDC,x,y,SAMPLESTR_STATEMENT,lstrlen(SAMPLESTR_STATEMENT));
				x=font_width*41;
				TextOut(pds->hDC,x,y,SAMPLESTR_STATEMENT,lstrlen(SAMPLESTR_STATEMENT));

				//"color:#123456"
				x=font_width*11;
				SetTextColor(pds->hDC,ColorInfo.rgbString);
				TextOut(pds->hDC,x,y,SAMPLESTR_STRING,lstrlen(SAMPLESTR_STRING));

				x=0;
				y+=font_height*2;

				//"'̍sɃJ[\܂
				hBrush=CreateSolidBrush(ColorInfo.rgbCursorBack);
				hOldBrush=(HBRUSH)SelectObject(pds->hDC,hBrush);
				PatBlt(pds->hDC,x,y,pds->rcItem.right,font_height,PATCOPY);
				SelectObject(pds->hDC,hOldBrush);
				DeleteObject(hBrush);

				SetTextColor(pds->hDC,ColorInfo.rgbComment);
				SetBkColor(pds->hDC,ColorInfo.rgbCursorBack);
				TextOut(pds->hDC,x,y,SAMPLESTR_COMMENT,lstrlen(SAMPLESTR_COMMENT));
#else
#define SAMPLESTR_STATEMENT "#console"
#define SAMPLESTR_COMMENT "'̍sɃJ[\܂"
#define SAMPLESTR_DEFAULT "Print "
#define SAMPLESTR_STRING "\"Hello World!\""

				//"#console"
				SetTextColor(pds->hDC,ColorInfo.rgbStatement);
				SetBkColor(pds->hDC,ColorInfo.rgbBackground);
				TextOut(pds->hDC,0,0,SAMPLESTR_STATEMENT,lstrlen(SAMPLESTR_STATEMENT));
				y+=font_height*2;

				//"'̍sɃJ[\܂
				hBrush=CreateSolidBrush(ColorInfo.rgbCursorBack);
				hOldBrush=(HBRUSH)SelectObject(pds->hDC,hBrush);
				PatBlt(pds->hDC,x,y,pds->rcItem.right,font_height,PATCOPY);
				SelectObject(pds->hDC,hOldBrush);
				DeleteObject(hBrush);

				SetTextColor(pds->hDC,ColorInfo.rgbComment);
				SetBkColor(pds->hDC,ColorInfo.rgbCursorBack);
				TextOut(pds->hDC,x,y,SAMPLESTR_COMMENT,lstrlen(SAMPLESTR_COMMENT));
				y+=font_height*2;

				//Print
				SetTextColor(pds->hDC,ColorInfo.rgbDefault);
				SetBkColor(pds->hDC,ColorInfo.rgbBackground);
				TextOut(pds->hDC,x,y,SAMPLESTR_DEFAULT,lstrlen(SAMPLESTR_DEFAULT));
				x+=lstrlen(SAMPLESTR_DEFAULT)*font_width;

				//"Hello World!"
				SetTextColor(pds->hDC,ColorInfo.rgbString);
				TextOut(pds->hDC,x,y,SAMPLESTR_STRING,lstrlen(SAMPLESTR_STRING));
#endif

				SelectObject(pds->hDC,hOldFont);
			}
			return 0;

		case WM_HELP:
			HELPINFO *lpHelpInfo;
			lpHelpInfo = (HELPINFO *)lParam;

			HH_POPUP hp;
			memset(&hp, 0, sizeof(HH_POPUP));
			hp.cbStruct = sizeof(HH_POPUP);
			hp.pt.x = lpHelpInfo->MousePos.x;
			hp.pt.y = lpHelpInfo->MousePos.y+10;
			hp.clrForeground = RGB(0, 0, 0);
			hp.clrBackground = -1;
			hp.rcMargins.left = -1;
			hp.rcMargins.right = -1;
			hp.rcMargins.top = -1;
			hp.rcMargins.bottom = -1;
			hp.idString = 0;
			hp.pszFont="MS Sans Serif,10";

			switch(lpHelpInfo->iCtrlId){
				case IDC_TARGET:
					hp.pszText="ǂ̐̕Fݒ肷邩I܂B";
					break;
				default:
					hp.pszText="";
					break;
			}
			HtmlHelp(hwnd, 0, HH_DISPLAY_TEXT_POPUP, (DWORD)&hp);
			return 1;
	}
	return 0;
}
BOOL CALLBACK Dlg_Option_Toolbar(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	switch(message){
		case WM_INITDIALOG:
			bOptionToolbar=1;
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_RESETTOOLBAR:
					//"c[o[̔zuׂďԂɖ߂܂B\n낵łH"
					if(IDCANCEL==MessageBox(hwnd,STRING_TOOLBAR_RESET,APPLICATION_NAME,MB_OKCANCEL|MB_ICONEXCLAMATION)) break;

					//o[Rg[Đ
					pobj_Rebar->ResetInitRebar();

					//j[Ԃݒ
					ResetState_DocMenu();
					return 1;
			}
			break;

		case WM_HELP:
			HELPINFO *lpHelpInfo;
			lpHelpInfo = (HELPINFO *)lParam;

			HH_POPUP hp;
			memset(&hp, 0, sizeof(HH_POPUP));
			hp.cbStruct = sizeof(HH_POPUP);
			hp.pt.x = lpHelpInfo->MousePos.x;
			hp.pt.y = lpHelpInfo->MousePos.y+10;
			hp.clrForeground = RGB(0, 0, 0);
			hp.clrBackground = -1;
			hp.rcMargins.left = -1;
			hp.rcMargins.right = -1;
			hp.rcMargins.top = -1;
			hp.rcMargins.bottom = -1;
			hp.idString = 0;
			hp.pszFont="MS Sans Serif,10";

			switch(lpHelpInfo->iCtrlId){
				case IDC_RESETTOOLBAR:
#if defined(JPN)
					//{
					hp.pszText="c[o[̔zuԂɖ߂܂B";
#else
					//p
					hp.pszText="Reset the state of the toolbar.";
#endif
					break;
				default:
					hp.pszText="";
					break;
			}
			HtmlHelp(hwnd, 0, HH_DISPLAY_TEXT_POPUP, (DWORD)&hp);
			return 1;
	}
	return 0;
}
BOOL CALLBACK Dlg_Option_Rad(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	NMHDR *nmhdr;
	switch(message){
		case WM_INITDIALOG:

			bOptionRad=1;

			//C AWX^
			if(pobj_nv->bLineAdjust) SendDlgItemMessage(hwnd,IDC_LINEADJUST,BM_SETCHECK,BST_CHECKED,0);

			break;
		case WM_NOTIFY:
			nmhdr=(NMHDR *)lParam;
			if(nmhdr->code==PSN_APPLY||nmhdr->code==PSN_KILLACTIVE){
				if(SendDlgItemMessage(hwnd,IDC_LINEADJUST,BM_GETCHECK,0,0)) temp_bLineAdjust=1;
				else temp_bLineAdjust=0;

				if(nmhdr->code==PSN_APPLY) SaveSetting();
			}
			return 1;

		case WM_HELP:
			HELPINFO *lpHelpInfo;
			lpHelpInfo = (HELPINFO *)lParam;

			HH_POPUP hp;
			memset(&hp, 0, sizeof(HH_POPUP));
			hp.cbStruct = sizeof(HH_POPUP);
			hp.pt.x = lpHelpInfo->MousePos.x;
			hp.pt.y = lpHelpInfo->MousePos.y+10;
			hp.clrForeground = RGB(0, 0, 0);
			hp.clrBackground = -1;
			hp.rcMargins.left = -1;
			hp.rcMargins.right = -1;
			hp.rcMargins.top = -1;
			hp.rcMargins.bottom = -1;
			hp.idString = 0;
			hp.pszFont="MS Sans Serif,10";

			switch(lpHelpInfo->iCtrlId){
				case IDC_LINEADJUST:
#if defined(JPN)
					//{
					hp.pszText="̃`FbN{bNXIɂƁACAWX^@\LɂȂ܂BCAWX^@\IɂƁA}EXgăRg[̈ړsۂɑ̃Rg[mƂ̈ʒu킹eՂɍs悤ɂȂ܂B";
#else
					//p
					hp.pszText="If this check is on, line adjuster becomes effective.";
#endif
					break;
				default:
					hp.pszText="";
					break;
			}
			HtmlHelp(hwnd, 0, HH_DISPLAY_TEXT_POPUP, (DWORD)&hp);
			return 1;
	}
	return 0;
}
char szDomainAdd_Name[255];
char szDomainAdd_Domain[255];
BOOL CALLBACK Dlg_Option_Web_Domain_Add(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(hwnd);
			SetFocus(GetDlgItem(hwnd,IDC_NAME));

			if(lParam!=-1){
				SetWindowText(hwnd,"WebphCҏW");
				SetDlgItemText(hwnd,IDC_NAME,szDomainAdd_Name);
				SetDlgItemText(hwnd,IDC_DOMAIN,szDomainAdd_Domain);
			}
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					GetDlgItemText(hwnd,IDC_NAME,szDomainAdd_Name,255);
					GetDlgItemText(hwnd,IDC_DOMAIN,szDomainAdd_Domain,255);
					EndDialog(hwnd,1);
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
			}
			return 0;
	}
	return 0;
}
BOOL CALLBACK Dlg_Option_Web(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	HWND hListView;
	NMHDR *nmhdr;
	int i;
	char temporary[255];
	switch(message){
		case WM_INITDIALOG:

			bOptionWeb=1;


			//CtrlL[ɂnCp[N
			if(pobj_nv->bCtrlKeyHyperLink) SendDlgItemMessage(hwnd,IDC_CTRLKEY_HYPERLINK,BM_SETCHECK,BST_CHECKED,0);

			//Webۑ邩ǂ
			if(pobj_nv->bSaveWebFindStr) SendDlgItemMessage(hwnd,IDC_SAVE_WEBFINDSTR,BM_SETCHECK,BST_CHECKED,0);


			//gX^C
			DWORD dwStyle;
			hListView=GetDlgItem(hwnd,IDC_DOMAIN_LIST);
			dwStyle=ListView_GetExtendedListViewStyle(hListView);
			dwStyle|=LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES;
			ListView_SetExtendedListViewStyle(hListView,dwStyle);

			LV_COLUMN ListView_Column;
			ListView_Column.mask=LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
			ListView_Column.fmt=LVCFMT_LEFT;

			ListView_Column.cx=80;
			ListView_Column.pszText="\";
			ListView_Column.iSubItem=0;
			ListView_InsertColumn(hListView,ListView_Column.iSubItem,&ListView_Column);

			ListView_Column.cx=200;
			ListView_Column.pszText="hC";
			ListView_Column.iSubItem++;
			ListView_InsertColumn(hListView,ListView_Column.iSubItem,&ListView_Column);

			//ꎞIuWFNgɃRs[
			pobj_temp_DBDomain->copy_get(pobj_nv->pobj_DBDomain);

			//hCXgɃf[^Zbg
			pobj_temp_DBDomain->SetListView(hListView);

			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_ADD:
					if(!DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_OPTION_WEB_DOMAIN_ADD),hwnd,(DLGPROC)Dlg_Option_Web_Domain_Add,-1)) return 1;

					pobj_temp_DBDomain->add(szDomainAdd_Name,szDomainAdd_Domain);
					return 1;
				case IDC_DELETE:
					hListView=GetDlgItem(hwnd,IDC_DOMAIN_LIST);
					for(i=0;i<ListView_GetItemCount(hListView);i++){
						if(ListView_GetItemState(hListView,i,LVIS_SELECTED)){
							ListView_GetItemText(hListView,i,0,temporary,255);
							pobj_temp_DBDomain->del(temporary);
							break;
						}
					}
					return 1;
				case IDC_EDIT:
					hListView=GetDlgItem(hwnd,IDC_DOMAIN_LIST);
					for(i=0;i<ListView_GetItemCount(hListView);i++){
						if(ListView_GetItemState(hListView,i,LVIS_SELECTED)){
							ListView_GetItemText(hListView,i,0,temporary,255);

							ListView_GetItemText(hListView,i,0,szDomainAdd_Name,255);
							ListView_GetItemText(hListView,i,1,szDomainAdd_Domain,255);
							lstrcpy(temporary,szDomainAdd_Name);
							if(!DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_OPTION_WEB_DOMAIN_ADD),hwnd,(DLGPROC)Dlg_Option_Web_Domain_Add,i)) return 1;

							pobj_temp_DBDomain->change(temporary,szDomainAdd_Name,szDomainAdd_Domain);
						}
					}
					return 1;
			}
			return 0;
		case WM_NOTIFY:
			nmhdr=(NMHDR *)lParam;
			if(nmhdr->code==PSN_APPLY||nmhdr->code==PSN_KILLACTIVE){

				//CtrlL[ɂnCp[N
				if(SendDlgItemMessage(hwnd,IDC_CTRLKEY_HYPERLINK,BM_GETCHECK,0,0)) temp_bCtrlKeyHyperLink=1;
				else temp_bCtrlKeyHyperLink=0;

				//Webۑ邩ǂ
				if(SendDlgItemMessage(hwnd,IDC_SAVE_WEBFINDSTR,BM_GETCHECK,0,0)) temp_bSaveWebFindStr=1;
				else temp_bSaveWebFindStr=0;

				if(nmhdr->code==PSN_APPLY) SaveSetting();
			}
			if(nmhdr->idFrom==IDC_DOMAIN_LIST){
				if(nmhdr->code==NM_DBLCLK){
					LPNMLISTVIEW lpnmListView;
					lpnmListView=(LPNMLISTVIEW)lParam;

					char szBeforeName[255];
					ListView_GetItemText(nmhdr->hwndFrom,lpnmListView->iItem,0,szDomainAdd_Name,255);
					ListView_GetItemText(nmhdr->hwndFrom,lpnmListView->iItem,1,szDomainAdd_Domain,255);
					lstrcpy(szBeforeName,szDomainAdd_Name);
					if(!DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_OPTION_WEB_DOMAIN_ADD),hwnd,(DLGPROC)Dlg_Option_Web_Domain_Add,lpnmListView->iItem)) return 1;

					pobj_temp_DBDomain->change(szBeforeName,szDomainAdd_Name,szDomainAdd_Domain);
				}
			}
			return 1;
	}
	return 0;
}
void DlgOptionSetting(HWND hwnd){
	PROPSHEETHEADER psh;
#define MAX_SETDLG 32
	PROPSHEETPAGE psp[MAX_SETDLG];
	HPROPSHEETPAGE hpsp[MAX_SETDLG];
	int i;

	bOptionWhole=0;
	bOptionEditor=0;
	bOptionColor=0;
	bOptionToolbar=0;
	bOptionRad=0;
	bOptionWeb=0;

	i=0;

	//ey[W̃ZbeBO
	psp[i].dwSize=sizeof(PROPSHEETPAGE);
	psp[i].dwFlags=PSP_DEFAULT;
	psp[i].hInstance=hResInst;
	psp[i].pszTemplate=MAKEINTRESOURCE(IDD_OPTION_WHOLE);
	psp[i].pfnDlgProc=(DLGPROC)Dlg_Option_Whole;
	hpsp[i]=CreatePropertySheetPage(&psp[i]);
	i++;
	psp[i].dwSize=sizeof(PROPSHEETPAGE);
	psp[i].dwFlags=PSP_DEFAULT;
	psp[i].hInstance=hResInst;
	psp[i].pszTemplate=MAKEINTRESOURCE(IDD_OPTION_EDITOR);
	psp[i].pfnDlgProc=(DLGPROC)Dlg_Option_Editor;
	hpsp[i]=CreatePropertySheetPage(&psp[i]);
	i++;
	psp[i].dwSize=sizeof(PROPSHEETPAGE);
	psp[i].dwFlags=PSP_DEFAULT;
	psp[i].hInstance=hResInst;
	psp[i].pszTemplate=MAKEINTRESOURCE(IDD_OPTION_COLOR);
	psp[i].pfnDlgProc=(DLGPROC)Dlg_Option_Color;
	hpsp[i]=CreatePropertySheetPage(&psp[i]);
	i++;
	psp[i].dwSize=sizeof(PROPSHEETPAGE);
	psp[i].dwFlags=PSP_DEFAULT;
	psp[i].hInstance=hResInst;
	psp[i].pszTemplate=MAKEINTRESOURCE(IDD_OPTION_TOOLBAR);
	psp[i].pfnDlgProc=(DLGPROC)Dlg_Option_Toolbar;
	hpsp[i]=CreatePropertySheetPage(&psp[i]);

#ifndef THETEXT
	//RADc[ɊւIvVProjectEditor̂ݕ\
	i++;
	psp[i].dwSize=sizeof(PROPSHEETPAGE);
	psp[i].dwFlags=PSP_DEFAULT;
	psp[i].hInstance=hResInst;
	psp[i].pszTemplate=MAKEINTRESOURCE(IDD_OPTION_RAD);
	psp[i].pfnDlgProc=(DLGPROC)Dlg_Option_Rad;
	hpsp[i]=CreatePropertySheetPage(&psp[i]);
#endif

	i++;
	psp[i].dwSize=sizeof(PROPSHEETPAGE);
	psp[i].dwFlags=PSP_DEFAULT;
	psp[i].hInstance=hResInst;
	psp[i].pszTemplate=MAKEINTRESOURCE(IDD_OPTION_WEB);
	psp[i].pfnDlgProc=(DLGPROC)Dlg_Option_Web;
	hpsp[i]=CreatePropertySheetPage(&psp[i]);

	i++;



	///////////////////////////
	// ꎞIuWFNg𐶐
	///////////////////////////

	pobj_temp_DBDomain=new CDBDomain();



	memset(&psh,0,sizeof(PROPSHEETHEADER));
	psh.dwSize=sizeof(PROPSHEETHEADER);
	psh.dwFlags=PSH_PROPSHEETPAGE|PSH_NOAPPLYNOW;
	psh.phpage=hpsp;
	psh.hwndParent=hwnd;
	psh.pszCaption=STRING_OPTION;	//"IvV"
	psh.nPages=i;
	psh.nStartPage=0;
	psh.ppsp=psp;
	PropertySheet(&psh);



	///////////////////////////
	// ꎞIuWFNgj
	///////////////////////////

	delete pobj_temp_DBDomain;
}
BOOL CALLBACK DialogAbout(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	if(message==WM_INITDIALOG){
		SetPosCenter(hwnd);

		SetDlgItemText(hwnd,IDC_STATIC_NAME,VERSION_APPLI_NAME);

		char temporary[1024];
		sprintf(temporary,"Version %s",VERSION_STRING);
		SetDlgItemText(hwnd,IDC_STATIC_VERSION,temporary);


#ifndef THETEXT
		//CuJ`[
		LoadString(hResInst,IDS_DEV_GROUP,temporary,1024);
		SetDlgItemText(hwnd,IDC_DEV_GROUP,temporary);
#endif
	}
	if(message==WM_COMMAND){
		switch(LOWORD(wParam)){
			case IDCANCEL:
				EndDialog(hwnd,NULL);
				return 1;
		}
	}
	return 0;
}
