#include "stdafx.h"

using namespace ActiveBasic::PM;

void OpenWorkfile( const std::string &path );

void Project::Load( char *path )
{
	extern HANDLE hHeap;
	int i,i2;
	char *buffer,temporary[MAX_PATH],temp2[MAX_PATH];

	//ɃvWFNgJĂꍇ͕
	if( this->IsOpened() ){
		if(!this->Close()) return;
	}
	//memset(&projectInfo,0,sizeof(PROJECTINFO));

	//vWFNg̍ƃfBNg擾
	_splitpath(path,temporary,temp2,0,0);
	lstrcat( temporary, temp2 );
	this->workDir = Jenga::Common::Directory( temporary );

	//t@CJAۑ̏fBNgZbg
	lstrcpy(pobj_nv->DefSaveDir,this->GetWorkDir().GetPath().c_str());



	//////////////////////////////////////////
	//vWFNgt@Ci*.pjjI[v
	buffer=ReadBuffer(path);
	if(!buffer) return;

	//
	this->pobj_DBFileInfo=new CDBFileInfo();
	bool isUseWindow = false;
	for(i=0;;i++){
		if(buffer[i]=='\0') break;
		if(buffer[i]=='\r'&&buffer[i+1]=='\n'&&buffer[i+2]=='#'){
			for(i+=3,i2=0;;i++,i2++){
				if(!IsVariableChar(buffer[i])){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			if(lstrcmpi(temporary,"VERSION")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				this->dwVersion=GetValue(temporary);
			}
			else if(lstrcmpi(temporary,"MODULETYPE")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				this->moduleType = (ActiveBasic::Common::TargetModuleType::EnumType)atoi(temporary);
			}
			else if(lstrcmpi(temporary,"NAME")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=buffer[i];
				}
				this->name = temporary;
			}
			else if(lstrcmpi(temporary,"PLATFORM")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				i2=atoi(temporary);
				extern HWND hSelectCompilerCombo;
				if(i2==32){
					//vbgtH[Win32I
					SendMessage(hSelectCompilerCombo,CB_SETCURSEL,0,0);
				}
				else if(i2==64){
					//vbgtH[Win64I
					SendMessage(hSelectCompilerCombo,CB_SETCURSEL,1,0);
				}
				SendMessage(hSelectCompilerCombo,WM_COMMAND,MAKELONG(0,CBN_SELCHANGE),0);
			}
			else if(lstrcmpi(temporary,"USEWINDOW")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				if( atoi(temporary) > 0 )
				{
					isUseWindow = true;
				}
			}
			else if(lstrcmpi(temporary,"OPTION")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				this->dwOption=GetValue(temporary);
			}
			else if(lstrcmpi(temporary,"OUTPUT_RELEASE")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				lstrcpy(this->lpszOutput_Release,temporary);
			}
			else if(lstrcmpi(temporary,"OUTPUT_DEBUG")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				lstrcpy(this->lpszOutput_Debug,temporary);
			}
			else if(lstrcmpi(temporary,"MANIFEST")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				lstrcpy(this->szManifestPath,temporary);
			}
			else if(lstrcmpi(temporary,"DEBUG_CMD_LINE")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				lstrcpy(this->szCmdLine,temporary);
			}
			else if(lstrcmpi(temporary,"DEBUG_EXE_PATH")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				lstrcpy(this->szExePath,temporary);
			}
			else if(lstrcmpi(temporary,"RESOURCE")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}

				// ̃p[^͎gpȂȂ
			}
			else if(lstrcmpi(temporary,"SOURCE")==0&&buffer[i]=='\r'&&buffer[i+1]=='\n'){
				while(1){
					for(i+=2,i2=0;;i++,i2++){
						if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
							temporary[i2]=0;
							break;
						}
						temporary[i2]=buffer[i];
					}
					if(temporary[0]=='\0') break;
					this->pobj_DBFileInfo->add(temporary,0);

					if(buffer[i]=='\0') break;
				}
			}
			else{
				//sȃp[^͖
				for(i++;;i++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
				}
			}
			if(buffer[i]=='\0') break;
		}
	}
	HeapDefaultFree(buffer);

	//Âo[Wt@Cl
	if(this->dwVersion<=4){
		if( this->GetModuleType() == ActiveBasic::Common::TargetModuleType::Dll )
		{
			sprintf(this->lpszOutput_Release,".\\%s.dll",this->GetName().c_str());
		}
		else
		{
			sprintf(this->lpszOutput_Release,".\\%s.exe",this->GetName().c_str());
		}
		sprintf(this->lpszOutput_Debug,".\\%s_debug.exe",this->GetName().c_str());
	}

	// \[Xǂݍ
	Jenga::Common::Path resourcePath( this->GetResourceFileFullPath() );
	if( resourcePath.IsExistFile() )
	{
		this->resourceManager.Load( this->GetResourceFileFullPath() );
	}

	//u[N|Cg
	this->pobj_DBBreakPoint=new CDBBreakPoint();


	if( isUseWindow )
	{
		/////////////////////////////////////////////
		//EBhE`t@Ci*.wndjI[v
		sprintf(temp2,"%s%s.wnd",this->GetWorkDir().GetPath().c_str(),this->GetName().c_str());
		if(!OpenWindowFile(temp2)) return;
	}
	else{
		this->windowInfos.Clear();

		this->NumberOfMenu=0;
		this->pMenuInfo=(MENU_INFO *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,1);
	}

	OpenWorkfile( this->GetWorkDir().GetPath() + this->GetName() + ".wrk" );

	this->modify=0;
	this->ModifyOfMaterial=0;
	this->ModifuOfResource=0;
}

void SetStatusText(char *MenuText);
void Project::Save()
{
	int i,i2,i3,WndNum;
	char temporary[MAX_PATH],buffer[32767];
	HWND hChild;

	SetStatusText( "vWFNgۑ..." );

	//vWFNgt@C̃o[Wݒ
	this->dwVersion=PROJECT_VERSION;

	hChild=GetWindow(hClient,GW_CHILD);
	while(hChild){
		WndNum=GetWndNum(hChild);
		if(IS_DOCUMENT_TEXT(MdiInfo[WndNum]->DocType)){
			if( MdiInfo[WndNum]->pMdiTextEdit->IsModified() ){
				for(i=0;i<this->pobj_DBFileInfo->iNum;i++){
					this->pobj_DBFileInfo->ppobj_FileInfo[i]->GetFullPath(temporary);
					if(lstrcmpi(MdiInfo[WndNum]->path.c_str(),temporary)==0){
						SaveDocument(hChild,NULL);
						break;
					}
				}
			}
		}
		if(MdiInfo[WndNum]->DocType==WNDTYPE_ICONEDIT){
			if(MdiInfo[WndNum]->MdiIconEditInfo->bModify){
				BOOST_FOREACH( const ActiveBasic::Common::ResourceItem &resourceItem, resourceManager.iconResources )
				{
					lstrcpy(temporary,resourceItem.filepath.c_str());
					lstrcpy( temporary, this->GetWorkDir().GetFullPath( temporary ).c_str() );
					if(lstrcmpi(MdiInfo[WndNum]->path.c_str(),temporary)==0){
						SaveDocument(hChild,NULL);
						break;
					}
				}
			}
		}
		hChild=GetNextWindow(hChild,GW_HWNDNEXT);
	}


	//////////////////////////////////////
	//vWFNgt@Ci*.pjj쐬
	lstrcpy(buffer,"\' ActiveBasic Project file.\r\n\r\n");
	i2=lstrlen(buffer);
	sprintf(buffer+i2,"#VERSION=%d\r\n\r\n",this->dwVersion);
	i2+=lstrlen(buffer+i2);
	sprintf(buffer+i2,"#MODULETYPE=%d\r\n\r\n",(int)this->GetModuleType());
	i2+=lstrlen(buffer+i2);
	sprintf(buffer+i2,"#NAME=%s\r\n\r\n",this->GetName().c_str());
	i2+=lstrlen(buffer+i2);
	extern HWND hSelectCompilerCombo;
	if(SendMessage(hSelectCompilerCombo,CB_GETCURSEL,0,0)==0){
		sprintf(buffer+i2,"#PLATFORM=32\r\n\r\n",this->GetName().c_str());
		i2+=lstrlen(buffer+i2);
	}
	else{
		sprintf(buffer+i2,"#PLATFORM=64\r\n\r\n",this->GetName().c_str());
		i2+=lstrlen(buffer+i2);
	}
	sprintf(buffer+i2,"#USEWINDOW=%d\r\n\r\n",this->windowInfos.size());
	i2+=lstrlen(buffer+i2);
	sprintf(buffer+i2,"#OPTION=&H%08x\r\n\r\n",this->dwOption);
	i2+=lstrlen(buffer+i2);
	sprintf(buffer+i2,"#OUTPUT_RELEASE=%s\r\n\r\n",this->lpszOutput_Release);
	i2+=lstrlen(buffer+i2);
	sprintf(buffer+i2,"#OUTPUT_DEBUG=%s\r\n\r\n",this->lpszOutput_Debug);
	i2+=lstrlen(buffer+i2);
	sprintf(buffer+i2,"#MANIFEST=%s\r\n\r\n",this->szManifestPath);
	i2+=lstrlen(buffer+i2);
	sprintf(buffer+i2,"#DEBUG_CMD_LINE=%s\r\n\r\n",this->szCmdLine);
	i2+=lstrlen(buffer+i2);
	sprintf(buffer+i2,"#DEBUG_EXE_PATH=%s\r\n\r\n",this->szExePath);
	i2+=lstrlen(buffer+i2);
	sprintf(buffer+i2,"#SOURCE\r\n");
	i2+=lstrlen(buffer+i2);
	for(i=0;i<this->pobj_DBFileInfo->iNum;i++){
		sprintf(buffer+i2,"%s\r\n",this->pobj_DBFileInfo->ppobj_FileInfo[i]->m_path);
		i2+=lstrlen(buffer+i2);
	}

	//ۑ
	sprintf(temporary,"%s%s.pj",this->GetWorkDir().GetPath().c_str(),this->GetName().c_str());
	WriteBuffer(temporary,buffer,i2);


	//////////////////////////////////
	// \[Xt@Ci*.rcAresource.abj쐬
	{
		i2=0;
		i3=101;
		BOOST_FOREACH( const ActiveBasic::Common::ResourceItem &resourceItem, resourceManager.cursorResources )
		{
			sprintf(buffer+i2,"Const %s=%d\r\n",
				resourceItem.idName.c_str(),
				i3);
			i2+=lstrlen(buffer+i2);

			i3++;
		}
		BOOST_FOREACH( const ActiveBasic::Common::ResourceItem &resourceItem, resourceManager.bitmapResources )
		{
			sprintf(buffer+i2,"Const %s=%d\r\n",
				resourceItem.idName.c_str(),
				i3);
			i2+=lstrlen(buffer+i2);

			i3++;
		}
		BOOST_FOREACH( const ActiveBasic::Common::ResourceItem &resourceItem, resourceManager.iconResources )
		{
			sprintf(buffer+i2,"Const %s=%d\r\n",
				resourceItem.idName.c_str(),
				i3);
			i2+=lstrlen(buffer+i2);

			i3++;
		}

		//ۑiresource.abj
		WriteBuffer(this->GetWorkDir().GetFullPath( "resource.ab" ),buffer,i2);

		i2=0;
		BOOST_FOREACH( const ActiveBasic::Common::ResourceItem &resourceItem, resourceManager.cursorResources )
		{
			sprintf(buffer+i2,"%s CURSOR \"%s\"\r\n",
				resourceItem.idName.c_str(),
				resourceItem.filepath.c_str());
			i2+=lstrlen(buffer+i2);
		}
		BOOST_FOREACH( const ActiveBasic::Common::ResourceItem &resourceItem, resourceManager.bitmapResources )
		{
			sprintf(buffer+i2,"%s BITMAP \"%s\"\r\n",
				resourceItem.idName.c_str(),
				resourceItem.filepath.c_str());
			i2+=lstrlen(buffer+i2);
		}
		BOOST_FOREACH( const ActiveBasic::Common::ResourceItem &resourceItem, resourceManager.iconResources )
		{
			sprintf(buffer+i2,"%s ICON \"%s\"\r\n",
				resourceItem.idName.c_str(),
				resourceItem.filepath.c_str());
			i2+=lstrlen(buffer+i2);
		}

		//}jtFXg
		if(this->dwOption&PJ_OP_RC_MANIFEST){
			sprintf(buffer+i2,"CREATEPROCESS_MANIFEST_RESOURCE_ID RT_MANIFEST \"%s\"\r\n",
				this->szManifestPath);
			i2+=lstrlen(buffer+i2);
		}

		//ۑ
		WriteBuffer(this->GetResourceFileFullPath(),buffer,i2);
	}


	///////////////////////////////////////
	//CfbNXt@Ci*.idxj쐬
	buffer[0]=0;
	lstrcpy(buffer,"' CfbNX vO\r\n");
	i2=lstrlen(buffer);
	if(this->dwOption&PJ_OP_SOURCE_MASK){
		if(this->dwOption&PJ_OP_STRICT){
			/* #strictfBNeBu͍͎gĂȂ
			lstrcpy(buffer+i2,"\r\n");
			i2+=lstrlen(buffer+i2);
			lstrcpy(buffer+i2,"#strict");
			i2+=lstrlen(buffer+i2);
			lstrcpy(buffer+i2,"\r\n");
			i2+=lstrlen(buffer+i2);
			*/
		}
		lstrcpy(buffer+i2,"\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"'Win32API̒`t@C\r\n");
		i2+=lstrlen(buffer+i2);
		if(this->dwOption&PJ_OP_MMSYSTEM){
			lstrcpy(buffer+i2,"#include <api_mmsys.sbp>\r\n");
			i2+=lstrlen(buffer+i2);
		}
		if(this->dwOption&PJ_OP_COMMCTRL){
			lstrcpy(buffer+i2,"#include <api_commctrl.sbp>\r\n");
			i2+=lstrlen(buffer+i2);
		}
		if(this->dwOption&PJ_OP_RICHEDIT){
			lstrcpy(buffer+i2,"#include <api_richedit.sbp>\r\n");
			i2+=lstrlen(buffer+i2);
		}
		if(this->dwOption&PJ_OP_WINSOCK){
			lstrcpy(buffer+i2,"#include <api_winsock2.sbp>\r\n");
			i2+=lstrlen(buffer+i2);
		}
	}
	if( !this->windowInfos.empty() )
	{
		lstrcpy(buffer+i2,"\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"'RADc[EBhEvO\r\n");
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"#include \"Callback.wbp\"\r\n");
		i2+=lstrlen(buffer+i2);
	}
	if(this->pobj_DBFileInfo->iNum>1){
		lstrcpy(buffer+i2,"\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"'vWFNg̃vO t@C\r\n");
		i2+=lstrlen(buffer+i2);
		for(i=1;i<this->pobj_DBFileInfo->iNum;i++){
			//Ct@C͊܂܂Ȃ
			sprintf(buffer+i2,"#include \"%s\"\r\n",this->pobj_DBFileInfo->ppobj_FileInfo[i]->m_path);
			i2+=lstrlen(buffer+i2);
			lstrcpy(buffer+i2,"_ClearNamespaceImported\r\n");
			i2+=lstrlen(buffer+i2);
		}
	}
	if( !this->windowInfos.empty() )
	{
		lstrcpy(buffer+i2,"\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"'RADc[EBhEvO\r\n");
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"#include \"MakeWindow.wbp\"\r\n");
		i2+=lstrlen(buffer+i2);
	}

	//\[Xt@C
	lstrcpy(buffer+i2,"\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"'\[Xt@C\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"#include \"resource.ab\"\r\n");
	i2+=lstrlen(buffer+i2);
	sprintf(buffer+i2,"#resource \"%s.rc\"\r\n",this->GetName().c_str());
	i2+=lstrlen(buffer+i2);

	//ۑ
	sprintf(temporary,"%s%s.idx",this->GetWorkDir().GetPath().c_str(),this->GetName().c_str());
	WriteBuffer(temporary,buffer,i2);


	if( !this->windowInfos.empty() )
	{
		/////////////////////////////////////////////////////
		//EBhE֘At@Ci*.wndj쐬Aۑ
		if(this->ModifyOfMaterial){
			sprintf(temporary,"%s%s.wnd",this->GetWorkDir().GetPath().c_str(),this->GetName().c_str());
			SaveWindowFile( temporary, this->windowInfos );
		}

		//.wbpt@C𐶐
		SaveWindowProgram();
	}


	MakeWorkFile();

	SetStatusText("");

	this->modify=0;
	this->ModifuOfResource=0;
}

bool Project::Close()
{
	extern HANDLE hHeap;
	int i,WndNum;
	HWND hChild,hCloseChild;
	char temporary[MAX_PATH];


	//ۑmF
	i=ProjectModifyCheck(0);
	if(i==0) return false;
	else if(i==2) MakeWorkFile();

	//vWFNgɊւMDIEBhEׂĕ
	hChild=GetWindow(hClient,GW_CHILD);
	while(hChild){
		hCloseChild=hChild;
		hChild=GetNextWindow(hChild,GW_HWNDNEXT);
		WndNum=GetWndNum(hCloseChild);
		if(IS_DOCUMENT_TEXT(MdiInfo[WndNum]->DocType)){
			for(i=0;i<this->pobj_DBFileInfo->iNum;i++){
				this->pobj_DBFileInfo->ppobj_FileInfo[i]->GetFullPath(temporary);
				if(lstrcmpi(MdiInfo[WndNum]->path.c_str(),temporary)==0){

					//ύXtOItɂ
					MdiInfo[WndNum]->pMdiTextEdit->UnModify();

					SendMessage(hCloseChild,WM_CLOSE,0,0);
					break;
				}
			}
		}
		else if(MdiInfo[WndNum]->DocType==WNDTYPE_RAD)
		{
			BOOST_FOREACH( const WindowInfo *pWindowInfo, windowInfos )
			{
				if( pWindowInfo->GetName() == MdiInfo[WndNum]->path ){
					SendMessage(hCloseChild,WM_CLOSE,0,0);
					break;
				}
			}
		}
		else if(MdiInfo[WndNum]->DocType==WNDTYPE_MENU){
			for(i=0;i<this->NumberOfMenu;i++){
				if( MdiInfo[WndNum]->path == this->pMenuInfo[i].IdName )
				{
					SendMessage(hCloseChild,WM_CLOSE,0,0);
					break;
				}
			}
		}
		else if(MdiInfo[WndNum]->DocType==WNDTYPE_ICONEDIT){
			for(i=0;this->resourceManager.iconResources.size();i++){
				lstrcpy(temporary,this->resourceManager.iconResources[i].filepath.c_str());
				lstrcpy( temporary, this->GetWorkDir().GetFullPath( temporary ).c_str() );
				if(lstrcmpi(MdiInfo[WndNum]->path.c_str(),temporary)==0){
					SendMessage(hCloseChild,WM_CLOSE,0,0);
					break;
				}
			}
		}
	}

	//t@C̃
	delete this->pobj_DBFileInfo;

	//u[N|Cg̃IuWFNg
	delete this->pobj_DBBreakPoint;

	//EBhẼ
	BOOST_FOREACH( ActiveBasic::PM::WindowInfo *pWindowInfo, windowInfos )
	{
		//qEBhẼ
		BOOST_FOREACH( ActiveBasic::PM::ChildWindowInfo *pChildWindowInfo, pWindowInfo->childWindowInfos )
		{
			delete pChildWindowInfo;
		}
		pWindowInfo->childWindowInfos.clear();
	}
	this->windowInfos.Clear();

	//j[̃
	HeapMenuDataFree(this->pMenuInfo,this->NumberOfMenu,0);
	HeapDefaultFree(this->pMenuInfo);

	//\[X̃
	this->resourceManager.Clear();

	//vWFNg r[\ɂ
	extern HWND hProjectView;
	if(IsWindowVisible(hProjectView)) SendMessage(hOwner,WM_COMMAND,IDM_PROJECTVIEW,0);
	SetWindowText(hProjectView,"Project View");

	extern HWND hProcedureTreeView;
	extern HWND hMaterialTreeView;
	TreeView_DeleteAllItems(pobj_FileTree->hTree);
	TreeView_DeleteAllItems(hProcedureTreeView);
	TreeView_DeleteAllItems(hMaterialTreeView);

	//EBhE ^CgύX
	SetWindowText(hOwner,APPLICATION_NAME);

	this->name = "";

	//j[Ԃݒ
	ResetState_DocMenu();

	return true;
}
