#include "stdafx.h"

#include "common.h"

void TextEdit_ResetWordColor(int WndNum,CHARRANGE *pCharRange,int DocType){
	extern HANDLE hHeap;
	int i,i2,IsStr;
	char *pBuf,*pTemp;
	CHARRANGE Range,cr2;

	pBuf=MdiInfo[WndNum]->pMdiTextEdit->buffer;

	//s̐擪ʒu擾
	i=pCharRange->cpMin;
	for(;i>0;i--){
		if(pBuf[i-1]=='\r'&&pBuf[i]=='\n'){
			i++;
			break;
		}
	}
	Range.cpMin=i;

	//s̖[ʒu擾
	i=pCharRange->cpMax;
	for(;;i++){
		if(pBuf[i]=='\0') break;
		if(pBuf[i]=='\r'&&pBuf[i+1]=='\n') break;
	}
	Range.cpMax=i;

	//iׂčFɖ߂j
	for(i=Range.cpMin;i<Range.cpMax;i++){
		MdiInfo[WndNum]->pMdiTextEdit->pColorRef[i]=tci.rgbDefault;
	}

	if(DocType==WNDTYPE_TEXT) return;

	pTemp=(char *)HeapAlloc(hHeap,0,Range.cpMax-Range.cpMin+1);

	for(i=Range.cpMin,IsStr=0;i<Range.cpMax;i++){
		if((IsVariableTopChar(pBuf[i])||pBuf[i]=='#')&&IsStr==0){
			cr2.cpMin=i;
			for(i2=0;;i++,i2++){
				if((!IsVariableChar(pBuf[i]))||pBuf[i]=='.'){
					pTemp[i2]=0;
					break;
				}
				pTemp[i2]=pBuf[i];
			}
			cr2.cpMax=i;

			//\iFj
			BOOL bResult=0;
			if(DocType==WNDTYPE_BASIC){
				i2=IsBasicReservedWord(pTemp);
				bResult=IsManagementCommand(i2);
			}
			else if(DocType==WNDTYPE_HTML) bResult=IsHtmlReservedWord(pTemp);

			if(bResult){
				for(i2=cr2.cpMin;i2<cr2.cpMax;i2++){
					MdiInfo[WndNum]->pMdiTextEdit->pColorRef[i2]=tci.rgbStatement;
				}
			}
		}
		if(IsStr||pBuf[i]=='\"'&&IsStr==0){
			//J[i""ň͂܂͈́j
			MdiInfo[WndNum]->pMdiTextEdit->pColorRef[i]=tci.rgbString;
		}
		if(pBuf[i]=='\0') break;
		if(pBuf[i]=='\"') IsStr^=1;
		if(pBuf[i]=='\r'&&pBuf[i+1]=='\n'){
			i++;
			IsStr=0;
		}
	}

	HeapDefaultFree(pTemp);
}

void TextEdit_Replace(int WndNum,char *str,BOOL bRedraw){
	extern HANDLE hHeap;
	CHARRANGE Range,DelRange;

	TextEdit_GetSel(WndNum,&DelRange);

	Range.cpMin=DelRange.cpMin;
	Range.cpMax=DelRange.cpMin+lstrlen(str);

	//obt@擾
	int length;
	length=lstrlen(MdiInfo[WndNum]->pMdiTextEdit->buffer);

	int delta;
	delta=DelRange.cpMin-DelRange.cpMax+(Range.cpMax-Range.cpMin);
	if(0<delta){
		////////////////////
		// obt@Ċm
		////////////////////

		MdiInfo[WndNum]->pMdiTextEdit->buffer=(char *)HeapReAlloc(hHeap,
			0,
			MdiInfo[WndNum]->pMdiTextEdit->buffer,
			length+1+delta);

		MdiInfo[WndNum]->pMdiTextEdit->pColorRef=(COLORREF *)HeapReAlloc(hHeap,
			0,
			MdiInfo[WndNum]->pMdiTextEdit->pColorRef,
			(length+1+delta)*sizeof(COLORREF));
	}


	//u[N|Cg̃ItZbgvZ
	if( projectInfo.IsOpened() ){
		projectInfo.pobj_DBBreakPoint->replace(
			MdiInfo[WndNum]->path.c_str(),
			MdiInfo[WndNum]->pMdiTextEdit->buffer,
			&DelRange,
			&Range,
			str);
	}
	else{
		extern CDBBreakPoint *pobj_DBBreakPoint;
		pobj_DBBreakPoint->replace(
			MdiInfo[WndNum]->path.c_str(),
			MdiInfo[WndNum]->pMdiTextEdit->buffer,
			&DelRange,
			&Range,
			str);
	}


	//obt@XChāA}
	SlideString(MdiInfo[WndNum]->pMdiTextEdit->buffer+DelRange.cpMax,
		delta);
	memcpy(MdiInfo[WndNum]->pMdiTextEdit->buffer+Range.cpMin,str,lstrlen(str));

	//J[obt@XCh
	SlideBuffer(((char *)MdiInfo[WndNum]->pMdiTextEdit->pColorRef)+DelRange.cpMax*sizeof(COLORREF),
		(length-DelRange.cpMax) * sizeof(COLORREF),
		delta*sizeof(COLORREF));
	//FÂ
	TextEdit_ResetWordColor(WndNum,&Range,MdiInfo[WndNum]->DocType);

	//VLbgʒuɕύX
	GetCaretPosFromBufferIndex(MdiInfo[WndNum]->pMdiTextEdit->buffer,
		Range.cpMax,
		&MdiInfo[WndNum]->pMdiTextEdit->StartCaretPos);
	MdiInfo[WndNum]->pMdiTextEdit->EndCaretPos=MdiInfo[WndNum]->pMdiTextEdit->StartCaretPos;

	//Rg[^uXy[X̕ƍsԍ̕XV
	MdiInfo[WndNum]->pMdiTextEdit->iWidth_ControlTabSpace=
		GetControlTabSpace(WndNum,&MdiInfo[WndNum]->pMdiTextEdit->iLineNumberTextCount);

	if(bRedraw){
		///////////////
		// ĕ`
		///////////////

		if(!TextEdit_ScrollCaret(WndNum,0)){
			UpdateWindow(MdiInfo[WndNum]->pMdiTextEdit->hEdit);	//h~
			InvalidateRect(MdiInfo[WndNum]->pMdiTextEdit->hEdit,NULL,0);
		}

		ResetCaretPos(WndNum,1);
	}

	//㉺Lbgړ̍Eʒuێ@\
	MdiInfo[WndNum]->pMdiTextEdit->Temp_UpDown_CaretXPos=-1;

	//ҏWj[Zbg
	ResetState_EditMenu();

	if( ! MdiInfo[WndNum]->pMdiTextEdit->IsModified() ){
		//ύXtOZbg
		MdiInfo[WndNum]->pMdiTextEdit->Modify();
	}


	//if( projectInfo.IsOpened() ){
		//vWFNgJĂƂ
		if(MdiInfo[WndNum]->DocType==WNDTYPE_BASIC){
			//NXc[ĕ\
			ResetClassTree(GetFileNum(WndNum));
		}
	//}
}
void TextEdit_ReplaceUpdateUndoData(int WndNum,char *str,BOOL bPaste,BOOL bRedraw){
	extern HANDLE hHeap;
	int Command;
	char *KeyStr,*DelStr;
	char temporary[255];
	CHARRANGE Range,DelRange;

	if(MdiInfo[WndNum]->IndentStr){
		//CfgLɂ
		lstrcpy(temporary,MdiInfo[WndNum]->IndentStr);

		CancelBeforeAutoIndent(WndNum);
		TextEdit_ReplaceUpdateUndoData(WndNum,temporary,0,1);
	}

	TextEdit_GetSel(WndNum,&DelRange);
	if(DelRange.cpMin!=DelRange.cpMax){
		Command=TEXTEDIT_UNDO_SELKEY;
		DelStr=(char *)HeapAlloc(hHeap,0,DelRange.cpMax-DelRange.cpMin+1);

		TextEdit_GetSelText(WndNum,&DelRange,DelStr);

		Range.cpMin=DelRange.cpMin;
		Range.cpMax=DelRange.cpMin;
	}
	else{
		if(bPaste) Command=TEXTEDIT_UNDO_PASTE;
		else Command=TEXTEDIT_UNDO_KEY;
		DelStr=0;

		Range=DelRange;
	}
	if(str[0]){
		KeyStr=(char *)HeapAlloc(hHeap,0,lstrlen(str)+1);
		lstrcpy(KeyStr,str);
		Range.cpMax+=lstrlen(KeyStr);
	}
	else KeyStr=0;
	TextEdit_NoticeChanging(WndNum,Command,KeyStr,DelStr,&Range,&DelRange);

	TextEdit_Replace(WndNum,str,bRedraw);
}


void TextEdit_Convert(int id){
	int i,i2;

	int WndNum;
	WndNum=GetWndNum(GetWindow(hClient,GW_CHILD));

	CHARRANGE CharRange;
	int length;
	TextEdit_GetSel(WndNum,&CharRange);

#ifdef THETEXT
	if(id==IDM_CONV_HASRETURN||id==IDM_CONV_QUOTE){
#else
	if(id==IDM_CODEFORMAT){
#endif
		char *pBuf;
		pBuf=MdiInfo[WndNum]->pMdiTextEdit->buffer;

		//sŜI(min)
		for(i=CharRange.cpMin;i>0;i--){
			if(pBuf[i-1]=='\r'&&pBuf[i]=='\n'){
				i++;
				break;
			}
		}
		CharRange.cpMin=i;

		//sŜI(max)
		for(i=CharRange.cpMax;;i++){
			if(pBuf[i]=='\r'&&pBuf[i+1]=='\n'||pBuf[i]=='\0') break;
		}
		CharRange.cpMax=i;

		TextEdit_SetSel(WndNum,CharRange.cpMin,CharRange.cpMax,0);
	}

	length=CharRange.cpMax-CharRange.cpMin;

	char *buffer,*temporary;
	buffer=(char *)HeapAlloc(hHeap,0,length*3+1024);
	temporary=(char *)HeapAlloc(hHeap,0,length*3+1024);
	memcpy(buffer,MdiInfo[WndNum]->pMdiTextEdit->buffer+CharRange.cpMin,length);
	buffer[length]=0;

	int x=0;
	switch(id){
		case IDM_CONV_ALPHA_SMALL:
			CharLower(buffer);
			break;
		case IDM_CONV_ALPHA_BIG:
			CharUpper(buffer);
			break;
		case IDM_CONV_HALF:
			LCMapString(GetUserDefaultLCID(),LCMAP_HALFWIDTH,buffer,length+1,temporary,length*2+1);
			lstrcpy(buffer,temporary);
			break;
		case IDM_CONV_MULTI:
			LCMapString(GetUserDefaultLCID(),LCMAP_FULLWIDTH,buffer,length+1,temporary,length*2+1);
			lstrcpy(buffer,temporary);
			break;
		case IDM_CONV_KATAKANA:
			LCMapString(GetUserDefaultLCID(),LCMAP_KATAKANA,buffer,length+1,temporary,length*2+1);
			lstrcpy(buffer,temporary);
			break;
		case IDM_CONV_HIRAGANA:
			LCMapString(GetUserDefaultLCID(),LCMAP_HIRAGANA,buffer,length+1,temporary,length*2+1);
			lstrcpy(buffer,temporary);
			break;
		case IDM_CONV_SPACE:
			temporary=(char *)HeapReAlloc(hHeap,0,temporary,length*pobj_nv->TabSize+1);
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,length*pobj_nv->TabSize+1);
			for(i=0,i2=0;;i++,i2++){
				if(buffer[i]=='\t'){
					memset(temporary+i2,' ',pobj_nv->TabSize);
					i2+=pobj_nv->TabSize-1;
					continue;
				}
				temporary[i2]=buffer[i];
				if(buffer[i]=='\0') break;
			}

			lstrcpy(buffer,temporary);
			break;
		case IDM_CONV_TAB:
			char szSpaceTemp[255];
			memset(szSpaceTemp,' ',pobj_nv->TabSize);
			szSpaceTemp[pobj_nv->TabSize]=0;

			for(i=0,i2=0;;i++,i2++){
				if(memcmp(buffer+i,szSpaceTemp,pobj_nv->TabSize)==0){
					temporary[i2]='\t';
					i+=pobj_nv->TabSize-1;
					continue;
				}
				temporary[i2]=buffer[i];
				if(buffer[i]=='\0') break;
			}

			lstrcpy(buffer,temporary);
			break;

#ifdef THETEXT
		case IDM_CONV_HASRETURN:
			//܂Ԃs}
			int i3;
			for(i=0,i2=0,x=0;;i++,i2++,x++){
				if(buffer[i]=='\r'&&buffer[i+1]=='\n'){
					temporary[i2++]=buffer[i++];
					temporary[i2]=buffer[i];
					x=-1;
					continue;
				}
				if(x>pobj_nv->iMaxOneLineTextLength-2){
					//sipPlj
					int i3=0;
					while(IsVariableChar(buffer[i-1])){
						i--;
						i2--;
						x--;
						i3++;
						if(x==1){
							i+=i3;
							i2+=i3;
							x+=i3;
							break;
						}
					}
					if(i3==1){
						i++;
						i2++;
						x++;
					}
					temporary[i2++]='\r';
					temporary[i2]='\n';
					i--;
					x=-1;
					continue;
				}

				if(IsDBCSLeadByte(buffer[i])){
					temporary[i2++]=buffer[i++];
					temporary[i2]=buffer[i];
					x++;
				}
				else{
					temporary[i2]=buffer[i];

					if(buffer[i]=='\t'){
						//^u
						int tab;
						tab=pobj_nv->TabSize;

						if(x%tab==0) i3=tab;
						else i3=tab-x%tab;
						x+=i3-1;
					}
				}

				if(buffer[i]=='\0') break;
			}

			lstrcpy(buffer,temporary);
			break;
		case IDM_CONV_QUOTE:
			//pɕϊ
			for(i=0,i2=0,x=0;;i++,i2++,x++){
				if(x==0){
					//"> " }
					temporary[i2++]='>';
					temporary[i2++]=' ';
				}
				if(buffer[i]=='\r'&&buffer[i+1]=='\n'){
					temporary[i2++]=buffer[i++];
					temporary[i2]=buffer[i];
					x=-1;
					continue;
				}
				if(x>pobj_nv->iMaxOneLineTextLength-4){
					//sipPlj
					int i3=0;
					while(IsVariableChar(buffer[i-1])){
						i--;
						i2--;
						x--;
						i3++;
						if(x==1){
							i+=i3;
							i2+=i3;
							x+=i3;
							break;
						}
					}
					if(i3==1){
						i++;
						i2++;
						x++;
					}
					temporary[i2++]='\r';
					temporary[i2]='\n';
					i--;
					x=-1;
					continue;
				}

				if(IsDBCSLeadByte(buffer[i])){
					temporary[i2++]=buffer[i++];
					temporary[i2]=buffer[i];
					x++;
				}
				else{
					temporary[i2]=buffer[i];
					if(buffer[i]=='\t'){
						//^u
						int tab;
						tab=pobj_nv->TabSize;

						if(x%tab==0) i3=tab;
						else i3=tab-x%tab;
						x+=i3-1;
					}
				}

				if(buffer[i]=='\0') break;
			}

			lstrcpy(buffer,temporary);
			break;

#else	//ProjectEditor

		case IDM_CODEFORMAT:
			char *temp2;
			temp2=CodeFormatter(buffer);
			HeapDefaultFree(buffer);
			buffer=temp2;
			break;

#endif
	}



	//eLXgGfB^̕vCX
	TextEdit_ReplaceUpdateUndoData(WndNum,
		buffer,
		1,
		1);

	HeapDefaultFree(buffer);
	HeapDefaultFree(temporary);

	//Lbgʒu܂ŃXN[
	TextEdit_ScrollCaret(WndNum,0);
	ResetCaretPos(WndNum);
}
