#include "stdafx.h"

#include "Common.h"


/////////////////////////////////////////////////////////////
// Note. o[Rg[Vɒǉꍇ́A
//      "o[ǉ" ŌAK؂ȃR[h𖄂ߍ
/////////////////////////////////////////////////////////////


CDBRebarBand::CDBRebarBand(){
	iMaxBandNum=0;
}
CDBRebarBand::~CDBRebarBand(){}

void CDBRebarBand::add(int band_id,AddBandProc add_proc){
	BandId[iMaxBandNum]=band_id;
	pAddProc[iMaxBandNum]=add_proc;
	iMaxBandNum++;
}

HWND CDBRebarBand::call_add(int band_id,int num,char *lpszText){
	int i;
	for(i=0;i<iMaxBandNum;i++){
		if(BandId[i]==band_id) break;
	}
	if(i==iMaxBandNum) return 0;

	return pAddProc[i](hRebar,num,lpszText);
}


HWND AddDocCombo(HWND hRebar,int num,char *lpszText);
HWND AddStandardToolbar(HWND hRebar,int num,char *lpszText);
HWND AddReleaseToolbar(HWND hRebar,int num,char *lpszText);
HWND AddDebuggerToolbar(HWND hRebar,int num,char *lpszText);
HWND AddBand_SelectCompiler(HWND hRebar,int num,char *lpszText);
HWND AddBand_WebSearch(HWND hRebar,int num,char *lpszText);


CMainRebar *pobj_Rebar=0;


void CMainRebar::SetupRebar(HWND hwnd){
	int i;

	//o[Rg[𐶐
	hRebar=CreateWindowEx(WS_EX_TOOLWINDOW,REBARCLASSNAME,NULL,
		WS_CHILD|WS_CLIPCHILDREN|WS_CLIPSIBLINGS|WS_BORDER|WS_VISIBLE|
		CCS_ADJUSTABLE|RBS_BANDBORDERS|RBS_DBLCLKTOGGLE ,
		0,0,0,0,hwnd,NULL,hInst,NULL);

	pobj_DBRebarBand->hRebar=hRebar;

	REBARINFO RebarInfo;
	ZeroMemory(&RebarInfo,sizeof(RebarInfo));
	RebarInfo.cbSize=sizeof(REBARINFO);
	SendMessage(hRebar,RB_SETBARINFO,0,(long)&RebarInfo);

	//oh}
	REBARBANDINFO RebarBand;
	ZeroMemory(&RebarBand,sizeof(REBARBANDINFO));
	RebarBand.cbSize=sizeof(REBARBANDINFO);
	RebarBand.fMask=RBBIM_TEXT|RBBIM_STYLE|RBBIM_CHILD|RBBIM_CHILDSIZE|RBBIM_SIZE|RBBIM_ID;
	RebarBand.cxMinChild=23;
	RebarBand.cyMinChild=22;
	if(pobj_nv->bNoGripper) RebarBand.fStyle=RBBS_CHILDEDGE|RBBS_NOGRIPPER;
	else RebarBand.fStyle=RBBS_CHILDEDGE;
	for(i=0;i<MAX_REBARBANDS;i++){
		if(pobj_nv->SaveRebar[i].RebarID==0) break;

		//o[ɂ̂qEBhE𐶐
		char szText[255];
		HWND hChild;
		hChild=pobj_DBRebarBand->call_add(pobj_nv->SaveRebar[i].RebarID,i,szText);

		//o[ohǉ
		RebarBand.lpText=szText;
		RebarBand.hwndChild=hChild;
		RebarBand.cx=pobj_nv->SaveRebar[i].RebarLength;
		RebarBand.wID=pobj_nv->SaveRebar[i].RebarID;
		RebarBand.fStyle|=pobj_nv->SaveRebar[i].IsBandBreak;
		SendMessage(hRebar,RB_INSERTBAND,-1,(LPARAM)&RebarBand);
		RebarBand.fStyle^=pobj_nv->SaveRebar[i].IsBandBreak;
	}
}

CMainRebar::CMainRebar(HWND hwnd_parent){
	hParent=hwnd_parent;

	pobj_DBRebarBand=new CDBRebarBand();

	pobj_DBRebarBand->add(
		ID_DOCCOMBO,
		AddDocCombo);

	pobj_DBRebarBand->add(
		ID_STANDARDTOOLBAR,
		AddStandardToolbar);

	pobj_DBRebarBand->add(
		ID_RELEASETOOLBAR,
		AddReleaseToolbar);

	pobj_DBRebarBand->add(
		ID_DEBUGGERTOOLBAR,
		AddDebuggerToolbar);

	pobj_DBRebarBand->add(
		ID_SELECTCOMPILERCOMBO,
		AddBand_SelectCompiler);

	pobj_DBRebarBand->add(
		ID_WEB_SEARCH,
		AddBand_WebSearch);

	//
	//o[ohǉꍇ͂̍sҏWio[ǉj
	//


	SetupRebar(hParent);
}
CMainRebar::~CMainRebar(){
	SaveRebarState();
	DestroyWindow(hRebar);

	delete pobj_DBRebarBand;
	pobj_DBRebarBand=0;
}

void CMainRebar::ResetInitRebar(){
	DestroyWindow(hRebar);
	ResetRebarData();
	SetupRebar(hParent);
}
void CMainRebar::ResetRebar(){
	SaveRebarState();
	DestroyWindow(hRebar);
	SetupRebar(hParent);
}

void CMainRebar::SaveRebarState(void){
	int i,BandNum;
	REBARBANDINFO BandInfo;

	ZeroMemory(&BandInfo,sizeof(REBARBANDINFO));
	BandInfo.cbSize=sizeof(REBARBANDINFO);
	BandInfo.fMask=RBBIM_TEXT|RBBIM_STYLE|RBBIM_CHILD|RBBIM_CHILDSIZE|RBBIM_SIZE|RBBIM_ID;
	BandNum=SendMessage(hRebar,RB_GETBANDCOUNT,0,0);
	for(i=0;i<BandNum;i++){
		SendMessage(hRebar,RB_GETBANDINFO,i,(long)&BandInfo);
		if(BandInfo.fStyle&RBBS_BREAK) pobj_nv->SaveRebar[i].IsBandBreak=RBBS_BREAK;
		else pobj_nv->SaveRebar[i].IsBandBreak=0;
		pobj_nv->SaveRebar[i].RebarID=BandInfo.wID;
		pobj_nv->SaveRebar[i].RebarLength=BandInfo.cx;
	}
}

void CMainRebar::ChangeRebarBand(int BandID){
	int i;
	REBARBANDINFO RebarBand;

	//c[o[Œ肳Ăꍇ͉
	if(pobj_nv->bNoGripper) SendMessage(hOwner,WM_COMMAND,IDM_NOGRIPPER,0);

	SAVEREBAR *psr;
	psr=pobj_nv->SaveRebar;

	for(i=0;i<MAX_REBARBANDS;i++){
		if(psr[i].RebarID==0) break;
		if(psr[i].RebarID==BandID){
			SendMessage(hRebar,RB_DELETEBAND,SendMessage(hRebar,RB_IDTOINDEX,BandID,0),0);
			memcpy(&psr[i],&psr[i+1],(MAX_REBARBANDS-i-1)*sizeof(SAVEREBAR));
			psr[MAX_REBARBANDS-1].RebarID=0;
			if(psr[0].RebarID==0){
				DestroyWindow(hRebar);
				SetupRebar(hOwner);

				//j[Ԃݒ
				ResetState_DocMenu();

				ActiveBasic::IDE::Program::mainFrame.Resized();
			}
			return;
		}
	}
	if(i>=MAX_REBARBANDS) return;
	psr[i].IsBandBreak=1;
	psr[i].RebarID=BandID;
	psr[i].RebarLength=0;
	ZeroMemory(&RebarBand,sizeof(REBARBANDINFO));
	RebarBand.cbSize=sizeof(REBARBANDINFO);
	RebarBand.fMask=RBBIM_TEXT|RBBIM_STYLE|RBBIM_CHILD|RBBIM_CHILDSIZE|RBBIM_SIZE|RBBIM_ID;
	RebarBand.fStyle=RBBS_CHILDEDGE;
	RebarBand.cxMinChild=0;
	RebarBand.cyMinChild=22;

	//o[ɂ̂qEBhE𐶐
	char szText[255];
	HWND hChild;
	hChild=pobj_DBRebarBand->call_add(pobj_nv->SaveRebar[i].RebarID,i,szText);

	//o[ohǉ
	RebarBand.lpText=szText;
	RebarBand.hwndChild=hChild;
	RebarBand.cx=pobj_nv->SaveRebar[i].RebarLength;
	RebarBand.wID=pobj_nv->SaveRebar[i].RebarID;
	RebarBand.fStyle|=pobj_nv->SaveRebar[i].IsBandBreak;
	SendMessage(hRebar,RB_INSERTBAND,-1,(LPARAM)&RebarBand);
	RebarBand.fStyle^=pobj_nv->SaveRebar[i].IsBandBreak;

	//j[Ԃݒ
	ResetState_DocMenu();
}

void CMainRebar::menu_popup(HWND hwnd,int PosX,int PosY){
	//o[Rg[̕\ݒ胁j[\
	int i;
	POINT MousePos;
	MENUITEMINFO MenuItemInfo;

	//j[̃`FbNڂZbg
	extern HMENU hRebarMenu;
	MenuItemInfo.cbSize=sizeof(MENUITEMINFO);
	MenuItemInfo.fMask=MIIM_STATE;
	MenuItemInfo.fState=MFS_UNCHECKED;
	SetMenuItemInfo(hRebarMenu,IDM_DOCSELECTBAND,0,&MenuItemInfo);
	SetMenuItemInfo(hRebarMenu,IDM_STANDARDBAND,0,&MenuItemInfo);
	SetMenuItemInfo(hRebarMenu,IDM_BANDMENU_WEB_SEARCH,0,&MenuItemInfo);
#ifndef THETEXT
	//ProjectEditor̂
	SetMenuItemInfo(hRebarMenu,IDM_RELEASEBAND,0,&MenuItemInfo);
	SetMenuItemInfo(hRebarMenu,IDM_DEBUGBAND,0,&MenuItemInfo);
	SetMenuItemInfo(hRebarMenu,IDM_SELECTCOMPILERBAND,0,&MenuItemInfo);
#endif

	
	MenuItemInfo.fState=MFS_CHECKED;
	for(i=0;i<MAX_REBARBANDS;i++){
		if(pobj_nv->SaveRebar[i].RebarID==0) break;

		if(pobj_nv->SaveRebar[i].RebarID==ID_DOCCOMBO)
			SetMenuItemInfo(hRebarMenu,IDM_DOCSELECTBAND,0,&MenuItemInfo);

		if(pobj_nv->SaveRebar[i].RebarID==ID_STANDARDTOOLBAR)
			SetMenuItemInfo(hRebarMenu,IDM_STANDARDBAND,0,&MenuItemInfo);

		if(pobj_nv->SaveRebar[i].RebarID==ID_WEB_SEARCH)
			SetMenuItemInfo(hRebarMenu,IDM_BANDMENU_WEB_SEARCH,0,&MenuItemInfo);

#ifndef THETEXT
	//ProjectEditor̂
		if(pobj_nv->SaveRebar[i].RebarID==ID_RELEASETOOLBAR)
			SetMenuItemInfo(hRebarMenu,IDM_RELEASEBAND,0,&MenuItemInfo);

		if(pobj_nv->SaveRebar[i].RebarID==ID_DEBUGGERTOOLBAR)
			SetMenuItemInfo(hRebarMenu,IDM_DEBUGBAND,0,&MenuItemInfo);

		if(pobj_nv->SaveRebar[i].RebarID==ID_SELECTCOMPILERCOMBO)
			SetMenuItemInfo(hRebarMenu,IDM_SELECTCOMPILERBAND,0,&MenuItemInfo);
#endif

	}
	if(pobj_nv->bNoGripper) MenuItemInfo.fState=MFS_CHECKED;
	else MenuItemInfo.fState=MFS_UNCHECKED;
	SetMenuItemInfo(hRebarMenu,IDM_NOGRIPPER,0,&MenuItemInfo);

	//|bvAbvj[\
	MousePos.x=PosX;
	MousePos.y=PosY;
	ClientToScreen(hwnd,&MousePos);
	TrackPopupMenu(hRebarMenu,TPM_LEFTALIGN|TPM_RIGHTBUTTON,MousePos.x,MousePos.y,0,hOwner,NULL);
}






WNDPROC OldDocComboProc;
WNDPROC OldStandardToolbarProc;
WNDPROC OldDebuggerToolbarProc;
WNDPROC OldSelectCompilerComboProc;
WNDPROC OldWebSearchProc,OldWebSearchEditProc;

void ResetRebarData(void){
	SAVEREBAR *psr;
	psr=pobj_nv->SaveRebar;
	int num=0;

#ifdef THETEXT

	//X^_[hc[o[
	psr[num].RebarID=ID_STANDARDTOOLBAR;
	psr[num].RebarLength=BMPNUM_STANDARDTOOLBAR*23+SEPNUM_STANDARDTOOLBAR*8+15;
	psr[num].IsBandBreak=0;
	num++;

	//WebSearchR{{bNX
	psr[num].RebarID=ID_WEB_SEARCH;
	psr[num].RebarLength=100;
	psr[num].IsBandBreak=0;
	num++;
#else

	//X^_[hc[o[
	psr[num].RebarID=ID_STANDARDTOOLBAR;
	psr[num].RebarLength=BMPNUM_STANDARDTOOLBAR*23+SEPNUM_STANDARDTOOLBAR*8+15;
	psr[num].IsBandBreak=0;
	num++;

	//vbgtH[Ic[o[
	psr[num].RebarID=ID_SELECTCOMPILERCOMBO;
	psr[num].RebarLength=100;
	psr[num].IsBandBreak=0;
	num++;

	//fobKc[o[
	psr[num].RebarID=ID_DEBUGGERTOOLBAR;
	psr[num].RebarLength=BMPNUM_DEBUGGERTOOLBAR*23+SEPNUM_DEBUGGERTOOLBAR*8+15;
	psr[num].IsBandBreak=0;
	num++;

	//[Xrhc[o[
	psr[num].RebarID=ID_RELEASETOOLBAR;
	psr[num].RebarLength=2*23+15;
	psr[num].IsBandBreak=0;
	num++;
#endif


	psr[num].RebarID=0;

	pobj_nv->bNoGripper=1;
}
