#include "stdafx.h"

#include "common.h"


int iPreviewNowPage;
int iZoomNowPage;

#define ZOOM_NUM 8
#define ZOOM_INIT 4
int array_Zoom[ZOOM_NUM]={
	500,
	200,
	150,
	100,
	75,
	50,
	25,
	10
};


CPage obj_Page;

CPage::CPage(){
	memset(&psd, 0, sizeof(PAGESETUPDLG));
	psd.lStructSize = sizeof(PAGESETUPDLG);
	psd.hwndOwner = hOwner;
	psd.Flags = PSD_MARGINS |PSD_INHUNDREDTHSOFMILLIMETERS|PSD_DISABLEORIENTATION;
	psd.rtMargin.left=2500;
	psd.rtMargin.top=2500;
	psd.rtMargin.right=2500;
	psd.rtMargin.bottom=2500;
	psd.ptPaperSize.x=21000;
	psd.ptPaperSize.y=29700;
}
CPage::~CPage(){
}

BOOL CPage::SetupDlg(void){
	//y[Wݒ_CAO
	return PageSetupDlg(&psd);
}

void DrawPage(HDC memdc,BOOL bPreview,BOOL *lpbLastPage=0){
	RECT rc;

	//y[W̕AiPʂ0.1~[gj
	int iPageWidth,iPageHeight;
	iPageWidth=obj_Page.psd.ptPaperSize.x/10;
	iPageHeight=obj_Page.psd.ptPaperSize.y/10;

	//}bsO[hZbg
	SetMapMode(memdc,MM_LOMETRIC);

	POINT px_pos;
	px_pos.x=iPageWidth;
	px_pos.y=iPageHeight;
	LPtoDP(memdc,&px_pos,1);
	px_pos.y=-px_pos.y;

	int WndNum;
	WndNum=GetWndNum(GetWindow(hClient,GW_CHILD));

	//tHg
	LOGFONT lf;
	lf=pobj_nv->lfPrint;
	lf.lfHeight=-MulDiv(pobj_nv->iPrintFontPointSize,GetDeviceCaps(memdc, LOGPIXELSY),960);
	HFONT hFont;
	hFont=CreateFontIndirect(&lf);

	//tHgZbg
	HFONT hOldFont;
	hOldFont=(HFONT)SelectObject(memdc,hFont);

	//}[WiPʂ0.1~[gj
	RECT rcMargin;
	rcMargin.left=obj_Page.psd.rtMargin.left/10;
	rcMargin.top=obj_Page.psd.rtMargin.top/10;
	rcMargin.right=obj_Page.psd.rtMargin.right/10;
	rcMargin.bottom=obj_Page.psd.rtMargin.bottom/10;

	//^u
	DRAWTEXTPARAMS dtp;
	dtp.cbSize=sizeof(DRAWTEXTPARAMS);
	dtp.iLeftMargin=0;
	dtp.iRightMargin=0;
	dtp.iTabLength=pobj_nv->TabSize;
	dtp.uiLengthDrawn=0;

	char *temp;
	temp=(char *)malloc(65535);

	char *buffer;
	buffer=MdiInfo[WndNum].pMdiTextEdit->buffer;
	int i=0,i2=0,iPage=0;
	for(i=0,i2=0;;i++,i2++){
		if(buffer[i]=='\0'||buffer[i]=='\r'&&buffer[i+1]=='\n'){
			temp[i2]=0;

			memset(&rc,0,sizeof(RECT));
			rc.right=iPageWidth-(rcMargin.left + rcMargin.right);
			DrawTextEx(memdc,temp,-1,&rc,DT_CALCRECT | DT_WORDBREAK|DT_TABSTOP|DT_EXPANDTABS|DT_NOPREFIX,&dtp);

			if(rc.bottom<=-(iPageHeight-(rcMargin.top+rcMargin.bottom)) || buffer[i]=='\0'){

				if(rc.bottom<-(iPageHeight-(rcMargin.top+rcMargin.bottom))){
					i--;i2--;
					while(i>0 && (!(buffer[i]=='\r'&&buffer[i+1]=='\n'))){
						i--;
						i2--;
					}
					temp[i2]=0;
				}

				rc.left=rcMargin.left;
				rc.right=iPageWidth-rcMargin.right;
				rc.top=-rcMargin.top;
				rc.bottom=-(iPageHeight-rcMargin.bottom);

				char szTempPage[255],*temp2,temp3[255];
				lstrcpy(temp3,pobj_nv->szPageStr);
				temp2=strstr(temp3,"&n");
				if(temp2){
					temp2[0]='%';
					temp2[1]='d';

					sprintf(szTempPage,temp3,iPage+1);
				}

				if(bPreview&&iPage==iPreviewNowPage || bPreview==0){
					if(bPreview==0) StartPage(memdc);

					DrawTextEx(memdc,temp,-1,&rc,DT_LEFT | DT_WORDBREAK|DT_TABSTOP|DT_EXPANDTABS|DT_NOPREFIX,&dtp);

					if(pobj_nv->bShowPageNum){
						//y[Wԍ
						rc.top=-(iPageHeight-rcMargin.bottom);
						rc.bottom=-iPageHeight;
						DrawText(memdc,szTempPage,-1,&rc,DT_CENTER|DT_VCENTER|DT_SINGLELINE|DT_NOPREFIX);
					}

					if(bPreview==0) EndPage(memdc);

					if(lpbLastPage){
						if(buffer[i]=='\0'){
							*lpbLastPage=1;
						}
						else *lpbLastPage=0;
					}

					if(bPreview) break;
				}

				if(buffer[i]=='\0') break;

				iPage++;

				i++;
				i2=-1;
				continue;
			}
		}
		temp[i2]=buffer[i];
	}

	free(temp);

	SelectObject(memdc,hOldFont);
}

void CreatePreviewDCAndBmp(HDC *lphDC,HBITMAP *lphBmp,POINT *lpPxPos,BOOL *lpbLastPage){

	//_CAO
	PRINTDLG pd;
	memset(&pd,0,sizeof(PRINTDLG));
	pd.lStructSize=sizeof(PRINTDLG);
	pd.hwndOwner=hOwner;
	pd.Flags=PD_RETURNDC|PD_RETURNDEFAULT;
	pd.nFromPage=1;
	pd.nToPage=1;
	pd.nMinPage=1;
	pd.nMaxPage=1;
	pd.nCopies=1;
	if(PrintDlg(&pd)==0){
		return;
	}

	HDC memdc;
	memdc=CreateCompatibleDC(pd.hDC);

	//y[W̕AiPʂ0.1~[gj
	int iPageWidth,iPageHeight;
	iPageWidth=obj_Page.psd.ptPaperSize.x/10;
	iPageHeight=obj_Page.psd.ptPaperSize.y/10;

	//}bsO[hZbg
	SetMapMode(memdc,MM_LOMETRIC);

	POINT px_pos;
	px_pos.x=iPageWidth;
	px_pos.y=iPageHeight;
	LPtoDP(memdc,&px_pos,1);
	px_pos.y=-px_pos.y;

	HBITMAP hMemBmp;
	hMemBmp=CreateCompatibleBitmap(pd.hDC,px_pos.x,px_pos.y);
	SelectObject(memdc,hMemBmp);

	//wi
	HBRUSH hOldBrush;
	hOldBrush=(HBRUSH)SelectObject(memdc,GetStockObject(WHITE_BRUSH));
	PatBlt(memdc,0,0,px_pos.x,-px_pos.y,PATCOPY);
	SelectObject(memdc,hOldBrush);

	//֕`
	DrawPage(memdc,1,lpbLastPage);

	DeleteDC(pd.hDC);


	*lphDC=memdc;
	*lphBmp=hMemBmp;
	*lpPxPos=px_pos;
}

void DrawPreview(HWND hPreview,HDC hdc,HDC memdc,POINT *lpPxPos){
	SetMapMode(memdc,MM_TEXT);

	POINT px_pos;
	px_pos=*lpPxPos;

	SIZE size;
	RECT rc;
	GetClientRect(hPreview,&rc);
	size.cy=(long)((double)rc.bottom*0.9);
	size.cx=(long)((double)size.cy*((double)obj_Page.psd.ptPaperSize.x/(double)obj_Page.psd.ptPaperSize.y));

	SIZE size_hori;
	size_hori.cx=(long)((double)rc.right*0.9);
	size_hori.cy=(long)((double)size_hori.cx*((double)obj_Page.psd.ptPaperSize.y/(double)obj_Page.psd.ptPaperSize.x));

	if(size.cx>size_hori.cx) size=size_hori;
	size.cx=px_pos.x;
	size.cy=px_pos.y;


	//////////////////////////////////
	// XN[o[擾
	//////////////////////////////////

	//
	SCROLLINFO si_vert;
	si_vert.cbSize=sizeof(SCROLLINFO);
	si_vert.fMask=SIF_PAGE|SIF_RANGE|SIF_POS;
	GetScrollInfo(hPreview,SB_VERT,&si_vert);

	//
	SCROLLINFO si_horz;
	si_horz.cbSize=sizeof(SCROLLINFO);
	si_horz.fMask=SIF_PAGE|SIF_RANGE|SIF_POS;
	GetScrollInfo(hPreview,SB_HORZ,&si_horz);



	//\
	double dblZoomRatio;
	dblZoomRatio=((double)array_Zoom[iZoomNowPage]/(double)100)*0.18;


	///////////////////////////
	// ֕`
	///////////////////////////

	HDC memdc2;
	memdc2=CreateCompatibleDC(hdc);

	HBITMAP hMemBmp;
	hMemBmp=CreateCompatibleBitmap(hdc,(int)((double)size.cx*dblZoomRatio)+40, (int)((double)size.cy*dblZoomRatio)+40);

	SelectObject(memdc2,hMemBmp);
	RECT rc2;
	rc2.left=0;rc2.top=0;
	rc2.right=(int)((double)size.cx*dblZoomRatio)+40;
	rc2.bottom=(int)((double)size.cy*dblZoomRatio)+40;
	FillRect(memdc2,&rc2,(HBRUSH)GetStockObject(GRAY_BRUSH));

	SetStretchBltMode(memdc2,HALFTONE);
	StretchBlt(memdc2,
		20, 20,
		(int)((double)size.cx*dblZoomRatio), (int)((double)size.cy*dblZoomRatio),
		memdc,0,0,px_pos.x,px_pos.y,SRCCOPY);

	//ʂ֕`
	BitBlt(hdc,-si_horz.nPos,-si_vert.nPos,rc2.right,rc2.bottom,
		memdc2,0,0,SRCCOPY);

	DeleteDC(memdc2);
	DeleteObject(hMemBmp);


	//////////////////////////////
	// XN[o[ݒ
	//////////////////////////////
	GetClientRect(hPreview,&rc);

	//
	si_vert.nMin=0;
	si_vert.nMax=rc2.bottom;
	si_vert.nPage=rc.bottom;
	SetScrollInfo(hPreview,SB_VERT,&si_vert,1);

	//
	si_horz.nMin=0;
	si_horz.nMax=rc2.right;
	si_horz.nPage=rc.right;
	SetScrollInfo(hPreview,SB_HORZ,&si_horz,1);
}
#define WM_RESETPREVIEW WM_USER+100
LRESULT CALLBACK PreviewWndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	static HDC memdc;
	static HBITMAP hMemBmp;
	static POINT px_pos;
	SCROLLINFO si;
	int i;
	RECT rc;
	switch(message){
		case WM_CREATE:
			memdc=0;
			hMemBmp=0;
			SendMessage(hwnd,WM_RESETPREVIEW,0,0);
			return 0;
		case WM_PAINT:
			HDC hdc;
			PAINTSTRUCT ps;
			hdc=BeginPaint(hwnd,&ps);
			DrawPreview(hwnd,hdc,memdc,&px_pos);
			EndPaint(hwnd,&ps);
			return 0;
		case WM_RESETPREVIEW:
			if(memdc) DeleteDC(memdc);
			if(hMemBmp) DeleteObject(hMemBmp);
			BOOL bLastPage;
			CreatePreviewDCAndBmp(&memdc,&hMemBmp,&px_pos,&bLastPage);
			InvalidateRect(hwnd,NULL,1);

			if(iPreviewNowPage==0) EnableWindow(GetDlgItem(GetParent(hwnd),IDC_PREV),0);
			else EnableWindow(GetDlgItem(GetParent(hwnd),IDC_PREV),1);
			if(bLastPage) EnableWindow(GetDlgItem(GetParent(hwnd),IDC_NEXT),0);
			else EnableWindow(GetDlgItem(GetParent(hwnd),IDC_NEXT),1);

			if(iZoomNowPage<=0) EnableWindow(GetDlgItem(GetParent(hwnd),IDC_ZOOMIN),0);
			else EnableWindow(GetDlgItem(GetParent(hwnd),IDC_ZOOMIN),1);
			if(iZoomNowPage>=ZOOM_NUM-1)
				EnableWindow(GetDlgItem(GetParent(hwnd),IDC_ZOOMOUT),0);
			else EnableWindow(GetDlgItem(GetParent(hwnd),IDC_ZOOMOUT),1);
			return 0;
		case WM_VSCROLL:
		case WM_HSCROLL:
			int fnBar;
			if(message==WM_VSCROLL) fnBar=SB_VERT;
			else fnBar=SB_HORZ;

			si.cbSize=sizeof(SCROLLINFO);
			si.fMask=SIF_POS|SIF_PAGE|SIF_RANGE;

			GetScrollInfo(hwnd,fnBar,&si);
			if(LOWORD(wParam)==SB_LINEUP) i=-1;
			else if(LOWORD(wParam)==SB_LINEDOWN) i=1;
			else if(LOWORD(wParam)==SB_PAGEUP) i=-(signed int)si.nPage;
			else if(LOWORD(wParam)==SB_PAGEDOWN) i=si.nPage;
			else if(LOWORD(wParam)==SB_THUMBTRACK) i=HIWORD(wParam)-si.nPos;
			else i=0;
			GetClientRect(hwnd,&rc);
			if(message==WM_VSCROLL)
				i=max(-si.nPos,min(i,si.nMax-rc.bottom-si.nPos));
			else
				i=max(-si.nPos,min(i,si.nMax-rc.right-si.nPos));
			if(i!=0){
				si.nPos+=i;
				SetScrollInfo(hwnd,fnBar,&si,1);

				InvalidateRect(hwnd,NULL,0);
			}
			return 0;
		case WM_DESTROY:
			DeleteDC(memdc);
			DeleteObject(hMemBmp);
			return 0;
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}
BOOL CALLBACK DlgPreview(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	static HWND hPreview;
	char temporary[255];
	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(GetDesktopWindow(),hwnd);

			hPreview=CreateWindowEx(WS_EX_STATICEDGE,"PreviewWindow",NULL,
				WS_CHILD|WS_VISIBLE|WS_HSCROLL|WS_VSCROLL,
				0,0,0,0,
				hwnd,0,hInst,0);

			RECT rc;
			GetClientRect(hwnd,&rc);
			SetWindowPos(hwnd,NULL,0,0,rc.right,rc.bottom,SWP_NOMOVE);

			iPreviewNowPage=0;

			SetDlgItemText(hwnd,IDC_FONT,pobj_nv->lfPrint.lfFaceName);

			//y[Wԍ\邩ǂ
			if(pobj_nv->bShowPageNum) SendDlgItemMessage(hwnd,IDC_SHOWPAGENUM,BM_SETCHECK,BST_CHECKED,0);
			SendMessage(hwnd,WM_COMMAND,IDC_SHOWPAGENUM,0);

			//y[Wԍ
			SetDlgItemText(hwnd,IDC_PAGESTR,pobj_nv->szPageStr);

			//gEkACR\
			SendDlgItemMessage(hwnd,IDC_ZOOMOUT,BM_SETIMAGE,IMAGE_ICON ,
				(LPARAM)LoadImage(hResInst,MAKEINTRESOURCE(IDI_ZOOMOUT),IMAGE_ICON,16,16,LR_SHARED));
			SendDlgItemMessage(hwnd,IDC_ZOOMIN,BM_SETIMAGE,IMAGE_ICON ,
				(LPARAM)LoadImage(hResInst,MAKEINTRESOURCE(IDI_ZOOMIN),IMAGE_ICON,16,16,LR_SHARED));
			iZoomNowPage=ZOOM_INIT;

			sprintf(temporary,"%d%%",array_Zoom[iZoomNowPage]);
			SetDlgItemText(hwnd,IDC_ZOOMRATIO,temporary);

			SendMessage(hPreview,WM_RESETPREVIEW,0,0);

			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;

				case IDC_PREV:
					iPreviewNowPage--;
					SendMessage(hPreview,WM_RESETPREVIEW,0,0);
					return 1;
				case IDC_NEXT:
					iPreviewNowPage++;
					SendMessage(hPreview,WM_RESETPREVIEW,0,0);
					return 1;

				case IDC_ZOOMOUT:
				case IDC_ZOOMIN:
					if(LOWORD(wParam)==IDC_ZOOMOUT)
						iZoomNowPage++;
					if(LOWORD(wParam)==IDC_ZOOMIN)
						iZoomNowPage--;
					SendMessage(hPreview,WM_RESETPREVIEW,0,0);

					sprintf(temporary,"%d%%",array_Zoom[iZoomNowPage]);
					SetDlgItemText(hwnd,IDC_ZOOMRATIO,temporary);
					return 1;

				case IDC_PRINT:
					Printout();
					return 1;

				case IDC_PAGESET:
					if(obj_Page.SetupDlg()){
						//ĕ`
						SendMessage(hPreview,WM_RESETPREVIEW,0,0);
					}
					return 1;

				case IDC_FONT:
					int iPointSize;
					LOGFONT temp_lf;
					temp_lf=pobj_nv->lfPrint;
					if(!SetFontDialog(hwnd,&temp_lf,0,&iPointSize)) return 1;
					pobj_nv->lfPrint=temp_lf;
					pobj_nv->iPrintFontPointSize=iPointSize;

					SetDlgItemText(hwnd,IDC_FONT,pobj_nv->lfPrint.lfFaceName);

					//ĕ`
					SendMessage(hPreview,WM_RESETPREVIEW,0,0);
					return 1;

				case IDC_SHOWPAGENUM:
					//y[Wԍ\邩ǂ
					if(SendDlgItemMessage(hwnd,IDC_SHOWPAGENUM,BM_GETCHECK,0,0)){
						EnableWindow(GetDlgItem(hwnd,IDC_PAGESTR),1);
						pobj_nv->bShowPageNum=1;
					}
					else{
						EnableWindow(GetDlgItem(hwnd,IDC_PAGESTR),0);
						pobj_nv->bShowPageNum=0;
					}
					SendMessage(hPreview,WM_RESETPREVIEW,0,0);
					return 1;

				case IDC_PAGESTR:
					//y[Wԍ
					GetDlgItemText(hwnd,IDC_PAGESTR,pobj_nv->szPageStr,255);
					return 1;
			}
			return 0;

		case WM_SIZE:
			MoveWindow(hPreview,
				140,40,
				LOWORD(lParam)-155,
				HIWORD(lParam)-55,0);
			InvalidateRect(hwnd,NULL,0);
			return 0;

		case WM_DESTROY:
			DestroyWindow(hPreview);
			return 0;
	}
	return 0;
}

void Preview(void){
	DialogBox(hResInst,MAKEINTRESOURCE(IDD_PREVIEW),hOwner,(DLGPROC)DlgPreview);
}


void Printout(void){
	int WndNum;
	WndNum=GetWndNum(GetWindow(hClient,GW_CHILD));

	//_CAO
	PRINTDLG pd;
	memset(&pd,0,sizeof(PRINTDLG));
	pd.lStructSize=sizeof(PRINTDLG);
	pd.hwndOwner=hOwner;
	pd.Flags=PD_ALLPAGES | PD_RETURNDC | PD_USEDEVMODECOPIESANDCOLLATE | PD_NOSELECTION | PD_NOPAGENUMS | PD_HIDEPRINTTOFILE;
	pd.nFromPage=1;
	pd.nToPage=1;
	pd.nMinPage=1;
	pd.nMaxPage=1;
	pd.nCopies=1;
	if(PrintDlg(&pd)==0){
		return;
	}

	//hLgX^[g
	DOCINFO di;
	memset(&di,0,sizeof(DOCINFO));
	di.cbSize=sizeof(DOCINFO);
	di.lpszDocName=MdiInfo[WndNum].title.c_str();
	if(StartDoc(pd.hDC,&di)==0){
		MessageBox(hOwner,"ł܂Bv^[̏󋵂mFĂB",APPLICATION_NAME,MB_OK | MB_ICONEXCLAMATION);
		return;
	}

	//֕`
	DrawPage(pd.hDC,0);

	//hLgI
	EndDoc(pd.hDC);

	DeleteDC(pd.hDC);
}
