#include "stdafx.h"

#include "Common.h"

void MakeUserSettingDir(void){
	char temporary[MAX_PATH];
	sprintf(temporary,"%sUserSetting",pj_editor_Dir);

	HANDLE hFind;
	WIN32_FIND_DATA wfd;
	hFind=FindFirstFile(temporary,&wfd);
	if(hFind==INVALID_HANDLE_VALUE){
		//UserSettingfBNg쐬
		if(!CreateDirectory(temporary,NULL)){
			MessageBox(hOwner,"UserSettingfBNg̍쐬Ɏs",APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);
			return;
		}
	}
}

char *ReadBuffer( const std::string &path ){
	extern HANDLE hHeap;
	int i;
	DWORD dw;
	char *buffer,temporary[MAX_PATH];
	HANDLE hFile;

	hFile=CreateFile(path.c_str(),GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile==INVALID_HANDLE_VALUE){
		//"\"%s\" t@C̓ǂݍ݂Ɏs܂B"
		sprintf(temporary,STRING_ERROR_CANT_FILEOPEN,path.c_str());
		MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);

		return 0;
	}
	i=GetFileSize(hFile,0);
	buffer=(char *)HeapAlloc(hHeap,0,i+1);
	ReadFile(hFile,buffer,i,&dw,0);
	buffer[dw]=0;
	CloseHandle(hFile);
	return buffer;
}
char *ReadBuffer_NonErrMsg( const std::string &path ){
	extern HANDLE hHeap;
	int i;
	DWORD dw;
	char *buffer;
	HANDLE hFile;

	hFile=CreateFile(path.c_str(),GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile==INVALID_HANDLE_VALUE) return 0;
	i=GetFileSize(hFile,0);
	buffer=(char *)HeapAlloc(hHeap,0,i+1);
	ReadFile(hFile,buffer,i,&dw,0);
	buffer[dw]=0;
	CloseHandle(hFile);
	return buffer;
}
_int8 WriteBuffer(const std::string &path,const char *buffer,int length, bool isEnableError)
{
	HANDLE hFile;
	DWORD dw;
	hFile=CreateFile(path.c_str(),GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile==INVALID_HANDLE_VALUE){
		char temporary[MAX_PATH];

		if( isEnableError ){
			//"\"%s\" t@Cւ݂̏Ɏs܂B"
			sprintf(temporary,STRING_ERROR_CANT_FILESAVE,path);
			MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
		}
		return 0;
	}
	if(length) WriteFile(hFile,buffer,length,&dw,NULL);
	CloseHandle(hFile);
	return 1;
}
_int8 WriteBuffer_NonErrMsg(const std::string &path,char *buffer,int length){
	return WriteBuffer( path, buffer, length, false );
}
void GetRelationalPath(char *path,char *dir){
	//΃pX擾
	int i,i2,i3,i4,i5;
	char temporary[MAX_PATH],temp2[MAX_PATH],temp3[MAX_PATH],temp4[MAX_PATH];

	//hCu`FbN
	_splitpath(path,temporary,0,0,0);
	_splitpath(dir,temp2,0,0,0);
	if(lstrcmpi(temporary,temp2)!=0) return;

	_splitpath(path,0,temporary,0,0);
	_splitpath(dir,0,temp2,0,0);
	i=1;i2=1;
	while(1){
		i4=i;
		if(temporary[i-1]=='\\'&&temporary[i]){	//path
			for(i3=0;;i++,i3++){
				if(temporary[i]=='\\'){
					temp3[i3]=0;
					i++;
					break;
				}
				temp3[i3]=temporary[i];
			}
		}
		else temp3[0]=0;

		i5=i2;
		if(temp2[i2-1]=='\\'&&temp2[i2]){		//dir
			for(i3=0;;i2++,i3++){
				if(temp2[i2]=='\\'){
					temp4[i3]=0;
					i2++;
					break;
				}
				temp4[i3]=temp2[i2];
			}
		}
		else temp4[0]=0;

		if(temp3[0]=='\0'&&temp4[0]=='\0') break;

		if(lstrcmpi(temp3,temp4)!=0){
			for(i3=0;;i5++){
				if(temp2[i5]=='\0') break;
				if(temp2[i5]=='\\') i3++;
			}
			temp3[0]=0;
			for(i2=0;i2<i3;i2++) lstrcat(temp3,"..\\");
			lstrcat(temp3,temporary+i4);
			break;
		}
	}
	_splitpath(path,0,0,temporary,temp2);
	lstrcat(temp3,temporary);
	lstrcat(temp3,temp2);
	lstrcpy(path,temp3);
}
void GetFullPath(char *path,const char *dir){
	int i,i2,i3,i4;
	char temporary[MAX_PATH];

	if(strstr(path,":")||strstr(path,"\\\\")) return;

	i=0;i2=0;
	while(1){
		if(path[i]=='.'&&path[i+1]=='\\') i+=2;
		if(path[i]=='.'&&path[i+1]=='.'&&path[i+2]=='\\'){
			i2++;
			i+=3;
		}
		else break;
	}

	i3=lstrlen(dir);i4=0;
	while(i4<i2){
		for(i3--;;i3--){
			if(dir[i3-1]=='\\'){
				i4++;
				break;
			}
		}
	}
	memcpy(temporary,dir,i3);
	temporary[i3]=0;
	lstrcat(temporary,path+i);
	lstrcpy(path,temporary);
}

void RemoveDirectoryStrong(const char *dirPath){
	char tempDirPath[MAX_PATH];
	lstrcpy( tempDirPath, dirPath );

	if( tempDirPath[lstrlen(tempDirPath)-1] == '\\' ){
		 tempDirPath[lstrlen(tempDirPath)-1] = 0;
	}

	HANDLE hFind;
	WIN32_FIND_DATA wfd;
	char temporary[MAX_PATH];
	sprintf(temporary,"%s\\*",tempDirPath);

	hFind=FindFirstFile(temporary,&wfd);
	if(hFind!=INVALID_HANDLE_VALUE){
		do{
			if(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY){
				if(!(lstrcmp(wfd.cFileName,".")==0||lstrcmp(wfd.cFileName,"..")==0)){
					//fBNĝƂ
					sprintf(temporary,"%s\\%s\\",tempDirPath,wfd.cFileName);
					RemoveDirectoryStrong(temporary);
				}
			}
			else{
				//t@ĈƂ
				sprintf(temporary,"%s\\%s",tempDirPath,wfd.cFileName);

				DeleteFile(temporary);
			}
		}while(FindNextFile(hFind,&wfd));

		FindClose( hFind );
	}

	if( !RemoveDirectory(tempDirPath) ){
		OutputDebugString( GetLastErrorString().c_str() );
		OutputDebugString( "\r\n" );
		OutputDebugString( "ꎞfBNg̍폜Ɏs\r\n" );
	}
}

BOOL GetFilePathDialog(HWND hwnd,char *filename,LPSTR Filter,LPSTR Title,_int8 IsOpen){
	OPENFILENAME ofstr;
	filename[0]=0;
	ofstr.lStructSize=sizeof(OPENFILENAME);
	ofstr.hwndOwner=hwnd;
	ofstr.hInstance=0;
	ofstr.lpstrFilter=Filter;
	ofstr.lpstrCustomFilter=NULL;
	ofstr.nMaxCustFilter=0;
	ofstr.nFilterIndex=1;
	ofstr.lpstrFile=filename;
	ofstr.nMaxFile=MAX_PATH;
	ofstr.lpstrFileTitle=NULL;
	ofstr.nMaxFileTitle=0;
	ofstr.lpstrInitialDir=pobj_nv->DefSaveDir;
	ofstr.lpstrTitle=Title;
	ofstr.Flags=OFN_FILEMUSTEXIST|OFN_HIDEREADONLY|OFN_PATHMUSTEXIST;
	ofstr.nFileOffset=0;
	ofstr.nFileExtension=0;
	ofstr.lpstrDefExt="*";
	ofstr.lCustData=NULL;
	ofstr.lpfnHook=NULL;
	ofstr.lpTemplateName=NULL;
	if(IsOpen){
		if(!GetOpenFileName(&ofstr)) return FALSE;
	}
	else{
		if(!GetSaveFileName(&ofstr)) return FALSE;
	}

	//̏fBNgZbg
	char temporary[MAX_PATH];
	_splitpath(filename,pobj_nv->DefSaveDir,temporary,NULL,NULL);
	lstrcat(pobj_nv->DefSaveDir,temporary);

	return TRUE;
}
BOOL GetFolder(HWND hWnd,char *folder,char *OpenFolderTitle){
	BROWSEINFO BrowseInfo;
	LPITEMIDLIST pidlBrowse;
	LPMALLOC g_pMalloc;
	char temporary[MAX_PATH];

	BrowseInfo.hwndOwner=hWnd;
	BrowseInfo.pszDisplayName=temporary;
	BrowseInfo.pidlRoot=NULL;
	BrowseInfo.lpszTitle=OpenFolderTitle;
	BrowseInfo.ulFlags=BIF_RETURNONLYFSDIRS;
	BrowseInfo.lpfn=NULL;
	BrowseInfo.lParam=(LPARAM)0;
	BrowseInfo.iImage=0;
	pidlBrowse=SHBrowseForFolder(&BrowseInfo);
	if(pidlBrowse){
		if(SHGetMalloc(&g_pMalloc)!=0) return 0;
		SHGetPathFromIDList(pidlBrowse,folder);
		g_pMalloc->Free(pidlBrowse);
		g_pMalloc->Release();
		return 1;
	}
	return 0;
}

int GetFileExtension(char *path){
	char temporary[MAX_PATH];
	_splitpath(path,0,0,0,temporary);

	if(lstrcmpi(temporary,".bas")==0||
		lstrcmpi(temporary,".ab")==0||
		lstrcmpi(temporary,".abp")==0) return FT_BASICPROGRAM;
	if(lstrcmpi(temporary,".sbp")==0) return FT_SUBPROGRAM;
	if(lstrcmpi(temporary,".txt")==0) return FT_TEXT;
	if(lstrcmpi(temporary,".pj")==0) return FT_PROJECT;
	if(lstrcmpi(temporary,".ico")==0) return FT_ICON;

	if(lstrcmpi(temporary,".html")==0||
		lstrcmpi(temporary,".htm")==0||
		lstrcmpi(temporary,".tpl")==0||
		lstrcmpi(temporary,".php")==0)
		return FT_HTML;

	return FT_OTHER;
}
HWND OpenFileWithExtension( const std::string &filePath )
{
	int i;
	_int8 DocumentType;

	// TODO:
	char *OpenFileName = const_cast<char *>(filePath.c_str());

	i=GetFileExtension(OpenFileName);

#ifndef THETEXT
	if(i==FT_PROJECT){
		//uŋߎgvWFNgvɒǉ
		pobj_nv->pobj_ProjectHistory->insert(OpenFileName);

		projectInfo.Load(OpenFileName);
		return 0;
	}
#endif

	//uŋߎgt@Cvɒǉ
	pobj_nv->pobj_History->insert(OpenFileName);

	if(i==FT_ICON){
		NewIconEditWindow(OpenFileName);
		return 0;
	}
	else if(i==FT_BASICPROGRAM||i==FT_SUBPROGRAM){
		DocumentType=WNDTYPE_BASIC;

#ifdef THETEXT
		DocumentType=WNDTYPE_TEXT;
#endif
	}
	else if(i==FT_HTML) DocumentType=WNDTYPE_HTML;
	else DocumentType=WNDTYPE_TEXT;

	COLORREF TabColor;
	TabColor=pobj_nv->pobj_ExtLink->GetTabColorFromFilePath( filePath );

	return NewTextEditWindow(OpenFileName,DocumentType,TabColor);
}
BOOL SaveDocument(HWND hChild,char *SaveFileName){	//EBhEobt@ǂݎAt@Cɕۑ
	extern LPSTR IconFileFilter;
	extern HWND hClient,hDocCombo;
	int WndNum,i2;
	char temporary[MAX_PATH],str[MAX_PATH],str2[32];
	HANDLE fh;
	DWORD dummy;

	WndNum=GetWndNum(hChild);

	char szOldTitle[MAX_PATH];
	lstrcpy(szOldTitle,MdiInfo[WndNum].title.c_str());

	if(MdiInfo[WndNum].DocType==WNDTYPE_RAD||MdiInfo[WndNum].DocType==WNDTYPE_MENU){
		////////////////////////////////////
		// RADc[yуj[GfB^
		////////////////////////////////////

		if(projectInfo.ModifyOfMaterial){
			sprintf(temporary,"%s%s.wnd",projectInfo.GetWorkDir().GetPath().c_str(),projectInfo.GetName().c_str());
			SaveWindowFile( temporary, projectInfo.windowInfos );

			//.wbpt@C𐶐
			SaveWindowProgram();
		}
	}
	else if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
		//////////////////////////
		// eLXghLg
		//////////////////////////

		if(SaveFileName){
			lstrcpy(temporary,SaveFileName);
			if((fh=CreateFile(temporary,GENERIC_WRITE,0,NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL))==INVALID_HANDLE_VALUE){
				sprintf(str,STRING_FILE_OVERWRIDE,temporary);
				if(MessageBox(hOwner,str,APPLICATION_NAME,MB_YESNO|MB_ICONINFORMATION)==IDNO){
					CloseHandle(fh);
					return 0;
				}
			}
			CloseHandle(fh);

			//hLg ZNg R{{bNX
			i2=SendMessage(hDocCombo,CB_FINDSTRINGEXACT,0,(long)MdiInfo[WndNum].title.c_str());
			SendMessage(hDocCombo,CB_DELETESTRING,i2,0);

			//VpXZbg
			MdiInfo[WndNum].path = temporary;

			//hLg ZNg R{{bNXɑ}
			_splitpath(temporary,NULL,NULL,str,str2);
			lstrcat(str,str2);
			MdiInfo[WndNum].title = str;
			SendMessage(hDocCombo,CB_ADDSTRING,0,(long)MdiInfo[WndNum].title.c_str());
			i2=SendMessage(hDocCombo,CB_FINDSTRINGEXACT,0,(long)MdiInfo[WndNum].title.c_str());
			SendMessage(hDocCombo,CB_SETCURSEL,i2,0);

			//MDIEBhẼ^CgĐݒ
			SetWindowText(hChild,MdiInfo[WndNum].title.c_str());
		}
		else{
			if(MdiInfo[WndNum].path.empty()){
				//"ۑ̃t@Cw肵Ă"
get_file_path:

				LPSTR ff;

				extern LPSTR DefFileFilter;
				extern LPSTR HtmlFileFilter;
				extern LPSTR TextFileFilter;
				if(MdiInfo[WndNum].DocType==WNDTYPE_BASIC)
					ff=DefFileFilter;
				else if(MdiInfo[WndNum].DocType==WNDTYPE_HTML)
					ff=HtmlFileFilter;
				else if(MdiInfo[WndNum].DocType==WNDTYPE_TEXT)
					ff=TextFileFilter;

				if(!GetFilePathDialog(hOwner,temporary,ff,STRING_FILESAVETITLE_DEFAULT,FALSE)) return 0;
				SaveDocument(hChild,temporary);
				return 1;
			}
			lstrcpy(temporary,MdiInfo[WndNum].path.c_str());
		}

		if(!IsExistFile(temporary)){
			//ۑt@C݂ȂƂ
			char temp2[MAX_PATH];

			//fBNgZbg
			_splitpath(temporary,pobj_nv->DefSaveDir,temp2,NULL,NULL);
			lstrcat(pobj_nv->DefSaveDir,temp2);

			goto get_file_path;
		}

		//R[h𕜌
		char *pBuf;
		pBuf=nkf.RestoreBuffer(MdiInfo[WndNum].pMdiTextEdit->buffer,MdiInfo[WndNum].pMdiTextEdit->iCharCode);

		//sR[h𕜌
		if(MdiInfo[WndNum].pMdiTextEdit->iLfCode==LFCODE_LF) nkf.ToLF(pBuf);
		else if(MdiInfo[WndNum].pMdiTextEdit->iLfCode==LFCODE_CR) nkf.ToCR(pBuf);


		////////////////////////
		// ۑ
		////////////////////////

		fh=CreateFile(temporary,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
		if(fh==INVALID_HANDLE_VALUE){
			sprintf(str,STRING_ERROR_CANT_FILESAVE,temporary);
			MessageBox(hOwner,str,STRING_ERROR,MB_OK|MB_ICONSTOP);
			return 0;
		}
		WriteFile(fh,pBuf,lstrlen(pBuf),&dummy,NULL);
		CloseHandle(fh);


		HeapDefaultFree(pBuf);

		//ύXtOItɂ
		MdiInfo[WndNum].pMdiTextEdit->UnModify();
	}
	else if(MdiInfo[WndNum].DocType==WNDTYPE_ICONEDIT){
		///////////////////
		// ICON
		///////////////////

		if(SaveFileName){
			lstrcpy(temporary,SaveFileName);
			if((fh=CreateFile(temporary,GENERIC_WRITE,0,NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL))==INVALID_HANDLE_VALUE){
				sprintf(str,STRING_FILE_OVERWRIDE,temporary);
				if(MessageBox(hOwner,str,APPLICATION_NAME,MB_YESNO|MB_ICONINFORMATION)==IDNO){
					CloseHandle(fh);
					return 0;
				}
			}
			CloseHandle(fh);
			MdiInfo[WndNum].path = temporary;
			i2=SendMessage(hDocCombo,CB_FINDSTRINGEXACT,0,(long)MdiInfo[WndNum].title.c_str());
			SendMessage(hDocCombo,CB_DELETESTRING,i2,0);
			_splitpath(temporary,NULL,NULL,str,str2);
			lstrcat(str,str2);
			MdiInfo[WndNum].title = str;
			SendMessage(hDocCombo,CB_ADDSTRING,0,(long)MdiInfo[WndNum].title.c_str());
			i2=SendMessage(hDocCombo,CB_FINDSTRINGEXACT,0,(long)MdiInfo[WndNum].title.c_str());
			SendMessage(hDocCombo,CB_SETCURSEL,i2,0);
			SetWindowText(hChild,MdiInfo[WndNum].title.c_str());
		}
		else{
			if(MdiInfo[WndNum].path.empty()){
				//"ۑ̃t@Cw肵Ă"
				if(!GetFilePathDialog(hOwner,temporary,IconFileFilter,STRING_FILESAVETITLE_DEFAULT,FALSE)) return 0;
				SaveDocument(hChild,temporary);
				return 1;
			}
			lstrcpy(temporary,MdiInfo[WndNum].path.c_str());
		}
		SaveIconFile(temporary,hChild);

		MdiInfo[WndNum].MdiIconEditInfo->bModify=0;
	}


	//^uRg[Đݒ
	if(pobj_nv->bSaveTabToHead){
		COLORREF color;
		color=pobj_MainTab->GetItemColor(szOldTitle);
		pobj_MainTab->DeleteItem( szOldTitle, false );
		pobj_MainTab->InsertItem( MdiInfo[WndNum].title.c_str(), false, color );
	}
	else{
		pobj_MainTab->RenameItem( szOldTitle, MdiInfo[WndNum].title.c_str() );
	}

	//uŋߎgt@CvXV
	pobj_nv->pobj_History->insert(MdiInfo[WndNum].path.c_str());

	return 1;
}
BOOL ShortPathToLongPath(char ShortPath[MAX_PATH],char *LongPath){
	HANDLE hFind;
	WIN32_FIND_DATA wfd;
	int i;
	char dummy[MAX_PATH];
	for(i=0;i<MAX_PATH;i++){
		LongPath[i]=ShortPath[i];
		if((ShortPath[i-1]==':'&&ShortPath[i]=='\\')||(ShortPath[i-1]=='\\'&&ShortPath[i]=='\\')){
			LongPath[i+1]=0;
			break;
		}
	}
	if(ShortPath[i-1]=='\\'&&ShortPath[i]=='\\'){
		for(i++;i<MAX_PATH;i++){
			if(IsDBCSLeadByte(ShortPath[i])){
				i++;
				continue;
			}
			LongPath[i]=ShortPath[i];
			if(ShortPath[i]=='\\'){
				LongPath[i+1]=0;
				break;
			}
		}
		for(i++;i<MAX_PATH;i++){
			if(IsDBCSLeadByte(ShortPath[i])){
				i++;
				continue;
			}
			LongPath[i]=ShortPath[i];
			if(ShortPath[i]=='\\'){
				LongPath[i+1]=0;
				break;
			}
		}
	}
	for(i++;i<MAX_PATH;i++){
		if(IsDBCSLeadByte(ShortPath[i])){
			i++;
			continue;
		}
		if(ShortPath[i]=='\\'||ShortPath[i]=='\0'){
			strncpy(dummy,ShortPath,i);
			dummy[i]=0;
			if((hFind=FindFirstFile(dummy,&wfd))!=INVALID_HANDLE_VALUE) FindClose(hFind);
			lstrcat(LongPath,wfd.cFileName);

			if(ShortPath[i]=='\0') break;
			lstrcat(LongPath,"\\");

			if(ShortPath[i]=='\\'&&ShortPath[i+1]=='\0'){
				break;
			}
		}
	}
	return 1;
}

bool IsExistFile( const char *FilePath ){
	WIN32_FIND_DATA wfd;
	HANDLE hFind;

	hFind = FindFirstFile(FilePath,&wfd);
	if( hFind == INVALID_HANDLE_VALUE ){
		return false;
	}
	FindClose( hFind );

	return true;
}

bool IsExistDirectory( const char *DirPath ){
	WIN32_FIND_DATA wfd;
	HANDLE hFind;

	hFind = FindFirstFile(DirPath,&wfd);
	if( hFind == INVALID_HANDLE_VALUE ){
		//݂Ȃ
		return false;
	}
	FindClose( hFind );

	if( wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ){
		//fBNg̏ꍇ
		return true;
	}

	//݂Ȃ
	return false;
}
