#include "stdafx.h"

#include "common.h"

#if defined(JPN)
//{
#include "pj_msg_jpn.h"
#else
//p
#include "pj_msg_eng.h"
#endif


void Project_CursorResInsert(void){
	extern HANDLE hHeap;
	extern LPSTR CursorFileFilter;
	int i3;
	char temporary[MAX_PATH];

	//"J[\ t@Cw肵Ă"
	if(!GetFilePathDialog(hOwner,temporary,CursorFileFilter,STRING_FILEOPENTITLE_CURSOR,TRUE)) return;

	ActiveBasic::Common::ResourceItem item;
	item.filepath = projectInfo.GetWorkDir().GetRelationalPath( temporary );

	for(i3=1;;i3++){
		sprintf(temporary,"IDC_CURSOR%d",i3);
		bool isDuplicate = false;
		BOOST_FOREACH( const ActiveBasic::Common::ResourceItem &resourceItem, projectInfo.resourceManager.cursorResources )
		{
			if( resourceItem.idName == temporary )
			{
				isDuplicate = true;
				break;
			}
		}

		if( !isDuplicate )
		{
			break;
		}
	}
	item.idName = temporary;

	//c[r[ɒǉ
	extern HWND hMaterialTreeView;
	TV_INSERTSTRUCT tv;
	tv.hInsertAfter=TVI_SORT;
	tv.item.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
	tv.item.iImage=6;
	tv.item.iSelectedImage=6;
	tv.hParent = hCursorTreeItemForProjectView;
	tv.item.pszText=temporary;

	item.hTreeItem = TreeView_InsertItem(hMaterialTreeView,&tv);

	TreeView_SelectItem( hMaterialTreeView, item.hTreeItem );

	projectInfo.resourceManager.cursorResources.push_back( item );

	projectInfo.ModifuOfResource=1;
}
void Project_Cursor_Delete(int CursorInfoNum){
	//c[r[폜
	extern HWND hMaterialTreeView;
	TreeView_DeleteItem(hMaterialTreeView,projectInfo.resourceManager.cursorResources[CursorInfoNum].hTreeItem);

	//projectInfo.pCursorInfo\̂폜
	Jenga::Common::EraseVectorItem<ActiveBasic::Common::ResourceItems>( projectInfo.resourceManager.cursorResources, CursorInfoNum );

	projectInfo.ModifuOfResource=1;
}
void Project_Cursor_RenameID(int CursorInfoNum){
	extern HANDLE hHeap;
	extern char NewIdName[MAX_PATH];
	extern HWND hMaterialTreeView;
	int i2;
	char temporary[MAX_PATH];
	TVITEM tvItem;

	if(!DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_INPUTID),hOwner,(DLGPROC)DlgProject_ResourceID_Input,(long)projectInfo.resourceManager.cursorResources[CursorInfoNum].idName.c_str())) return;

	//d`FbN
	for(i2=0;i2<static_cast<int>(projectInfo.resourceManager.cursorResources.size());i2++){
		if(i2==CursorInfoNum) continue;
		if( projectInfo.resourceManager.cursorResources[i2].idName == NewIdName )
		{
			//"ID \"%s\" ͊ɃvWFNgɑ݂܂B"
			sprintf(temporary,STRING_DUPLICATIONERROR_ID_IN_PROJECT,NewIdName);
			MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
			return;
		}
	}

	projectInfo.resourceManager.cursorResources[CursorInfoNum].idName = NewIdName;

	tvItem.hItem=projectInfo.resourceManager.cursorResources[CursorInfoNum].hTreeItem;
	tvItem.mask=TVIF_TEXT;
	lstrcpy( temporary, projectInfo.resourceManager.cursorResources[CursorInfoNum].idName.c_str() );
	tvItem.pszText=temporary;
	tvItem.cchTextMax=lstrlen(temporary)+1;
	TreeView_SetItem(hMaterialTreeView,&tvItem);

	projectInfo.ModifuOfResource=1;

	TreeView_SortChildren(hMaterialTreeView,
		TreeView_GetParent(hMaterialTreeView,projectInfo.resourceManager.cursorResources[CursorInfoNum].hTreeItem),
		0);
}

void Project_BitmapResInsert(void){
	extern HANDLE hHeap;
	extern LPSTR BitmapFileFilter;
	int i2,i3;
	char temporary[MAX_PATH];

	//"rbg}bv t@Cw肵Ă"
	if(!GetFilePathDialog(hOwner,temporary,BitmapFileFilter,STRING_FILEOPENTITLE_BITMAP,TRUE)) return;

	ActiveBasic::Common::ResourceItem item;
	item.filepath = projectInfo.GetWorkDir().GetRelationalPath( temporary );

	for(i3=1;;i3++){
		sprintf(temporary,"IDB_BITMAP%d",i3);
		bool isDuplicate = false;
		BOOST_FOREACH( const ActiveBasic::Common::ResourceItem &resourceItem, projectInfo.resourceManager.bitmapResources )
		{
			if( resourceItem.idName == temporary )
			{
				isDuplicate = true;
				break;
			}
		}

		if( !isDuplicate )
		{
			break;
		}
	}
	item.idName = temporary;

	//c[r[ɒǉ
	extern HWND hMaterialTreeView;
	TV_INSERTSTRUCT tv;
	tv.hInsertAfter=TVI_SORT;
	tv.item.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
	tv.item.iImage=5;
	tv.item.iSelectedImage=5;
	tv.hParent = hBitmapTreeItemForProjectView;
	tv.item.pszText=temporary;

	item.hTreeItem = TreeView_InsertItem(hMaterialTreeView,&tv);

	TreeView_SelectItem(hMaterialTreeView,item.hTreeItem);

	projectInfo.resourceManager.bitmapResources.push_back( item );

	projectInfo.ModifuOfResource=1;


	////////////////////////////////
	// EBhE vpeBXV
	for(i2=0;i2<MdiInfo.size();i2++){
		if(MdiInfo[i2].hwnd&&MdiInfo[i2].DocType==WNDTYPE_RAD){
			if(MdiInfo[i2].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW)
				ChangePropertyWindow(i2,GetWndInfoNum(MdiInfo[i2].path));
		}
	}
}
void Project_Bitmap_Delete(int BitmapInfoNum){
	//c[r[폜
	extern HWND hMaterialTreeView;
	TreeView_DeleteItem(hMaterialTreeView,projectInfo.resourceManager.bitmapResources[BitmapInfoNum].hTreeItem);

	//projectInfo.pBitmapInfo\̂폜
	Jenga::Common::EraseVectorItem<ActiveBasic::Common::ResourceItems>( projectInfo.resourceManager.bitmapResources, BitmapInfoNum );

	projectInfo.ModifuOfResource=1;
}
void Project_Bitmap_RenameID(int BitmapInfoNum){
	extern HANDLE hHeap;
	extern char NewIdName[MAX_PATH];
	extern HWND hMaterialTreeView;
	int i2;
	char temporary[MAX_PATH];
	TVITEM tvItem;

	if(!DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_INPUTID),hOwner,(DLGPROC)DlgProject_ResourceID_Input,(long)projectInfo.resourceManager.bitmapResources[BitmapInfoNum].idName.c_str())) return;

	//d`FbN
	for(i2=0;i2<static_cast<int>(projectInfo.resourceManager.bitmapResources.size());i2++){
		if(i2==BitmapInfoNum) continue;
		if( projectInfo.resourceManager.bitmapResources[i2].idName == NewIdName )
		{
			//"ID \"%s\" ͊ɃvWFNgɑ݂܂B"
			sprintf(temporary,STRING_DUPLICATIONERROR_ID_IN_PROJECT,NewIdName);
			MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
			return;
		}
	}

	projectInfo.resourceManager.bitmapResources[BitmapInfoNum].idName = NewIdName;

	tvItem.hItem=projectInfo.resourceManager.bitmapResources[BitmapInfoNum].hTreeItem;
	tvItem.mask=TVIF_TEXT;
	lstrcpy( temporary, projectInfo.resourceManager.bitmapResources[BitmapInfoNum].idName.c_str() );
	tvItem.pszText = temporary;
	tvItem.cchTextMax=lstrlen(temporary)+1;
	TreeView_SetItem(hMaterialTreeView,&tvItem);

	projectInfo.ModifuOfResource=1;

	TreeView_SortChildren(hMaterialTreeView,
		TreeView_GetParent(hMaterialTreeView,projectInfo.resourceManager.bitmapResources[BitmapInfoNum].hTreeItem),
		0);
}
void Project_IconResInsert(void){
	extern HANDLE hHeap;
	extern LPSTR IconFileFilter;
	int i2,i3;
	char temporary[MAX_PATH];

	//"ACR t@Cw肵Ă"
	if(!GetFilePathDialog(hOwner,temporary,IconFileFilter,STRING_FILEOPENTITLE_ICON,TRUE)) return;

	ActiveBasic::Common::ResourceItem item;
	item.filepath = projectInfo.GetWorkDir().GetRelationalPath( temporary );

	for(i3=1;;i3++){
		sprintf(temporary,"IDI_ICON%d",i3);
		bool isDuplicate = false;
		BOOST_FOREACH( const ActiveBasic::Common::ResourceItem &resourceItem, projectInfo.resourceManager.iconResources )
		{
			if( resourceItem.idName == temporary )
			{
				isDuplicate = true;
				break;
			}
		}

		if( !isDuplicate )
		{
			break;
		}
	}
	item.idName = temporary;

	//c[r[ɒǉ
	extern HWND hMaterialTreeView;
	TV_INSERTSTRUCT tv;
	tv.hInsertAfter=TVI_SORT;
	tv.item.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
	tv.item.iImage=4;
	tv.item.iSelectedImage=4;
	tv.hParent = hIconTreeItemForProjectView;
	if(projectInfo.resourceManager.iconResources.size()==0) lstrcat(temporary," (Main)");
	tv.item.pszText=temporary;

	item.hTreeItem=
		TreeView_InsertItem(hMaterialTreeView,&tv);

	TreeView_SelectItem(hMaterialTreeView,item.hTreeItem);

	projectInfo.resourceManager.iconResources.push_back( item );

	projectInfo.ModifuOfResource=1;

	////////////////////////////////
	// EBhE vpeBXV
	for(i2=0;i2<MdiInfo.size();i2++){
		if(MdiInfo[i2].hwnd&&MdiInfo[i2].DocType==WNDTYPE_RAD){
			if(MdiInfo[i2].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW)
				ChangePropertyWindow(i2,GetWndInfoNum(MdiInfo[i2].path));
		}
	}
}
void Project_Icon_Delete(int IconInfoNum){
	extern HANDLE hHeap;
	int i2;
	char temporary[MAX_PATH];
	TVITEM tv;

	//c[r[폜
	extern HWND hMaterialTreeView;
	TreeView_DeleteItem(hMaterialTreeView,projectInfo.resourceManager.iconResources[IconInfoNum].hTreeItem);

	//projectInfo.pIconInfo\̂폜
	Jenga::Common::EraseVectorItem<ActiveBasic::Common::ResourceItems>( projectInfo.resourceManager.iconResources, IconInfoNum );

	if(IconInfoNum==0&&projectInfo.resourceManager.iconResources.size()){
		tv.mask=TVIF_TEXT|TVIF_HANDLE;
		tv.pszText=temporary;
		tv.cchTextMax=MAX_PATH;
		tv.hItem=projectInfo.resourceManager.iconResources[0].hTreeItem;
		TreeView_GetItem(hMaterialTreeView,&tv);
		lstrcat(tv.pszText," (Main)");
		TreeView_SetItem(hMaterialTreeView,&tv);
	}

	projectInfo.ModifuOfResource=1;

	////////////////////////////////
	// EBhE vpeBXV
	for(i2=0;i2<MdiInfo.size();i2++){
		if(MdiInfo[i2].hwnd&&MdiInfo[i2].DocType==WNDTYPE_RAD){
			if(MdiInfo[i2].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW)
				ChangePropertyWindow(i2,GetWndInfoNum(MdiInfo[i2].path));
		}
	}
}
void Project_Icon_RenameID(int IconInfoNum){
	extern HANDLE hHeap;
	extern char NewIdName[MAX_PATH];
	extern HWND hMaterialTreeView;
	int i2;
	char temporary[MAX_PATH];
	TVITEM tvItem;

	if(!DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_INPUTID),hOwner,(DLGPROC)DlgProject_ResourceID_Input,(long)projectInfo.resourceManager.iconResources[IconInfoNum].idName.c_str())) return;

	//d`FbN
	for(i2=0;i2<static_cast<int>(projectInfo.resourceManager.iconResources.size());i2++){
		if(i2==IconInfoNum) continue;
		if( projectInfo.resourceManager.iconResources[i2].idName == NewIdName )
		{
			//"ID \"%s\" ͊ɃvWFNgɑ݂܂B"
			sprintf(temporary,STRING_DUPLICATIONERROR_ID_IN_PROJECT,NewIdName);
			MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
			return;
		}
	}

	projectInfo.resourceManager.iconResources[IconInfoNum].idName = NewIdName;

	tvItem.hItem=projectInfo.resourceManager.iconResources[IconInfoNum].hTreeItem;
	tvItem.mask=TVIF_TEXT;
	if(IconInfoNum==0){
		sprintf(temporary,"%s (Main)",projectInfo.resourceManager.iconResources[IconInfoNum].idName.c_str());
	}
	else
	{
		sprintf(temporary,"%s",projectInfo.resourceManager.iconResources[IconInfoNum].idName.c_str());
	}
	tvItem.pszText=temporary;
	tvItem.cchTextMax=lstrlen(temporary)+1;
	TreeView_SetItem(hMaterialTreeView,&tvItem);

	projectInfo.ModifuOfResource=1;

	TreeView_SortChildren(hMaterialTreeView,
		TreeView_GetParent(hMaterialTreeView,projectInfo.resourceManager.iconResources[IconInfoNum].hTreeItem),
		0);
}

BOOL CALLBACK DlgProject_ResourceID_Input(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern char NewIdName[MAX_PATH];
	switch(message){
		case WM_INITDIALOG:
			//"ID̕ύX"
			SetWindowText(hwnd,STRING_RENAME_ID);

			SetDlgItemText(hwnd,IDC_IDNAME,(char *)lParam);
			SetPosCenter(hwnd);
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					GetDlgItemText(hwnd,IDC_IDNAME,NewIdName,MAX_PATH);
					if(!NewIdName[0]){
						//"ID͂ĉB"
						MessageBox(hwnd,STRING_ERROR_MUST_IDNAME,APPLICATION_NAME,MB_OK);
						return 1;
					}
					EndDialog(hwnd,1);
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
			}
			break;
	}
	return 0;
}
