#include "stdafx.h"

#include "Common.h"

extern HFONT hFont_TextEdit,hFont_HyperLink_TextEdit;
extern int font_width,font_height;


int GetControlTabSpace(int WndNum,int *piCount){
	if(pobj_nv->bEditor_LineNumber){

		char *pBuf;
		pBuf=MdiInfo[WndNum].pMdiTextEdit->buffer;

		int i,iNum=1,x=0;
		for(i=0;;i++,x++){
			if(IsRightTurn(pBuf,i,x)){
				//E[Ő܂Ԃ
				iNum++;
				x=-1;
				i--;
				continue;
			}
			if(pBuf[i]=='\0') break;
			if(pBuf[i]=='\r'&&pBuf[i+1]=='\n'){
				iNum++;

				x=-1;
			}
		}
		char temporary[255];
		sprintf(temporary,"%d",iNum);

		extern SIZE sizeLineNumberFont;

		i=lstrlen(temporary);
		if(piCount) *piCount=i;

		return sizeLineNumberFont.cx*(i+2);
	}

	return CONTROL_TAB_SPACE_DEFAULT;
}

void ResetTextEditFont(HWND hwnd){
	if(hFont_TextEdit) DeleteObject(hFont_TextEdit);
	hFont_TextEdit=CreateFontIndirect(&pobj_nv->lf);

	//tHg
	LOGFONT lf;
	lf=pobj_nv->lf;
	lf.lfUnderline=TRUE;
	if(hFont_HyperLink_TextEdit) DeleteObject(hFont_HyperLink_TextEdit);
	hFont_HyperLink_TextEdit=CreateFontIndirect(&lf);

	HDC hdc;
	HFONT hOldFont;
	hdc=GetDC(hwnd);


	hOldFont=(HFONT)SelectObject(hdc,hFont_TextEdit);

	//Pʕ̕A
	SIZE size;
	GetTextExtentPoint32(hdc,"A",1,&size);
	font_width=size.cx;
	font_height=size.cy;

	SelectObject(hdc,hOldFont);


	//sԍ\ptHg̃TCY
	extern HFONT hFont_LineNumber;
	hOldFont=(HFONT)SelectObject(hdc,hFont_LineNumber);
	extern SIZE sizeLineNumberFont;
	GetTextExtentPoint32(hdc,"A",1,&sizeLineNumberFont);
	SelectObject(hdc, hOldFont);
	
	
	ReleaseDC(hwnd,hdc);
}
void SetTextEditWordColor(int WndNum){
	int i,i2,i3,IsStr;
	char str[255];
	char *pBuf;

	pBuf=MdiInfo[WndNum].pMdiTextEdit->buffer;

	if(MdiInfo[WndNum].DocType==WNDTYPE_TEXT){
		//ʏ̃eLXgׂ͂ĂftHgJ[iWōjɂ
		for(i=0;;i++){
			if(pBuf[i]=='\0') break;
			MdiInfo[WndNum].pMdiTextEdit->pColorRef[i]=tci.rgbDefault;
		}
		return;
	}


	for(i=0,IsStr=0;;i++){
		if(pBuf[i]=='\0') break;

		if((IsVariableTopChar(pBuf[i]))&&IsStr==0){
			for(i2=0;;i++,i2++){
				if((!IsVariableChar(pBuf[i]))||pBuf[i]=='.'){
					str[i2]=0;
					break;
				}
				str[i2]=pBuf[i];
			}

			BOOL bResult=0;
			if(MdiInfo[WndNum].DocType==WNDTYPE_BASIC){
				i3=IsBasicReservedWord(str);
				bResult=IsManagementCommand(i3);
			}
			else if(MdiInfo[WndNum].DocType==WNDTYPE_HTML){
				bResult=IsHtmlReservedWord(str);
			}

			if(bResult){
				for(i3=i-i2;i3<i;i3++){
					MdiInfo[WndNum].pMdiTextEdit->pColorRef[i3]=tci.rgbStatement;
				}
			}
			else{
				for(i3=i-i2;i3<i;i3++){
					MdiInfo[WndNum].pMdiTextEdit->pColorRef[i3]=tci.rgbDefault;
				}
			}
			i--;
			continue;
		}
		else{
			if(IsStr||pBuf[i]=='\"'&&IsStr==0){
				//J[i""ň͂܂͈́j
				MdiInfo[WndNum].pMdiTextEdit->pColorRef[i]=tci.rgbString;
			}
			else{
				//ʏJ[
				MdiInfo[WndNum].pMdiTextEdit->pColorRef[i]=tci.rgbDefault;
			}
		}

		if(pBuf[i]=='\"') IsStr^=1;

		if(pBuf[i]=='\r'&&pBuf[i+1]=='\n'){
			IsStr=0;
			continue;
		}
	}
}
void ResetScrollbar(int WndNum,int max_x,int max_y){
	RECT rect;

	//GfB^ʍ[̃Rg[^u
	int iControlTabSpace;
	iControlTabSpace=MdiInfo[WndNum].pMdiTextEdit->iWidth_ControlTabSpace;

	HWND hEdit;
	hEdit=GetWindow(MdiInfo[WndNum].hwnd,GW_CHILD);
	GetClientRect(hEdit,&rect);

	SCROLLINFO si;
	si.cbSize=sizeof(SCROLLINFO);
	si.fMask=SIF_PAGE|SIF_RANGE|SIF_DISABLENOSCROLL;

	//XN[o[̐ݒ
	GetScrollInfo(hEdit,SB_VERT,&si);
	si.nPage=(rect.bottom/font_height)-1;
	si.nMin=0;
	si.nMax=max_y+si.nPage/5*3;
	SetScrollInfo(hEdit,SB_VERT,&si,1);

	//XN[o[̐ݒ
	GetScrollInfo(hEdit,SB_HORZ,&si);
	si.nMin=0;
	si.nPage=(rect.right-iControlTabSpace)/font_width   -1;
	si.nMax=max_x+si.nPage/3;
	SetScrollInfo(hEdit,SB_HORZ,&si,1);

	//[[ĕ`
	InvalidateRect(MdiInfo[WndNum].pMdiTextEdit->pobj_Ruler->hRulerWnd,NULL,0);
	UpdateWindow(MdiInfo[WndNum].pMdiTextEdit->pobj_Ruler->hRulerWnd);
}

#define HIRA_START	(unsigned char)0x9F		//Ђ炪Ȃ2oCgڂ͈̔
#define HIRA_END	(unsigned char)0xF1
#define KATA_START	(unsigned char)0x40		//J^Ji2oCgڂ͈̔
#define KATA_END	(unsigned char)0x96
BOOL IsHiragana(char *pBuf){
	if((unsigned char)pBuf[0]==(unsigned char)0x82&&
		HIRA_START<=(unsigned char)pBuf[1]&&(unsigned char)pBuf[1]<=HIRA_END) return 1;
	return 0;
}
BOOL IsKatakana(char *pBuf){
	if(((unsigned char)pBuf[0]==(unsigned char)0x83&&
		KATA_START<=(unsigned char)pBuf[1]&&(unsigned char)pBuf[1]<=KATA_END)||
		(unsigned char)pBuf[0]==(unsigned char)0x81&&(unsigned char)pBuf[1]==(unsigned char)0x5B) return 1;
	return 0;
}
BOOL IsKanji(char *pBuf){
	if((unsigned char)0x88<=(unsigned char)pBuf[0] && (unsigned char)pBuf[0]<=(unsigned char)0xEA) return 1;
	return 0;
}
BOOL IsAlphabet(char c){
	if('a'<=c&&c<='z'||'A'<=c&&c<='Z') return 1;
	return 0;
}
BOOL IsReturnCode(char *pBuf){
	if(pBuf[0]=='\r'&&pBuf[1]=='\n') return 1;
	return 0;
}
void TextEdit_GetWordCaret(HWND hwnd,int WndNum,POINT *pPos,int *piStart,int *piEnd,BOOL bBeforeAfterFlag){
	int i,start,end;
	char *pBuf;

	pBuf=MdiInfo[WndNum].pMdiTextEdit->buffer;

	//_uNbNʒu擾iobt@CfbNXj
	i=GetBufferIndexFromCaretPos(pBuf,
		pPos->x,
		pPos->y);

	if(IsDBCSLeadByte(pBuf[i])){
		///////////////////
		// Sp̂Ƃ
		///////////////////

		if(IsHiragana(pBuf+i)){
			//Ђ炪

			//P̐擪ʒu擾
			start=i;
			for(;;start-=2){
				if(0>start){
					start+=2;
					break;
				}
				if(!IsHiragana(pBuf+start)){
					start+=2;
					break;
				}
			}

			//P̏I[ʒu擾
			end=i;
			for(;;end+=2){
				if(!IsHiragana(pBuf+end)) break;
			}
		}
		else if(IsKatakana(pBuf+i)){
			//J^Ji

			//P̐擪ʒu擾
			start=i;
			for(;;start-=2){
				if(0>start){
					start+=2;
					break;
				}
				if(!IsKatakana(pBuf+start)){
					start+=2;
					break;
				}
			}

			//P̏I[ʒu擾
			end=i;
			for(;;end+=2){
				if(!IsKatakana(pBuf+end)) break;
			}
		}
		else if(IsKanji(pBuf+i)){
			//

			//P̐擪ʒu擾
			start=i;
			for(;;start-=2){
				if(0>start){
					start+=2;
					break;
				}
				if(!IsKanji(pBuf+start)){
					start+=2;
					break;
				}
			}

			//P̏I[ʒu擾
			end=i;
			for(;;end+=2){
				if(!IsKanji(pBuf+end)) break;
			}
		}
		else{
			//Ƃ̑̑Sp
			start=i;
			end=start+2;
		}
	}
	else{
		///////////////////
		// p̂Ƃ
		///////////////////

		//P̐擪ʒu擾
		start=i;
		for(;0<=start;start--){
			if(!(IsVariableChar(pBuf[start])&&pBuf[start]!='.')){
				break;
			}
		}
		start++;

		//P̏I[ʒu擾
		end=i;
		for(;;end++){
			if(!(IsVariableChar(pBuf[end])&&pBuf[end]!='.')) break;
		}
	}

	*piStart=start;
	*piEnd=end;
}
void CancelBeforeAutoIndent(int WndNum){
	int i;

	i=GetBufferIndexFromCaretPos(
		MdiInfo[WndNum].pMdiTextEdit->buffer,
		MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x,
		MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y);
	GetCaretPosFromBufferIndex(
		MdiInfo[WndNum].pMdiTextEdit->buffer,
		i-lstrlen(MdiInfo[WndNum].IndentStr),
		&MdiInfo[WndNum].pMdiTextEdit->StartCaretPos);

	TextEdit_Replace(WndNum,"",1);

	HeapDefaultFree(MdiInfo[WndNum].IndentStr);
	MdiInfo[WndNum].IndentStr=0;
}
