#pragma once


namespace ActiveBasic{ namespace PM{


struct ImageReferenceType
{
	enum EnumType
	{
		File = 0,
		Resource,
	};
};

class ImageControlInfo
{
public:
	ImageReferenceType::EnumType type;
	std::string path;

	bool IsFile() const
	{
		return ( type == ImageReferenceType::File );
	}
	bool IsResource() const
	{
		return ( type == ImageReferenceType::Resource );
	}
};

class WindowInfoBase
{
public:
	const std::string &GetName() const
	{
		return name;
	}
	void SetName( const std::string &name )
	{
		this->name = name;
	}

	const std::string &GetCaption() const
	{
		return caption;
	}
	void SetCaption( const std::string &caption )
	{
		this->caption = caption;
	}

	DWORD GetStyle() const
	{
		return style;
	}
	void SetStyle( DWORD style )
	{
		this->style = style;
	}
	void AddStyle( DWORD style )
	{
		this->style |= style;
	}
	void AndStyle( DWORD style )
	{
		this->style &= style;
	}
	void DeleteStyle( DWORD style )
	{
		this->style &= ~style;
	}

	DWORD GetExStyle() const
	{
		return exstyle;
	}
	void SetExStyle( DWORD exstyle )
	{
		this->exstyle = exstyle;
	}
	void AddExStyle( DWORD exstyle )
	{
		this->exstyle |= exstyle;
	}

private:
	std::string name;
	std::string caption;
	DWORD style;
	DWORD exstyle;

public:
	POINT pos;
	SIZE size;
};

class ChildWindowInfo
	: public WindowInfoBase
{
public:
	int Control;

	ImageControlInfo image;
};
typedef std::vector<ChildWindowInfo *> ChildWindowInfos;
class WindowInfo
	: public WindowInfoBase
{
public:
	WindowInfo()
		: WindowInfoBase()
		, CallBackName( NULL )
	{
	}

	const std::string &GetClassName() const
	{
		return className;
	}
	void SetClassName( const std::string &className )
	{
		this->className = className;
	}

	const std::string &GetHandleName() const
	{
		return handleName;
	}
	void SetHandleName( const std::string &handleName )
	{
		this->handleName = handleName;
	}

	const std::string &GetMenuIdName() const
	{
		return menuIdName;
	}
	void SetMenuIdName( const std::string &menuIdName )
	{
		this->menuIdName = menuIdName;
	}
	bool HasMenu() const
	{
		return !menuIdName.empty();
	}

	int GetBackgroundColor() const
	{
		return backgroundColor;
	}
	void SetBackgroundColor( int backgroundColor )
	{
		this->backgroundColor = backgroundColor;
	}

	const std::string &GetIconResourceName() const
	{
		return iconResourceName;
	}
	void SetIconResourceName( const std::string &iconResourceName )
	{
		this->iconResourceName = iconResourceName;
	}
	bool HasIcon() const
	{
		return !iconResourceName.empty();
	}

	//EBhEf[^
	LOGFONT LogFont;
	char *CallBackName;
	long type;
	char *filepath;

	//qEBhEǗ
	ChildWindowInfos childWindowInfos;

	//c[
	HTREEITEM hTreeItem;

private:
	std::string className;
	std::string handleName;
	std::string menuIdName;
	int backgroundColor;
	std::string iconResourceName;
};

class WindowInfos
	: public std::vector<WindowInfo *>
{
public:
	WindowInfos()
	{
	}
	~WindowInfos()
	{
	}

	void Clear()
	{
		WindowInfos &windowInfos = *this;
		BOOST_FOREACH( WindowInfo *pWindowInfo, windowInfos )
		{
			delete pWindowInfo;
		}
		this->clear();
	}
	void Erase( int index )
	{
		WindowInfos::iterator it = this->begin();
		for( int i=0; i!=index ;i++, it++ )
		{
			delete *it;
		}
		this->erase( it );
	}
};


}}
