#include "stdafx.h"

#include "Common.h"

void Rad_UndoCommand(int WndNum){
	extern HINSTANCE hInst;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i;
	DWORD dw;
	char *temporary;
	RAD_UNDOSTATE *pUndoState;

	pUndoState=&MdiInfo[WndNum].MdiRadInfo->undo;
	i=pUndoState->NowPos-1;
	if(i==-1) i=MAX_UNDONUM-1;
	if(!pUndoState->Command[i]){
		MessageBeep(0);
		return;
	}
	pUndoState->NowPos=i;

	ActiveBasic::PM::WindowInfo *pWindowInfo = GetWndInfo(MdiInfo[WndNum].path);
	int WndInfoNum = GetWndInfoNum(MdiInfo[WndNum].path);
	switch(pUndoState->Command[pUndoState->NowPos]){
		case RAD_UNDO_INSERTITEM:
			DeleteDlgItem(WndNum,WndInfoNum,pUndoState->SelectItemNum[pUndoState->NowPos],0);
			MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]=-1;
			break;
		case RAD_UNDO_DELETEITEM:
			ActiveBasic::PM::ChildWindowInfo *pChildInfo;
			RECT rect;
			pChildInfo=(ActiveBasic::PM::ChildWindowInfo *)pUndoState->lpdwData[pUndoState->NowPos];
			rect.left=pChildInfo->pos.x;
			rect.top=pChildInfo->pos.y;
			rect.right=pChildInfo->pos.x+pChildInfo->size.cx;
			rect.bottom=pChildInfo->pos.y+pChildInfo->size.cy;
			InsertDlgItem(WndNum,WndInfoNum,pUndoState->SelectItemNum[pUndoState->NowPos],
				&pChildInfo->pos,&pChildInfo->size,
				pChildInfo->GetName().c_str(),pChildInfo->GetCaption().c_str(),pChildInfo->GetStyle(),pChildInfo->GetExStyle(),pChildInfo->Control,pChildInfo->image.type,pChildInfo->image.path.c_str(),0);
			break;
		case RAD_UNDO_NAME:
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				RAD_UNDOSTATE_NAME *names = (RAD_UNDOSTATE_NAME *)pUndoState->lpdwData[pUndoState->NowPos];

				std::string tempStr = pWindowInfo->GetName();
				pWindowInfo->SetName( names->name );
				names->name = tempStr;

				GlobalFree(MdiInfo[WndNum].path);
				MdiInfo[WndNum].path=(char *)GlobalAlloc(GMEM_FIXED,pWindowInfo->GetName().size()+1);
				lstrcpy(MdiInfo[WndNum].path,pWindowInfo->GetName().c_str());

				tempStr = pWindowInfo->GetHandleName();
				pWindowInfo->SetHandleName( names->HandleName );
				names->HandleName = tempStr;

				temporary=pWindowInfo->CallBackName;
				pWindowInfo->CallBackName=names->CallBackName;
				names->CallBackName=temporary;
			}
			else{
				std::string tempStr = pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->GetName();
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->SetName( *(std::string *)pUndoState->lpdwData[pUndoState->NowPos] );
				delete (std::string *)pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)( new std::string( tempStr ) );
			}
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			break;
		case RAD_UNDO_CAPTION:
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				std::string tempStr = pWindowInfo->GetCaption();
				pWindowInfo->SetCaption( *(std::string *)pUndoState->lpdwData[pUndoState->NowPos] );
				delete (std::string *)pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)( new std::string( tempStr ) );
			}
			else{
				std::string tempStr = pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->GetCaption();
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->SetCaption( *(std::string *)pUndoState->lpdwData[pUndoState->NowPos] );
				delete (std::string *)pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)( new std::string( tempStr ) );
			}
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_FONT:
			LOGFONT *pLogFont,lf;
			pLogFont=(LOGFONT *)pUndoState->lpdwData[pUndoState->NowPos];
			lf=pWindowInfo->LogFont;
			pWindowInfo->LogFont=*pLogFont;
			*pLogFont=lf;
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_BGCOLOR:
			{
				int tempBgColor = pWindowInfo->GetBackgroundColor();
				pWindowInfo->SetBackgroundColor( static_cast<int>(pUndoState->lpdwData[pUndoState->NowPos]) );
				pUndoState->lpdwData[pUndoState->NowPos] = static_cast<DWORD>(tempBgColor);

				if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
					ChangePropertyWindow(WndNum,WndInfoNum);
				DrawRadWindow(WndNum,pWindowInfo);
				break;
			}
		case RAD_UNDO_WINDOWMENU:
			{
				std::string tempMenuIdName = pWindowInfo->GetMenuIdName();
				pWindowInfo->SetMenuIdName( *(std::string *)pUndoState->lpdwData[pUndoState->NowPos] );
				delete (std::string *)pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos] = (DWORD)( new std::string( tempMenuIdName ) );
				if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				{
					ChangePropertyWindow(WndNum,WndInfoNum);
				}
				DrawRadWindow(WndNum,pWindowInfo);
				break;
			}
		case RAD_UNDO_ICONRES:
			{
				std::string tempStr = pWindowInfo->GetIconResourceName();
				pWindowInfo->SetIconResourceName( *(std::string *)pUndoState->lpdwData[pUndoState->NowPos] );
				delete (std::string *)pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)( new std::string( tempStr ) );
			}
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			break;
		case RAD_UNDO_STYLE:
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				dw=pWindowInfo->GetStyle();
				pWindowInfo->SetStyle( pUndoState->lpdwData[pUndoState->NowPos] );
				pUndoState->lpdwData[pUndoState->NowPos]=dw;
			}
			else{
				dw=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->GetStyle();
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->SetStyle( pUndoState->lpdwData[pUndoState->NowPos] );
				pUndoState->lpdwData[pUndoState->NowPos]=dw;
			}
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_EXSTYLE:
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				dw=pWindowInfo->GetExStyle();
				pWindowInfo->SetExStyle( pUndoState->lpdwData[pUndoState->NowPos] );
				pUndoState->lpdwData[pUndoState->NowPos]=dw;
			}
			else{
				dw=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->GetExStyle();
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->SetExStyle( pUndoState->lpdwData[pUndoState->NowPos] );
				pUndoState->lpdwData[pUndoState->NowPos]=dw;
			}
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_POSITION:
			POINTANDSIZE PointAndSize,*pReadPointAndSize;
			pReadPointAndSize=(POINTANDSIZE *)pUndoState->lpdwData[pUndoState->NowPos];
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				PointAndSize.size=pWindowInfo->size;
				pWindowInfo->size=pReadPointAndSize->size;
			}
			else{
				PointAndSize.pos=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->pos;
				PointAndSize.size=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->size;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->pos=pReadPointAndSize->pos;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->size=pReadPointAndSize->size;
			}
			*pReadPointAndSize=PointAndSize;
			DrawRadWindow(WndNum,pWindowInfo);
			SetStatusText(NULL);

			//T|[g_CAO̓eZbg
			SetSupportDlgData( WndNum, *pWindowInfo );
			break;
		case RAD_UNDO_IMAGESTATE:
			{
				ActiveBasic::PM::ImageControlInfo *pImageCtrlInfo = (ActiveBasic::PM::ImageControlInfo *)pUndoState->lpdwData[pUndoState->NowPos];

				ActiveBasic::PM::ImageReferenceType::EnumType tempType = pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->image.type;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->image.type = pImageCtrlInfo->type;
				pImageCtrlInfo->type = tempType;

				std::string tempPath = pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->image.path;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->image.path = pImageCtrlInfo->path;
				pImageCtrlInfo->path = tempPath;

				if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
					ChangePropertyWindow(WndNum,WndInfoNum);
				DrawRadWindow(WndNum,pWindowInfo);
			}
			break;
		case RAD_UNDO_TYPE:
			dw=pWindowInfo->type;
			pWindowInfo->type=pUndoState->lpdwData[pUndoState->NowPos];
			pUndoState->lpdwData[pUndoState->NowPos]=dw;
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			break;
	}

	projectInfo.ModifyOfMaterial=1;

	ResetState_UndoMenu();
}
void Rad_RedoCommand(int WndNum){
	extern HINSTANCE hInst;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	DWORD dw;
	char *temporary;
	RAD_UNDOSTATE *pUndoState;
	ActiveBasic::PM::ChildWindowInfo *pChildInfo;
	RECT rect;

	pUndoState=&MdiInfo[WndNum].MdiRadInfo->undo;
	if(!pUndoState->Command[pUndoState->NowPos]){
		MessageBeep(0);
		return;
	}

	ActiveBasic::PM::WindowInfo *pWindowInfo = GetWndInfo(MdiInfo[WndNum].path);
	int WndInfoNum = GetWndInfoNum(MdiInfo[WndNum].path);
	switch(pUndoState->Command[pUndoState->NowPos]){
		case RAD_UNDO_INSERTITEM:
			pChildInfo=(ActiveBasic::PM::ChildWindowInfo *)pUndoState->lpdwData[pUndoState->NowPos];
			rect.left=pChildInfo->pos.x;
			rect.top=pChildInfo->pos.y;
			rect.right=pChildInfo->pos.x+pChildInfo->size.cx;
			rect.bottom=pChildInfo->pos.y+pChildInfo->size.cy;
			InsertDlgItem(WndNum,WndInfoNum,pUndoState->SelectItemNum[pUndoState->NowPos],
				&pChildInfo->pos,&pChildInfo->size,
				pChildInfo->GetName().c_str(),pChildInfo->GetCaption().c_str(),pChildInfo->GetStyle(),pChildInfo->GetExStyle(),pChildInfo->Control,pChildInfo->image.type,pChildInfo->image.path.c_str(),0);
			break;
		case RAD_UNDO_DELETEITEM:
			DeleteDlgItem(WndNum,WndInfoNum,pUndoState->SelectItemNum[pUndoState->NowPos],0);
			MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]=-1;
			break;
		case RAD_UNDO_NAME:
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				RAD_UNDOSTATE_NAME *names = (RAD_UNDOSTATE_NAME *)pUndoState->lpdwData[pUndoState->NowPos];

				std::string tempStr = pWindowInfo->GetName();
				pWindowInfo->SetName( names->name );
				names->name = tempStr;

				GlobalFree(MdiInfo[WndNum].path);
				MdiInfo[WndNum].path=(char *)GlobalAlloc(GMEM_FIXED,pWindowInfo->GetName().size()+1);
				lstrcpy(MdiInfo[WndNum].path,pWindowInfo->GetName().c_str());

				tempStr = pWindowInfo->GetHandleName();
				pWindowInfo->SetHandleName( names->HandleName );
				names->HandleName = tempStr;

				temporary=pWindowInfo->CallBackName;
				pWindowInfo->CallBackName=names->CallBackName;
				names->CallBackName=temporary;
			}
			else{
				std::string tempStr = pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->GetName();
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->SetName( *(std::string *)pUndoState->lpdwData[pUndoState->NowPos] );
				delete (std::string *)pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)( new std::string( tempStr ) );
			}
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			break;
		case RAD_UNDO_CAPTION:
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				std::string tempStr = pWindowInfo->GetCaption();
				pWindowInfo->SetCaption( *(std::string *)pUndoState->lpdwData[pUndoState->NowPos] );
				delete (std::string *)pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)( new std::string( tempStr ) );
			}
			else{
				std::string tempStr = pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->GetCaption();
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->SetCaption( *(std::string *)pUndoState->lpdwData[pUndoState->NowPos] );
				delete (std::string *)pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)( new std::string( tempStr ) );
			}
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_FONT:
			LOGFONT *pLogFont,lf;
			pLogFont=(LOGFONT *)pUndoState->lpdwData[pUndoState->NowPos];
			lf=pWindowInfo->LogFont;
			pWindowInfo->LogFont=*pLogFont;
			*pLogFont=lf;
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_BGCOLOR:
			{
				int tempBgColor = pWindowInfo->GetBackgroundColor();
				pWindowInfo->SetBackgroundColor( static_cast<int>(pUndoState->lpdwData[pUndoState->NowPos]) );
				pUndoState->lpdwData[pUndoState->NowPos] = static_cast<DWORD>(tempBgColor);
			}
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_WINDOWMENU:
			{
				std::string tempMenuIdName = pWindowInfo->GetMenuIdName();
				pWindowInfo->SetMenuIdName( *(std::string *)pUndoState->lpdwData[pUndoState->NowPos] );
				delete (std::string *)pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos] = (DWORD)( new std::string( tempMenuIdName ) );
				if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				{
					ChangePropertyWindow(WndNum,WndInfoNum);
				}
				DrawRadWindow(WndNum,pWindowInfo);
				break;
			}
		case RAD_UNDO_ICONRES:
			{
				std::string tempStr = pWindowInfo->GetIconResourceName();
				pWindowInfo->SetIconResourceName( *(std::string *)pUndoState->lpdwData[pUndoState->NowPos] );
				delete (std::string *)pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)( new std::string( tempStr ) );
			}
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			break;
		case RAD_UNDO_STYLE:
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				dw=pWindowInfo->GetStyle();
				pWindowInfo->SetStyle( pUndoState->lpdwData[pUndoState->NowPos] );
				pUndoState->lpdwData[pUndoState->NowPos]=dw;
			}
			else{
				dw=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->GetStyle();
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->SetStyle( pUndoState->lpdwData[pUndoState->NowPos] );
				pUndoState->lpdwData[pUndoState->NowPos]=dw;
			}
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_EXSTYLE:
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				dw=pWindowInfo->GetExStyle();
				pWindowInfo->SetExStyle( pUndoState->lpdwData[pUndoState->NowPos] );
				pUndoState->lpdwData[pUndoState->NowPos]=dw;
			}
			else{
				dw=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->GetExStyle();
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->SetExStyle( pUndoState->lpdwData[pUndoState->NowPos] );
				pUndoState->lpdwData[pUndoState->NowPos]=dw;
			}
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_POSITION:
			POINTANDSIZE PointAndSize,*pReadPointAndSize;
			pReadPointAndSize=(POINTANDSIZE *)pUndoState->lpdwData[pUndoState->NowPos];
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				PointAndSize.size=pWindowInfo->size;
				pWindowInfo->size=pReadPointAndSize->size;
			}
			else{
				PointAndSize.pos=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->pos;
				PointAndSize.size=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->size;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->pos=pReadPointAndSize->pos;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->size=pReadPointAndSize->size;
			}
			*pReadPointAndSize=PointAndSize;
			DrawRadWindow(WndNum,pWindowInfo);
			SetStatusText(NULL);

			//T|[g_CAO̓eZbg
			SetSupportDlgData( WndNum, *pWindowInfo );
			break;
		case RAD_UNDO_IMAGESTATE:
			{
				ActiveBasic::PM::ImageControlInfo *pImageCtrlInfo = (ActiveBasic::PM::ImageControlInfo *)pUndoState->lpdwData[pUndoState->NowPos];

				ActiveBasic::PM::ImageReferenceType::EnumType tempType = pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->image.type;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->image.type = pImageCtrlInfo->type;
				pImageCtrlInfo->type = tempType;

				std::string tempPath = pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->image.path;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->image.path = pImageCtrlInfo->path;
				pImageCtrlInfo->path = tempPath;

				if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
					ChangePropertyWindow(WndNum,WndInfoNum);
				DrawRadWindow(WndNum,pWindowInfo);
				break;
			}
		case RAD_UNDO_TYPE:
			dw=pWindowInfo->type;
			pWindowInfo->type=pUndoState->lpdwData[pUndoState->NowPos];
			pUndoState->lpdwData[pUndoState->NowPos]=dw;
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			break;
	}

	pUndoState->NowPos++;
	if(pUndoState->NowPos==MAX_UNDONUM) pUndoState->NowPos=0;

	projectInfo.ModifyOfMaterial=1;

	ResetState_UndoMenu();
}
void Rad_DeleteUndoData(int WndNum,int pos){
	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	RAD_UNDOSTATE *pUndoState;

	pUndoState=&MdiInfo[WndNum].MdiRadInfo->undo;
	switch(pUndoState->Command[pos]){
		case RAD_UNDO_INSERTITEM:
		case RAD_UNDO_DELETEITEM:
			ActiveBasic::PM::ChildWindowInfo *pChildInfo;
			pChildInfo=(ActiveBasic::PM::ChildWindowInfo *)pUndoState->lpdwData[pos];
			delete pChildInfo;
			break;
		case RAD_UNDO_NAME:
			if(pUndoState->SelectItemNum[pos]==SELECT_WINDOW){
				RAD_UNDOSTATE_NAME *names = (RAD_UNDOSTATE_NAME *)pUndoState->lpdwData[pos];
				HeapDefaultFree(names->CallBackName);
				delete names;
			}
			else
			{
				std::string *pTempStr = (std::string *)pUndoState->lpdwData[pos];
				delete pTempStr;
			}
			break;
		case RAD_UNDO_CAPTION:
			{
				std::string *pTempStr = (std::string *)pUndoState->lpdwData[pos];
				delete pTempStr;
			}
			break;
		case RAD_UNDO_FONT:
			HeapDefaultFree((void *)pUndoState->lpdwData[pos]);
			break;
		case RAD_UNDO_WINDOWMENU:
			{
				std::string *pTempMenuId = (std::string *)pUndoState->lpdwData[pos];
				delete pTempMenuId;
			}
			break;
		case RAD_UNDO_ICONRES:
			{
				std::string *pTempStr = (std::string *)pUndoState->lpdwData[pos];
				delete pTempStr;
			}
			break;
		case RAD_UNDO_POSITION:
			HeapDefaultFree((void *)pUndoState->lpdwData[pos]);
			break;
		case RAD_UNDO_IMAGESTATE:
			{
				ActiveBasic::PM::ImageControlInfo *pImageCtrlInfo = (ActiveBasic::PM::ImageControlInfo *)pUndoState->lpdwData[pUndoState->NowPos];

				delete pImageCtrlInfo;

				break;
			}
	}
	pUndoState->Command[pos]=0;
}
void Rad_NoticeChanging(int WndNum,int Command,int SelectItemNum,DWORD dwData){
	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i;
	RAD_UNDOSTATE *pUndoState;

	pUndoState=&MdiInfo[WndNum].MdiRadInfo->undo;

	//Redoꂽꍇ̕svȃf[^폜
	for(i=pUndoState->NowPos;;i++){
		if(i==MAX_UNDONUM) i=0;
		if(pUndoState->Command[i]==0) break;
		Rad_DeleteUndoData(WndNum,i);
	}

	pUndoState->Command[pUndoState->NowPos]=Command;
	pUndoState->SelectItemNum[pUndoState->NowPos]=SelectItemNum;
	switch(Command){
		case RAD_UNDO_INSERTITEM:
		case RAD_UNDO_DELETEITEM:
			ActiveBasic::PM::ChildWindowInfo *pChildInfo,*pSaveChildInfo;
			pChildInfo=(ActiveBasic::PM::ChildWindowInfo *)dwData;
			pSaveChildInfo = new ActiveBasic::PM::ChildWindowInfo();
			pSaveChildInfo->SetName( pChildInfo->GetName() );
			pSaveChildInfo->pos=pChildInfo->pos;
			pSaveChildInfo->size=pChildInfo->size;
			pSaveChildInfo->SetCaption( pChildInfo->GetCaption() );
			pSaveChildInfo->SetStyle( pChildInfo->GetStyle() );
			pSaveChildInfo->SetExStyle( pChildInfo->GetExStyle() );
			pSaveChildInfo->Control=pChildInfo->Control;
			if(pChildInfo->Control==CT_IMAGEBOX){
				//C[W {bNX̏ꍇ
				pSaveChildInfo->image = pChildInfo->image;
			}
			pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)pSaveChildInfo;
			break;
		case RAD_UNDO_NAME:
			if(SelectItemNum==SELECT_WINDOW){
				RAD_UNDOSTATE_NAME *names = (RAD_UNDOSTATE_NAME *)dwData;
				RAD_UNDOSTATE_NAME *SaveNames = new RAD_UNDOSTATE_NAME();
				SaveNames->name = names->name;
				SaveNames->HandleName = names->HandleName;
				SaveNames->CallBackName=(char *)HeapAlloc(hHeap,0,lstrlen(names->CallBackName)+1);
				lstrcpy(SaveNames->CallBackName,names->CallBackName);
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)SaveNames;
			}
			else{
				std::string *pTempStr = new std::string( *(std::string *)dwData );
				pUndoState->lpdwData[pUndoState->NowPos] = (DWORD)pTempStr;
			}
			break;
		case RAD_UNDO_CAPTION:
			{
				std::string *pTempStr = new std::string( *(std::string *)dwData );
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)pTempStr;
			}
			break;
		case RAD_UNDO_FONT:
			LOGFONT *pLogFont,*pSaveLogFont;
			pLogFont=(LOGFONT *)dwData;
			pSaveLogFont=(LOGFONT *)HeapAlloc(hHeap,0,sizeof(LOGFONT));
			*pSaveLogFont=*pLogFont;
			pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)pSaveLogFont;
			break;
		case RAD_UNDO_BGCOLOR:
			pUndoState->lpdwData[pUndoState->NowPos]=dwData;
			break;
		case RAD_UNDO_WINDOWMENU:
			{
				std::string *pTempStr = new std::string( *(std::string *)dwData );
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)pTempStr;
			}
			break;
		case RAD_UNDO_ICONRES:
			{
				std::string *pTempStr = new std::string( *(std::string *)dwData );
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)pTempStr;
			}
			break;
		case RAD_UNDO_STYLE:
		case RAD_UNDO_EXSTYLE:
			pUndoState->lpdwData[pUndoState->NowPos]=dwData;
			break;
		case RAD_UNDO_POSITION:
			POINTANDSIZE *pPointAndSize,*pSavePointAndSize;
			pPointAndSize=(POINTANDSIZE *)dwData;
			pSavePointAndSize=(POINTANDSIZE *)HeapAlloc(hHeap,0,sizeof(POINTANDSIZE));
			pSavePointAndSize->pos=pPointAndSize->pos;
			pSavePointAndSize->size=pPointAndSize->size;
			pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)pSavePointAndSize;
			break;
		case RAD_UNDO_IMAGESTATE:
			{
				ActiveBasic::PM::ImageControlInfo *pImageCtrlInfo = (ActiveBasic::PM::ImageControlInfo *)dwData;
				ActiveBasic::PM::ImageControlInfo *pSaveImageCtrlInfo = new ActiveBasic::PM::ImageControlInfo( *pImageCtrlInfo );
				pUndoState->lpdwData[pUndoState->NowPos] = (DWORD)( new ActiveBasic::PM::ImageControlInfo( *pImageCtrlInfo ) );
				break;
			}
		case RAD_UNDO_TYPE:
			pUndoState->lpdwData[pUndoState->NowPos]=dwData;
			break;
	}

	pUndoState->NowPos++;
	if(pUndoState->NowPos==MAX_UNDONUM) pUndoState->NowPos=0;
	if(pUndoState->Command[pUndoState->NowPos]){
		//ԌÂ؂̂Ă
		Rad_DeleteUndoData(WndNum,pUndoState->NowPos);
	}

	projectInfo.ModifyOfMaterial=1;

	ResetState_UndoMenu();
}
