#include "stdafx.h"

#include <Compiler.h>

#include "common.h"
#include <ver.h>

void StepCompileProgress(void){
	extern HWND hMainDlg;
	PostMessage(GetDlgItem(hMainDlg,IDC_PROGRESS),PBM_STEPIT,0,0);
}

void MakeMiddleCode( char *buffer )
{
	// sR[hCRLFLFɂ
	ChangeReturnCode( buffer );

	// Rg
	DeleteComment( buffer );

	//GXP[vV[PXݒ
	SetEscapeSequenceFormat( buffer );

	//R}hΉ
	ChangeCommandToCode( buffer );
}

void AddSourceCode(const char *buffer){
	char *temp;
	temp=(char *)HeapAlloc(hHeap,0,lstrlen(buffer)+8192);
	lstrcpy(temp,buffer);

	MakeMiddleCode( temp );

	//Ōɓ\t
	compiler.GetObjectModule().GetCurrentSource().Addition( temp );

	HeapDefaultFree(temp);
}

void Build()
{
	extern HANDLE hHeap;
	extern char *basbuf;
	extern BOOL bStopCompile;
	extern HWND hMainDlg;
	char temp2[MAX_PATH];

	// JnL^
	DWORD beforeTickCount = GetTickCount();

	//vOXo[̐ݒ
	PostMessage(GetDlgItem(hMainDlg,IDC_PROGRESS),PBM_SETRANGE,0,MAKELPARAM(0,6));
	PostMessage(GetDlgItem(hMainDlg,IDC_PROGRESS),PBM_SETSTEP,1,0);

	//"f"
	SetDlgItemText(hMainDlg,IDOK,STRING_STOP);

	//ftO
	bStopCompile=0;

	//TuVXẽ^Cv
	extern unsigned short TypeOfSubSystem;
	TypeOfSubSystem=IMAGE_SUBSYSTEM_WINDOWS_GUI;

	//vOt@Cǂݍ
	compiler.GetObjectModule().SetCurrentSourceIndex( (int)compiler.GetObjectModule().GetSources().size() );
	compiler.GetObjectModule().GetSources().push_back( BasicSource() );
	bool result = compiler.GetObjectModule().GetCurrentSource().ReadFile(
		program.GetSourceFilePath(),
		compiler.IsDebug(),
		compiler.IsDll(),
		compiler.IsUnicode(),
		MAJOR_VER,
		program.GetSourceFilePath(),
		program.GetIncludeDir()
	);
	if( !result ){
		compiler.errorMessenger.Output(201,program.GetSourceFilePath(),-1);
		goto EndCompile;
	}
	if( !compiler.GetObjectModule().GetCurrentSource().cannotIncludePath.empty() )
	{
		compiler.errorMessenger.Output(
			35,
			compiler.GetObjectModule().GetCurrentSource().cannotIncludePath,
			compiler.GetObjectModule().GetCurrentSource().cannotIncludeSourcePos
		);
		goto EndCompile;
	}

	//C[Wx[X̐ݒ
	extern DWORD ImageBase;
	if(compiler.IsDll()) ImageBase=0x10000000;
	else ImageBase=0x00400000;

	if( compiler.errorMessenger.HasError() || bStopCompile ) goto EndCompile;


	//////////////////////////
	// ԃR[h̐Jn

	//"œK..."
	compiler.messenger.Output( STRING_COMPILE_OPTIMIZING );

	//JbR𑊌݃`FbNi_uNH[g`FbN`FbN܂ށj
	CheckParenthesis(basbuf);

	if( compiler.errorMessenger.HasError() || bStopCompile )
	{
		goto EndCompile;
	}

	//RpC_CAÕvOXo[グ
	StepCompileProgress();

	//fBNeBu
	DirectiveCheck();

	//Nextߌ𐳋K\ɕϊ
	//NextCommandFormat(basbuf);

	//GXP[vV[PXݒ
	SetEscapeSequenceFormat(basbuf);

	//DefߌFunctionߌɕϊ
	DefCommandFormat(basbuf);

	//ׂĂIfߌubN`ɕϊ
	IfCommandFormat(basbuf);

	//΂ɂȂ閽ߌ𑊌݃`FbN
	//CheckPareCommand();

	if( compiler.errorMessenger.HasError() || bStopCompile )
	{
		goto EndCompile;
	}

	//RpC_CAÕvOXo[グ
	StepCompileProgress();

	// dG[NA
	compiler.errorMessenger.ClearSynonymKeyWords();

	ChangeCommandToCode(basbuf);
	compiler.GetObjectModule().GetSources()[0]._ResetLength();

	if( compiler.errorMessenger.HasError() || bStopCompile )
	{
		//萔Ɋւ
		goto EndCompile;
	}

	StepCompileProgress();


	/////////////////////////////////////////////////////////////////
	// ÓINCu[h
	/////////////////////////////////////////////////////////////////
	{
		bool isSuccessfulLoadStaticLinkLibrary = true;
		if( !compiler.IsCore() )
		{
			// RAW[[h
			extern BOOL bDebugCompile;

			const char *coreFileName = "core.lib";
			if( compiler.IsDebug() )
			{
				coreFileName = "cored.lib";
			}

			char coreFilePath[MAX_PATH];
#ifdef _AMD64_
			sprintf( coreFilePath, "..\\lib\\x64\\%s", coreFileName );
#else
			sprintf( coreFilePath, "..\\lib\\%s", coreFileName );
#endif
			GetFullPath( coreFilePath, program.GetIncludeDir() );

			Jenga::Common::Path path( coreFilePath );
			if( path.IsExistFile() )
			{
				compiler.staticLibraries.push_back( new ObjectModule() );
				if( compiler.staticLibraries.back()->Read( coreFilePath ) )
				{
					compiler.messenger.Output( ((std::string)"\"" + path.GetFullPath() + "\" ǂݍ݂܂B").c_str() );
				}
				else
				{
					compiler.errorMessenger.Output( 203, path.GetFullPath() );
					isSuccessfulLoadStaticLinkLibrary = false;
				}
			}
			else
			{
				compiler.errorMessenger.Output( 202, path.GetFullPath() );
				isSuccessfulLoadStaticLinkLibrary = false;
			}
		}

		BOOST_FOREACH( const std::string &filePath, compiler.staticLibraryFilePaths )
		{
			Jenga::Common::Path path( filePath );
			if( path.IsExistFile() )
			{
				compiler.staticLibraries.push_back( new ObjectModule() );
				if( compiler.staticLibraries.back()->Read( filePath ) )
				{
					compiler.messenger.Output( ((std::string)"\"" + path.GetFullPath() + "\" ǂݍ݂܂B").c_str() );
				}
				else
				{
					compiler.errorMessenger.Output( 203, path.GetFullPath() );
					isSuccessfulLoadStaticLinkLibrary = false;
				}
			}
			else
			{
				compiler.errorMessenger.Output( 202, path.GetFullPath() );
				isSuccessfulLoadStaticLinkLibrary = false;
			}
		}

		if( !isSuccessfulLoadStaticLinkLibrary )
		{
			// ÓINCũ[hɎsƂ
			goto EndCompile;
		}
	}


	///////////////////////
	// RpCJn

	MakeExe();

	//RpC_CAÕvOXo[グ
	StepCompileProgress();


	//////////////////////////
	// I
EndCompile:
	if(bStopCompile){
		PostMessage(GetDlgItem(hMainDlg,IDC_PROGRESS),PBM_SETPOS,0,0);

		//"RpC̓[U[ɂ蒆f܂B"
		compiler.messenger.Output(STRING_COMPILE_STOP);
	}
	else{
		extern int WarningNum;
		if( !compiler.errorMessenger.HasError() )
		{
			//"RpC͐Ɋ܂iG[:%dAx:%dj"
			sprintf(temp2,
				STRING_COMPILE_SUCCESS,
				compiler.errorMessenger.GetErrorCount(),
				compiler.errorMessenger.GetWarningCount(),
				((double)(GetTickCount() - beforeTickCount))/1000
			);
		}
		else
		{
			//"RpC͒f܂iG[:%dAx:%dj"
			sprintf(temp2,STRING_COMPILE_ERROR,
				compiler.errorMessenger.GetErrorCount(),
				compiler.errorMessenger.GetWarningCount() );
		}

		compiler.messenger.Output( "" );
		compiler.messenger.Output( "-----------------------------------------------------" );
		compiler.messenger.Output( temp2 );
	}

	//""
	SetDlgItemText(hMainDlg,IDOK,STRING_CLOSE);

	// G[Ȃꍇ̓rhƂ
	if( !compiler.errorMessenger.HasError() )
	{
		// rh
		compiler.BuildSuccessful();
	}

#ifdef _DEBUG
	// fobO[ĥƂ̓_CAOBĂ
	ShowWindow(hMainDlg,SW_SHOW);
#endif
}
void MainThread(void *dummy)
{
	if( program.IsDebugRun() )
	{
		if( compiler.IsDebug() )
		{
			//fobORpC
			Build();
		}

		//fobOs
		if( !compiler.errorMessenger.HasError() )
		{
			DebugProgram();
		}
	}
	else{
		//[XRpC
		Build();
	}
}
