#include "stdafx.h"

#include "common.h"

#if defined(JPN)
//{
#include "pj_msg_jpn.h"
#else
//p
#include "pj_msg_eng.h"
#endif

void GetResourceData(void){
	extern HANDLE hHeap;
	int i2,i3;
	char *buffer,temporary[MAX_PATH],temp2[MAX_PATH],temp3[MAX_PATH];
	HANDLE hFile;

	lstrcpy(temporary,projectInfo.ResourceFileName);
	lstrcpy( temporary, projectInfo.GetWorkDir().GetFullPath( temporary ).c_str() );

	hFile=CreateFile(temporary,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile==INVALID_HANDLE_VALUE) return;
	i2=GetFileSize(hFile,NULL);
	buffer=(char *)HeapAlloc(hHeap,0,i2+i2+1);
	ReadFile(hFile,buffer,i2,(DWORD *)&i3,NULL);
	CloseHandle(hFile);
	buffer[i3]=0;
	ChangeReturnCode(buffer);

	i2=0;
	while(1){
		//ID
		while(buffer[i2]==' '||buffer[i2]=='\t') i2++;
		for(i3=0;;i2++,i3++){
			if(!IsVariableChar(buffer[i2])){
				temp3[i3]=0;
				break;
			}
			temp3[i3]=buffer[i2];
		}
		if(temp3[0]=='\0') break;

		//Type
		while(buffer[i2]==' '||buffer[i2]=='\t') i2++;
		for(i3=0;;i2++,i3++){
			if(!IsVariableChar(buffer[i2])){
				temporary[i3]=0;
				break;
			}
			temporary[i3]=buffer[i2];
		}

		//FileName
		while(buffer[i2]==' '||buffer[i2]=='\t') i2++;
		if(buffer[i2]!='\"'){
			//G[
			return;
		}
		for(i2++,i3=0;;i2++,i3++){
			if(buffer[i2]=='\"'){
				temp2[i3]=0;
				break;
			}
			temp2[i3]=buffer[i2];
		}

		if(lstrcmpi(temporary,"CURSOR")==0){
			projectInfo.res.pCursorResInfo=(RESITEMINFO *)HeapReAlloc(hHeap,0,projectInfo.res.pCursorResInfo,(projectInfo.res.NumberOfCursorRes+1)*sizeof(RESITEMINFO));

			projectInfo.res.pCursorResInfo[projectInfo.res.NumberOfCursorRes].IdName=
				(char *)HeapAlloc(hHeap,0,lstrlen(temp3)+1);
			lstrcpy(projectInfo.res.pCursorResInfo[projectInfo.res.NumberOfCursorRes].IdName,temp3);

			projectInfo.res.pCursorResInfo[projectInfo.res.NumberOfCursorRes].path=
				(char *)HeapAlloc(hHeap,0,lstrlen(temp2)+1);
			lstrcpy(projectInfo.res.pCursorResInfo[projectInfo.res.NumberOfCursorRes].path,temp2);

			projectInfo.res.NumberOfCursorRes++;
		}
		else if(lstrcmpi(temporary,"BITMAP")==0){
			projectInfo.res.pBitmapResInfo=(RESITEMINFO *)HeapReAlloc(hHeap,0,projectInfo.res.pBitmapResInfo,(projectInfo.res.NumberOfBitmapRes+1)*sizeof(RESITEMINFO));

			projectInfo.res.pBitmapResInfo[projectInfo.res.NumberOfBitmapRes].IdName=
				(char *)HeapAlloc(hHeap,0,lstrlen(temp3)+1);
			lstrcpy(projectInfo.res.pBitmapResInfo[projectInfo.res.NumberOfBitmapRes].IdName,temp3);

			projectInfo.res.pBitmapResInfo[projectInfo.res.NumberOfBitmapRes].path=
				(char *)HeapAlloc(hHeap,0,lstrlen(temp2)+1);
			lstrcpy(projectInfo.res.pBitmapResInfo[projectInfo.res.NumberOfBitmapRes].path,temp2);

			projectInfo.res.NumberOfBitmapRes++;
		}
		else if(lstrcmpi(temporary,"ICON")==0){
			projectInfo.res.pIconResInfo=(RESITEMINFO *)HeapReAlloc(hHeap,0,projectInfo.res.pIconResInfo,(projectInfo.res.NumberOfIconRes+1)*sizeof(RESITEMINFO));

			projectInfo.res.pIconResInfo[projectInfo.res.NumberOfIconRes].IdName=
				(char *)HeapAlloc(hHeap,0,lstrlen(temp3)+1);
			lstrcpy(projectInfo.res.pIconResInfo[projectInfo.res.NumberOfIconRes].IdName,temp3);

			projectInfo.res.pIconResInfo[projectInfo.res.NumberOfIconRes].path=
				(char *)HeapAlloc(hHeap,0,lstrlen(temp2)+1);
			lstrcpy(projectInfo.res.pIconResInfo[projectInfo.res.NumberOfIconRes].path,temp2);

			projectInfo.res.NumberOfIconRes++;
		}
		else if(lstrcmpi(temporary,"RT_MANIFEST")==0){
			//
		}
		else{
			//G[
			return;
		}

		i2++;
		while(buffer[i2]==' '||buffer[i2]=='\t') i2++;
		if(buffer[i2]=='\0') break;
		else if(buffer[i2]!='\n'){
			//G[
			return;
		}
		i2++;
	}

	//\[X̏ꍇ
	if(projectInfo.res.NumberOfCursorRes==0&&
		projectInfo.res.NumberOfBitmapRes==0&&
		projectInfo.res.NumberOfIconRes==0)
		projectInfo.ResourceFileName[0]=0;

	HeapDefaultFree(buffer);
}

void Project_CursorResInsert(void){
	extern HANDLE hHeap;
	extern LPSTR CursorFileFilter;
	int i2,i3;
	char temporary[MAX_PATH];

	if(!projectInfo.ResourceFileName[0])
		sprintf(projectInfo.ResourceFileName,"%s.rc",projectInfo.GetName().c_str());

	//"J[\ t@Cw肵Ă"
	if(!GetFilePathDialog(hOwner,temporary,CursorFileFilter,STRING_FILEOPENTITLE_CURSOR,TRUE)) return;

	lstrcpy( temporary, projectInfo.GetWorkDir().GetRelationalPath( temporary ).c_str() );

	projectInfo.res.pCursorResInfo=(RESITEMINFO *)HeapReAlloc(hHeap,0,projectInfo.res.pCursorResInfo,(projectInfo.res.NumberOfCursorRes+1)*sizeof(RESITEMINFO));

	projectInfo.res.pCursorResInfo[projectInfo.res.NumberOfCursorRes].path=
		(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
	lstrcpy(projectInfo.res.pCursorResInfo[projectInfo.res.NumberOfCursorRes].path,temporary);

	for(i3=1;;i3++){
		sprintf(temporary,"IDC_CURSOR%d",i3);
		for(i2=0;i2<projectInfo.res.NumberOfCursorRes;i2++){
			if(lstrcmp(temporary,projectInfo.res.pCursorResInfo[i2].IdName)==0) break;
		}
		if(i2==projectInfo.res.NumberOfCursorRes) break;
	}

	projectInfo.res.pCursorResInfo[projectInfo.res.NumberOfCursorRes].IdName=
		(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
	lstrcpy(projectInfo.res.pCursorResInfo[projectInfo.res.NumberOfCursorRes].IdName,temporary);

	//c[r[ɒǉ
	extern HWND hMaterialTreeView;
	TV_INSERTSTRUCT tv;
	tv.hInsertAfter=TVI_SORT;
	tv.item.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
	tv.item.iImage=6;
	tv.item.iSelectedImage=6;
	tv.hParent=projectInfo.res.hCursorTreeItem;
	tv.item.pszText=temporary;

	projectInfo.res.pCursorResInfo[projectInfo.res.NumberOfCursorRes].hTreeItem=
		TreeView_InsertItem(hMaterialTreeView,&tv);

	TreeView_SelectItem(hMaterialTreeView,projectInfo.res.pCursorResInfo[projectInfo.res.NumberOfCursorRes].hTreeItem);

	projectInfo.res.NumberOfCursorRes++;
	projectInfo.ModifuOfResource=1;
}
void Project_Cursor_Delete(int CursorInfoNum){
	int i;

	//c[r[폜
	extern HWND hMaterialTreeView;
	TreeView_DeleteItem(hMaterialTreeView,projectInfo.res.pCursorResInfo[CursorInfoNum].hTreeItem);

	//projectInfo.pCursorInfo\̂폜
	HeapDefaultFree(projectInfo.res.pCursorResInfo[CursorInfoNum].IdName);
	HeapDefaultFree(projectInfo.res.pCursorResInfo[CursorInfoNum].path);
	projectInfo.res.NumberOfCursorRes--;
	for(i=CursorInfoNum;i<projectInfo.res.NumberOfCursorRes;i++)
		projectInfo.res.pCursorResInfo[i]=projectInfo.res.pCursorResInfo[i+1];

	projectInfo.ModifuOfResource=1;
}
void Project_Cursor_RenameID(int CursorInfoNum){
	extern HANDLE hHeap;
	extern char NewIdName[MAX_PATH];
	extern HWND hMaterialTreeView;
	int i2;
	char temporary[MAX_PATH];
	TVITEM tvItem;

	if(!DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_INPUTID),hOwner,(DLGPROC)DlgProject_ResourceID_Input,(long)projectInfo.res.pCursorResInfo[CursorInfoNum].IdName)) return;

	//d`FbN
	for(i2=0;i2<projectInfo.res.NumberOfCursorRes;i2++){
		if(i2==CursorInfoNum) continue;
		if(lstrcmp(NewIdName,projectInfo.res.pCursorResInfo[i2].IdName)==0){
			//"ID \"%s\" ͊ɃvWFNgɑ݂܂B"
			sprintf(temporary,STRING_DUPLICATIONERROR_ID_IN_PROJECT,NewIdName);
			MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
			return;
		}
	}

	HeapDefaultFree(projectInfo.res.pCursorResInfo[CursorInfoNum].IdName);
	projectInfo.res.pCursorResInfo[CursorInfoNum].IdName=(char *)HeapAlloc(hHeap,0,lstrlen(NewIdName)+1);
	lstrcpy(projectInfo.res.pCursorResInfo[CursorInfoNum].IdName,NewIdName);

	tvItem.hItem=projectInfo.res.pCursorResInfo[CursorInfoNum].hTreeItem;
	tvItem.mask=TVIF_TEXT;
	tvItem.pszText=projectInfo.res.pCursorResInfo[CursorInfoNum].IdName;
	tvItem.cchTextMax=lstrlen(projectInfo.res.pCursorResInfo[CursorInfoNum].IdName)+1;
	TreeView_SetItem(hMaterialTreeView,&tvItem);

	projectInfo.ModifuOfResource=1;

	TreeView_SortChildren(hMaterialTreeView,
		TreeView_GetParent(hMaterialTreeView,projectInfo.res.pCursorResInfo[CursorInfoNum].hTreeItem),
		0);
}

void Project_BitmapResInsert(void){
	extern HANDLE hHeap;
	extern LPSTR BitmapFileFilter;
	int i2,i3;
	char temporary[MAX_PATH];

	if(!projectInfo.ResourceFileName[0])
		sprintf(projectInfo.ResourceFileName,"%s.rc",projectInfo.GetName().c_str());

	//"rbg}bv t@Cw肵Ă"
	if(!GetFilePathDialog(hOwner,temporary,BitmapFileFilter,STRING_FILEOPENTITLE_BITMAP,TRUE)) return;

	lstrcpy( temporary, projectInfo.GetWorkDir().GetRelationalPath( temporary ).c_str() );

	projectInfo.res.pBitmapResInfo=(RESITEMINFO *)HeapReAlloc(hHeap,0,projectInfo.res.pBitmapResInfo,(projectInfo.res.NumberOfBitmapRes+1)*sizeof(RESITEMINFO));

	projectInfo.res.pBitmapResInfo[projectInfo.res.NumberOfBitmapRes].path=
		(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
	lstrcpy(projectInfo.res.pBitmapResInfo[projectInfo.res.NumberOfBitmapRes].path,temporary);

	for(i3=1;;i3++){
		sprintf(temporary,"IDB_BITMAP%d",i3);
		for(i2=0;i2<projectInfo.res.NumberOfBitmapRes;i2++){
			if(lstrcmp(temporary,projectInfo.res.pBitmapResInfo[i2].IdName)==0) break;
		}
		if(i2==projectInfo.res.NumberOfBitmapRes) break;
	}

	projectInfo.res.pBitmapResInfo[projectInfo.res.NumberOfBitmapRes].IdName=
		(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
	lstrcpy(projectInfo.res.pBitmapResInfo[projectInfo.res.NumberOfBitmapRes].IdName,temporary);

	//c[r[ɒǉ
	extern HWND hMaterialTreeView;
	TV_INSERTSTRUCT tv;
	tv.hInsertAfter=TVI_SORT;
	tv.item.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
	tv.item.iImage=5;
	tv.item.iSelectedImage=5;
	tv.hParent=projectInfo.res.hBitmapTreeItem;
	tv.item.pszText=temporary;

	projectInfo.res.pBitmapResInfo[projectInfo.res.NumberOfBitmapRes].hTreeItem=
		TreeView_InsertItem(hMaterialTreeView,&tv);

	TreeView_SelectItem(hMaterialTreeView,projectInfo.res.pBitmapResInfo[projectInfo.res.NumberOfBitmapRes].hTreeItem);

	projectInfo.res.NumberOfBitmapRes++;
	projectInfo.ModifuOfResource=1;


	////////////////////////////////
	// EBhE vpeBXV
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	for(i2=0;i2<MAX_WNDNUM;i2++){
		if(MdiInfo[i2].hwnd&&MdiInfo[i2].DocType==WNDTYPE_RAD){
			if(MdiInfo[i2].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW)
				ChangePropertyWindow(i2,GetWndInfoNum(MdiInfo[i2].path));
		}
	}
}
void Project_Bitmap_Delete(int BitmapInfoNum){
	int i;

	//c[r[폜
	extern HWND hMaterialTreeView;
	TreeView_DeleteItem(hMaterialTreeView,projectInfo.res.pBitmapResInfo[BitmapInfoNum].hTreeItem);

	//projectInfo.pBitmapInfo\̂폜
	HeapDefaultFree(projectInfo.res.pBitmapResInfo[BitmapInfoNum].IdName);
	HeapDefaultFree(projectInfo.res.pBitmapResInfo[BitmapInfoNum].path);
	projectInfo.res.NumberOfBitmapRes--;
	for(i=BitmapInfoNum;i<projectInfo.res.NumberOfBitmapRes;i++)
		projectInfo.res.pBitmapResInfo[i]=projectInfo.res.pBitmapResInfo[i+1];

	projectInfo.ModifuOfResource=1;
}
void Project_Bitmap_RenameID(int BitmapInfoNum){
	extern HANDLE hHeap;
	extern char NewIdName[MAX_PATH];
	extern HWND hMaterialTreeView;
	int i2;
	char temporary[MAX_PATH];
	TVITEM tvItem;

	if(!DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_INPUTID),hOwner,(DLGPROC)DlgProject_ResourceID_Input,(long)projectInfo.res.pBitmapResInfo[BitmapInfoNum].IdName)) return;

	//d`FbN
	for(i2=0;i2<projectInfo.res.NumberOfBitmapRes;i2++){
		if(i2==BitmapInfoNum) continue;
		if(lstrcmp(NewIdName,projectInfo.res.pBitmapResInfo[i2].IdName)==0){
			//"ID \"%s\" ͊ɃvWFNgɑ݂܂B"
			sprintf(temporary,STRING_DUPLICATIONERROR_ID_IN_PROJECT,NewIdName);
			MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
			return;
		}
	}

	HeapDefaultFree(projectInfo.res.pBitmapResInfo[BitmapInfoNum].IdName);
	projectInfo.res.pBitmapResInfo[BitmapInfoNum].IdName=(char *)HeapAlloc(hHeap,0,lstrlen(NewIdName)+1);
	lstrcpy(projectInfo.res.pBitmapResInfo[BitmapInfoNum].IdName,NewIdName);

	tvItem.hItem=projectInfo.res.pBitmapResInfo[BitmapInfoNum].hTreeItem;
	tvItem.mask=TVIF_TEXT;
	tvItem.pszText=projectInfo.res.pBitmapResInfo[BitmapInfoNum].IdName;
	tvItem.cchTextMax=lstrlen(projectInfo.res.pBitmapResInfo[BitmapInfoNum].IdName)+1;
	TreeView_SetItem(hMaterialTreeView,&tvItem);

	projectInfo.ModifuOfResource=1;

	TreeView_SortChildren(hMaterialTreeView,
		TreeView_GetParent(hMaterialTreeView,projectInfo.res.pBitmapResInfo[BitmapInfoNum].hTreeItem),
		0);
}
void Project_IconResInsert(void){
	extern HANDLE hHeap;
	extern LPSTR IconFileFilter;
	int i2,i3;
	char temporary[MAX_PATH];

	if(!projectInfo.ResourceFileName[0])
		sprintf(projectInfo.ResourceFileName,"%s.rc",projectInfo.GetName().c_str());

	//"ACR t@Cw肵Ă"
	if(!GetFilePathDialog(hOwner,temporary,IconFileFilter,STRING_FILEOPENTITLE_ICON,TRUE)) return;

	lstrcpy( temporary, projectInfo.GetWorkDir().GetRelationalPath( temporary ).c_str() );

	projectInfo.res.pIconResInfo=(RESITEMINFO *)HeapReAlloc(hHeap,0,projectInfo.res.pIconResInfo,(projectInfo.res.NumberOfIconRes+1)*sizeof(RESITEMINFO));

	projectInfo.res.pIconResInfo[projectInfo.res.NumberOfIconRes].path=
		(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
	lstrcpy(projectInfo.res.pIconResInfo[projectInfo.res.NumberOfIconRes].path,temporary);

	for(i3=1;;i3++){
		sprintf(temporary,"IDI_ICON%d",i3);
		for(i2=0;i2<projectInfo.res.NumberOfIconRes;i2++){
			if(lstrcmp(temporary,projectInfo.res.pIconResInfo[i2].IdName)==0) break;
		}
		if(i2==projectInfo.res.NumberOfIconRes) break;
	}

	projectInfo.res.pIconResInfo[projectInfo.res.NumberOfIconRes].IdName=
		(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
	lstrcpy(projectInfo.res.pIconResInfo[projectInfo.res.NumberOfIconRes].IdName,temporary);

	//c[r[ɒǉ
	extern HWND hMaterialTreeView;
	TV_INSERTSTRUCT tv;
	tv.hInsertAfter=TVI_SORT;
	tv.item.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
	tv.item.iImage=4;
	tv.item.iSelectedImage=4;
	tv.hParent=projectInfo.res.hIconTreeItem;
	if(projectInfo.res.NumberOfIconRes==0) lstrcat(temporary," (Main)");
	tv.item.pszText=temporary;

	projectInfo.res.pIconResInfo[projectInfo.res.NumberOfIconRes].hTreeItem=
		TreeView_InsertItem(hMaterialTreeView,&tv);

	TreeView_SelectItem(hMaterialTreeView,projectInfo.res.pIconResInfo[projectInfo.res.NumberOfIconRes].hTreeItem);

	projectInfo.res.NumberOfIconRes++;
	projectInfo.ModifuOfResource=1;

	////////////////////////////////
	// EBhE vpeBXV
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	for(i2=0;i2<MAX_WNDNUM;i2++){
		if(MdiInfo[i2].hwnd&&MdiInfo[i2].DocType==WNDTYPE_RAD){
			if(MdiInfo[i2].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW)
				ChangePropertyWindow(i2,GetWndInfoNum(MdiInfo[i2].path));
		}
	}
}
void Project_Icon_Delete(int IconInfoNum){
	extern HANDLE hHeap;
	int i2;
	char temporary[MAX_PATH];
	TVITEM tv;

	//c[r[폜
	extern HWND hMaterialTreeView;
	TreeView_DeleteItem(hMaterialTreeView,projectInfo.res.pIconResInfo[IconInfoNum].hTreeItem);

	//projectInfo.pIconInfo\̂폜
	HeapDefaultFree(projectInfo.res.pIconResInfo[IconInfoNum].IdName);
	HeapDefaultFree(projectInfo.res.pIconResInfo[IconInfoNum].path);
	projectInfo.res.NumberOfIconRes--;
	for(i2=IconInfoNum;i2<projectInfo.res.NumberOfIconRes;i2++) projectInfo.res.pIconResInfo[i2]=projectInfo.res.pIconResInfo[i2+1];

	if(IconInfoNum==0&&projectInfo.res.NumberOfIconRes){
		tv.mask=TVIF_TEXT|TVIF_HANDLE;
		tv.pszText=temporary;
		tv.cchTextMax=MAX_PATH;
		tv.hItem=projectInfo.res.pIconResInfo[0].hTreeItem;
		TreeView_GetItem(hMaterialTreeView,&tv);
		lstrcat(tv.pszText," (Main)");
		TreeView_SetItem(hMaterialTreeView,&tv);
	}

	projectInfo.ModifuOfResource=1;

	////////////////////////////////
	// EBhE vpeBXV
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	for(i2=0;i2<MAX_WNDNUM;i2++){
		if(MdiInfo[i2].hwnd&&MdiInfo[i2].DocType==WNDTYPE_RAD){
			if(MdiInfo[i2].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW)
				ChangePropertyWindow(i2,GetWndInfoNum(MdiInfo[i2].path));
		}
	}
}
void Project_Icon_RenameID(int IconInfoNum){
	extern HANDLE hHeap;
	extern char NewIdName[MAX_PATH];
	extern HWND hMaterialTreeView;
	int i2;
	char temporary[MAX_PATH];
	TVITEM tvItem;

	if(!DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_INPUTID),hOwner,(DLGPROC)DlgProject_ResourceID_Input,(long)projectInfo.res.pIconResInfo[IconInfoNum].IdName)) return;

	//d`FbN
	for(i2=0;i2<projectInfo.res.NumberOfIconRes;i2++){
		if(i2==IconInfoNum) continue;
		if(lstrcmp(NewIdName,projectInfo.res.pIconResInfo[i2].IdName)==0){
			//"ID \"%s\" ͊ɃvWFNgɑ݂܂B"
			sprintf(temporary,STRING_DUPLICATIONERROR_ID_IN_PROJECT,NewIdName);
			MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
			return;
		}
	}

	HeapDefaultFree(projectInfo.res.pIconResInfo[IconInfoNum].IdName);
	projectInfo.res.pIconResInfo[IconInfoNum].IdName=(char *)HeapAlloc(hHeap,0,lstrlen(NewIdName)+1);
	lstrcpy(projectInfo.res.pIconResInfo[IconInfoNum].IdName,NewIdName);

	tvItem.hItem=projectInfo.res.pIconResInfo[IconInfoNum].hTreeItem;
	tvItem.mask=TVIF_TEXT;
	if(IconInfoNum==0){
		sprintf(temporary,"%s (Main)",projectInfo.res.pIconResInfo[IconInfoNum].IdName);
		tvItem.pszText=temporary;
	}
	else tvItem.pszText=projectInfo.res.pIconResInfo[IconInfoNum].IdName;
	tvItem.cchTextMax=lstrlen(projectInfo.res.pIconResInfo[IconInfoNum].IdName)+1;
	TreeView_SetItem(hMaterialTreeView,&tvItem);

	projectInfo.ModifuOfResource=1;

	TreeView_SortChildren(hMaterialTreeView,
		TreeView_GetParent(hMaterialTreeView,projectInfo.res.pIconResInfo[IconInfoNum].hTreeItem),
		0);
}

BOOL CALLBACK DlgProject_ResourceID_Input(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern char NewIdName[MAX_PATH];
	switch(message){
		case WM_INITDIALOG:
			//"ID̕ύX"
			SetWindowText(hwnd,STRING_RENAME_ID);

			SetDlgItemText(hwnd,IDC_IDNAME,(char *)lParam);
			SetPosCenter(hwnd);
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					GetDlgItemText(hwnd,IDC_IDNAME,NewIdName,MAX_PATH);
					if(!NewIdName[0]){
						//"ID͂ĉB"
						MessageBox(hwnd,STRING_ERROR_MUST_IDNAME,APPLICATION_NAME,MB_OK);
						return 1;
					}
					EndDialog(hwnd,1);
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
			}
			break;
	}
	return 0;
}
