#include "stdafx.h"

using namespace Jenga::Common;

Directory::Directory( const std::string &path, bool isMake )
	: path( path )
{
	if ( isMake )
	{
		if (!::MakeSureDirectoryPathExists(path.c_str()))
		{
			Jenga::Throw( "MakeSureDirectoryPathExists failed!" );
		}
	}
}
Directory::Directory( const Directory &dir )
	: path( dir.path )
{
}

std::string Directory::GetFullPath( const std::string &relationPath ) const
{
	std::string resultPath = relationPath;

	// '/''\'
	BOOST_FOREACH( char &c, resultPath )
	{
		if( c == '/' )
		{
			c = '\\';
		}
	}

	if( resultPath.find( ":" ) != std::string::npos || resultPath.find( "\\\\" ) != std::string::npos )
	{
		// tpXnĂƂ
		return resultPath;
	}

	int i=0,i2=0;
	while(1){
		if(resultPath[i]=='.'&&resultPath[i+1]=='\\') i+=2;
		if(resultPath[i]=='.'&&resultPath[i+1]=='.'&&resultPath[i+2]=='\\'){
			i2++;
			i+=3;
		}
		else break;
	}

	int i3 = (int)path.size(),i4=0;
	while(i4<i2){
		for(i3--;;i3--){
			if(path[i3-1]=='\\'){
				i4++;
				break;
			}
		}
	}

	char temporary[MAX_PATH];
	memcpy(temporary,path.c_str(),i3);
	temporary[i3]=0;
	lstrcat(temporary,resultPath.c_str()+i);

	return temporary;
}

void _GetRelationalPath(char *path,const char *dir){
	//΃pX擾
	int i,i2,i3,i4,i5;
	char temporary[MAX_PATH],temp2[MAX_PATH],temp3[MAX_PATH],temp4[MAX_PATH];

	//hCu`FbN
	_splitpath(path,temporary,0,0,0);
	_splitpath(dir,temp2,0,0,0);
	if(lstrcmpi(temporary,temp2)!=0) return;

	_splitpath(path,0,temporary,0,0);
	_splitpath(dir,0,temp2,0,0);
	i=1;i2=1;
	while(1){
		i4=i;
		if(temporary[i-1]=='\\'&&temporary[i]){	//path
			for(i3=0;;i++,i3++){
				if(temporary[i]=='\\'){
					temp3[i3]=0;
					i++;
					break;
				}
				temp3[i3]=temporary[i];
			}
		}
		else temp3[0]=0;

		i5=i2;
		if(temp2[i2-1]=='\\'&&temp2[i2]){		//dir
			for(i3=0;;i2++,i3++){
				if(temp2[i2]=='\\'){
					temp4[i3]=0;
					i2++;
					break;
				}
				temp4[i3]=temp2[i2];
			}
		}
		else temp4[0]=0;

		if(temp3[0]=='\0'&&temp4[0]=='\0'){
			lstrcpy(temp3,".\\");
			break;
		}

		if(lstrcmpi(temp3,temp4)!=0){
			for(i3=0;;i5++){
				if(temp2[i5]=='\0') break;
				if(temp2[i5]=='\\') i3++;
			}
			if(i3==0) lstrcpy(temp3,".\\");
			else{
				temp3[0]=0;
				for(i2=0;i2<i3;i2++) lstrcat(temp3,"..\\");
			}
			lstrcat(temp3,temporary+i4);
			break;
		}
	}
	_splitpath(path,0,0,temporary,temp2);
	lstrcat(temp3,temporary);
	lstrcat(temp3,temp2);
	lstrcpy(path,temp3);
}

std::string Directory::GetRelationalPath( const std::string &fullPath ) const
{
	char temp[1024];
	lstrcpy( temp, fullPath.c_str() );
	_GetRelationalPath( temp, path.c_str() );
	return temp;
}
