#include "stdafx.h"

#include "common.h"

CFileTree *pobj_FileTree;

WNDPROC OldFileTreeViewProc;

BOOL CALLBACK DlgProject_FileProperty(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	HTREEITEM hTreeItem;
	int i;
	char temporary[MAX_PATH];
	HANDLE hFile;
	FILETIME LastWriteTime,LocalTime;
	SYSTEMTIME SystemTime;

	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(hwnd);

			hTreeItem=TreeView_GetSelection(pobj_FileTree->hTree);

			char *path;
			path=projectInfo.pobj_DBFileInfo->GetPath(hTreeItem);

			//΃pXA΃pX\
			lstrcpy(temporary,path);
			GetFullPath(temporary,projectInfo.dir);
			SetDlgItemText(hwnd,IDC_USING_FILE,temporary);
			SetDlgItemText(hwnd,IDC_DEFINED_FILE,path);

			//ŏIXV\
			hFile=CreateFile(temporary,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
			if(hFile==INVALID_HANDLE_VALUE){
				//"G["
				lstrcpy(temporary,STRING_ERROR);
			}
			else{
				GetFileTime(hFile,NULL,NULL,&LastWriteTime);
				FileTimeToLocalFileTime(&LastWriteTime,&LocalTime);
				FileTimeToSystemTime(&LocalTime,&SystemTime);
				if(SystemTime.wHour>=12){
					//"ߌ "
					lstrcpy(temporary,STRING_AFTERNOON);
					lstrcat(temporary," ");
					SystemTime.wHour-=12;
				}
				else{
					//"ߑO "
					lstrcpy(temporary,STRING_MORNING);
					lstrcat(temporary," ");
				}
				sprintf(temporary+5,"%02d:%02d:%02d %04d/%02d/%02d",
					SystemTime.wHour,SystemTime.wMinute,SystemTime.wSecond,
					SystemTime.wYear,SystemTime.wMonth,SystemTime.wDay);
				CloseHandle(hFile);
			}
			SetDlgItemText(hwnd,IDC_UPDATE_TIME,temporary);


			//////////////
			// `\
			//////////////
			i=GetFileExtension(path);

			//"Basic vO"
			if(i==FT_BASICPROGRAM) lstrcpy(temporary,STRING_FILETYPE_BASICPROGRAM);
			//"Tu vO"
			else if(i==FT_SUBPROGRAM) lstrcpy(temporary,STRING_FILETYPE_SUBPROGRAM);
			//"eLXg hLg"
			else if(i==FT_TEXT) lstrcpy(temporary,STRING_FILETYPE_TEXT);
			//"ʂł܂"
			else lstrcpy(temporary,STRING_FILETYPE_UNKNOWN);

			SetDlgItemText(hwnd,IDC_FILETYPE,temporary);

			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					EndDialog(hwnd,0);
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
			}
			break;
	}
	return 0;
}

LRESULT CALLBACK FileTreeViewProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	HTREEITEM hTreeItem;
	char temporary[MAX_PATH];
	char *path;
	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDM_FILETREE_INSERT:
					//"vWFNg֑}t@Cw肵ĉ"
					extern LPSTR DefFileFilter;
					if(!GetFilePathDialog(hOwner,temporary,DefFileFilter,STRING_FILEOPENTITLE_INSERTEDPROJECT,1)) break;
					Project_File_Insert(temporary);
					break;
				case IDM_FILETREE_OPEN:
					hTreeItem=TreeView_GetSelection(hwnd);

					path=projectInfo.pobj_DBFileInfo->GetPath(hTreeItem);
					if(!path) break;

					lstrcpy(temporary,path);
					GetFullPath(temporary,projectInfo.dir);
					OpenFileWithExtension(temporary);
					break;
				case IDM_FILETREE_DELETE:
					hTreeItem=TreeView_GetSelection(hwnd);
					Project_File_Delete(hTreeItem);
					break;
				case IDM_FILETREE_PROPERTY:
					DialogBox(hResInst,MAKEINTRESOURCE(IDD_PROJECT_FILEPROPERTY),hOwner,(DLGPROC)DlgProject_FileProperty);
					break;
			}
			return 0;
		case WM_CHAR:
			if(wParam==VK_RETURN){
				SendMessage(hwnd,WM_COMMAND,IDM_FILETREE_OPEN,0);
				//ftHg̃bZ[Wƃr[vĂ܂̂Ŕ
				return 0;
			}
			break;
		case WM_KEYDOWN:
			if(wParam==VK_DELETE){
				SendMessage(hwnd,WM_COMMAND,IDM_FILETREE_DELETE,0);
			}
			break;
		case WM_LBUTTONDBLCLK:
			SendMessage(hwnd,WM_COMMAND,IDM_FILETREE_OPEN,0);
			break;
	}
	return CallWindowProc(OldFileTreeViewProc,hwnd,message,wParam,lParam);
}

CFileTree::CFileTree(HWND hParent){
	hTree=CreateWindowEx(WS_EX_CLIENTEDGE,WC_TREEVIEW,"",
		WS_CHILD|TVS_HASLINES|TVS_HASBUTTONS|TVS_LINESATROOT|TVS_SHOWSELALWAYS,
		0,0,0,0,
		hParent,0,hInst,0);
	OldFileTreeViewProc=(WNDPROC)GetWindowLongPtr(hTree,GWLP_WNDPROC);
	SetWindowLongPtr(hTree,GWLP_WNDPROC,(long)FileTreeViewProc);

	//C[WXgǂݍ݁Aݒ
	hImageList=ImageList_Create(16,16,ILC_COLOR24|ILC_MASK,3,0);
	ImageList_AddIcon(hImageList,LoadIcon(hResInst,MAKEINTRESOURCE(IDI_FOLDER_CLOSE)));
	ImageList_AddIcon(hImageList,LoadIcon(hResInst,MAKEINTRESOURCE(IDI_FOLDER_OPEN)));
	ImageList_AddIcon(hImageList,LoadIcon(hResInst,MAKEINTRESOURCE(IDI_TEXTDOCUMENT)));
	TreeView_SetImageList(hTree,hImageList,TVSIL_NORMAL);
}
CFileTree::~CFileTree(){
	DestroyWindow(hTree);
	ImageList_Destroy(hImageList);
}

void CFileTree::ContextMenu(POINT *pPos){
	//ENbNɂ郁j[\
	TV_HITTESTINFO tvHitTestInfo;
	tvHitTestInfo.pt=*pPos;
	ScreenToClient(hTree,&tvHitTestInfo.pt);

	HTREEITEM hTreeItem;
	hTreeItem=TreeView_HitTest(hTree,&tvHitTestInfo);
	if(hTreeItem){
		TreeView_SelectItem(hTree,hTreeItem);

		extern HMENU hFileTreeMenuBase;
		if(TreeView_GetRoot(hTree)==hTreeItem)
			TrackPopupMenu(GetSubMenu(hFileTreeMenuBase,0),TPM_LEFTALIGN,pPos->x,pPos->y,0,hTree,0);
		else TrackPopupMenu(GetSubMenu(hFileTreeMenuBase,1),TPM_LEFTALIGN,pPos->x,pPos->y,0,hTree,0);
	}
}

HTREEITEM CFileTree::insert(char *str){
	//////////////////////
	//c[r[ɒǉ

	TV_INSERTSTRUCT tv;
	tv.hInsertAfter=TVI_SORT;
	tv.item.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
	tv.item.iImage=2;
	tv.item.iSelectedImage=2;
	tv.hParent=TreeView_GetRoot(hTree);
	tv.item.pszText=str;

	return TreeView_InsertItem(hTree,&tv);
}

void CFileTree::resize(int x,int y,int cx,int cy){
	MoveWindow(hTree,x,y,cx,cy,1);
}
